/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;

public class ArrowDrawable
extends Drawable
implements Animatable {
    private boolean mRunning = false;
    private long mStartTime;
    private float mAnimProgress;
    private int mAnimDuration;
    private Paint mPaint;
    private ColorStateList mColorStateList;
    private int mSize;
    private int mCurColor;
    private int mMode;
    private Interpolator mInterpolator;
    private Path mPath;
    public static int MODE_DOWN = 0;
    public static int MODE_UP = 1;
    private boolean mClockwise = true;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            ArrowDrawable.this.update();
        }
    };

    public ArrowDrawable(int mode, int size, ColorStateList colorStateList, int animDuration, Interpolator interpolator, boolean clockwise) {
        this.mSize = size;
        this.mAnimDuration = animDuration;
        this.mMode = mode;
        this.mInterpolator = interpolator;
        if (this.mInterpolator == null) {
            this.mInterpolator = new DecelerateInterpolator();
        }
        this.mClockwise = clockwise;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPath = new Path();
        this.setColor(colorStateList);
    }

    public void setColor(ColorStateList colorStateList) {
        this.mColorStateList = colorStateList;
        this.onStateChange(this.getState());
    }

    public void setMode(int mode, boolean animation) {
        if (this.mMode != mode) {
            this.mMode = mode;
            if (animation && this.mAnimDuration > 0) {
                this.start();
            } else {
                this.invalidateSelf();
            }
        }
    }

    public int getMode() {
        return this.mMode;
    }

    protected void onBoundsChange(Rect bounds) {
        float x = bounds.exactCenterX();
        float y = bounds.exactCenterY();
        this.mPath.reset();
        this.mPath.moveTo(x, y + (float)this.mSize / 2.0f);
        this.mPath.lineTo(x - (float)this.mSize, y - (float)this.mSize / 2.0f);
        this.mPath.lineTo(x + (float)this.mSize, y - (float)this.mSize / 2.0f);
        this.mPath.close();
    }

    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        Rect bounds = this.getBounds();
        if (!this.isRunning()) {
            if (this.mMode == MODE_UP) {
                canvas.rotate(180.0f, bounds.exactCenterX(), bounds.exactCenterY());
            }
        } else {
            float value = this.mInterpolator.getInterpolation(this.mAnimProgress);
            float degree = this.mClockwise ? (this.mMode == MODE_UP ? 180.0f * value : 180.0f * (1.0f + value)) : (this.mMode == MODE_UP ? -180.0f * value : -180.0f * (1.0f + value));
            canvas.rotate(degree, bounds.exactCenterX(), bounds.exactCenterY());
        }
        this.mPaint.setColor(this.mCurColor);
        canvas.drawPath(this.mPath, this.mPaint);
        canvas.restoreToCount(saveCount);
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public boolean isStateful() {
        return true;
    }

    protected boolean onStateChange(int[] state) {
        int color = this.mColorStateList.getColorForState(state, this.mCurColor);
        if (this.mCurColor != color) {
            this.mCurColor = color;
            return true;
        }
        return false;
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mAnimProgress = 0.0f;
    }

    public void start() {
        this.resetAnimation();
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    public void stop() {
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void scheduleSelf(Runnable what, long when) {
        this.mRunning = true;
        super.scheduleSelf(what, when);
    }

    private void update() {
        long curTime = SystemClock.uptimeMillis();
        this.mAnimProgress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mAnimDuration);
        if (this.mAnimProgress == 1.0f) {
            this.mRunning = false;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }
}

