/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.app;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.app.FragmentManager;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.widget.ActionMenuView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.rey.material.drawable.NavigationDrawerDrawable;
import com.rey.material.drawable.ToolbarRippleDrawable;
import com.rey.material.util.ViewUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class ToolbarManager {
    private ActionBarActivity mActivity;
    private Toolbar mToolbar;
    private int mRippleStyle;
    private Animator mAnimator;
    private ActionMenuView mMenuView;
    private ToolbarRippleDrawable.Builder mBuilder;
    private int mCurrentGroup = 0;
    private boolean mGroupChanged = false;
    private boolean mMenuDataChanged = true;
    private ArrayList<WeakReference<OnToolbarGroupChangedListener>> mListeners = new ArrayList();
    private ViewTreeObserver.OnGlobalLayoutListener mOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            ToolbarManager.this.onGlobalLayout();
        }
    };
    private ArrayList<Animation> mAnimations = new ArrayList();
    private Animation.AnimationListener mOutAnimationEndListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            if (ToolbarManager.this.mActivity != null) {
                ToolbarManager.this.mActivity.supportInvalidateOptionsMenu();
            } else {
                ToolbarManager.this.onPrepareMenu();
            }
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };
    private NavigationManager mNavigationManager;

    public ToolbarManager(ActionBarActivity activity, Toolbar toolbar, int defaultGroupId, int rippleStyle, int animIn, int animOut) {
        this(activity, toolbar, defaultGroupId, rippleStyle, new SimpleAnimator(animIn, animOut));
    }

    public ToolbarManager(ActionBarActivity activity, Toolbar toolbar, int defaultGroupId, int rippleStyle, Animator animator) {
        this.mActivity = activity;
        this.mToolbar = toolbar;
        this.mCurrentGroup = defaultGroupId;
        this.mRippleStyle = rippleStyle;
        this.mAnimator = animator;
        this.mActivity.setSupportActionBar(toolbar);
    }

    public void registerOnToolbarGroupChangedListener(OnToolbarGroupChangedListener listener) {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            WeakReference<OnToolbarGroupChangedListener> ref = this.mListeners.get(i);
            if (ref.get() == null) {
                this.mListeners.remove(i);
                continue;
            }
            if (ref.get() != listener) continue;
            return;
        }
        this.mListeners.add(new WeakReference<OnToolbarGroupChangedListener>(listener));
    }

    public void unregisterOnToolbarGroupChangedListener(OnToolbarGroupChangedListener listener) {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            WeakReference<OnToolbarGroupChangedListener> ref = this.mListeners.get(i);
            if (ref.get() != null && ref.get() != listener) continue;
            this.mListeners.remove(i);
        }
    }

    private void dispatchOnToolbarGroupChanged(int oldGroupId, int groupId) {
        for (int i = this.mListeners.size() - 1; i >= 0; --i) {
            WeakReference<OnToolbarGroupChangedListener> ref = this.mListeners.get(i);
            if (ref.get() == null) {
                this.mListeners.remove(i);
                continue;
            }
            ((OnToolbarGroupChangedListener)ref.get()).onToolbarGroupChanged(oldGroupId, groupId);
        }
    }

    public int getCurrentGroup() {
        return this.mCurrentGroup;
    }

    public void setCurrentGroup(int groupId) {
        if (this.mCurrentGroup != groupId) {
            int oldGroupId = this.mCurrentGroup;
            this.mCurrentGroup = groupId;
            this.mGroupChanged = true;
            this.dispatchOnToolbarGroupChanged(oldGroupId, this.mCurrentGroup);
            this.animateOut();
        }
    }

    public void createMenu(int menuId) {
        this.mToolbar.inflateMenu(menuId);
        this.mMenuDataChanged = true;
        if (this.mActivity == null) {
            this.onPrepareMenu();
        }
    }

    public void onPrepareMenu() {
        if (this.mGroupChanged || this.mMenuDataChanged) {
            this.mToolbar.getViewTreeObserver().addOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
            Menu menu = this.mToolbar.getMenu();
            int count = menu.size();
            for (int i = 0; i < count; ++i) {
                MenuItem item;
                item.setVisible((item = menu.getItem(i)).getGroupId() == this.mCurrentGroup);
            }
            this.mMenuDataChanged = false;
        }
    }

    public void setNavigationManager(NavigationManager navigationManager) {
        this.mNavigationManager = navigationManager;
    }

    public void notifyNavigationStateInvalidated() {
        if (this.mNavigationManager != null) {
            this.mNavigationManager.notifyStateInvalidated();
        }
    }

    public void notifyNavigationStateChanged() {
        if (this.mNavigationManager != null) {
            this.mNavigationManager.notifyStateChanged();
        }
    }

    public void notifyNavigationStateProgressChanged(boolean isBackState, float progress) {
        if (this.mNavigationManager != null) {
            this.mNavigationManager.notifyStateProgressChanged(isBackState, progress);
        }
    }

    public boolean isNavigationBackState() {
        return this.mNavigationManager != null && this.mNavigationManager.isBackState();
    }

    private ToolbarRippleDrawable getBackground() {
        if (this.mBuilder == null) {
            this.mBuilder = new ToolbarRippleDrawable.Builder(this.mToolbar.getContext(), this.mRippleStyle);
        }
        return this.mBuilder.build();
    }

    private ActionMenuView getMenuView() {
        if (this.mMenuView == null) {
            for (int i = 0; i < this.mToolbar.getChildCount(); ++i) {
                View child = this.mToolbar.getChildAt(i);
                if (!(child instanceof ActionMenuView)) continue;
                this.mMenuView = (ActionMenuView)child;
                break;
            }
        }
        return this.mMenuView;
    }

    private void onGlobalLayout() {
        int count;
        if (Build.VERSION.SDK_INT >= 16) {
            this.mToolbar.getViewTreeObserver().removeOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
        } else {
            this.mToolbar.getViewTreeObserver().removeGlobalOnLayoutListener(this.mOnGlobalLayoutListener);
        }
        ActionMenuView menuView = this.getMenuView();
        int n = count = menuView == null ? 0 : menuView.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = menuView.getChildAt(i);
            if (this.mRippleStyle == 0 || child.getBackground() != null && child.getBackground() instanceof ToolbarRippleDrawable) continue;
            ViewUtil.setBackground(child, this.getBackground());
        }
        if (this.mGroupChanged) {
            this.animateIn();
            this.mGroupChanged = false;
        }
    }

    private void animateOut() {
        int i;
        ActionMenuView menuView = this.getMenuView();
        int count = menuView == null ? 0 : menuView.getChildCount();
        Animation slowestAnimation = null;
        this.mAnimations.clear();
        this.mAnimations.ensureCapacity(count);
        for (i = 0; i < count; ++i) {
            View child = menuView.getChildAt(i);
            Animation anim = this.mAnimator.getOutAnimation(child, i);
            this.mAnimations.add(anim);
            if (anim == null || slowestAnimation != null && slowestAnimation.getStartOffset() + slowestAnimation.getDuration() >= anim.getStartOffset() + anim.getDuration()) continue;
            slowestAnimation = anim;
        }
        if (slowestAnimation == null) {
            this.mOutAnimationEndListener.onAnimationEnd(null);
        } else {
            slowestAnimation.setAnimationListener(this.mOutAnimationEndListener);
            for (i = 0; i < count; ++i) {
                Animation anim = this.mAnimations.get(i);
                if (anim == null) continue;
                menuView.getChildAt(i).startAnimation(anim);
            }
        }
        this.mAnimations.clear();
    }

    private void animateIn() {
        int count;
        ActionMenuView menuView = this.getMenuView();
        int n = count = menuView == null ? 0 : menuView.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = menuView.getChildAt(i);
            Animation anim = this.mAnimator.getInAnimation(child, i);
            if (anim == null) continue;
            child.startAnimation(anim);
        }
    }

    public static class BaseNavigationManager
    extends NavigationManager {
        protected DrawerLayout mDrawerLayout;
        protected FragmentManager mFragmentManager;
        protected boolean mSyncDrawerSlidingProgress = false;

        public BaseNavigationManager(int styledId, ActionBarActivity activity, Toolbar toolbar, DrawerLayout drawerLayout) {
            super(styledId, toolbar);
            this.mDrawerLayout = drawerLayout;
            this.mFragmentManager = activity.getSupportFragmentManager();
            if (this.mDrawerLayout != null) {
                this.mDrawerLayout.setDrawerListener(new DrawerLayout.DrawerListener(){

                    public void onDrawerSlide(View drawerView, float slideOffset) {
                        BaseNavigationManager.this.onDrawerSlide(drawerView, slideOffset);
                    }

                    public void onDrawerOpened(View drawerView) {
                        BaseNavigationManager.this.onDrawerOpened(drawerView);
                    }

                    public void onDrawerClosed(View drawerView) {
                        BaseNavigationManager.this.onDrawerClosed(drawerView);
                    }

                    public void onDrawerStateChanged(int newState) {
                        BaseNavigationManager.this.onDrawerStateChanged(newState);
                    }
                });
            }
            this.mFragmentManager.addOnBackStackChangedListener(new FragmentManager.OnBackStackChangedListener(){

                public void onBackStackChanged() {
                    BaseNavigationManager.this.onFragmentChanged();
                }
            });
        }

        @Override
        public boolean isBackState() {
            return this.mFragmentManager.getBackStackEntryCount() > 1 || this.mDrawerLayout != null && this.mDrawerLayout.isDrawerOpen(0x800003);
        }

        @Override
        public void onNavigationClick() {
        }

        protected boolean shouldSyncDrawerSlidingProgress() {
            return this.mFragmentManager.getBackStackEntryCount() <= 1;
        }

        protected void onFragmentChanged() {
            this.notifyStateChanged();
        }

        protected void onDrawerSlide(View drawerView, float slideOffset) {
            if (!this.mSyncDrawerSlidingProgress) {
                return;
            }
            if (this.mDrawerLayout.isDrawerOpen(0x800003)) {
                this.notifyStateProgressChanged(false, 1.0f - slideOffset);
            } else {
                this.notifyStateProgressChanged(true, slideOffset);
            }
        }

        protected void onDrawerOpened(View drawerView) {
        }

        protected void onDrawerClosed(View drawerView) {
        }

        protected void onDrawerStateChanged(int newState) {
            this.mSyncDrawerSlidingProgress = (newState == 1 || newState == 2) && this.shouldSyncDrawerSlidingProgress();
        }
    }

    public static abstract class NavigationManager {
        protected NavigationDrawerDrawable mNavigationIcon;
        protected Toolbar mToolbar;

        public NavigationManager(int styleId, Toolbar toolbar) {
            this.mToolbar = toolbar;
            this.mNavigationIcon = new NavigationDrawerDrawable.Builder(this.mToolbar.getContext(), styleId).build();
            this.mToolbar.setNavigationIcon((Drawable)this.mNavigationIcon);
            this.mToolbar.setNavigationOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NavigationManager.this.onNavigationClick();
                }
            });
        }

        public abstract boolean isBackState();

        public abstract void onNavigationClick();

        public void notifyStateInvalidated() {
            this.mNavigationIcon.switchIconState(this.isBackState() ? 1 : 0, false);
        }

        public void notifyStateChanged() {
            this.mNavigationIcon.switchIconState(this.isBackState() ? 1 : 0, true);
        }

        public void notifyStateProgressChanged(boolean isBackState, float progress) {
            this.mNavigationIcon.setIconState(isBackState ? 1 : 0, progress);
        }
    }

    private static class SimpleAnimator
    implements Animator {
        private int mAnimationIn;
        private int mAnimationOut;

        public SimpleAnimator(int animIn, int animOut) {
            this.mAnimationIn = animIn;
            this.mAnimationOut = animOut;
        }

        @Override
        public Animation getOutAnimation(View v, int position) {
            return this.mAnimationOut == 0 ? null : AnimationUtils.loadAnimation((Context)v.getContext(), (int)this.mAnimationOut);
        }

        @Override
        public Animation getInAnimation(View v, int position) {
            return this.mAnimationIn == 0 ? null : AnimationUtils.loadAnimation((Context)v.getContext(), (int)this.mAnimationIn);
        }
    }

    public static interface Animator {
        public Animation getOutAnimation(View var1, int var2);

        public Animation getInAnimation(View var1, int var2);
    }

    public static interface OnToolbarGroupChangedListener {
        public void onToolbarGroupChanged(int var1, int var2);
    }
}

