/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.app;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.rey.material.R;
import com.rey.material.app.Dialog;
import com.rey.material.util.ThemeUtil;
import com.rey.material.widget.CircleCheckedTextView;
import com.rey.material.widget.TimePicker;
import java.text.DateFormat;
import java.util.Calendar;

public class TimePickerDialog
extends Dialog {
    private TimePickerLayout mTimePickerLayout;
    private float mCornerRadius;

    public TimePickerDialog(Context context) {
        super(context, R.style.Material_App_Dialog_TimePicker_Light);
    }

    public TimePickerDialog(Context context, int style2) {
        super(context, style2);
    }

    @Override
    protected void onCreate() {
        this.mTimePickerLayout = new TimePickerLayout(this.getContext());
        this.contentView((View)this.mTimePickerLayout);
    }

    @Override
    public Dialog applyStyle(int resId) {
        super.applyStyle(resId);
        if (resId == 0) {
            return this;
        }
        this.mTimePickerLayout.applyStyle(resId);
        this.layoutParams(-1, -1);
        return this;
    }

    @Override
    public Dialog layoutParams(int width, int height) {
        return super.layoutParams(-1, -1);
    }

    @Override
    public Dialog cornerRadius(float radius) {
        this.mCornerRadius = radius;
        return super.cornerRadius(radius);
    }

    public TimePickerDialog hour(int hour) {
        this.mTimePickerLayout.setHour(hour);
        return this;
    }

    public TimePickerDialog minute(int minute) {
        this.mTimePickerLayout.setMinute(minute);
        return this;
    }

    public TimePickerDialog onTimeChangedListener(OnTimeChangedListener listener) {
        this.mTimePickerLayout.setOnTimeChangedListener(listener);
        return this;
    }

    public int getHour() {
        return this.mTimePickerLayout.getHour();
    }

    public int getMinute() {
        return this.mTimePickerLayout.getMinute();
    }

    public String getFormattedTime(DateFormat formatter) {
        return this.mTimePickerLayout.getFormattedTime(formatter);
    }

    public static class Builder
    extends Dialog.Builder
    implements OnTimeChangedListener {
        protected int mHour;
        protected int mMinute;
        public static final Parcelable.Creator<Builder> CREATOR = new Parcelable.Creator<Builder>(){

            public Builder createFromParcel(Parcel in) {
                return new Builder(in);
            }

            public Builder[] newArray(int size) {
                return new Builder[size];
            }
        };

        public Builder() {
            super(R.style.Material_App_Dialog_TimePicker_Light);
            Calendar cal = Calendar.getInstance();
            this.mHour = cal.get(11);
            this.mMinute = cal.get(12);
        }

        public Builder(int hourOfDay, int minute) {
            this(R.style.Material_App_Dialog_TimePicker_Light, hourOfDay, minute);
        }

        public Builder(int styleId, int hourOfDay, int minute) {
            super(styleId);
            this.hour(hourOfDay);
            this.minute(minute);
        }

        public Builder hour(int hour) {
            this.mHour = Math.min(Math.max(hour, 0), 24);
            return this;
        }

        public Builder minute(int minute) {
            this.mMinute = minute;
            return this;
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        @Override
        public Dialog.Builder contentView(int layoutId) {
            return this;
        }

        @Override
        protected Dialog onBuild(Context context, int styleId) {
            TimePickerDialog dialog = new TimePickerDialog(context, styleId);
            dialog.hour(this.mHour).minute(this.mMinute).onTimeChangedListener(this);
            return dialog;
        }

        @Override
        public void onTimeChanged(int oldHour, int oldMinute, int newHour, int newMinute) {
            this.hour(newHour).minute(newMinute);
        }

        protected Builder(Parcel in) {
            super(in);
        }

        @Override
        protected void onWriteToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
        }

        @Override
        protected void onReadFromParcel(Parcel in) {
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
        }
    }

    private class TimePickerLayout
    extends FrameLayout
    implements View.OnClickListener,
    TimePicker.OnTimeChangedListener {
        private int mHeaderHeight;
        private int mTextTimeColor;
        private int mTextTimeSize;
        private boolean mIsLeadingZero;
        private boolean mIsAm;
        private int mCheckBoxSize;
        private int mHeaderRealWidth;
        private int mHeaderRealHeight;
        private CircleCheckedTextView mAmView;
        private CircleCheckedTextView mPmView;
        private TimePicker mTimePicker;
        private Paint mPaint;
        private Path mHeaderBackground;
        private RectF mRect;
        private static final String TIME_DIVIDER = ":";
        private static final String BASE_TEXT = "0";
        private static final String FORMAT = "%02d";
        private static final String FORMAT_NO_LEADING_ZERO = "%d";
        private boolean mLocationDirty;
        private float mBaseY;
        private float mHourX;
        private float mDividerX;
        private float mMinuteX;
        private float mMiddayX;
        private float mHourWidth;
        private float mMinuteWidth;
        private float mBaseHeight;
        private String mHour;
        private String mMinute;
        private String mMidday;
        private OnTimeChangedListener mOnTimeChangedListener;

        public TimePickerLayout(Context context) {
            super(context);
            this.mIsAm = true;
            this.mLocationDirty = true;
            this.mPaint = new Paint(1);
            this.mPaint.setTextAlign(Paint.Align.LEFT);
            this.mHeaderBackground = new Path();
            this.mRect = new RectF();
            this.mAmView = new CircleCheckedTextView(context);
            this.mPmView = new CircleCheckedTextView(context);
            this.mTimePicker = new TimePicker(context);
            this.mTimePicker.setPadding(TimePickerDialog.this.mContentPadding, TimePickerDialog.this.mContentPadding, TimePickerDialog.this.mContentPadding, TimePickerDialog.this.mContentPadding);
            this.mTimePicker.setOnTimeChangedListener(this);
            this.mAmView.setGravity(17);
            this.mPmView.setGravity(17);
            if (Build.VERSION.SDK_INT >= 17) {
                this.mAmView.setTextAlignment(4);
                this.mPmView.setTextAlignment(4);
            }
            this.mAmView.setCheckedImmediately(this.mIsAm);
            this.mPmView.setCheckedImmediately(!this.mIsAm);
            this.mAmView.setOnClickListener(this);
            this.mPmView.setOnClickListener(this);
            this.addView(this.mTimePicker);
            this.addView((View)this.mAmView);
            this.addView((View)this.mPmView);
            this.setWillNotDraw(false);
        }

        public void applyStyle(int resId) {
            this.mTimePicker.applyStyle(resId);
            Context context = this.getContext();
            this.mCheckBoxSize = ThemeUtil.dpToPx(context, 48);
            TypedArray a = context.obtainStyledAttributes(resId, R.styleable.TimePickerDialog);
            this.mHeaderHeight = a.getDimensionPixelSize(R.styleable.TimePickerDialog_tp_headerHeight, ThemeUtil.dpToPx(context, 120));
            this.mTextTimeColor = a.getColor(R.styleable.TimePickerDialog_tp_textTimeColor, -16777216);
            this.mTextTimeSize = a.getDimensionPixelSize(R.styleable.TimePickerDialog_tp_textTimeSize, context.getResources().getDimensionPixelOffset(R.dimen.abc_text_size_headline_material));
            this.mIsLeadingZero = a.getBoolean(R.styleable.TimePickerDialog_tp_leadingZero, false);
            String am = a.getString(R.styleable.TimePickerDialog_tp_am);
            String pm = a.getString(R.styleable.TimePickerDialog_tp_pm);
            a.recycle();
            if (am == null) {
                am = DateUtils.getAMPMString((int)0).toUpperCase();
            }
            if (pm == null) {
                pm = DateUtils.getAMPMString((int)1).toUpperCase();
            }
            int[][] states = new int[][]{{-16842912}, {0x10100A0}};
            int[] colors = new int[]{this.mTimePicker.getTextColor(), this.mTimePicker.getTextHighlightColor()};
            this.mAmView.setBackgroundColor(this.mTimePicker.getSelectionColor());
            this.mAmView.setAnimDuration(this.mTimePicker.getAnimDuration());
            this.mAmView.setInterpolator(this.mTimePicker.getInInterpolator(), this.mTimePicker.getOutInterpolator());
            this.mAmView.setTypeface(this.mTimePicker.getTypeface());
            this.mAmView.setTextSize(0, this.mTimePicker.getTextSize());
            this.mAmView.setTextColor(new ColorStateList((int[][])states, colors));
            this.mAmView.setText(am);
            this.mPmView.setBackgroundColor(this.mTimePicker.getSelectionColor());
            this.mPmView.setAnimDuration(this.mTimePicker.getAnimDuration());
            this.mPmView.setInterpolator(this.mTimePicker.getInInterpolator(), this.mTimePicker.getOutInterpolator());
            this.mPmView.setTypeface(this.mTimePicker.getTypeface());
            this.mPmView.setTextSize(0, this.mTimePicker.getTextSize());
            this.mPmView.setTextColor(new ColorStateList((int[][])states, colors));
            this.mPmView.setText(pm);
            this.mPaint.setTypeface(this.mTimePicker.getTypeface());
            this.mHour = String.format(this.mIsLeadingZero ? FORMAT : FORMAT_NO_LEADING_ZERO, !this.mTimePicker.is24Hour() && this.mTimePicker.getHour() == 0 ? 12 : this.mTimePicker.getHour());
            this.mMinute = String.format(FORMAT, this.mTimePicker.getMinute());
            if (!this.mTimePicker.is24Hour()) {
                this.mMidday = this.mIsAm ? this.mAmView.getText().toString() : this.mPmView.getText().toString();
            }
            this.mLocationDirty = true;
            this.invalidate(0, 0, this.mHeaderRealWidth, this.mHeaderRealHeight);
        }

        public void setHour(int hour) {
            if (!this.mTimePicker.is24Hour()) {
                if (hour > 11 && hour < 24) {
                    this.setAm(false, false);
                } else {
                    this.setAm(true, false);
                }
            }
            this.mTimePicker.setHour(hour);
        }

        public int getHour() {
            return this.mTimePicker.is24Hour() || this.mIsAm ? this.mTimePicker.getHour() : this.mTimePicker.getHour() + 12;
        }

        public void setMinute(int minute) {
            this.mTimePicker.setMinute(minute);
        }

        public int getMinute() {
            return this.mTimePicker.getMinute();
        }

        private void setAm(boolean am, boolean animation) {
            if (this.mTimePicker.is24Hour()) {
                return;
            }
            if (this.mIsAm != am) {
                int oldHour = this.getHour();
                this.mIsAm = am;
                if (animation) {
                    this.mAmView.setChecked(this.mIsAm);
                    this.mPmView.setChecked(!this.mIsAm);
                } else {
                    this.mAmView.setCheckedImmediately(this.mIsAm);
                    this.mPmView.setCheckedImmediately(!this.mIsAm);
                }
                this.mMidday = this.mIsAm ? this.mAmView.getText().toString() : this.mPmView.getText().toString();
                this.invalidate(0, 0, this.mHeaderRealWidth, this.mHeaderRealHeight);
                if (this.mOnTimeChangedListener != null) {
                    this.mOnTimeChangedListener.onTimeChanged(oldHour, this.getMinute(), this.getHour(), this.getMinute());
                }
            }
        }

        public String getFormattedTime(DateFormat formatter) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, this.getHour());
            cal.set(12, this.getMinute());
            cal.set(13, 0);
            cal.set(14, 0);
            return formatter.format(cal.getTime());
        }

        public void setOnTimeChangedListener(OnTimeChangedListener listener) {
            this.mOnTimeChangedListener = listener;
        }

        public void onClick(View v) {
            this.setAm(v == this.mAmView, true);
        }

        @Override
        public void onModeChanged(int mode) {
            this.invalidate(0, 0, this.mHeaderRealWidth, this.mHeaderRealHeight);
        }

        @Override
        public void onHourChanged(int oldValue, int newValue) {
            int oldHour = this.mTimePicker.is24Hour() || this.mIsAm ? oldValue : oldValue + 12;
            this.mHour = String.format(this.mIsLeadingZero ? FORMAT : FORMAT_NO_LEADING_ZERO, !this.mTimePicker.is24Hour() && newValue == 0 ? 12 : newValue);
            this.mLocationDirty = true;
            this.invalidate(0, 0, this.mHeaderRealWidth, this.mHeaderRealHeight);
            if (this.mOnTimeChangedListener != null) {
                this.mOnTimeChangedListener.onTimeChanged(oldHour, this.getMinute(), this.getHour(), this.getMinute());
            }
        }

        @Override
        public void onMinuteChanged(int oldValue, int newValue) {
            this.mMinute = String.format(FORMAT, newValue);
            this.mLocationDirty = true;
            this.invalidate(0, 0, this.mHeaderRealWidth, this.mHeaderRealHeight);
            if (this.mOnTimeChangedListener != null) {
                this.mOnTimeChangedListener.onTimeChanged(this.getHour(), oldValue, this.getHour(), newValue);
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int checkboxSize;
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            boolean isPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
            int n = checkboxSize = this.mTimePicker.is24Hour() ? 0 : this.mCheckBoxSize;
            if (isPortrait) {
                int spec;
                if (heightMode == Integer.MIN_VALUE) {
                    heightSize = Math.min(heightSize, checkboxSize + widthSize + this.mHeaderHeight);
                }
                if (checkboxSize > 0) {
                    spec = View.MeasureSpec.makeMeasureSpec((int)this.mCheckBoxSize, (int)0x40000000);
                    this.mAmView.setVisibility(0);
                    this.mPmView.setVisibility(0);
                    this.mAmView.measure(spec, spec);
                    this.mPmView.measure(spec, spec);
                } else {
                    this.mAmView.setVisibility(8);
                    this.mPmView.setVisibility(8);
                }
                spec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000);
                this.mTimePicker.measure(spec, spec);
                this.setMeasuredDimension(widthSize, heightSize);
            } else {
                int spec;
                int halfWidth = widthSize / 2;
                if (heightMode == Integer.MIN_VALUE) {
                    heightSize = Math.min(heightSize, Math.max(checkboxSize > 0 ? checkboxSize + this.mHeaderHeight + TimePickerDialog.this.mContentPadding : this.mHeaderHeight, halfWidth));
                }
                if (checkboxSize > 0) {
                    spec = View.MeasureSpec.makeMeasureSpec((int)checkboxSize, (int)0x40000000);
                    this.mAmView.setVisibility(0);
                    this.mPmView.setVisibility(0);
                    this.mAmView.measure(spec, spec);
                    this.mPmView.measure(spec, spec);
                } else {
                    this.mAmView.setVisibility(8);
                    this.mPmView.setVisibility(8);
                }
                spec = View.MeasureSpec.makeMeasureSpec((int)Math.min(halfWidth, heightSize), (int)0x40000000);
                this.mTimePicker.measure(spec, spec);
                this.setMeasuredDimension(widthSize, heightSize);
            }
        }

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            int checkboxSize;
            boolean isPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
            this.mLocationDirty = true;
            int n = checkboxSize = this.mTimePicker.is24Hour() ? 0 : this.mCheckBoxSize;
            if (isPortrait) {
                this.mHeaderRealWidth = w;
                this.mHeaderRealHeight = h - checkboxSize - w;
                this.mHeaderBackground.reset();
                if (TimePickerDialog.this.mCornerRadius == 0.0f) {
                    this.mHeaderBackground.addRect(0.0f, 0.0f, (float)this.mHeaderRealWidth, (float)this.mHeaderRealHeight, Path.Direction.CW);
                } else {
                    this.mHeaderBackground.moveTo(0.0f, (float)this.mHeaderRealHeight);
                    this.mHeaderBackground.lineTo(0.0f, TimePickerDialog.this.mCornerRadius);
                    this.mRect.set(0.0f, 0.0f, TimePickerDialog.this.mCornerRadius * 2.0f, TimePickerDialog.this.mCornerRadius * 2.0f);
                    this.mHeaderBackground.arcTo(this.mRect, 180.0f, 90.0f, false);
                    this.mHeaderBackground.lineTo((float)this.mHeaderRealWidth - TimePickerDialog.this.mCornerRadius, 0.0f);
                    this.mRect.set((float)this.mHeaderRealWidth - TimePickerDialog.this.mCornerRadius * 2.0f, 0.0f, (float)this.mHeaderRealWidth, TimePickerDialog.this.mCornerRadius * 2.0f);
                    this.mHeaderBackground.arcTo(this.mRect, 270.0f, 90.0f, false);
                    this.mHeaderBackground.lineTo((float)this.mHeaderRealWidth, (float)this.mHeaderRealHeight);
                    this.mHeaderBackground.close();
                }
            } else {
                this.mHeaderRealWidth = w / 2;
                this.mHeaderRealHeight = checkboxSize > 0 ? h - checkboxSize - TimePickerDialog.this.mContentPadding : h;
                this.mHeaderBackground.reset();
                if (TimePickerDialog.this.mCornerRadius == 0.0f) {
                    this.mHeaderBackground.addRect(0.0f, 0.0f, (float)this.mHeaderRealWidth, (float)this.mHeaderRealHeight, Path.Direction.CW);
                } else {
                    this.mHeaderBackground.moveTo(0.0f, (float)this.mHeaderRealHeight);
                    this.mHeaderBackground.lineTo(0.0f, TimePickerDialog.this.mCornerRadius);
                    this.mRect.set(0.0f, 0.0f, TimePickerDialog.this.mCornerRadius * 2.0f, TimePickerDialog.this.mCornerRadius * 2.0f);
                    this.mHeaderBackground.arcTo(this.mRect, 180.0f, 90.0f, false);
                    this.mHeaderBackground.lineTo((float)this.mHeaderRealWidth, 0.0f);
                    this.mHeaderBackground.lineTo((float)this.mHeaderRealWidth, (float)this.mHeaderRealHeight);
                    this.mHeaderBackground.close();
                }
            }
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            int checkboxSize;
            int childLeft = 0;
            int childTop = 0;
            int childRight = right - left;
            int childBottom = bottom - top;
            boolean isPortrait = this.getContext().getResources().getConfiguration().orientation == 1;
            int n = checkboxSize = this.mTimePicker.is24Hour() ? 0 : this.mCheckBoxSize;
            if (isPortrait) {
                int paddingHorizontal = TimePickerDialog.this.mContentPadding + TimePickerDialog.this.mActionPadding;
                int paddingVertical = TimePickerDialog.this.mContentPadding - TimePickerDialog.this.mActionPadding;
                if (checkboxSize > 0) {
                    this.mAmView.layout(childLeft + paddingHorizontal, childBottom - paddingVertical - checkboxSize, childLeft + paddingHorizontal + checkboxSize, childBottom - paddingVertical);
                    this.mPmView.layout(childRight - paddingHorizontal - checkboxSize, childBottom - paddingVertical - checkboxSize, childRight - paddingHorizontal, childBottom - paddingVertical);
                }
                this.mTimePicker.layout(childLeft, childTop += this.mHeaderRealHeight, childRight, childBottom -= checkboxSize);
            } else {
                int paddingHorizontal = (childRight / 2 - this.mTimePicker.getMeasuredWidth()) / 2;
                int paddingVertical = (childBottom - this.mTimePicker.getMeasuredHeight()) / 2;
                this.mTimePicker.layout(childRight - paddingHorizontal - this.mTimePicker.getMeasuredWidth(), childTop + paddingVertical, childRight - paddingHorizontal, childTop + paddingVertical + this.mTimePicker.getMeasuredHeight());
                if (checkboxSize > 0) {
                    paddingHorizontal = TimePickerDialog.this.mContentPadding + TimePickerDialog.this.mActionPadding;
                    paddingVertical = TimePickerDialog.this.mContentPadding - TimePickerDialog.this.mActionPadding;
                    this.mAmView.layout(childLeft + paddingHorizontal, childBottom - paddingVertical - checkboxSize, childLeft + paddingHorizontal + checkboxSize, childBottom - paddingVertical);
                    this.mPmView.layout((childRight /= 2) - paddingHorizontal - checkboxSize, childBottom - paddingVertical - checkboxSize, childRight - paddingHorizontal, childBottom - paddingVertical);
                }
            }
        }

        private void measureTimeText() {
            if (!this.mLocationDirty) {
                return;
            }
            this.mPaint.setTextSize((float)this.mTextTimeSize);
            Rect bounds = new Rect();
            this.mPaint.getTextBounds(BASE_TEXT, 0, BASE_TEXT.length(), bounds);
            this.mBaseHeight = bounds.height();
            this.mBaseY = ((float)this.mHeaderRealHeight + this.mBaseHeight) / 2.0f;
            float dividerWidth = this.mPaint.measureText(TIME_DIVIDER, 0, TIME_DIVIDER.length());
            this.mHourWidth = this.mPaint.measureText(this.mHour, 0, this.mHour.length());
            this.mMinuteWidth = this.mPaint.measureText(this.mMinute, 0, this.mMinute.length());
            this.mDividerX = ((float)this.mHeaderRealWidth - dividerWidth) / 2.0f;
            this.mHourX = this.mDividerX - this.mHourWidth;
            this.mMinuteX = this.mDividerX + dividerWidth;
            this.mMiddayX = this.mMinuteX + this.mMinuteWidth;
            this.mLocationDirty = false;
        }

        public void draw(Canvas canvas) {
            super.draw(canvas);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(this.mTimePicker.getSelectionColor());
            canvas.drawPath(this.mHeaderBackground, this.mPaint);
            this.measureTimeText();
            this.mPaint.setTextSize((float)this.mTextTimeSize);
            this.mPaint.setColor(this.mTimePicker.getMode() == 0 ? this.mTimePicker.getTextHighlightColor() : this.mTextTimeColor);
            canvas.drawText(this.mHour, this.mHourX, this.mBaseY, this.mPaint);
            this.mPaint.setColor(this.mTextTimeColor);
            canvas.drawText(TIME_DIVIDER, this.mDividerX, this.mBaseY, this.mPaint);
            this.mPaint.setColor(this.mTimePicker.getMode() == 1 ? this.mTimePicker.getTextHighlightColor() : this.mTextTimeColor);
            canvas.drawText(this.mMinute, this.mMinuteX, this.mBaseY, this.mPaint);
            if (!this.mTimePicker.is24Hour()) {
                this.mPaint.setTextSize((float)this.mTimePicker.getTextSize());
                this.mPaint.setColor(this.mTextTimeColor);
                canvas.drawText(this.mMidday, this.mMiddayX, this.mBaseY, this.mPaint);
            }
        }

        private boolean isTouched(float left, float top, float right, float bottom, float x, float y) {
            return x >= left && x <= right && y >= top && y <= bottom;
        }

        public boolean onTouchEvent(MotionEvent event) {
            boolean handled = super.onTouchEvent(event);
            if (handled) {
                return handled;
            }
            switch (event.getAction()) {
                case 0: {
                    if (this.isTouched(this.mHourX, this.mBaseY - this.mBaseHeight, this.mHourX + this.mHourWidth, this.mBaseY, event.getX(), event.getY())) {
                        return this.mTimePicker.getMode() == 1;
                    }
                    if (!this.isTouched(this.mMinuteX, this.mBaseY - this.mBaseHeight, this.mMinuteX + this.mMinuteWidth, this.mBaseY, event.getX(), event.getY())) break;
                    return this.mTimePicker.getMode() == 0;
                }
                case 1: {
                    if (this.isTouched(this.mHourX, this.mBaseY - this.mBaseHeight, this.mHourX + this.mHourWidth, this.mBaseY, event.getX(), event.getY())) {
                        this.mTimePicker.setMode(0, true);
                    }
                    if (!this.isTouched(this.mMinuteX, this.mBaseY - this.mBaseHeight, this.mMinuteX + this.mMinuteWidth, this.mBaseY, event.getX(), event.getY())) break;
                    this.mTimePicker.setMode(1, true);
                }
            }
            return false;
        }
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(int var1, int var2, int var3, int var4);
    }
}

