/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import com.rey.material.R;
import com.rey.material.drawable.BlankDrawable;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.TypefaceUtil;
import com.rey.material.widget.CircleCheckedTextView;
import com.rey.material.widget.ListView;
import java.util.Calendar;

public class YearPicker
extends ListView {
    private YearAdapter mAdapter;
    private int mTextSize;
    private int mItemHeight;
    private int mSelectionColor;
    private int mAnimDuration;
    private Interpolator mInInterpolator;
    private Interpolator mOutInterpolator;
    private Typeface mTypeface;
    private int mItemRealHeight = -1;
    private int mPadding;
    private int mPositionShift;
    private int mDistanceShift;
    private Paint mPaint;
    private OnYearChangedListener mOnYearChangedListener;
    private static final int[][] STATES = new int[][]{{-16842912}, {0x10100A0}};
    private int[] mTextColors = new int[2];

    public YearPicker(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public YearPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public YearPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public YearPicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.setWillNotDraw(false);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mAdapter = new YearAdapter();
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setScrollBarStyle(0x2000000);
        this.setSelector(BlankDrawable.getInstance());
        this.setDividerHeight(0);
        this.setCacheColorHint(0);
        this.setClipToPadding(false);
        this.mPadding = ThemeUtil.dpToPx(context, 4);
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
    }

    public void applyStyle(int resId) {
        this.applyStyle(this.getContext(), null, 0, resId);
    }

    private void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.YearPicker, defStyleAttr, defStyleRes);
        this.mTextSize = a.getDimensionPixelSize(R.styleable.YearPicker_dp_yearTextSize, context.getResources().getDimensionPixelOffset(R.dimen.abc_text_size_title_material));
        int year = a.getInteger(R.styleable.YearPicker_dp_year, this.mAdapter.getYear());
        int yearMin = a.getInteger(R.styleable.YearPicker_dp_yearMin, this.mAdapter.getMinYear());
        int yearMax = a.getInteger(R.styleable.YearPicker_dp_yearMax, this.mAdapter.getMaxYear());
        this.mItemHeight = a.getDimensionPixelSize(R.styleable.YearPicker_dp_yearItemHeight, ThemeUtil.dpToPx(context, 48));
        this.mTextColors[0] = a.getColor(R.styleable.YearPicker_dp_textColor, -16777216);
        this.mTextColors[1] = a.getColor(R.styleable.YearPicker_dp_textHighlightColor, -1);
        this.mSelectionColor = a.getColor(R.styleable.YearPicker_dp_selectionColor, ThemeUtil.colorPrimary(context, -16777216));
        this.mAnimDuration = a.getInteger(R.styleable.YearPicker_dp_animDuration, context.getResources().getInteger(0x10E0001));
        int resId = a.getResourceId(R.styleable.YearPicker_dp_inInterpolator, 0);
        this.mInInterpolator = resId != 0 ? AnimationUtils.loadInterpolator((Context)context, (int)resId) : new DecelerateInterpolator();
        resId = a.getResourceId(R.styleable.YearPicker_dp_outInterpolator, 0);
        this.mOutInterpolator = resId != 0 ? AnimationUtils.loadInterpolator((Context)context, (int)resId) : new DecelerateInterpolator();
        String familyName = a.getString(R.styleable.YearPicker_dp_fontFamily);
        int style2 = a.getInteger(R.styleable.YearPicker_dp_textStyle, 0);
        this.mTypeface = TypefaceUtil.load(context, familyName, style2);
        a.recycle();
        if (yearMax < yearMin) {
            yearMax = Integer.MAX_VALUE;
        }
        if (year < 0) {
            Calendar cal = Calendar.getInstance();
            year = cal.get(1);
        }
        year = Math.max(yearMin, Math.min(yearMax, year));
        this.setYearRange(yearMin, yearMax);
        this.setYear(year);
        this.mAdapter.notifyDataSetChanged();
    }

    public void setYearRange(int min, int max) {
        this.mAdapter.setYearRange(min, max);
    }

    public void goTo(int year) {
        int position = this.mAdapter.positionOfYear(year) - this.mPositionShift;
        int offset = this.mDistanceShift;
        if (position < 0) {
            position = 0;
            offset = 0;
        }
        this.postSetSelectionFromTop(position, offset);
    }

    public void postSetSelectionFromTop(final int position, final int offset) {
        this.post(new Runnable(){

            @Override
            public void run() {
                YearPicker.this.setSelectionFromTop(position, offset);
                YearPicker.this.requestLayout();
            }
        });
    }

    public void setYear(int year) {
        if (this.mAdapter.getYear() == year) {
            return;
        }
        this.mAdapter.setYear(year);
        this.goTo(year);
    }

    public int getYear() {
        return this.mAdapter.getYear();
    }

    public void setOnYearChangedListener(OnYearChangedListener listener) {
        this.mOnYearChangedListener = listener;
    }

    private void measureItemHeight() {
        if (this.mItemRealHeight > 0) {
            return;
        }
        this.mPaint.setTextSize((float)this.mTextSize);
        this.mItemRealHeight = Math.max(Math.round(this.mPaint.measureText("9999", 0, 4)) + this.mPadding * 2, this.mItemHeight);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.measureItemHeight();
        if (heightMode != 0x40000000) {
            if (heightMode == Integer.MIN_VALUE) {
                int num = Math.min(this.mAdapter.getCount(), heightSize / this.mItemRealHeight);
                if (num >= 3) {
                    heightSize = this.mItemRealHeight * (num % 2 == 0 ? num - 1 : num);
                }
            } else {
                heightSize = this.mItemRealHeight * this.mAdapter.getCount();
            }
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(heightSize + this.getPaddingTop() + this.getPaddingBottom()), (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        float shift = ((float)h / (float)this.mItemRealHeight - 1.0f) / 2.0f;
        this.mPositionShift = (int)Math.floor(shift);
        this.mPositionShift = shift > (float)this.mPositionShift ? this.mPositionShift + 1 : this.mPositionShift;
        this.mDistanceShift = (int)((shift - (float)this.mPositionShift) * (float)this.mItemRealHeight) - this.getPaddingTop();
        this.goTo(this.mAdapter.getYear());
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.yearMin = this.mAdapter.getMinYear();
        ss.yearMax = this.mAdapter.getMaxYear();
        ss.year = this.mAdapter.getYear();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setYearRange(ss.yearMin, ss.yearMax);
        this.setYear(ss.year);
    }

    static class SavedState
    extends View.BaseSavedState {
        int yearMin;
        int yearMax;
        int year;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.yearMin = in.readInt();
            this.yearMax = in.readInt();
            this.year = in.readInt();
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeValue((Object)this.yearMin);
            out.writeValue((Object)this.yearMax);
            out.writeValue((Object)this.year);
        }

        public String toString() {
            return "YearPicker.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " yearMin=" + this.yearMin + " yearMax=" + this.yearMax + " year=" + this.year + "}";
        }
    }

    private class YearAdapter
    extends BaseAdapter
    implements View.OnClickListener {
        private int mMinYear = 1990;
        private int mMaxYear = 0x7FFFFFFE;
        private int mCurYear = -1;

        public int getMinYear() {
            return this.mMinYear;
        }

        public int getMaxYear() {
            return this.mMaxYear;
        }

        public void setYearRange(int min, int max) {
            if (this.mMinYear != min || this.mMaxYear != max) {
                this.mMinYear = min;
                this.mMaxYear = max;
                this.notifyDataSetChanged();
            }
        }

        public int positionOfYear(int year) {
            return year - this.mMinYear;
        }

        public int getCount() {
            return this.mMaxYear - this.mMinYear + 1;
        }

        public Object getItem(int position) {
            return this.mMinYear + position;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public void setYear(int year) {
            if (this.mCurYear != year) {
                int old = this.mCurYear;
                this.mCurYear = year;
                CircleCheckedTextView child = (CircleCheckedTextView)YearPicker.this.getChildAt(this.positionOfYear(old) - YearPicker.this.getFirstVisiblePosition());
                if (child != null) {
                    child.setChecked(false);
                }
                if ((child = (CircleCheckedTextView)YearPicker.this.getChildAt(this.positionOfYear(this.mCurYear) - YearPicker.this.getFirstVisiblePosition())) != null) {
                    child.setChecked(true);
                }
                if (YearPicker.this.mOnYearChangedListener != null) {
                    YearPicker.this.mOnYearChangedListener.onYearChanged(old, this.mCurYear);
                }
            }
        }

        public int getYear() {
            return this.mCurYear;
        }

        public void onClick(View v) {
            this.setYear((Integer)v.getTag());
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            CircleCheckedTextView v = (CircleCheckedTextView)convertView;
            if (v == null) {
                v = new CircleCheckedTextView(YearPicker.this.getContext());
                v.setGravity(17);
                v.setMinHeight(YearPicker.this.mItemRealHeight);
                v.setMaxHeight(YearPicker.this.mItemRealHeight);
                v.setAnimDuration(YearPicker.this.mAnimDuration);
                v.setInterpolator(YearPicker.this.mInInterpolator, YearPicker.this.mOutInterpolator);
                v.setBackgroundColor(YearPicker.this.mSelectionColor);
                v.setTypeface(YearPicker.this.mTypeface);
                v.setTextSize(0, YearPicker.this.mTextSize);
                v.setTextColor(new ColorStateList(STATES, YearPicker.this.mTextColors));
                v.setOnClickListener(this);
            }
            int year = (Integer)this.getItem(position);
            v.setTag(year);
            v.setText(String.valueOf(year));
            v.setCheckedImmediately(year == this.mCurYear);
            return v;
        }
    }

    public static interface OnYearChangedListener {
        public void onYearChanged(int var1, int var2);
    }
}

