/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import com.rey.material.R;
import com.rey.material.drawable.BlankDrawable;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.TypefaceUtil;
import com.rey.material.widget.ListView;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class DatePicker
extends ListView
implements AbsListView.OnScrollListener {
    private Typeface mTypeface;
    private int mTextSize;
    private int mTextColor;
    private int mTextLabelColor;
    private int mTextHighlightColor;
    private int mTextDisableColor;
    private int mSelectionColor;
    private int mAnimDuration;
    private Interpolator mInInterpolator;
    private Interpolator mOutInterpolator;
    private Paint mPaint;
    private float mDayBaseWidth;
    private float mDayBaseHeight;
    private float mDayHeight;
    private float mDayWidth;
    private int mDayPadding;
    private float mSelectionRadius;
    private int mMonthRealWidth;
    private int mMonthRealHeight;
    private Calendar mCalendar;
    private boolean mIsMondayFirst;
    private String[] mLabels = new String[7];
    private static String[] mDayTexts;
    private MonthAdapter mAdapter;
    private OnDateChangedListener mOnDateChangedListener;
    protected static final int SCROLL_DURATION = 250;
    protected static final int SCROLL_CHANGE_DELAY = 40;
    protected static final int LIST_TOP_OFFSET = -1;
    protected Handler mHandler = new Handler();
    protected int mCurrentScrollState = 0;
    protected long mPreviousScrollPosition;
    protected int mPreviousScrollState = 0;
    protected float mFriction = 1.0f;
    protected ScrollStateRunnable mScrollStateChangedRunnable = new ScrollStateRunnable();
    private int mPaddingLeft;
    private int mPaddingTop;
    private int mPaddingRight;
    private int mPaddingBottom;

    public DatePicker(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public DatePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public DatePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public DatePicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.setWillNotDraw(false);
        this.setSelector(BlankDrawable.getInstance());
        this.setCacheColorHint(0);
        this.setDivider(null);
        this.setItemsCanFocus(true);
        this.setFastScrollEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        this.setOnScrollListener(this);
        this.setFadingEdgeLength(0);
        this.setFrictionIfSupported(ViewConfiguration.getScrollFriction() * this.mFriction);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayPadding = ThemeUtil.dpToPx(context, 4);
        this.mCalendar = Calendar.getInstance();
        this.mIsMondayFirst = this.mCalendar.getFirstDayOfWeek() == 2;
        int index = this.mCalendar.get(7) - 1;
        SimpleDateFormat format = new SimpleDateFormat(Build.VERSION.SDK_INT >= 18 ? "EEEEE" : "E");
        for (int i = 0; i < 7; ++i) {
            this.mLabels[index] = format.format(this.mCalendar.getTime());
            index = (index + 1) % 7;
            this.mCalendar.add(5, 1);
        }
        this.mAdapter = new MonthAdapter();
        this.setAdapter((ListAdapter)this.mAdapter);
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
    }

    public void applyStyle(int resId) {
        this.applyStyle(this.getContext(), null, 0, resId);
    }

    private void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyleAttr, defStyleRes);
        this.mTextSize = a.getDimensionPixelSize(R.styleable.DatePicker_dp_dayTextSize, context.getResources().getDimensionPixelOffset(R.dimen.abc_text_size_caption_material));
        this.mTextColor = a.getColor(R.styleable.DatePicker_dp_textColor, -16777216);
        this.mTextHighlightColor = a.getColor(R.styleable.DatePicker_dp_textHighlightColor, -1);
        this.mTextLabelColor = a.getColor(R.styleable.DatePicker_dp_textLabelColor, -9013642);
        this.mTextDisableColor = a.getColor(R.styleable.DatePicker_dp_textDisableColor, -9013642);
        this.mSelectionColor = a.getColor(R.styleable.DatePicker_dp_selectionColor, ThemeUtil.colorPrimary(context, -16777216));
        this.mAnimDuration = a.getInteger(R.styleable.DatePicker_dp_animDuration, context.getResources().getInteger(0x10E0001));
        int resId = a.getResourceId(R.styleable.DatePicker_dp_inInterpolator, 0);
        this.mInInterpolator = resId != 0 ? AnimationUtils.loadInterpolator((Context)context, (int)resId) : new DecelerateInterpolator();
        resId = a.getResourceId(R.styleable.DatePicker_dp_outInterpolator, 0);
        this.mOutInterpolator = resId != 0 ? AnimationUtils.loadInterpolator((Context)context, (int)resId) : new DecelerateInterpolator();
        String familyName = a.getString(R.styleable.DatePicker_dp_fontFamily);
        int style2 = a.getInteger(R.styleable.DatePicker_dp_textStyle, 0);
        this.mTypeface = TypefaceUtil.load(context, familyName, style2);
        int padding = a.getDimensionPixelSize(R.styleable.DatePicker_android_padding, -1);
        if (padding >= 0) {
            this.setContentPadding(padding, padding, padding, padding);
        }
        this.mPaddingLeft = a.getDimensionPixelSize(R.styleable.DatePicker_android_paddingLeft, this.mPaddingLeft);
        this.mPaddingTop = a.getDimensionPixelSize(R.styleable.DatePicker_android_paddingTop, this.mPaddingTop);
        this.mPaddingRight = a.getDimensionPixelSize(R.styleable.DatePicker_android_paddingRight, this.mPaddingRight);
        this.mPaddingBottom = a.getDimensionPixelSize(R.styleable.DatePicker_android_paddingBottom, this.mPaddingBottom);
        a.recycle();
    }

    @TargetApi(value=11)
    private void setFrictionIfSupported(float friction) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.setFriction(friction);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        MonthView child = (MonthView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        this.mPreviousScrollPosition = this.getFirstVisiblePosition() * child.getHeight() - child.getBottom();
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    public void onScrollStateChanged(AbsListView absListView, int scroll) {
        this.mScrollStateChangedRunnable.doScrollStateChange(absListView, scroll);
    }

    private void measureBaseSize() {
        this.mPaint.setTextSize((float)this.mTextSize);
        this.mPaint.setTypeface(this.mTypeface);
        this.mDayBaseWidth = this.mPaint.measureText("88", 0, 2) + (float)(this.mDayPadding * 2);
        Rect bounds = new Rect();
        this.mPaint.getTextBounds("88", 0, 2, bounds);
        this.mDayBaseHeight = bounds.height();
    }

    private void measureMonthView(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.measureBaseSize();
        int size = Math.round(Math.max(this.mDayBaseWidth, this.mDayBaseHeight));
        int width = size * 7 + this.mPaddingLeft + this.mPaddingRight;
        int height = Math.round((float)(size * 7) + this.mDayBaseHeight + (float)(this.mDayPadding * 2) + (float)this.mPaddingTop + (float)this.mPaddingBottom);
        switch (widthMode) {
            case -2147483648: {
                width = Math.min(width, widthSize);
                break;
            }
            case 0x40000000: {
                width = widthSize;
            }
        }
        switch (heightMode) {
            case -2147483648: {
                height = Math.min(height, heightSize);
                break;
            }
            case 0x40000000: {
                height = heightSize;
            }
        }
        this.mMonthRealWidth = width;
        this.mMonthRealHeight = height;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureMonthView(widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mDayWidth = (float)(w - this.mPaddingLeft - this.mPaddingRight) / 7.0f;
        this.mDayHeight = ((float)h - this.mDayBaseHeight - (float)(this.mDayPadding * 2) - (float)this.mPaddingTop - (float)this.mPaddingBottom) / 7.0f;
        this.mSelectionRadius = Math.min(this.mDayWidth, this.mDayHeight) / 2.0f;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(0, 0, 0, 0);
    }

    public void setContentPadding(int left, int top, int right, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingTop = top;
        this.mPaddingRight = right;
        this.mPaddingBottom = bottom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String getDayText(int day) {
        if (mDayTexts == null) {
            Class<DatePicker> clazz = DatePicker.class;
            // MONITORENTER : com.rey.material.widget.DatePicker.class
            if (mDayTexts == null) {
                mDayTexts = new String[31];
            }
            // MONITOREXIT : clazz
        }
        if (mDayTexts[day - 1] != null) return mDayTexts[day - 1];
        DatePicker.mDayTexts[day - 1] = String.valueOf(day);
        return mDayTexts[day - 1];
    }

    public void setDateRange(int minDay, int minMonth, int minYear, int maxDay, int maxMonth, int maxYear) {
        this.mAdapter.setDateRange(minDay, minMonth, minYear, maxDay, maxMonth, maxYear);
    }

    public void goTo(int month, int year) {
        int position = this.mAdapter.positionOfMonth(month, year);
        this.postSetSelectionFromTop(position, 0);
    }

    public void postSetSelectionFromTop(final int position, final int offset) {
        this.post(new Runnable(){

            @Override
            public void run() {
                DatePicker.this.setSelectionFromTop(position, offset);
                DatePicker.this.requestLayout();
            }
        });
    }

    public void setDate(int day, int month, int year) {
        if (this.mAdapter.getYear() == year && this.mAdapter.getMonth() == month && this.mAdapter.getDay() == day) {
            return;
        }
        this.mAdapter.setDate(day, month, year, false);
        this.goTo(month, year);
    }

    public void setOnDateChangedListener(OnDateChangedListener listener) {
        this.mOnDateChangedListener = listener;
    }

    public int getDay() {
        return this.mAdapter.getDay();
    }

    public int getMonth() {
        return this.mAdapter.getMonth();
    }

    public int getYear() {
        return this.mAdapter.getYear();
    }

    public String getFormattedDate(DateFormat formatter) {
        this.mCalendar.set(1, this.mAdapter.getYear());
        this.mCalendar.set(2, this.mAdapter.getMonth());
        this.mCalendar.set(5, this.mAdapter.getDay());
        return formatter.format(this.mCalendar.getTime());
    }

    public int getSelectionColor() {
        return this.mSelectionColor;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public int getTextLabelColor() {
        return this.mTextLabelColor;
    }

    public int getTextHighlightColor() {
        return this.mTextHighlightColor;
    }

    public int getTextDisableColor() {
        return this.mTextDisableColor;
    }

    public Calendar getCalendar() {
        return this.mCalendar;
    }

    private class MonthAdapter
    extends BaseAdapter {
        private int mDay = -1;
        private int mMonth = -1;
        private int mYear = -1;
        private int mMinDay = -1;
        private int mMinMonth = -1;
        private int mMinYear = -1;
        private int mMaxDay = -1;
        private int mMaxMonth = -1;
        private int mMaxYear = -1;
        private int mToday;
        private int mTodayMonth;
        private int mTodayYear;
        private int mMinMonthValue;
        private int mMaxMonthValue;

        private MonthAdapter() {
        }

        public void setDateRange(int minDay, int minMonth, int minYear, int maxDay, int maxMonth, int maxYear) {
            int maxMonthValue;
            int minMonthValue = minDay < 0 || minMonth < 0 || minYear < 0 ? 0 : minYear * 12 + minMonth;
            int n = maxMonthValue = maxDay < 0 || maxMonth < 0 || maxYear < 0 ? 0x7FFFFFFE : maxYear * 12 + maxMonth;
            if (minDay != this.mMinDay || this.mMinMonthValue != minMonthValue || maxDay != this.mMaxDay || this.mMaxMonthValue != maxMonthValue) {
                this.mMinDay = minDay;
                this.mMinMonth = minMonth;
                this.mMinYear = minYear;
                this.mMaxDay = maxDay;
                this.mMaxMonth = maxMonth;
                this.mMaxYear = maxYear;
                this.mMinMonthValue = minMonthValue;
                this.mMaxMonthValue = maxMonthValue;
                this.notifyDataSetChanged();
            }
        }

        public void setDate(int day, int month, int year, boolean animation) {
            if (this.mMonth != month || this.mYear != year) {
                MonthView v = (MonthView)DatePicker.this.getChildAt(this.positionOfMonth(this.mMonth, this.mYear) - DatePicker.this.getFirstVisiblePosition());
                if (v != null) {
                    v.setSelectedDay(-1, false);
                }
                int oldDay = this.mDay;
                int oldMonth = this.mMonth;
                int oldYear = this.mYear;
                this.mDay = day;
                this.mMonth = month;
                this.mYear = year;
                v = (MonthView)DatePicker.this.getChildAt(this.positionOfMonth(this.mMonth, this.mYear) - DatePicker.this.getFirstVisiblePosition());
                if (v != null) {
                    v.setSelectedDay(this.mDay, animation);
                }
                if (DatePicker.this.mOnDateChangedListener != null) {
                    DatePicker.this.mOnDateChangedListener.onDateChanged(oldDay, oldMonth, oldYear, this.mDay, this.mMonth, this.mYear);
                }
            } else if (day != this.mDay) {
                int oldDay = this.mDay;
                this.mDay = day;
                MonthView v = (MonthView)DatePicker.this.getChildAt(this.positionOfMonth(this.mMonth, this.mYear) - DatePicker.this.getFirstVisiblePosition());
                if (v != null) {
                    v.setSelectedDay(this.mDay, animation);
                }
                if (DatePicker.this.mOnDateChangedListener != null) {
                    DatePicker.this.mOnDateChangedListener.onDateChanged(oldDay, this.mMonth, this.mYear, this.mDay, this.mMonth, this.mYear);
                }
            }
        }

        public int positionOfMonth(int month, int year) {
            return year * 12 + month - this.mMinMonthValue;
        }

        public int getDay() {
            return this.mDay;
        }

        public int getMonth() {
            return this.mMonth;
        }

        public int getYear() {
            return this.mYear;
        }

        private void calToday() {
            DatePicker.this.mCalendar.setTimeInMillis(System.currentTimeMillis());
            this.mToday = DatePicker.this.mCalendar.get(5);
            this.mTodayMonth = DatePicker.this.mCalendar.get(2);
            this.mTodayYear = DatePicker.this.mCalendar.get(1);
        }

        public int getCount() {
            return this.mMaxMonthValue - this.mMinMonthValue + 1;
        }

        public Object getItem(int position) {
            return position + this.mMinMonthValue;
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            MonthView v = (MonthView)convertView;
            if (v == null) {
                v = new MonthView(parent.getContext());
                v.setPadding(DatePicker.this.mPaddingLeft, DatePicker.this.mPaddingTop, DatePicker.this.mPaddingRight, DatePicker.this.mPaddingBottom);
            }
            this.calToday();
            int monthValue = (Integer)this.getItem(position);
            int year = monthValue / 12;
            int month = monthValue % 12;
            int minDay = month == this.mMinMonth && year == this.mMinYear ? this.mMinDay : -1;
            int maxDay = month == this.mMaxMonth && year == this.mMaxYear ? this.mMaxDay : -1;
            int today = this.mTodayMonth == month && this.mTodayYear == year ? this.mToday : -1;
            int day = month == this.mMonth && year == this.mYear ? this.mDay : -1;
            v.setMonth(month, year);
            v.setToday(today);
            v.setAvailableDay(minDay, maxDay);
            v.setSelectedDay(day, false);
            return v;
        }
    }

    private class MonthView
    extends View {
        private long mStartTime;
        private float mAnimProgress;
        private boolean mRunning;
        private int mTouchedDay;
        private int mMonth;
        private int mYear;
        private int mMaxDay;
        private int mFirstDayCol;
        private int mMinAvailDay;
        private int mMaxAvailDay;
        private int mToday;
        private int mSelectedDay;
        private int mPreviousSelectedDay;
        private String mMonthText;
        private final Runnable mUpdater;

        public MonthView(Context context) {
            super(context);
            this.mTouchedDay = -1;
            this.mMinAvailDay = -1;
            this.mMaxAvailDay = -1;
            this.mToday = -1;
            this.mSelectedDay = -1;
            this.mPreviousSelectedDay = -1;
            this.mUpdater = new Runnable(){

                @Override
                public void run() {
                    MonthView.this.update();
                }
            };
            this.setWillNotDraw(false);
        }

        public void setMonth(int month, int year) {
            if (this.mMonth != month || this.mYear != year) {
                this.mMonth = month;
                this.mYear = year;
                this.calculateMonthView();
                this.invalidate();
            }
        }

        public void setSelectedDay(int day, boolean animation) {
            if (this.mSelectedDay != day) {
                this.mPreviousSelectedDay = this.mSelectedDay;
                this.mSelectedDay = day;
                if (animation) {
                    this.startAnimation();
                } else {
                    this.invalidate();
                }
            }
        }

        public void setToday(int day) {
            if (this.mToday != day) {
                this.mToday = day;
                this.invalidate();
            }
        }

        public void setAvailableDay(int min, int max) {
            if (this.mMinAvailDay != min || this.mMaxAvailDay != max) {
                this.mMinAvailDay = min;
                this.mMaxAvailDay = max;
                this.invalidate();
            }
        }

        private void calculateMonthView() {
            DatePicker.this.mCalendar.set(5, 1);
            DatePicker.this.mCalendar.set(2, this.mMonth);
            DatePicker.this.mCalendar.set(1, this.mYear);
            this.mMaxDay = DatePicker.this.mCalendar.getActualMaximum(5);
            this.mFirstDayCol = DatePicker.this.mCalendar.get(7) - 1;
            if (DatePicker.this.mIsMondayFirst) {
                this.mFirstDayCol = this.mFirstDayCol == 0 ? 6 : this.mFirstDayCol - 1;
            }
            this.mMonthText = DatePicker.this.mCalendar.getDisplayName(2, 2, Locale.getDefault()) + " " + this.mYear;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(DatePicker.this.mMonthRealWidth, DatePicker.this.mMonthRealHeight);
        }

        protected void onDraw(Canvas canvas) {
            float radius;
            int row;
            int col;
            DatePicker.this.mPaint.setTextSize((float)DatePicker.this.mTextSize);
            DatePicker.this.mPaint.setTypeface(DatePicker.this.mTypeface);
            float x = 3.5f * DatePicker.this.mDayWidth + (float)this.getPaddingLeft();
            float y = (float)(DatePicker.this.mDayPadding * 2) + DatePicker.this.mDayBaseHeight + (float)this.getPaddingTop();
            DatePicker.this.mPaint.setFakeBoldText(true);
            DatePicker.this.mPaint.setColor(DatePicker.this.mTextColor);
            canvas.drawText(this.mMonthText, x, y, DatePicker.this.mPaint);
            float paddingLeft = this.getPaddingLeft();
            float paddingTop = (float)(DatePicker.this.mDayPadding * 2) + DatePicker.this.mDayBaseHeight + (float)this.getPaddingTop();
            if (this.mSelectedDay > 0) {
                col = (this.mFirstDayCol + this.mSelectedDay - 1) % 7;
                row = (this.mFirstDayCol + this.mSelectedDay - 1) / 7 + 1;
                x = ((float)col + 0.5f) * DatePicker.this.mDayWidth + paddingLeft;
                y = ((float)row + 0.5f) * DatePicker.this.mDayHeight + paddingTop;
                radius = this.mRunning ? DatePicker.this.mInInterpolator.getInterpolation(this.mAnimProgress) * DatePicker.this.mSelectionRadius : DatePicker.this.mSelectionRadius;
                DatePicker.this.mPaint.setColor(DatePicker.this.mSelectionColor);
                canvas.drawCircle(x, y, radius, DatePicker.this.mPaint);
            }
            if (this.mRunning && this.mPreviousSelectedDay > 0) {
                col = (this.mFirstDayCol + this.mPreviousSelectedDay - 1) % 7;
                row = (this.mFirstDayCol + this.mPreviousSelectedDay - 1) / 7 + 1;
                x = ((float)col + 0.5f) * DatePicker.this.mDayWidth + paddingLeft;
                y = ((float)row + 0.5f) * DatePicker.this.mDayHeight + paddingTop;
                radius = (1.0f - DatePicker.this.mOutInterpolator.getInterpolation(this.mAnimProgress)) * DatePicker.this.mSelectionRadius;
                DatePicker.this.mPaint.setColor(DatePicker.this.mSelectionColor);
                canvas.drawCircle(x, y, radius, DatePicker.this.mPaint);
            }
            DatePicker.this.mPaint.setFakeBoldText(false);
            DatePicker.this.mPaint.setColor(DatePicker.this.mTextLabelColor);
            paddingTop += (DatePicker.this.mDayHeight + DatePicker.this.mDayBaseHeight) / 2.0f;
            for (int i = 0; i < 7; ++i) {
                x = ((float)i + 0.5f) * DatePicker.this.mDayWidth + paddingLeft;
                y = paddingTop;
                int index = DatePicker.this.mIsMondayFirst ? (i == 6 ? 0 : i + 1) : i;
                canvas.drawText(DatePicker.this.mLabels[index], x, y, DatePicker.this.mPaint);
            }
            col = this.mFirstDayCol;
            row = 1;
            int maxDay = this.mMaxAvailDay > 0 ? Math.min(this.mMaxAvailDay, this.mMaxDay) : this.mMaxDay;
            for (int day = 1; day <= this.mMaxDay; ++day) {
                if (day == this.mSelectedDay) {
                    DatePicker.this.mPaint.setColor(DatePicker.this.mTextHighlightColor);
                } else if (day < this.mMinAvailDay || day > maxDay) {
                    DatePicker.this.mPaint.setColor(DatePicker.this.mTextDisableColor);
                } else if (day == this.mToday) {
                    DatePicker.this.mPaint.setColor(DatePicker.this.mSelectionColor);
                } else {
                    DatePicker.this.mPaint.setColor(DatePicker.this.mTextColor);
                }
                x = ((float)col + 0.5f) * DatePicker.this.mDayWidth + paddingLeft;
                y = (float)row * DatePicker.this.mDayHeight + paddingTop;
                canvas.drawText(DatePicker.this.getDayText(day), x, y, DatePicker.this.mPaint);
                if (++col != 7) continue;
                col = 0;
                ++row;
            }
        }

        private int getTouchedDay(float x, float y) {
            float paddingTop = (float)(DatePicker.this.mDayPadding * 2) + DatePicker.this.mDayBaseHeight + (float)this.getPaddingTop() + DatePicker.this.mDayHeight;
            if (x < (float)this.getPaddingLeft() || x > (float)(this.getWidth() - this.getPaddingRight()) || y < paddingTop || y > (float)(this.getHeight() - this.getPaddingBottom())) {
                return -1;
            }
            int col = (int)Math.floor((x - (float)this.getPaddingLeft()) / DatePicker.this.mDayWidth);
            int row = (int)Math.floor((y - paddingTop) / DatePicker.this.mDayHeight);
            int maxDay = this.mMaxAvailDay > 0 ? Math.min(this.mMaxAvailDay, this.mMaxDay) : this.mMaxDay;
            int day = row * 7 + col - this.mFirstDayCol + 1;
            if (day < 0 || day < this.mMinAvailDay || day > maxDay) {
                return -1;
            }
            return day;
        }

        public boolean onTouchEvent(MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    this.mTouchedDay = this.getTouchedDay(event.getX(), event.getY());
                    if (this.mTouchedDay <= 0) break;
                    return true;
                }
                case 1: {
                    if (this.getTouchedDay(event.getX(), event.getY()) == this.mTouchedDay) {
                        DatePicker.this.mAdapter.setDate(this.mTouchedDay, this.mMonth, this.mYear, true);
                    }
                    this.mTouchedDay = -1;
                    return true;
                }
                case 3: {
                    this.mTouchedDay = -1;
                }
            }
            return false;
        }

        private void resetAnimation() {
            this.mStartTime = SystemClock.uptimeMillis();
            this.mAnimProgress = 0.0f;
        }

        private void startAnimation() {
            if (this.getHandler() != null) {
                this.resetAnimation();
                this.mRunning = true;
                this.getHandler().postAtTime(this.mUpdater, SystemClock.uptimeMillis() + 16L);
            }
            this.invalidate();
        }

        private void stopAnimation() {
            this.mRunning = false;
            this.mAnimProgress = 1.0f;
            if (this.getHandler() != null) {
                this.getHandler().removeCallbacks(this.mUpdater);
            }
            this.invalidate();
        }

        private void update() {
            long curTime = SystemClock.uptimeMillis();
            this.mAnimProgress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)DatePicker.this.mAnimDuration);
            if (this.mAnimProgress == 1.0f) {
                this.stopAnimation();
            }
            if (this.mRunning) {
                if (this.getHandler() != null) {
                    this.getHandler().postAtTime(this.mUpdater, SystemClock.uptimeMillis() + 16L);
                } else {
                    this.stopAnimation();
                }
            }
            this.invalidate();
        }
    }

    private class ScrollStateRunnable
    implements Runnable {
        private int mNewState;

        private ScrollStateRunnable() {
        }

        public void doScrollStateChange(AbsListView view, int scrollState) {
            DatePicker.this.mHandler.removeCallbacks((Runnable)this);
            this.mNewState = scrollState;
            DatePicker.this.mHandler.postDelayed((Runnable)this, 40L);
        }

        @Override
        public void run() {
            DatePicker.this.mCurrentScrollState = this.mNewState;
            if (this.mNewState == 0 && DatePicker.this.mPreviousScrollState != 0 && DatePicker.this.mPreviousScrollState != 1) {
                DatePicker.this.mPreviousScrollState = this.mNewState;
                int i = 0;
                View child = DatePicker.this.getChildAt(i);
                while (child != null && child.getBottom() <= 0) {
                    child = DatePicker.this.getChildAt(++i);
                }
                if (child == null) {
                    return;
                }
                int firstPosition = DatePicker.this.getFirstVisiblePosition();
                int lastPosition = DatePicker.this.getLastVisiblePosition();
                boolean scroll = firstPosition != 0 && lastPosition != DatePicker.this.getCount() - 1;
                int top = child.getTop();
                int bottom = child.getBottom();
                int midpoint = DatePicker.this.getHeight() / 2;
                if (scroll && top < -1) {
                    if (bottom > midpoint) {
                        DatePicker.this.smoothScrollBy(top, 250);
                    } else {
                        DatePicker.this.smoothScrollBy(bottom, 250);
                    }
                }
            } else {
                DatePicker.this.mPreviousScrollState = this.mNewState;
            }
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

