/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.rey.material.R;
import com.rey.material.util.ColorUtil;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.ViewUtil;

public class ToolbarRippleDrawable
extends Drawable
implements Animatable {
    private boolean mRunning = false;
    private Paint mShaderPaint;
    private Paint mFillPaint;
    private RadialGradient mInShader;
    private RadialGradient mOutShader;
    private Matrix mMatrix;
    private int mAlpha = 255;
    private RectF mBackgroundBounds;
    private Path mBackground;
    private int mBackgroundAnimDuration;
    private int mBackgroundColor;
    private float mBackgroundAlphaPercent;
    private PointF mRipplePoint;
    private float mRippleRadius;
    private int mRippleType;
    private int mMaxRippleRadius;
    private int mRippleAnimDuration;
    private int mRippleColor;
    private float mRippleAlphaPercent;
    private boolean mDelayClick;
    private Interpolator mInInterpolator;
    private Interpolator mOutInterpolator;
    private long mStartTime;
    private boolean mPressed = false;
    private int mState = 0;
    private static final int STATE_OUT = 0;
    private static final int STATE_PRESS = 1;
    private static final int STATE_HOVER = 2;
    private static final int STATE_RELEASE_ON_HOLD = 3;
    private static final int STATE_RELEASE = 4;
    private static final int TYPE_TOUCH_MATCH_VIEW = -1;
    private static final int TYPE_TOUCH = 0;
    private static final int TYPE_WAVE = 1;
    private static final float[] GRADIENT_STOPS = new float[]{0.0f, 0.99f, 1.0f};
    private static final float GRADIENT_RADIUS = 16.0f;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            switch (ToolbarRippleDrawable.this.mRippleType) {
                case -1: 
                case 0: {
                    ToolbarRippleDrawable.this.updateTouch();
                    break;
                }
                case 1: {
                    ToolbarRippleDrawable.this.updateWave();
                }
            }
        }
    };

    private ToolbarRippleDrawable(int backgroundAnimDuration, int backgroundColor, int rippleType, boolean delayClick, int maxTouchRadius, int touchAnimDuration, int touchColor, Interpolator inInterpolator, Interpolator outInterpolator) {
        this.mBackgroundAnimDuration = backgroundAnimDuration;
        this.mBackgroundColor = backgroundColor;
        this.mRippleType = rippleType;
        this.mMaxRippleRadius = maxTouchRadius;
        this.mRippleAnimDuration = touchAnimDuration;
        this.mRippleColor = touchColor;
        this.mDelayClick = delayClick;
        if (this.mRippleType == 0 && this.mMaxRippleRadius <= 0) {
            this.mRippleType = -1;
        }
        this.mInInterpolator = inInterpolator;
        this.mOutInterpolator = outInterpolator;
        this.mFillPaint = new Paint(1);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mShaderPaint = new Paint(1);
        this.mShaderPaint.setStyle(Paint.Style.FILL);
        this.mBackground = new Path();
        this.mBackgroundBounds = new RectF();
        this.mRipplePoint = new PointF();
        this.mMatrix = new Matrix();
        this.mInShader = new RadialGradient(0.0f, 0.0f, 16.0f, new int[]{this.mRippleColor, this.mRippleColor, 0}, GRADIENT_STOPS, Shader.TileMode.CLAMP);
        if (this.mRippleType == 1) {
            this.mOutShader = new RadialGradient(0.0f, 0.0f, 16.0f, new int[]{0, ColorUtil.getColor(this.mRippleColor, 0.0f), this.mRippleColor}, GRADIENT_STOPS, Shader.TileMode.CLAMP);
        }
    }

    public boolean isDelayClick() {
        return this.mDelayClick;
    }

    public void setDelayClick(boolean enable) {
        this.mDelayClick = enable;
    }

    public void setAlpha(int alpha) {
        this.mAlpha = alpha;
    }

    public void setColorFilter(ColorFilter filter) {
        this.mFillPaint.setColorFilter(filter);
        this.mShaderPaint.setColorFilter(filter);
    }

    public int getOpacity() {
        return -3;
    }

    public long getClickDelayTime() {
        if (this.mState == 3) {
            return (long)((this.mDelayClick ? 2 : 1) * Math.max(this.mBackgroundAnimDuration, this.mRippleAnimDuration)) - (SystemClock.uptimeMillis() - this.mStartTime);
        }
        if (this.mState == 4) {
            return (long)(this.mDelayClick ? Math.max(this.mBackgroundAnimDuration, this.mRippleAnimDuration) : 0) - (SystemClock.uptimeMillis() - this.mStartTime);
        }
        return -1L;
    }

    private void setRippleState(int state) {
        if (this.mState != state) {
            this.mState = state;
            if (this.mState != 0) {
                if (this.mState != 2) {
                    this.start();
                } else {
                    this.stop();
                }
            } else {
                this.stop();
            }
        }
    }

    private boolean setRippleEffect(float x, float y, float radius) {
        if (this.mRipplePoint.x != x || this.mRipplePoint.y != y || this.mRippleRadius != radius) {
            this.mRipplePoint.set(x, y);
            this.mRippleRadius = radius;
            radius = this.mRippleRadius / 16.0f;
            this.mMatrix.reset();
            this.mMatrix.postTranslate(x, y);
            this.mMatrix.postScale(radius, radius, x, y);
            this.mInShader.setLocalMatrix(this.mMatrix);
            if (this.mOutShader != null) {
                this.mOutShader.setLocalMatrix(this.mMatrix);
            }
            return true;
        }
        return false;
    }

    protected void onBoundsChange(Rect bounds) {
        this.mBackgroundBounds.set((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom);
        this.mBackground.reset();
        this.mBackground.addRect(this.mBackgroundBounds, Path.Direction.CW);
    }

    public boolean isStateful() {
        return true;
    }

    protected boolean onStateChange(int[] state) {
        boolean pressed = ViewUtil.hasState(state, 16842919);
        if (this.mPressed != pressed) {
            this.mPressed = pressed;
            if (this.mPressed) {
                Rect bounds = this.getBounds();
                if (this.mState == 0 || this.mState == 4) {
                    if (this.mRippleType == 1 || this.mRippleType == -1) {
                        this.mMaxRippleRadius = this.getMaxRippleRadius(bounds.exactCenterX(), bounds.exactCenterY());
                    }
                    this.setRippleEffect(bounds.exactCenterX(), bounds.exactCenterY(), 0.0f);
                    this.setRippleState(1);
                } else if (this.mRippleType == 0) {
                    this.setRippleEffect(bounds.exactCenterX(), bounds.exactCenterY(), this.mRippleRadius);
                }
            } else if (this.mState != 0) {
                if (this.mState == 2) {
                    if (this.mRippleType == 1 || this.mRippleType == -1) {
                        this.setRippleEffect(this.mRipplePoint.x, this.mRipplePoint.y, 0.0f);
                    }
                    this.setRippleState(4);
                } else {
                    this.setRippleState(3);
                }
            }
            return true;
        }
        return false;
    }

    public void draw(Canvas canvas) {
        switch (this.mRippleType) {
            case -1: 
            case 0: {
                this.drawTouch(canvas);
                break;
            }
            case 1: {
                this.drawWave(canvas);
            }
        }
    }

    private void drawTouch(Canvas canvas) {
        if (this.mState != 0) {
            if (this.mBackgroundAlphaPercent > 0.0f) {
                this.mFillPaint.setColor(this.mBackgroundColor);
                this.mFillPaint.setAlpha(Math.round((float)this.mAlpha * this.mBackgroundAlphaPercent));
                canvas.drawPath(this.mBackground, this.mFillPaint);
            }
            if (this.mRippleRadius > 0.0f && this.mRippleAlphaPercent > 0.0f) {
                this.mShaderPaint.setAlpha(Math.round((float)this.mAlpha * this.mRippleAlphaPercent));
                this.mShaderPaint.setShader((Shader)this.mInShader);
                canvas.drawPath(this.mBackground, this.mShaderPaint);
            }
        }
    }

    private void drawWave(Canvas canvas) {
        if (this.mState != 0) {
            if (this.mState == 4) {
                if (this.mRippleRadius == 0.0f) {
                    this.mFillPaint.setColor(this.mRippleColor);
                    canvas.drawPath(this.mBackground, this.mFillPaint);
                } else {
                    this.mShaderPaint.setShader((Shader)this.mOutShader);
                    canvas.drawPath(this.mBackground, this.mShaderPaint);
                }
            } else if (this.mRippleRadius > 0.0f) {
                this.mShaderPaint.setShader((Shader)this.mInShader);
                canvas.drawPath(this.mBackground, this.mShaderPaint);
            }
        }
    }

    private int getMaxRippleRadius(float x, float y) {
        float x1 = x < this.mBackgroundBounds.centerX() ? this.mBackgroundBounds.right : this.mBackgroundBounds.left;
        float y1 = y < this.mBackgroundBounds.centerY() ? this.mBackgroundBounds.bottom : this.mBackgroundBounds.top;
        return (int)Math.round(Math.sqrt(Math.pow(x1 - x, 2.0) + Math.pow(y1 - y, 2.0)));
    }

    public void cancel() {
        this.setRippleState(0);
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.resetAnimation();
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.mRunning = false;
        this.unscheduleSelf(this.mUpdater);
        this.invalidateSelf();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void scheduleSelf(Runnable what, long when) {
        this.mRunning = true;
        super.scheduleSelf(what, when);
    }

    private void updateTouch() {
        if (this.mState != 4) {
            float backgroundProgress = Math.min(1.0f, (float)(SystemClock.uptimeMillis() - this.mStartTime) / (float)this.mBackgroundAnimDuration);
            this.mBackgroundAlphaPercent = this.mInInterpolator.getInterpolation(backgroundProgress) * (float)Color.alpha((int)this.mBackgroundColor) / 255.0f;
            float touchProgress = Math.min(1.0f, (float)(SystemClock.uptimeMillis() - this.mStartTime) / (float)this.mRippleAnimDuration);
            this.mRippleAlphaPercent = this.mInInterpolator.getInterpolation(touchProgress);
            this.setRippleEffect(this.mRipplePoint.x, this.mRipplePoint.y, (float)this.mMaxRippleRadius * this.mInInterpolator.getInterpolation(touchProgress));
            if (backgroundProgress == 1.0f && touchProgress == 1.0f) {
                this.mStartTime = SystemClock.uptimeMillis();
                this.setRippleState(this.mState == 1 ? 2 : 4);
            }
        } else {
            float backgroundProgress = Math.min(1.0f, (float)(SystemClock.uptimeMillis() - this.mStartTime) / (float)this.mBackgroundAnimDuration);
            this.mBackgroundAlphaPercent = (1.0f - this.mOutInterpolator.getInterpolation(backgroundProgress)) * (float)Color.alpha((int)this.mBackgroundColor) / 255.0f;
            float touchProgress = Math.min(1.0f, (float)(SystemClock.uptimeMillis() - this.mStartTime) / (float)this.mRippleAnimDuration);
            this.mRippleAlphaPercent = 1.0f - this.mOutInterpolator.getInterpolation(touchProgress);
            this.setRippleEffect(this.mRipplePoint.x, this.mRipplePoint.y, (float)this.mMaxRippleRadius * (1.0f + 0.5f * this.mOutInterpolator.getInterpolation(touchProgress)));
            if (backgroundProgress == 1.0f && touchProgress == 1.0f) {
                this.setRippleState(0);
            }
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }

    private void updateWave() {
        float progress = Math.min(1.0f, (float)(SystemClock.uptimeMillis() - this.mStartTime) / (float)this.mRippleAnimDuration);
        if (this.mState != 4) {
            this.setRippleEffect(this.mRipplePoint.x, this.mRipplePoint.y, (float)this.mMaxRippleRadius * this.mInInterpolator.getInterpolation(progress));
            if (progress == 1.0f) {
                this.mStartTime = SystemClock.uptimeMillis();
                if (this.mState == 1) {
                    this.setRippleState(2);
                } else {
                    this.setRippleEffect(this.mRipplePoint.x, this.mRipplePoint.y, 0.0f);
                    this.setRippleState(4);
                }
            }
        } else {
            this.setRippleEffect(this.mRipplePoint.x, this.mRipplePoint.y, (float)this.mMaxRippleRadius * this.mOutInterpolator.getInterpolation(progress));
            if (progress == 1.0f) {
                this.setRippleState(0);
            }
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }

    public static class Builder {
        private int mBackgroundAnimDuration = 200;
        private int mBackgroundColor;
        private int mRippleType;
        private int mMaxRippleRadius;
        private int mRippleAnimDuration = 400;
        private int mRippleColor;
        private boolean mDelayClick;
        private Interpolator mInInterpolator;
        private Interpolator mOutInterpolator;

        public Builder() {
        }

        public Builder(Context context, int defStyleRes) {
            this(context, null, 0, defStyleRes);
        }

        public Builder(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RippleDrawable, defStyleAttr, defStyleRes);
            this.backgroundColor(a.getColor(R.styleable.RippleDrawable_rd_backgroundColor, 0));
            this.backgroundAnimDuration(a.getInteger(R.styleable.RippleDrawable_rd_backgroundAnimDuration, context.getResources().getInteger(0x10E0001)));
            this.rippleType(a.getInteger(R.styleable.RippleDrawable_rd_rippleType, 0));
            this.delayClick(a.getBoolean(R.styleable.RippleDrawable_rd_delayClick, false));
            this.maxRippleRadius(a.getDimensionPixelSize(R.styleable.RippleDrawable_rd_maxRippleRadius, ThemeUtil.dpToPx(context, 48)));
            this.rippleColor(a.getColor(R.styleable.RippleDrawable_rd_rippleColor, ThemeUtil.colorControlHighlight(context, 0)));
            this.rippleAnimDuration(a.getInteger(R.styleable.RippleDrawable_rd_rippleAnimDuration, context.getResources().getInteger(0x10E0001)));
            int resId = a.getResourceId(R.styleable.RippleDrawable_rd_inInterpolator, 0);
            if (resId != 0) {
                this.inInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resId));
            }
            if ((resId = a.getResourceId(R.styleable.RippleDrawable_rd_outInterpolator, 0)) != 0) {
                this.outInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resId));
            }
            a.recycle();
        }

        public ToolbarRippleDrawable build() {
            if (this.mInInterpolator == null) {
                this.mInInterpolator = new AccelerateInterpolator();
            }
            if (this.mOutInterpolator == null) {
                this.mOutInterpolator = new DecelerateInterpolator();
            }
            return new ToolbarRippleDrawable(this.mBackgroundAnimDuration, this.mBackgroundColor, this.mRippleType, this.mDelayClick, this.mMaxRippleRadius, this.mRippleAnimDuration, this.mRippleColor, this.mInInterpolator, this.mOutInterpolator);
        }

        public Builder backgroundAnimDuration(int duration) {
            this.mBackgroundAnimDuration = duration;
            return this;
        }

        public Builder backgroundColor(int color) {
            this.mBackgroundColor = color;
            return this;
        }

        public Builder rippleType(int type) {
            this.mRippleType = type;
            return this;
        }

        public Builder delayClick(boolean enable) {
            this.mDelayClick = enable;
            return this;
        }

        public Builder maxRippleRadius(int radius) {
            this.mMaxRippleRadius = radius;
            return this;
        }

        public Builder rippleAnimDuration(int duration) {
            this.mRippleAnimDuration = duration;
            return this;
        }

        public Builder rippleColor(int color) {
            this.mRippleColor = color;
            return this;
        }

        public Builder inInterpolator(Interpolator interpolator) {
            this.mInInterpolator = interpolator;
            return this;
        }

        public Builder outInterpolator(Interpolator interpolator) {
            this.mOutInterpolator = interpolator;
            return this;
        }
    }
}

