/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.rey.material.R;
import com.rey.material.util.ColorUtil;
import com.rey.material.util.ThemeUtil;

public class LinearProgressDrawable
extends Drawable
implements Animatable {
    private long mLastUpdateTime;
    private long mLastProgressStateTime;
    private long mLastRunStateTime;
    private int mProgressState;
    private static final int PROGRESS_STATE_STRETCH = 0;
    private static final int PROGRESS_STATE_KEEP_STRETCH = 1;
    private static final int PROGRESS_STATE_SHRINK = 2;
    private static final int PROGRESS_STATE_KEEP_SHRINK = 3;
    private int mRunState = 0;
    private static final int RUN_STATE_STOPPED = 0;
    private static final int RUN_STATE_STARTING = 1;
    private static final int RUN_STATE_STARTED = 2;
    private static final int RUN_STATE_RUNNING = 3;
    private static final int RUN_STATE_STOPPING = 4;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_BOTTOM = 2;
    private Paint mPaint;
    private float mStartLine;
    private float mLineWidth;
    private int mStrokeColorIndex;
    private float mAnimTime;
    private Path mPath;
    private DashPathEffect mPathEffect;
    private float mProgressPercent;
    private float mSecondaryProgressPercent;
    private int mMaxLineWidth;
    private float mMaxLineWidthPercent;
    private int mMinLineWidth;
    private float mMinLineWidthPercent;
    private int mStrokeSize;
    private int mVerticalAlign;
    private int[] mStrokeColors;
    private int mStrokeSecondaryColor;
    private boolean mReverse;
    private int mTravelDuration;
    private int mTransformDuration;
    private int mKeepDuration;
    private int mInAnimationDuration;
    private int mOutAnimationDuration;
    private int mProgressMode;
    private Interpolator mTransformInterpolator;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            LinearProgressDrawable.this.update();
        }
    };

    private LinearProgressDrawable(float progressPercent, float secondaryProgressPercent, int maxLineWidth, float maxLineWidthPercent, int minLineWidth, float minLineWidthPercent, int strokeSize, int verticalAlign, int[] strokeColors, int strokeSecondaryColor, boolean reverse, int travelDuration, int transformDuration, int keepDuration, Interpolator transformInterpolator, int progressMode, int inAnimDuration, int outAnimDuration) {
        this.setProgress(progressPercent);
        this.setSecondaryProgress(secondaryProgressPercent);
        this.mMaxLineWidth = maxLineWidth;
        this.mMaxLineWidthPercent = maxLineWidthPercent;
        this.mMinLineWidth = minLineWidth;
        this.mMinLineWidthPercent = minLineWidthPercent;
        this.mStrokeSize = strokeSize;
        this.mVerticalAlign = verticalAlign;
        this.mStrokeColors = strokeColors;
        this.mStrokeSecondaryColor = strokeSecondaryColor;
        this.mReverse = reverse;
        this.mTravelDuration = travelDuration;
        this.mTransformDuration = transformDuration;
        this.mKeepDuration = keepDuration;
        this.mTransformInterpolator = transformInterpolator;
        this.mProgressMode = progressMode;
        this.mInAnimationDuration = inAnimDuration;
        this.mOutAnimationDuration = outAnimDuration;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPath = new Path();
    }

    public void draw(Canvas canvas) {
        switch (this.mProgressMode) {
            case 0: {
                this.drawDeterminate(canvas);
                break;
            }
            case 1: {
                this.drawIndeterminate(canvas);
                break;
            }
            case 2: {
                this.drawBuffer(canvas);
                break;
            }
            case 3: {
                this.drawQuery(canvas);
            }
        }
    }

    private void drawLinePath(Canvas canvas, float x1, float y1, float x2, float y2, Paint paint) {
        this.mPath.reset();
        this.mPath.moveTo(x1, y1);
        this.mPath.lineTo(x2, y2);
        canvas.drawPath(this.mPath, paint);
    }

    private void drawDeterminate(Canvas canvas) {
        Rect bounds = this.getBounds();
        int width = bounds.width();
        float size = 0.0f;
        if (this.mRunState == 1) {
            size = (float)this.mStrokeSize * (float)Math.min((long)this.mInAnimationDuration, SystemClock.uptimeMillis() - this.mLastRunStateTime) / (float)this.mInAnimationDuration;
        } else if (this.mRunState == 4) {
            size = (float)this.mStrokeSize * (float)Math.max(0L, (long)this.mOutAnimationDuration - SystemClock.uptimeMillis() + this.mLastRunStateTime) / (float)this.mOutAnimationDuration;
        } else if (this.mRunState != 0) {
            size = this.mStrokeSize;
        }
        if (size > 0.0f) {
            float y = 0.0f;
            float lineWidth = (float)width * this.mProgressPercent;
            switch (this.mVerticalAlign) {
                case 0: {
                    y = size / 2.0f;
                    break;
                }
                case 1: {
                    y = (float)bounds.height() / 2.0f;
                    break;
                }
                case 2: {
                    y = (float)bounds.height() - size / 2.0f;
                }
            }
            this.mPaint.setStrokeWidth(size);
            this.mPaint.setStyle(Paint.Style.STROKE);
            if (this.mProgressPercent != 1.0f) {
                this.mPaint.setColor(this.mStrokeSecondaryColor);
                if (this.mReverse) {
                    canvas.drawLine(0.0f, y, (float)width - lineWidth, y, this.mPaint);
                } else {
                    canvas.drawLine(lineWidth, y, (float)width, y, this.mPaint);
                }
            }
            if (this.mProgressPercent != 0.0f) {
                this.mPaint.setColor(this.mStrokeColors[0]);
                if (this.mReverse) {
                    this.drawLinePath(canvas, (float)width - lineWidth, y, width, y, this.mPaint);
                } else {
                    this.drawLinePath(canvas, 0.0f, y, lineWidth, y, this.mPaint);
                }
            }
        }
    }

    private int getIndeterminateStrokeColor() {
        if (this.mProgressState != 3 || this.mStrokeColors.length == 1) {
            return this.mStrokeColors[this.mStrokeColorIndex];
        }
        float value = Math.max(0.0f, Math.min(1.0f, (float)(SystemClock.uptimeMillis() - this.mLastProgressStateTime) / (float)this.mKeepDuration));
        int prev_index = this.mStrokeColorIndex == 0 ? this.mStrokeColors.length - 1 : this.mStrokeColorIndex - 1;
        return ColorUtil.getMiddleColor(this.mStrokeColors[prev_index], this.mStrokeColors[this.mStrokeColorIndex], value);
    }

    private void drawIndeterminate(Canvas canvas) {
        Rect bounds = this.getBounds();
        int width = bounds.width();
        float size = 0.0f;
        if (this.mRunState == 1) {
            size = (float)this.mStrokeSize * (float)Math.min((long)this.mInAnimationDuration, SystemClock.uptimeMillis() - this.mLastRunStateTime) / (float)this.mInAnimationDuration;
        } else if (this.mRunState == 4) {
            size = (float)this.mStrokeSize * (float)Math.max(0L, (long)this.mOutAnimationDuration - SystemClock.uptimeMillis() + this.mLastRunStateTime) / (float)this.mOutAnimationDuration;
        } else if (this.mRunState != 0) {
            size = this.mStrokeSize;
        }
        if (size > 0.0f) {
            float y = 0.0f;
            switch (this.mVerticalAlign) {
                case 0: {
                    y = size / 2.0f;
                    break;
                }
                case 1: {
                    y = (float)bounds.height() / 2.0f;
                    break;
                }
                case 2: {
                    y = (float)bounds.height() - size / 2.0f;
                }
            }
            this.mPaint.setStrokeWidth(size);
            this.mPaint.setStyle(Paint.Style.STROKE);
            float endLine = this.offset(this.mStartLine, this.mLineWidth, width);
            if (this.mReverse) {
                if (endLine <= this.mStartLine) {
                    this.mPaint.setColor(this.mStrokeSecondaryColor);
                    if (endLine > 0.0f) {
                        canvas.drawLine(0.0f, y, endLine, y, this.mPaint);
                    }
                    if (this.mStartLine < (float)width) {
                        canvas.drawLine(this.mStartLine, y, (float)width, y, this.mPaint);
                    }
                    this.mPaint.setColor(this.getIndeterminateStrokeColor());
                    this.drawLinePath(canvas, endLine, y, this.mStartLine, y, this.mPaint);
                } else {
                    this.mPaint.setColor(this.mStrokeSecondaryColor);
                    canvas.drawLine(this.mStartLine, y, endLine, y, this.mPaint);
                    this.mPaint.setColor(this.getIndeterminateStrokeColor());
                    this.mPath.reset();
                    if (this.mStartLine > 0.0f) {
                        this.mPath.moveTo(0.0f, y);
                        this.mPath.lineTo(this.mStartLine, y);
                    }
                    if (endLine < (float)width) {
                        this.mPath.moveTo(endLine, y);
                        this.mPath.lineTo((float)width, y);
                    }
                    canvas.drawPath(this.mPath, this.mPaint);
                }
            } else if (endLine >= this.mStartLine) {
                this.mPaint.setColor(this.mStrokeSecondaryColor);
                if (this.mStartLine > 0.0f) {
                    canvas.drawLine(0.0f, y, this.mStartLine, y, this.mPaint);
                }
                if (endLine < (float)width) {
                    canvas.drawLine(endLine, y, (float)width, y, this.mPaint);
                }
                this.mPaint.setColor(this.getIndeterminateStrokeColor());
                this.drawLinePath(canvas, this.mStartLine, y, endLine, y, this.mPaint);
            } else {
                this.mPaint.setColor(this.mStrokeSecondaryColor);
                canvas.drawLine(endLine, y, this.mStartLine, y, this.mPaint);
                this.mPaint.setColor(this.getIndeterminateStrokeColor());
                this.mPath.reset();
                if (endLine > 0.0f) {
                    this.mPath.moveTo(0.0f, y);
                    this.mPath.lineTo(endLine, y);
                }
                if (this.mStartLine < (float)width) {
                    this.mPath.moveTo(this.mStartLine, y);
                    this.mPath.lineTo((float)width, y);
                }
                canvas.drawPath(this.mPath, this.mPaint);
            }
        }
    }

    private PathEffect getPathEffect() {
        if (this.mPathEffect == null) {
            this.mPathEffect = new DashPathEffect(new float[]{0.1f, this.mStrokeSize * 2}, 0.0f);
        }
        return this.mPathEffect;
    }

    private void drawBuffer(Canvas canvas) {
        Rect bounds = this.getBounds();
        int width = bounds.width();
        float size = 0.0f;
        if (this.mRunState == 1) {
            size = (float)this.mStrokeSize * (float)Math.min((long)this.mInAnimationDuration, SystemClock.uptimeMillis() - this.mLastRunStateTime) / (float)this.mInAnimationDuration;
        } else if (this.mRunState == 4) {
            size = (float)this.mStrokeSize * (float)Math.max(0L, (long)this.mOutAnimationDuration - SystemClock.uptimeMillis() + this.mLastRunStateTime) / (float)this.mOutAnimationDuration;
        } else if (this.mRunState != 0) {
            size = this.mStrokeSize;
        }
        if (size > 0.0f) {
            float y = 0.0f;
            float lineWidth = (float)width * this.mProgressPercent;
            float secondaryLineWidth = (float)width * this.mSecondaryProgressPercent;
            switch (this.mVerticalAlign) {
                case 0: {
                    y = size / 2.0f;
                    break;
                }
                case 1: {
                    y = (float)bounds.height() / 2.0f;
                    break;
                }
                case 2: {
                    y = (float)bounds.height() - size / 2.0f;
                }
            }
            this.mPaint.setStyle(Paint.Style.STROKE);
            if (this.mProgressPercent != 1.0f) {
                this.mPaint.setStrokeWidth(size);
                this.mPaint.setColor(this.mStrokeSecondaryColor);
                this.mPaint.setPathEffect(null);
                if (this.mReverse) {
                    this.drawLinePath(canvas, (float)width - secondaryLineWidth, y, (float)width - lineWidth, y, this.mPaint);
                } else {
                    this.drawLinePath(canvas, secondaryLineWidth, y, lineWidth, y, this.mPaint);
                }
                this.mPaint.setStrokeWidth(this.mLineWidth);
                this.mPaint.setPathEffect(this.getPathEffect());
                float offset = (float)(this.mStrokeSize * 2) - this.mStartLine;
                if (this.mReverse) {
                    this.drawLinePath(canvas, -offset, y, (float)width - secondaryLineWidth, y, this.mPaint);
                } else {
                    this.drawLinePath(canvas, (float)width + offset, y, secondaryLineWidth, y, this.mPaint);
                }
            }
            if (this.mProgressPercent != 0.0f) {
                this.mPaint.setStrokeWidth(size);
                this.mPaint.setColor(this.mStrokeColors[0]);
                this.mPaint.setPathEffect(null);
                if (this.mReverse) {
                    this.drawLinePath(canvas, (float)width - lineWidth, y, width, y, this.mPaint);
                } else {
                    this.drawLinePath(canvas, 0.0f, y, lineWidth, y, this.mPaint);
                }
            }
        }
    }

    private int getQueryStrokeColor() {
        return ColorUtil.getColor(this.mStrokeColors[0], this.mAnimTime);
    }

    private void drawQuery(Canvas canvas) {
        Rect bounds = this.getBounds();
        int width = bounds.width();
        float size = 0.0f;
        if (this.mRunState == 1) {
            size = (float)this.mStrokeSize * (float)Math.min((long)this.mInAnimationDuration, SystemClock.uptimeMillis() - this.mLastRunStateTime) / (float)this.mInAnimationDuration;
        } else if (this.mRunState == 4) {
            size = (float)this.mStrokeSize * (float)Math.max(0L, (long)this.mOutAnimationDuration - SystemClock.uptimeMillis() + this.mLastRunStateTime) / (float)this.mOutAnimationDuration;
        } else if (this.mRunState != 0) {
            size = this.mStrokeSize;
        }
        if (size > 0.0f) {
            float y = 0.0f;
            switch (this.mVerticalAlign) {
                case 0: {
                    y = size / 2.0f;
                    break;
                }
                case 1: {
                    y = (float)bounds.height() / 2.0f;
                    break;
                }
                case 2: {
                    y = (float)bounds.height() - size / 2.0f;
                }
            }
            this.mPaint.setStrokeWidth(size);
            this.mPaint.setStyle(Paint.Style.STROKE);
            if (this.mProgressPercent != 1.0f) {
                this.mPaint.setColor(this.mStrokeSecondaryColor);
                canvas.drawLine(0.0f, y, (float)width, y, this.mPaint);
                if (this.mAnimTime < 1.0f) {
                    float endLine = Math.max(0.0f, Math.min((float)width, this.mStartLine + this.mLineWidth));
                    this.mPaint.setColor(this.getQueryStrokeColor());
                    this.drawLinePath(canvas, this.mStartLine, y, endLine, y, this.mPaint);
                }
            }
            if (this.mProgressPercent != 0.0f) {
                float lineWidth = (float)width * this.mProgressPercent;
                this.mPaint.setColor(this.mStrokeColors[0]);
                if (this.mReverse) {
                    this.drawLinePath(canvas, (float)width - lineWidth, y, width, y, this.mPaint);
                } else {
                    this.drawLinePath(canvas, 0.0f, y, lineWidth, y, this.mPaint);
                }
            }
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public int getProgressMode() {
        return this.mProgressMode;
    }

    public float getProgress() {
        return this.mProgressPercent;
    }

    public float getSecondaryProgress() {
        return this.mSecondaryProgressPercent;
    }

    public void setProgress(float percent) {
        if (this.mProgressPercent != (percent = Math.min(1.0f, Math.max(0.0f, percent)))) {
            this.mProgressPercent = percent;
            if (this.isRunning()) {
                this.invalidateSelf();
            } else if (this.mProgressPercent != 0.0f) {
                this.start();
            }
        }
    }

    public void setSecondaryProgress(float percent) {
        if (this.mSecondaryProgressPercent != (percent = Math.min(1.0f, Math.max(0.0f, percent)))) {
            this.mSecondaryProgressPercent = percent;
            if (this.isRunning()) {
                this.invalidateSelf();
            } else if (this.mSecondaryProgressPercent != 0.0f) {
                this.start();
            }
        }
    }

    private void resetAnimation() {
        this.mLastProgressStateTime = this.mLastUpdateTime = SystemClock.uptimeMillis();
        if (this.mProgressMode == 1) {
            this.mStartLine = this.mReverse ? (float)this.getBounds().width() : 0.0f;
            this.mStrokeColorIndex = 0;
            this.mLineWidth = this.mReverse ? (float)(-this.mMinLineWidth) : (float)this.mMinLineWidth;
            this.mProgressState = 0;
        } else if (this.mProgressMode == 2) {
            this.mStartLine = 0.0f;
        } else if (this.mProgressMode == 3) {
            this.mStartLine = !this.mReverse ? (float)this.getBounds().width() : 0.0f;
            this.mStrokeColorIndex = 0;
            this.mLineWidth = !this.mReverse ? (float)(-this.mMaxLineWidth) : (float)this.mMaxLineWidth;
        }
    }

    public void start() {
        this.start(this.mInAnimationDuration > 0);
    }

    public void stop() {
        this.stop(this.mOutAnimationDuration > 0);
    }

    private void start(boolean withAnimation) {
        if (this.isRunning()) {
            return;
        }
        if (withAnimation) {
            this.mRunState = 1;
            this.mLastRunStateTime = SystemClock.uptimeMillis();
        }
        this.resetAnimation();
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    private void stop(boolean withAnimation) {
        if (!this.isRunning()) {
            return;
        }
        if (withAnimation) {
            this.mLastRunStateTime = SystemClock.uptimeMillis();
            if (this.mRunState == 2) {
                this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
                this.invalidateSelf();
            }
            this.mRunState = 4;
        } else {
            this.mRunState = 0;
            this.unscheduleSelf(this.mUpdater);
            this.invalidateSelf();
        }
    }

    public boolean isRunning() {
        return this.mRunState != 0;
    }

    public void scheduleSelf(Runnable what, long when) {
        if (this.mRunState == 0) {
            this.mRunState = this.mInAnimationDuration > 0 ? 1 : 3;
        }
        super.scheduleSelf(what, when);
    }

    private void update() {
        switch (this.mProgressMode) {
            case 0: {
                this.updateDeterminate();
                break;
            }
            case 1: {
                this.updateIndeterminate();
                break;
            }
            case 2: {
                this.updateBuffer();
                break;
            }
            case 3: {
                this.updateQuery();
            }
        }
    }

    private void updateDeterminate() {
        long curTime = SystemClock.uptimeMillis();
        if (this.mRunState == 1) {
            if (curTime - this.mLastRunStateTime > (long)this.mInAnimationDuration) {
                this.mRunState = 2;
                return;
            }
        } else if (this.mRunState == 4 && curTime - this.mLastRunStateTime > (long)this.mOutAnimationDuration) {
            this.stop(false);
            return;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }

    private float offset(float pos, float offset, float max) {
        if ((pos += offset) > max) {
            return pos - max;
        }
        if (pos < 0.0f) {
            return max + pos;
        }
        return pos;
    }

    private void updateIndeterminate() {
        Rect bounds = this.getBounds();
        int width = bounds.width();
        long curTime = SystemClock.uptimeMillis();
        float travelOffset = (float)(curTime - this.mLastUpdateTime) * (float)width / (float)this.mTravelDuration;
        if (this.mReverse) {
            travelOffset = -travelOffset;
        }
        this.mLastUpdateTime = curTime;
        switch (this.mProgressState) {
            case 0: {
                if (this.mTransformDuration <= 0) {
                    float f = this.mLineWidth = this.mMinLineWidth == 0 ? (float)width * this.mMinLineWidthPercent : (float)this.mMinLineWidth;
                    if (this.mReverse) {
                        this.mLineWidth = -this.mLineWidth;
                    }
                    this.mStartLine = this.offset(this.mStartLine, travelOffset, width);
                    this.mProgressState = 1;
                    this.mLastProgressStateTime = curTime;
                    break;
                }
                float value = (float)(curTime - this.mLastProgressStateTime) / (float)this.mTransformDuration;
                float maxWidth = this.mMaxLineWidth == 0 ? (float)width * this.mMaxLineWidthPercent : (float)this.mMaxLineWidth;
                float minWidth = this.mMinLineWidth == 0 ? (float)width * this.mMinLineWidthPercent : (float)this.mMinLineWidth;
                this.mStartLine = this.offset(this.mStartLine, travelOffset, width);
                this.mLineWidth = this.mTransformInterpolator.getInterpolation(value) * (maxWidth - minWidth) + minWidth;
                if (this.mReverse) {
                    this.mLineWidth = -this.mLineWidth;
                }
                if (!(value > 1.0f)) break;
                this.mLineWidth = this.mReverse ? -maxWidth : maxWidth;
                this.mProgressState = 1;
                this.mLastProgressStateTime = curTime;
                break;
            }
            case 1: {
                this.mStartLine = this.offset(this.mStartLine, travelOffset, width);
                if (curTime - this.mLastProgressStateTime <= (long)this.mKeepDuration) break;
                this.mProgressState = 2;
                this.mLastProgressStateTime = curTime;
                break;
            }
            case 2: {
                if (this.mTransformDuration <= 0) {
                    float f = this.mLineWidth = this.mMinLineWidth == 0 ? (float)width * this.mMinLineWidthPercent : (float)this.mMinLineWidth;
                    if (this.mReverse) {
                        this.mLineWidth = -this.mLineWidth;
                    }
                    this.mStartLine = this.offset(this.mStartLine, travelOffset, width);
                    this.mProgressState = 3;
                    this.mLastProgressStateTime = curTime;
                    this.mStrokeColorIndex = (this.mStrokeColorIndex + 1) % this.mStrokeColors.length;
                    break;
                }
                float value = (float)(curTime - this.mLastProgressStateTime) / (float)this.mTransformDuration;
                float maxWidth = this.mMaxLineWidth == 0 ? (float)width * this.mMaxLineWidthPercent : (float)this.mMaxLineWidth;
                float minWidth = this.mMinLineWidth == 0 ? (float)width * this.mMinLineWidthPercent : (float)this.mMinLineWidth;
                float newLineWidth = (1.0f - this.mTransformInterpolator.getInterpolation(value)) * (maxWidth - minWidth) + minWidth;
                if (this.mReverse) {
                    newLineWidth = -newLineWidth;
                }
                this.mStartLine = this.offset(this.mStartLine, travelOffset + this.mLineWidth - newLineWidth, width);
                this.mLineWidth = newLineWidth;
                if (!(value > 1.0f)) break;
                this.mLineWidth = this.mReverse ? -minWidth : minWidth;
                this.mProgressState = 3;
                this.mLastProgressStateTime = curTime;
                this.mStrokeColorIndex = (this.mStrokeColorIndex + 1) % this.mStrokeColors.length;
                break;
            }
            case 3: {
                this.mStartLine = this.offset(this.mStartLine, travelOffset, width);
                if (curTime - this.mLastProgressStateTime <= (long)this.mKeepDuration) break;
                this.mProgressState = 0;
                this.mLastProgressStateTime = curTime;
            }
        }
        if (this.mRunState == 1) {
            if (curTime - this.mLastRunStateTime > (long)this.mInAnimationDuration) {
                this.mRunState = 3;
            }
        } else if (this.mRunState == 4 && curTime - this.mLastRunStateTime > (long)this.mOutAnimationDuration) {
            this.stop(false);
            return;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }

    private void updateBuffer() {
        long curTime = SystemClock.uptimeMillis();
        float maxDistance = this.mStrokeSize * 2;
        this.mStartLine += maxDistance * (float)(curTime - this.mLastUpdateTime) / (float)this.mTravelDuration;
        while (this.mStartLine > maxDistance) {
            this.mStartLine -= maxDistance;
        }
        this.mLastUpdateTime = curTime;
        switch (this.mProgressState) {
            case 0: {
                if (this.mTransformDuration <= 0) {
                    this.mProgressState = 1;
                    this.mLastProgressStateTime = curTime;
                    break;
                }
                float value = (float)(curTime - this.mLastProgressStateTime) / (float)this.mTransformDuration;
                this.mLineWidth = this.mTransformInterpolator.getInterpolation(value) * (float)this.mStrokeSize;
                if (!(value > 1.0f)) break;
                this.mLineWidth = this.mStrokeSize;
                this.mProgressState = 1;
                this.mLastProgressStateTime = curTime;
                break;
            }
            case 1: {
                if (curTime - this.mLastProgressStateTime <= (long)this.mKeepDuration) break;
                this.mProgressState = 2;
                this.mLastProgressStateTime = curTime;
                break;
            }
            case 2: {
                if (this.mTransformDuration <= 0) {
                    this.mProgressState = 3;
                    this.mLastProgressStateTime = curTime;
                    break;
                }
                float value = (float)(curTime - this.mLastProgressStateTime) / (float)this.mTransformDuration;
                this.mLineWidth = (1.0f - this.mTransformInterpolator.getInterpolation(value)) * (float)this.mStrokeSize;
                if (!(value > 1.0f)) break;
                this.mLineWidth = 0.0f;
                this.mProgressState = 3;
                this.mLastProgressStateTime = curTime;
                break;
            }
            case 3: {
                if (curTime - this.mLastProgressStateTime <= (long)this.mKeepDuration) break;
                this.mProgressState = 0;
                this.mLastProgressStateTime = curTime;
            }
        }
        if (this.mRunState == 1) {
            if (curTime - this.mLastRunStateTime > (long)this.mInAnimationDuration) {
                this.mRunState = 3;
            }
        } else if (this.mRunState == 4 && curTime - this.mLastRunStateTime > (long)this.mOutAnimationDuration) {
            this.stop(false);
            return;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }

    private void updateQuery() {
        boolean requestUpdate;
        long curTime = SystemClock.uptimeMillis();
        this.mAnimTime = (float)(curTime - this.mLastProgressStateTime) / (float)this.mTravelDuration;
        boolean bl = requestUpdate = this.mRunState == 4 || this.mProgressPercent == 0.0f || this.mAnimTime < 1.0f;
        if (this.mAnimTime > 1.0f) {
            this.mLastProgressStateTime = Math.round((float)curTime - (this.mAnimTime - 1.0f) * (float)this.mTravelDuration);
            this.mAnimTime -= 1.0f;
        }
        if (requestUpdate && this.mRunState != 4) {
            Rect bounds = this.getBounds();
            int width = bounds.width();
            float maxWidth = this.mMaxLineWidth == 0 ? (float)width * this.mMaxLineWidthPercent : (float)this.mMaxLineWidth;
            float minWidth = this.mMinLineWidth == 0 ? (float)width * this.mMinLineWidthPercent : (float)this.mMinLineWidth;
            this.mLineWidth = this.mTransformInterpolator.getInterpolation(this.mAnimTime) * (minWidth - maxWidth) + maxWidth;
            if (this.mReverse) {
                this.mLineWidth = -this.mLineWidth;
            }
            float f = this.mStartLine = this.mReverse ? this.mTransformInterpolator.getInterpolation(this.mAnimTime) * ((float)width + minWidth) : (1.0f - this.mTransformInterpolator.getInterpolation(this.mAnimTime)) * ((float)width + minWidth) - minWidth;
        }
        if (this.mRunState == 1) {
            if (curTime - this.mLastRunStateTime > (long)this.mInAnimationDuration) {
                this.mRunState = 3;
            }
        } else if (this.mRunState == 4 && curTime - this.mLastRunStateTime > (long)this.mOutAnimationDuration) {
            this.stop(false);
            return;
        }
        if (this.isRunning()) {
            if (requestUpdate) {
                this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
            } else if (this.mRunState == 3) {
                this.mRunState = 2;
            }
        }
        this.invalidateSelf();
    }

    public static class Builder {
        private float mProgressPercent = 0.0f;
        private float mSecondaryProgressPercent = 0.0f;
        private int mMaxLineWidth;
        private float mMaxLineWidthPercent;
        private int mMinLineWidth;
        private float mMinLineWidthPercent;
        private int mStrokeSize = 8;
        private int mVerticalAlign = 2;
        private int[] mStrokeColors;
        private int mStrokeSecondaryColor;
        private boolean mReverse = false;
        private int mTravelDuration = 1000;
        private int mTransformDuration = 800;
        private int mKeepDuration = 200;
        private Interpolator mTransformInterpolator;
        private int mProgressMode = 1;
        private int mInAnimationDuration = 400;
        private int mOutAnimationDuration = 400;

        public Builder() {
        }

        public Builder(Context context, int defStyleRes) {
            this(context, null, 0, defStyleRes);
        }

        public Builder(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LinearProgressDrawable, defStyleAttr, defStyleRes);
            this.progressPercent(a.getFloat(R.styleable.LinearProgressDrawable_pv_progress, 0.0f));
            this.secondaryProgressPercent(a.getFloat(R.styleable.LinearProgressDrawable_pv_secondaryProgress, 0.0f));
            TypedValue value = a.peekValue(R.styleable.LinearProgressDrawable_lpd_maxLineWidth);
            if (value == null) {
                this.maxLineWidth(0.75f);
            } else if (value.type == 6) {
                this.maxLineWidth(a.getFraction(R.styleable.LinearProgressDrawable_lpd_maxLineWidth, 1, 1, 0.75f));
            } else {
                this.maxLineWidth(a.getDimensionPixelSize(R.styleable.LinearProgressDrawable_lpd_maxLineWidth, 0));
            }
            value = a.peekValue(R.styleable.LinearProgressDrawable_lpd_minLineWidth);
            if (value == null) {
                this.minLineWidth(0.25f);
            } else if (value.type == 6) {
                this.minLineWidth(a.getFraction(R.styleable.LinearProgressDrawable_lpd_minLineWidth, 1, 1, 0.25f));
            } else {
                this.minLineWidth(a.getDimensionPixelSize(R.styleable.LinearProgressDrawable_lpd_minLineWidth, 0));
            }
            this.strokeSize(a.getDimensionPixelSize(R.styleable.LinearProgressDrawable_lpd_strokeSize, ThemeUtil.dpToPx(context, 4)));
            this.verticalAlign(a.getInteger(R.styleable.LinearProgressDrawable_lpd_verticalAlign, 2));
            this.strokeColors(a.getColor(R.styleable.LinearProgressDrawable_lpd_strokeColor, ThemeUtil.colorPrimary(context, -16777216)));
            int resId = a.getResourceId(R.styleable.LinearProgressDrawable_lpd_strokeColors, 0);
            if (resId != 0) {
                TypedArray ta = context.getResources().obtainTypedArray(resId);
                int[] colors = new int[ta.length()];
                for (int j = 0; j < ta.length(); ++j) {
                    colors[j] = ta.getColor(j, 0);
                }
                ta.recycle();
                this.strokeColors(colors);
            }
            this.strokeSecondaryColor(a.getColor(R.styleable.LinearProgressDrawable_lpd_strokeSecondaryColor, 0));
            this.reverse(a.getBoolean(R.styleable.LinearProgressDrawable_lpd_reverse, false));
            this.travelDuration(a.getInteger(R.styleable.LinearProgressDrawable_lpd_travelDuration, context.getResources().getInteger(17694722)));
            this.transformDuration(a.getInteger(R.styleable.LinearProgressDrawable_lpd_transformDuration, context.getResources().getInteger(0x10E0001)));
            this.keepDuration(a.getInteger(R.styleable.LinearProgressDrawable_lpd_keepDuration, context.getResources().getInteger(0x10E0000)));
            resId = a.getResourceId(R.styleable.LinearProgressDrawable_lpd_transformInterpolator, 0);
            if (resId != 0) {
                this.transformInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resId));
            }
            this.progressMode(a.getInteger(R.styleable.LinearProgressDrawable_pv_progressMode, 1));
            this.inAnimDuration(a.getInteger(R.styleable.LinearProgressDrawable_lpd_inAnimDuration, context.getResources().getInteger(0x10E0001)));
            this.outAnimDuration(a.getInteger(R.styleable.LinearProgressDrawable_lpd_outAnimDuration, context.getResources().getInteger(0x10E0001)));
            a.recycle();
        }

        public LinearProgressDrawable build() {
            if (this.mStrokeColors == null) {
                this.mStrokeColors = new int[]{-16737793};
            }
            if (this.mTransformInterpolator == null) {
                this.mTransformInterpolator = new DecelerateInterpolator();
            }
            return new LinearProgressDrawable(this.mProgressPercent, this.mSecondaryProgressPercent, this.mMaxLineWidth, this.mMaxLineWidthPercent, this.mMinLineWidth, this.mMinLineWidthPercent, this.mStrokeSize, this.mVerticalAlign, this.mStrokeColors, this.mStrokeSecondaryColor, this.mReverse, this.mTravelDuration, this.mTransformDuration, this.mKeepDuration, this.mTransformInterpolator, this.mProgressMode, this.mInAnimationDuration, this.mOutAnimationDuration);
        }

        public Builder secondaryProgressPercent(float percent) {
            this.mSecondaryProgressPercent = percent;
            return this;
        }

        public Builder progressPercent(float percent) {
            this.mProgressPercent = percent;
            return this;
        }

        public Builder maxLineWidth(int width) {
            this.mMaxLineWidth = width;
            return this;
        }

        public Builder maxLineWidth(float percent) {
            this.mMaxLineWidthPercent = Math.max(0.0f, Math.min(1.0f, percent));
            this.mMaxLineWidth = 0;
            return this;
        }

        public Builder minLineWidth(int width) {
            this.mMinLineWidth = width;
            return this;
        }

        public Builder minLineWidth(float percent) {
            this.mMinLineWidthPercent = Math.max(0.0f, Math.min(1.0f, percent));
            this.mMinLineWidth = 0;
            return this;
        }

        public Builder strokeSize(int strokeSize) {
            this.mStrokeSize = strokeSize;
            return this;
        }

        public Builder verticalAlign(int align) {
            this.mVerticalAlign = align;
            return this;
        }

        public Builder strokeColors(int ... strokeColors) {
            this.mStrokeColors = strokeColors;
            return this;
        }

        public Builder strokeSecondaryColor(int color) {
            this.mStrokeSecondaryColor = color;
            return this;
        }

        public Builder reverse(boolean reverse) {
            this.mReverse = reverse;
            return this;
        }

        public Builder reverse() {
            return this.reverse(true);
        }

        public Builder travelDuration(int duration) {
            this.mTravelDuration = duration;
            return this;
        }

        public Builder transformDuration(int duration) {
            this.mTransformDuration = duration;
            return this;
        }

        public Builder keepDuration(int duration) {
            this.mKeepDuration = duration;
            return this;
        }

        public Builder transformInterpolator(Interpolator interpolator) {
            this.mTransformInterpolator = interpolator;
            return this;
        }

        public Builder progressMode(int mode) {
            this.mProgressMode = mode;
            return this;
        }

        public Builder inAnimDuration(int duration) {
            this.mInAnimationDuration = duration;
            return this;
        }

        public Builder outAnimDuration(int duration) {
            this.mOutAnimationDuration = duration;
            return this;
        }
    }
}

