/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.app;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v7.widget.CardView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.rey.material.R;
import com.rey.material.app.DialogFragment;
import com.rey.material.drawable.BlankDrawable;
import com.rey.material.drawable.RippleDrawable;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.ViewUtil;
import com.rey.material.widget.Button;
import com.rey.material.widget.TextView;

public class Dialog
extends android.app.Dialog {
    private ContainerFrameLayout mContainer;
    private int mLayoutWidth;
    private int mLayoutHeight;
    protected TextView mTitle;
    protected Button mPositiveAction;
    protected Button mNegativeAction;
    protected Button mNeutralAction;
    private View mContent;
    private DialogCardView mCardView;
    protected int mContentPadding;
    protected int mActionHeight;
    protected int mActionOuterHeight;
    protected int mActionOuterPadding;
    protected int mActionMinWidth;
    protected int mActionPadding;
    protected int mDialogHorizontalPadding;
    protected int mDialogVerticalPadding;
    protected int mInAnimationId;
    protected int mOutAnimationId;
    private final Handler mHandler = new Handler();
    private final Runnable mDismissAction = new Runnable(){

        @Override
        public void run() {
            try {
                Dialog.super.dismiss();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    };
    private boolean mLayoutActionVertical = false;
    private boolean mCancelable = true;
    private boolean mCanceledOnTouchOutside = true;
    public static final int ACTION_POSITIVE = ViewUtil.generateViewId();
    public static final int ACTION_NEGATIVE = ViewUtil.generateViewId();
    public static final int ACTION_NEUTRAL = ViewUtil.generateViewId();

    public Dialog(Context context) {
        this(context, R.style.Material_App_Dialog_Light);
    }

    public Dialog(Context context, int style2) {
        super(context, style2);
        this.requestWindowFeature(1);
        this.getWindow().setBackgroundDrawable((Drawable)BlankDrawable.getInstance());
        this.getWindow().setLayout(-1, -1);
        this.init(context, style2);
    }

    private void init(Context context, int style2) {
        this.mContentPadding = ThemeUtil.dpToPx(context, 24);
        this.mActionMinWidth = ThemeUtil.dpToPx(context, 64);
        this.mActionHeight = ThemeUtil.dpToPx(context, 36);
        this.mActionOuterHeight = ThemeUtil.dpToPx(context, 48);
        this.mActionPadding = ThemeUtil.dpToPx(context, 8);
        this.mActionOuterPadding = ThemeUtil.dpToPx(context, 16);
        this.mDialogHorizontalPadding = ThemeUtil.dpToPx(context, 40);
        this.mDialogVerticalPadding = ThemeUtil.dpToPx(context, 24);
        this.mCardView = new DialogCardView(context);
        this.mContainer = new ContainerFrameLayout(context);
        this.mTitle = new TextView(context);
        this.mPositiveAction = new Button(context);
        this.mNegativeAction = new Button(context);
        this.mNeutralAction = new Button(context);
        this.mCardView.setPreventCornerOverlap(false);
        this.mCardView.setUseCompatPadding(true);
        this.mTitle.setPadding(this.mContentPadding, this.mContentPadding, this.mContentPadding, this.mContentPadding - this.mActionPadding);
        this.mPositiveAction.setId(ACTION_POSITIVE);
        this.mPositiveAction.setPadding(this.mActionPadding, 0, this.mActionPadding, 0);
        this.mPositiveAction.setBackgroundResource(0);
        this.mNegativeAction.setId(ACTION_NEGATIVE);
        this.mNegativeAction.setPadding(this.mActionPadding, 0, this.mActionPadding, 0);
        this.mNegativeAction.setBackgroundResource(0);
        this.mNeutralAction.setId(ACTION_NEUTRAL);
        this.mNeutralAction.setPadding(this.mActionPadding, 0, this.mActionPadding, 0);
        this.mNeutralAction.setBackgroundResource(0);
        this.mContainer.addView((View)this.mCardView);
        this.mCardView.addView((View)this.mTitle);
        this.mCardView.addView((View)this.mPositiveAction);
        this.mCardView.addView((View)this.mNegativeAction);
        this.mCardView.addView((View)this.mNeutralAction);
        this.cancelable(true);
        this.canceledOnTouchOutside(true);
        this.clearContent();
        this.onCreate();
        this.applyStyle(style2);
        super.setContentView((View)this.mContainer);
    }

    protected void onCreate() {
    }

    public Dialog applyStyle(int resId) {
        Context context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(resId, R.styleable.Dialog);
        int layout_width = ThemeUtil.getType(a, R.styleable.Dialog_android_layout_width) == 5 ? a.getDimensionPixelSize(R.styleable.Dialog_android_layout_width, 0) : a.getInteger(R.styleable.Dialog_android_layout_width, -2);
        int layout_height = ThemeUtil.getType(a, R.styleable.Dialog_android_layout_height) == 5 ? a.getDimensionPixelSize(R.styleable.Dialog_android_layout_height, 0) : a.getInteger(R.styleable.Dialog_android_layout_height, -2);
        this.layoutParams(layout_width, layout_height);
        this.dimAmount(a.getFloat(R.styleable.Dialog_di_dimAmount, 0.5f));
        this.backgroundColor(a.getColor(R.styleable.Dialog_di_backgroundColor, ThemeUtil.windowBackground(context, -1)));
        this.maxElevation(a.getDimensionPixelOffset(R.styleable.Dialog_di_maxElevation, 0));
        this.elevation(a.getDimensionPixelOffset(R.styleable.Dialog_di_elevation, ThemeUtil.dpToPx(context, 4)));
        this.cornerRadius(a.getDimensionPixelOffset(R.styleable.Dialog_di_cornerRadius, ThemeUtil.dpToPx(context, 2)));
        this.titleTextAppearance(a.getResourceId(R.styleable.Dialog_di_titleTextAppearance, R.style.TextAppearance_AppCompat_Title));
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_titleTextColor) != 0) {
            this.titleColor(a.getColor(R.styleable.Dialog_di_titleTextColor, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_actionBackground) != 0) {
            this.actionBackground(a.getResourceId(R.styleable.Dialog_di_actionBackground, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_actionRipple) != 0) {
            this.actionRipple(a.getResourceId(R.styleable.Dialog_di_actionRipple, 0));
        }
        this.actionTextAppearance(a.getResourceId(R.styleable.Dialog_di_actionTextAppearance, R.style.TextAppearance_AppCompat_Button));
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_actionTextColor) != 0) {
            this.actionTextColor(a.getColorStateList(R.styleable.Dialog_di_actionTextColor));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_positiveActionBackground) != 0) {
            this.positiveActionBackground(a.getResourceId(R.styleable.Dialog_di_positiveActionBackground, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_positiveActionRipple) != 0) {
            this.positiveActionRipple(a.getResourceId(R.styleable.Dialog_di_positiveActionRipple, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_positiveActionTextAppearance) != 0) {
            this.positiveActionTextAppearance(a.getResourceId(R.styleable.Dialog_di_positiveActionTextAppearance, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_positiveActionTextColor) != 0) {
            this.positiveActionTextColor(a.getColorStateList(R.styleable.Dialog_di_positiveActionTextColor));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_negativeActionBackground) != 0) {
            this.negativeActionBackground(a.getResourceId(R.styleable.Dialog_di_negativeActionBackground, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_negativeActionRipple) != 0) {
            this.negativeActionRipple(a.getResourceId(R.styleable.Dialog_di_negativeActionRipple, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_negativeActionTextAppearance) != 0) {
            this.negativeActionTextAppearance(a.getResourceId(R.styleable.Dialog_di_negativeActionTextAppearance, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_negativeActionTextColor) != 0) {
            this.negativeActionTextColor(a.getColorStateList(R.styleable.Dialog_di_negativeActionTextColor));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_neutralActionBackground) != 0) {
            this.neutralActionBackground(a.getResourceId(R.styleable.Dialog_di_neutralActionBackground, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_neutralActionRipple) != 0) {
            this.neutralActionRipple(a.getResourceId(R.styleable.Dialog_di_neutralActionRipple, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_neutralActionTextAppearance) != 0) {
            this.neutralActionTextAppearance(a.getResourceId(R.styleable.Dialog_di_neutralActionTextAppearance, 0));
        }
        if (ThemeUtil.getType(a, R.styleable.Dialog_di_neutralActionTextColor) != 0) {
            this.neutralActionTextColor(a.getColorStateList(R.styleable.Dialog_di_neutralActionTextColor));
        }
        this.inAnimation(a.getResourceId(R.styleable.Dialog_di_inAnimation, 0));
        this.outAnimation(a.getResourceId(R.styleable.Dialog_di_outAnimation, 0));
        this.dividerColor(a.getColor(R.styleable.Dialog_di_dividerColor, 0x1E000000));
        this.dividerHeight(a.getDimensionPixelOffset(R.styleable.Dialog_di_dividerHeight, ThemeUtil.dpToPx(context, 1)));
        this.setCancelable(a.getBoolean(R.styleable.Dialog_di_cancelable, true));
        this.setCanceledOnTouchOutside(a.getBoolean(R.styleable.Dialog_di_canceledOnTouchOutside, true));
        a.recycle();
        return this;
    }

    public Dialog clearContent() {
        this.title(0);
        this.positiveAction(0);
        this.positiveActionClickListener(null);
        this.negativeAction(0);
        this.negativeActionClickListener(null);
        this.neutralAction(0);
        this.neutralActionClickListener(null);
        this.contentView(null);
        return this;
    }

    public Dialog layoutParams(int width, int height) {
        this.mLayoutWidth = width;
        this.mLayoutHeight = height;
        return this;
    }

    public Dialog dimAmount(float amount) {
        Window window = this.getWindow();
        if (amount > 0.0f) {
            window.addFlags(2);
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.dimAmount = amount;
            window.setAttributes(lp);
        } else {
            window.clearFlags(2);
        }
        return this;
    }

    public Dialog backgroundColor(int color) {
        this.mCardView.setCardBackgroundColor(color);
        return this;
    }

    public Dialog elevation(float radius) {
        if (this.mCardView.getMaxCardElevation() < radius) {
            this.mCardView.setMaxCardElevation(radius);
        }
        this.mCardView.setCardElevation(radius);
        return this;
    }

    public Dialog maxElevation(float radius) {
        this.mCardView.setMaxCardElevation(radius);
        return this;
    }

    public Dialog cornerRadius(float radius) {
        this.mCardView.setRadius(radius);
        return this;
    }

    public Dialog dividerColor(int color) {
        this.mCardView.setDividerColor(color);
        return this;
    }

    public Dialog dividerHeight(int height) {
        this.mCardView.setDividerHeight(height);
        return this;
    }

    public Dialog title(CharSequence title) {
        this.mTitle.setText(title);
        this.mTitle.setVisibility(TextUtils.isEmpty((CharSequence)title) ? 8 : 0);
        return this;
    }

    public Dialog title(int id) {
        return this.title(id == 0 ? null : this.getContext().getResources().getString(id));
    }

    public void setTitle(CharSequence title) {
        this.title(title);
    }

    public void setTitle(int titleId) {
        this.title(titleId);
    }

    public Dialog titleColor(int color) {
        this.mTitle.setTextColor(color);
        return this;
    }

    public Dialog titleTextAppearance(int resId) {
        this.mTitle.setTextAppearance(this.getContext(), resId);
        return this;
    }

    public Dialog actionBackground(int id) {
        this.positiveActionBackground(id);
        this.negativeActionBackground(id);
        this.neutralActionBackground(id);
        return this;
    }

    public Dialog actionBackground(Drawable drawable) {
        this.positiveActionBackground(drawable);
        this.negativeActionBackground(drawable);
        this.neutralActionBackground(drawable);
        return this;
    }

    public Dialog actionRipple(int resId) {
        this.positiveActionRipple(resId);
        this.negativeActionRipple(resId);
        this.neutralActionRipple(resId);
        return this;
    }

    public Dialog actionTextAppearance(int resId) {
        this.positiveActionTextAppearance(resId);
        this.negativeActionTextAppearance(resId);
        this.neutralActionTextAppearance(resId);
        return this;
    }

    public Dialog actionTextColor(ColorStateList color) {
        this.positiveActionTextColor(color);
        this.negativeActionTextColor(color);
        this.neutralActionTextColor(color);
        return this;
    }

    public Dialog actionTextColor(int color) {
        this.positiveActionTextColor(color);
        this.negativeActionTextColor(color);
        this.neutralActionTextColor(color);
        return this;
    }

    public Dialog positiveAction(CharSequence action) {
        this.mPositiveAction.setText(action);
        this.mPositiveAction.setVisibility(TextUtils.isEmpty((CharSequence)action) ? 8 : 0);
        return this;
    }

    public Dialog positiveAction(int id) {
        return this.positiveAction(id == 0 ? null : this.getContext().getResources().getString(id));
    }

    @TargetApi(value=16)
    public Dialog positiveActionBackground(Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mPositiveAction.setBackground(drawable);
        } else {
            this.mPositiveAction.setBackgroundDrawable(drawable);
        }
        return this;
    }

    public Dialog positiveActionBackground(int id) {
        return this.positiveActionBackground(id == 0 ? null : this.getContext().getResources().getDrawable(id));
    }

    public Dialog positiveActionRipple(int resId) {
        RippleDrawable drawable = new RippleDrawable.Builder(this.getContext(), resId).build();
        return this.positiveActionBackground(drawable);
    }

    public Dialog positiveActionTextAppearance(int resId) {
        this.mPositiveAction.setTextAppearance(this.getContext(), resId);
        return this;
    }

    public Dialog positiveActionTextColor(ColorStateList color) {
        this.mPositiveAction.setTextColor(color);
        return this;
    }

    public Dialog positiveActionTextColor(int color) {
        this.mPositiveAction.setTextColor(color);
        return this;
    }

    public Dialog positiveActionClickListener(View.OnClickListener listener) {
        this.mPositiveAction.setOnClickListener(listener);
        return this;
    }

    public Dialog negativeAction(CharSequence action) {
        this.mNegativeAction.setText(action);
        this.mNegativeAction.setVisibility(TextUtils.isEmpty((CharSequence)action) ? 8 : 0);
        return this;
    }

    public Dialog negativeAction(int id) {
        return this.negativeAction(id == 0 ? null : this.getContext().getResources().getString(id));
    }

    @TargetApi(value=16)
    public Dialog negativeActionBackground(Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mNegativeAction.setBackground(drawable);
        } else {
            this.mNegativeAction.setBackgroundDrawable(drawable);
        }
        return this;
    }

    public Dialog negativeActionBackground(int id) {
        return this.negativeActionBackground(id == 0 ? null : this.getContext().getResources().getDrawable(id));
    }

    public Dialog negativeActionRipple(int resId) {
        RippleDrawable drawable = new RippleDrawable.Builder(this.getContext(), resId).build();
        return this.negativeActionBackground(drawable);
    }

    public Dialog negativeActionTextAppearance(int resId) {
        this.mNegativeAction.setTextAppearance(this.getContext(), resId);
        return this;
    }

    public Dialog negativeActionTextColor(ColorStateList color) {
        this.mNegativeAction.setTextColor(color);
        return this;
    }

    public Dialog negativeActionTextColor(int color) {
        this.mNegativeAction.setTextColor(color);
        return this;
    }

    public Dialog negativeActionClickListener(View.OnClickListener listener) {
        this.mNegativeAction.setOnClickListener(listener);
        return this;
    }

    public Dialog neutralAction(CharSequence action) {
        this.mNeutralAction.setText(action);
        this.mNeutralAction.setVisibility(TextUtils.isEmpty((CharSequence)action) ? 8 : 0);
        return this;
    }

    public Dialog neutralAction(int id) {
        return this.neutralAction(id == 0 ? null : this.getContext().getResources().getString(id));
    }

    @TargetApi(value=16)
    public Dialog neutralActionBackground(Drawable drawable) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mNeutralAction.setBackground(drawable);
        } else {
            this.mNeutralAction.setBackgroundDrawable(drawable);
        }
        return this;
    }

    public Dialog neutralActionBackground(int id) {
        return this.neutralActionBackground(id == 0 ? null : this.getContext().getResources().getDrawable(id));
    }

    public Dialog neutralActionRipple(int resId) {
        RippleDrawable drawable = new RippleDrawable.Builder(this.getContext(), resId).build();
        return this.neutralActionBackground(drawable);
    }

    public Dialog neutralActionTextAppearance(int resId) {
        this.mNeutralAction.setTextAppearance(this.getContext(), resId);
        return this;
    }

    public Dialog neutralActionTextColor(ColorStateList color) {
        this.mNeutralAction.setTextColor(color);
        return this;
    }

    public Dialog neutralActionTextColor(int color) {
        this.mNeutralAction.setTextColor(color);
        return this;
    }

    public Dialog neutralActionClickListener(View.OnClickListener listener) {
        this.mNeutralAction.setOnClickListener(listener);
        return this;
    }

    public Dialog inAnimation(int resId) {
        this.mInAnimationId = resId;
        return this;
    }

    public Dialog outAnimation(int resId) {
        this.mOutAnimationId = resId;
        return this;
    }

    public Dialog showDivider(boolean show) {
        this.mCardView.setShowDivider(show);
        return this;
    }

    public Dialog contentView(View v) {
        if (this.mContent != v) {
            if (this.mContent != null) {
                this.mCardView.removeView(this.mContent);
            }
            this.mContent = v;
        }
        if (this.mContent != null) {
            this.mCardView.addView(this.mContent);
        }
        return this;
    }

    public Dialog contentView(int layoutId) {
        if (layoutId == 0) {
            return this;
        }
        View v = LayoutInflater.from((Context)this.getContext()).inflate(layoutId, null);
        return this.contentView(v);
    }

    public Dialog cancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        this.mCancelable = cancelable;
        return this;
    }

    public Dialog canceledOnTouchOutside(boolean cancel) {
        super.setCanceledOnTouchOutside(cancel);
        this.mCanceledOnTouchOutside = cancel;
        return this;
    }

    public Dialog contentMargin(int margin) {
        this.mCardView.setContentMargin(margin);
        return this;
    }

    public Dialog contentMargin(int left, int top, int right, int bottom) {
        this.mCardView.setContentMargin(left, top, right, bottom);
        return this;
    }

    public void setCancelable(boolean flag) {
        this.cancelable(flag);
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        this.canceledOnTouchOutside(cancel);
    }

    public void setContentView(View v) {
        this.contentView(v);
    }

    public void setContentView(int layoutId) {
        this.contentView(layoutId);
    }

    public void setContentView(View v, ViewGroup.LayoutParams params) {
        this.contentView(v);
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        this.contentView(view);
    }

    public void show() {
        if (this.mInAnimationId != 0) {
            this.mCardView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    Dialog.this.mCardView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    Animation anim = AnimationUtils.loadAnimation((Context)Dialog.this.mCardView.getContext(), (int)Dialog.this.mInAnimationId);
                    Dialog.this.mCardView.startAnimation(anim);
                    return false;
                }
            });
        }
        super.show();
    }

    public void dismiss() {
        if (this.mOutAnimationId != 0) {
            Animation anim = AnimationUtils.loadAnimation((Context)this.mContainer.getContext(), (int)this.mOutAnimationId);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    Dialog.this.mHandler.post(Dialog.this.mDismissAction);
                }
            });
            this.mCardView.startAnimation(anim);
        } else {
            this.mHandler.post(this.mDismissAction);
        }
    }

    public static class Builder
    implements DialogFragment.Builder,
    Parcelable {
        protected int mStyleId;
        protected int mContentViewId;
        protected CharSequence mTitle;
        protected CharSequence mPositive;
        protected CharSequence mNegative;
        protected CharSequence mNeutral;
        protected Dialog mDialog;
        public static final Parcelable.Creator<Builder> CREATOR = new Parcelable.Creator<Builder>(){

            public Builder createFromParcel(Parcel in) {
                return new Builder(in);
            }

            public Builder[] newArray(int size) {
                return new Builder[size];
            }
        };

        public Builder() {
            this(R.style.Material_App_Dialog_Light);
        }

        public Builder(int styleId) {
            this.mStyleId = styleId;
        }

        public Builder style(int styleId) {
            this.mStyleId = styleId;
            return this;
        }

        public Builder contentView(int layoutId) {
            this.mContentViewId = layoutId;
            return this;
        }

        public Builder title(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder positiveAction(CharSequence action) {
            this.mPositive = action;
            return this;
        }

        public Builder negativeAction(CharSequence action) {
            this.mNegative = action;
            return this;
        }

        public Builder neutralAction(CharSequence action) {
            this.mNeutral = action;
            return this;
        }

        @Override
        public void onPositiveActionClicked(DialogFragment fragment) {
            fragment.dismiss();
        }

        @Override
        public void onNegativeActionClicked(DialogFragment fragment) {
            fragment.dismiss();
        }

        @Override
        public void onNeutralActionClicked(DialogFragment fragment) {
            fragment.dismiss();
        }

        @Override
        public Dialog build(Context context) {
            this.mDialog = this.onBuild(context, this.mStyleId);
            this.mDialog.title(this.mTitle).positiveAction(this.mPositive).negativeAction(this.mNegative).neutralAction(this.mNeutral);
            if (this.mContentViewId != 0) {
                this.mDialog.contentView(this.mContentViewId);
            }
            return this.mDialog;
        }

        protected Dialog onBuild(Context context, int styleId) {
            return new Dialog(context, styleId);
        }

        protected Builder(Parcel in) {
            this.mStyleId = in.readInt();
            this.mContentViewId = in.readInt();
            this.mTitle = (CharSequence)in.readParcelable(null);
            this.mPositive = (CharSequence)in.readParcelable(null);
            this.mNegative = (CharSequence)in.readParcelable(null);
            this.mNeutral = (CharSequence)in.readParcelable(null);
            this.onReadFromParcel(in);
        }

        protected void onReadFromParcel(Parcel in) {
        }

        protected void onWriteToParcel(Parcel dest, int flags) {
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mStyleId);
            dest.writeInt(this.mContentViewId);
            dest.writeValue((Object)this.mTitle);
            dest.writeValue((Object)this.mPositive);
            dest.writeValue((Object)this.mNegative);
            dest.writeValue((Object)this.mNeutral);
            this.onWriteToParcel(dest, flags);
        }

        public int describeContents() {
            return 0;
        }
    }

    private class DialogCardView
    extends CardView {
        private Paint mDividerPaint;
        private float mDividerPos;
        private boolean mShowDivider;
        private int mContentMarginLeft;
        private int mContentMarginTop;
        private int mContentMarginRight;
        private int mContentMarginBottom;

        public DialogCardView(Context context) {
            super(context);
            this.mDividerPos = -1.0f;
            this.mShowDivider = false;
            this.mDividerPaint = new Paint(1);
            this.mDividerPaint.setStyle(Paint.Style.STROKE);
            this.setWillNotDraw(false);
        }

        public void setContentMargin(int margin) {
            this.setContentMargin(margin, margin, margin, margin);
        }

        public void setContentMargin(int left, int top, int right, int bottom) {
            this.mContentMarginLeft = left;
            this.mContentMarginTop = top;
            this.mContentMarginRight = right;
            this.mContentMarginBottom = bottom;
        }

        public void setDividerColor(int color) {
            this.mDividerPaint.setColor(color);
            this.invalidate();
        }

        public void setDividerHeight(int height) {
            this.mDividerPaint.setStrokeWidth((float)height);
            this.invalidate();
        }

        public void setShowDivider(boolean show) {
            if (this.mShowDivider != show) {
                this.mShowDivider = show;
                this.invalidate();
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int heightMs;
            int widthMs;
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int paddingLeft = Math.max(Dialog.this.mDialogHorizontalPadding, Dialog.this.mCardView.getPaddingLeft());
            int paddingRight = Math.max(Dialog.this.mDialogHorizontalPadding, Dialog.this.mCardView.getPaddingRight());
            int paddingTop = Math.max(Dialog.this.mDialogVerticalPadding, Dialog.this.mCardView.getPaddingTop());
            int paddingBottom = Math.max(Dialog.this.mDialogVerticalPadding, Dialog.this.mCardView.getPaddingBottom());
            int maxWidth = widthSize - paddingLeft - paddingRight;
            int maxHeight = heightSize - paddingTop - paddingBottom;
            int width = Dialog.this.mLayoutWidth == -1 ? maxWidth : Dialog.this.mLayoutWidth;
            int height = Dialog.this.mLayoutHeight == -1 ? maxHeight : Dialog.this.mLayoutHeight;
            int titleWidth = 0;
            int titleHeight = 0;
            if (Dialog.this.mTitle.getVisibility() == 0) {
                widthMs = View.MeasureSpec.makeMeasureSpec((int)(width == -2 ? maxWidth : width), (int)Integer.MIN_VALUE);
                heightMs = View.MeasureSpec.makeMeasureSpec((int)maxHeight, (int)Integer.MIN_VALUE);
                Dialog.this.mTitle.measure(widthMs, heightMs);
                titleWidth = Dialog.this.mTitle.getMeasuredWidth();
                titleHeight = Dialog.this.mTitle.getMeasuredHeight();
            }
            int contentWidth = 0;
            int contentHeight = 0;
            if (Dialog.this.mContent != null) {
                widthMs = View.MeasureSpec.makeMeasureSpec((int)((width == -2 ? maxWidth : width) - this.mContentMarginLeft - this.mContentMarginRight), (int)Integer.MIN_VALUE);
                heightMs = View.MeasureSpec.makeMeasureSpec((int)(maxHeight - this.mContentMarginTop - this.mContentMarginBottom), (int)Integer.MIN_VALUE);
                Dialog.this.mContent.measure(widthMs, heightMs);
                contentWidth = Dialog.this.mContent.getMeasuredWidth();
                contentHeight = Dialog.this.mContent.getMeasuredHeight();
            }
            int visibleActions = 0;
            int positiveActionWidth = 0;
            if (Dialog.this.mPositiveAction.getVisibility() == 0) {
                widthMs = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                heightMs = View.MeasureSpec.makeMeasureSpec((int)Dialog.this.mActionHeight, (int)0x40000000);
                Dialog.this.mPositiveAction.measure(widthMs, heightMs);
                positiveActionWidth = Dialog.this.mPositiveAction.getMeasuredWidth();
                if (positiveActionWidth < Dialog.this.mActionMinWidth) {
                    Dialog.this.mPositiveAction.measure(View.MeasureSpec.makeMeasureSpec((int)Dialog.this.mActionMinWidth, (int)0x40000000), heightMs);
                    positiveActionWidth = Dialog.this.mActionMinWidth;
                }
                ++visibleActions;
            }
            int negativeActionWidth = 0;
            if (Dialog.this.mNegativeAction.getVisibility() == 0) {
                widthMs = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                heightMs = View.MeasureSpec.makeMeasureSpec((int)Dialog.this.mActionHeight, (int)0x40000000);
                Dialog.this.mNegativeAction.measure(widthMs, heightMs);
                negativeActionWidth = Dialog.this.mNegativeAction.getMeasuredWidth();
                if (negativeActionWidth < Dialog.this.mActionMinWidth) {
                    Dialog.this.mNegativeAction.measure(View.MeasureSpec.makeMeasureSpec((int)Dialog.this.mActionMinWidth, (int)0x40000000), heightMs);
                    negativeActionWidth = Dialog.this.mActionMinWidth;
                }
                ++visibleActions;
            }
            int neutralActionWidth = 0;
            if (Dialog.this.mNeutralAction.getVisibility() == 0) {
                widthMs = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                heightMs = View.MeasureSpec.makeMeasureSpec((int)Dialog.this.mActionHeight, (int)0x40000000);
                Dialog.this.mNeutralAction.measure(widthMs, heightMs);
                neutralActionWidth = Dialog.this.mNeutralAction.getMeasuredWidth();
                if (neutralActionWidth < Dialog.this.mActionMinWidth) {
                    Dialog.this.mNeutralAction.measure(View.MeasureSpec.makeMeasureSpec((int)Dialog.this.mActionMinWidth, (int)0x40000000), heightMs);
                    neutralActionWidth = Dialog.this.mActionMinWidth;
                }
                ++visibleActions;
            }
            int actionBarWidth = positiveActionWidth + negativeActionWidth + neutralActionWidth + Dialog.this.mActionOuterPadding * 2 + Dialog.this.mActionPadding * Math.max(0, visibleActions - 1);
            if (width == -2) {
                width = Math.min(maxWidth, Math.max(titleWidth, Math.max(contentWidth + this.mContentMarginLeft + this.mContentMarginRight, actionBarWidth)));
            }
            Dialog.this.mLayoutActionVertical = actionBarWidth > width;
            int nonContentHeight = titleHeight + Dialog.this.mActionPadding + this.mContentMarginTop + this.mContentMarginBottom;
            nonContentHeight = Dialog.this.mLayoutActionVertical ? (nonContentHeight += Dialog.this.mActionOuterHeight * visibleActions) : (nonContentHeight += visibleActions > 0 ? Dialog.this.mActionOuterHeight : 0);
            if (height == -2) {
                height = Math.min(maxHeight, contentHeight + nonContentHeight);
            }
            if (Dialog.this.mContent != null) {
                Dialog.this.mContent.measure(View.MeasureSpec.makeMeasureSpec((int)(width - this.mContentMarginLeft - this.mContentMarginRight), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height - nonContentHeight), (int)0x40000000));
            }
            this.setMeasuredDimension(width + this.getPaddingLeft() + this.getPaddingRight(), height + this.getPaddingTop() + this.getPaddingBottom());
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            int childLeft = 0;
            int childTop = 0;
            int childRight = right - left;
            int childBottom = bottom - top;
            childLeft += this.getPaddingLeft();
            childTop += this.getPaddingTop();
            childRight -= this.getPaddingRight();
            childBottom -= this.getPaddingBottom();
            if (Dialog.this.mTitle.getVisibility() == 0) {
                Dialog.this.mTitle.layout(childLeft, childTop, childRight, childTop + Dialog.this.mTitle.getMeasuredHeight());
                childTop += Dialog.this.mTitle.getMeasuredHeight();
            }
            childBottom -= Dialog.this.mActionPadding;
            int temp = (Dialog.this.mActionOuterHeight - Dialog.this.mActionHeight) / 2;
            if (Dialog.this.mLayoutActionVertical) {
                if (Dialog.this.mNeutralAction.getVisibility() == 0) {
                    Dialog.this.mNeutralAction.layout(childRight - Dialog.this.mActionOuterPadding - Dialog.this.mNeutralAction.getMeasuredWidth(), childBottom - Dialog.this.mActionOuterHeight + temp, childRight - Dialog.this.mActionOuterPadding, childBottom - temp);
                    childBottom -= Dialog.this.mActionOuterHeight;
                }
                if (Dialog.this.mNegativeAction.getVisibility() == 0) {
                    Dialog.this.mNegativeAction.layout(childRight - Dialog.this.mActionOuterPadding - Dialog.this.mNegativeAction.getMeasuredWidth(), childBottom - Dialog.this.mActionOuterHeight + temp, childRight - Dialog.this.mActionOuterPadding, childBottom - temp);
                    childBottom -= Dialog.this.mActionOuterHeight;
                }
                if (Dialog.this.mPositiveAction.getVisibility() == 0) {
                    Dialog.this.mPositiveAction.layout(childRight - Dialog.this.mActionOuterPadding - Dialog.this.mPositiveAction.getMeasuredWidth(), childBottom - Dialog.this.mActionOuterHeight + temp, childRight - Dialog.this.mActionOuterPadding, childBottom - temp);
                    childBottom -= Dialog.this.mActionOuterHeight;
                }
            } else {
                int actionRight = childRight - Dialog.this.mActionOuterPadding;
                int actionTop = childBottom - Dialog.this.mActionOuterHeight + temp;
                int actionBottom = childBottom - temp;
                boolean hasAction = false;
                if (Dialog.this.mPositiveAction.getVisibility() == 0) {
                    Dialog.this.mPositiveAction.layout(actionRight - Dialog.this.mPositiveAction.getMeasuredWidth(), actionTop, actionRight, actionBottom);
                    actionRight -= Dialog.this.mPositiveAction.getMeasuredWidth() + Dialog.this.mActionPadding;
                    hasAction = true;
                }
                if (Dialog.this.mNegativeAction.getVisibility() == 0) {
                    Dialog.this.mNegativeAction.layout(actionRight - Dialog.this.mNegativeAction.getMeasuredWidth(), actionTop, actionRight, actionBottom);
                    hasAction = true;
                }
                if (Dialog.this.mNeutralAction.getVisibility() == 0) {
                    Dialog.this.mNeutralAction.layout(childLeft + Dialog.this.mActionOuterPadding, actionTop, childLeft + Dialog.this.mActionOuterPadding + Dialog.this.mNeutralAction.getMeasuredWidth(), actionBottom);
                    hasAction = true;
                }
                if (hasAction) {
                    childBottom -= Dialog.this.mActionOuterHeight;
                }
            }
            this.mDividerPos = (float)childBottom - this.mDividerPaint.getStrokeWidth() / 2.0f;
            if (Dialog.this.mContent != null) {
                Dialog.this.mContent.layout(childLeft + this.mContentMarginLeft, childTop + this.mContentMarginTop, childRight - this.mContentMarginRight, childBottom - this.mContentMarginBottom);
            }
        }

        public void draw(Canvas canvas) {
            super.draw(canvas);
            if (this.mShowDivider && (Dialog.this.mPositiveAction.getVisibility() == 0 || Dialog.this.mNegativeAction.getVisibility() == 0 || Dialog.this.mNeutralAction.getVisibility() == 0)) {
                canvas.drawLine((float)this.getPaddingLeft(), this.mDividerPos, (float)(this.getWidth() - this.getPaddingRight()), this.mDividerPos, this.mDividerPaint);
            }
        }
    }

    private class ContainerFrameLayout
    extends FrameLayout {
        private boolean mClickOutside;

        public ContainerFrameLayout(Context context) {
            super(context);
            this.mClickOutside = false;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            Dialog.this.mCardView.measure(widthMeasureSpec, heightMeasureSpec);
            this.setMeasuredDimension(widthSize, heightSize);
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            int childLeft = (right - left - Dialog.this.mCardView.getMeasuredWidth()) / 2;
            int childTop = (bottom - top - Dialog.this.mCardView.getMeasuredHeight()) / 2;
            int childRight = childLeft + Dialog.this.mCardView.getMeasuredWidth();
            int childBottom = childTop + Dialog.this.mCardView.getMeasuredHeight();
            Dialog.this.mCardView.layout(childLeft, childTop, childRight, childBottom);
        }

        private boolean isOutsideDialog(float x, float y) {
            return x < (float)(Dialog.this.mCardView.getLeft() + Dialog.this.mCardView.getPaddingLeft()) || x > (float)(Dialog.this.mCardView.getRight() - Dialog.this.mCardView.getPaddingRight()) || y < (float)(Dialog.this.mCardView.getTop() + Dialog.this.mCardView.getPaddingTop()) || y > (float)(Dialog.this.mCardView.getBottom() - Dialog.this.mCardView.getPaddingBottom());
        }

        public boolean onTouchEvent(MotionEvent event) {
            boolean handled = super.onTouchEvent(event);
            if (handled) {
                return true;
            }
            switch (event.getAction()) {
                case 0: {
                    if (this.isOutsideDialog(event.getX(), event.getY())) {
                        this.mClickOutside = true;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return this.mClickOutside;
                }
                case 3: {
                    this.mClickOutside = false;
                    return false;
                }
                case 1: {
                    if (this.mClickOutside && this.isOutsideDialog(event.getX(), event.getY())) {
                        this.mClickOutside = false;
                        if (Dialog.this.mCancelable && Dialog.this.mCanceledOnTouchOutside) {
                            Dialog.this.dismiss();
                        }
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
    }
}

