/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Checkable;
import com.rey.material.R;
import com.rey.material.util.ColorUtil;
import com.rey.material.util.ThemeUtil;
import com.rey.material.widget.RippleManager;

public class Switch
extends View
implements Checkable {
    private RippleManager mRippleManager = new RippleManager();
    private boolean mRunning = false;
    private Paint mPaint;
    private RectF mDrawRect;
    private RectF mTempRect;
    private Path mTrackPath;
    private int mTrackSize;
    private ColorStateList mTrackColors;
    private Paint.Cap mTrackCap;
    private int mThumbRadius;
    private ColorStateList mThumbColors;
    private float mThumbPosition;
    private int mMaxAnimDuration;
    private Interpolator mInterpolator;
    private int mGravity = 16;
    private boolean mChecked = false;
    private float mMemoX;
    private float mStartX;
    private float mFlingVelocity;
    private long mStartTime;
    private int mAnimDuration;
    private float mStartPosition;
    private int[] mTempStates = new int[2];
    private int mShadowSize;
    private int mShadowOffset;
    private Path mShadowPath;
    private Paint mShadowPaint;
    private static final int COLOR_SHADOW_START = 0x4C000000;
    private static final int COLOR_SHADOW_END = 0;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            Switch.this.update();
        }
    };

    public Switch(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public Switch(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public Switch(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public Switch(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mPaint = new Paint(1);
        this.mDrawRect = new RectF();
        this.mTempRect = new RectF();
        this.mTrackPath = new Path();
        this.mFlingVelocity = ViewConfiguration.get((Context)context).getScaledMinimumFlingVelocity();
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
    }

    private void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int[] colors;
        int[][] states;
        this.mRippleManager.onCreate(this, context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Switch, defStyleAttr, defStyleRes);
        this.mTrackSize = a.getDimensionPixelSize(R.styleable.Switch_sw_trackSize, ThemeUtil.dpToPx(context, 2));
        this.mTrackColors = a.getColorStateList(R.styleable.Switch_sw_trackColor);
        int cap = a.getInteger(R.styleable.Switch_sw_trackCap, 0);
        this.mTrackCap = cap == 0 ? Paint.Cap.BUTT : (cap == 1 ? Paint.Cap.ROUND : Paint.Cap.SQUARE);
        this.mThumbColors = a.getColorStateList(R.styleable.Switch_sw_thumbColor);
        this.mThumbRadius = a.getDimensionPixelSize(R.styleable.Switch_sw_thumbRadius, ThemeUtil.dpToPx(context, 8));
        this.mShadowSize = a.getDimensionPixelSize(R.styleable.Switch_sw_thumbElevation, ThemeUtil.dpToPx(context, 2));
        this.mShadowOffset = this.mShadowSize / 2;
        this.mMaxAnimDuration = a.getInt(R.styleable.Switch_sw_animDuration, context.getResources().getInteger(0x10E0001));
        this.mGravity = a.getInt(R.styleable.Switch_android_gravity, 16);
        this.mChecked = a.getBoolean(R.styleable.Switch_android_checked, false);
        this.mThumbPosition = this.mChecked ? 1.0f : 0.0f;
        int resId = a.getResourceId(R.styleable.Switch_sw_interpolator, 0);
        this.mInterpolator = resId != 0 ? AnimationUtils.loadInterpolator((Context)context, (int)resId) : new DecelerateInterpolator();
        a.recycle();
        if (this.mTrackColors == null) {
            states = new int[][]{{-16842912}, {0x10100A0}};
            colors = new int[]{ColorUtil.getColor(ThemeUtil.colorControlNormal(context, -16777216), 0.5f), ColorUtil.getColor(ThemeUtil.colorControlActivated(context, -16777216), 0.5f)};
            this.mTrackColors = new ColorStateList((int[][])states, colors);
        }
        if (this.mThumbColors == null) {
            states = new int[][]{{-16842912}, {0x10100A0}};
            colors = new int[]{0xFAFAFA, ThemeUtil.colorControlActivated(context, -16777216)};
            this.mThumbColors = new ColorStateList((int[][])states, colors);
        }
        this.mPaint.setStrokeCap(this.mTrackCap);
        this.buildShadow();
    }

    public void setOnClickListener(View.OnClickListener l) {
        if (l == this.mRippleManager) {
            super.setOnClickListener(l);
        } else {
            this.mRippleManager.setOnClickListener(l);
            this.setOnClickListener(this.mRippleManager);
        }
    }

    public void setChecked(boolean checked) {
        float desPos;
        if (this.mChecked != checked) {
            this.mChecked = checked;
        }
        float f = desPos = this.mChecked ? 1.0f : 0.0f;
        if (this.mThumbPosition != desPos) {
            this.startAnimation();
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        if (this.isEnabled()) {
            this.setChecked(!this.mChecked);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        super.onTouchEvent(event);
        this.mRippleManager.onTouchEvent(event);
        switch (event.getAction()) {
            case 0: {
                this.mStartX = this.mMemoX = event.getX();
                this.mStartTime = SystemClock.uptimeMillis();
                break;
            }
            case 2: {
                float offset = (event.getX() - this.mMemoX) / (this.mDrawRect.width() - (float)(this.mThumbRadius * 2));
                this.mThumbPosition = Math.min(1.0f, Math.max(0.0f, this.mThumbPosition + offset));
                this.mMemoX = event.getX();
                this.invalidate();
                break;
            }
            case 1: {
                float velocity = (event.getX() - this.mStartX) / (float)(SystemClock.uptimeMillis() - this.mStartTime) * 1000.0f;
                if (Math.abs(velocity) >= this.mFlingVelocity) {
                    this.setChecked(velocity > 0.0f);
                    break;
                }
                if (!this.mChecked && this.mThumbPosition < 0.1f || this.mChecked && this.mThumbPosition > 0.9f) {
                    this.toggle();
                    break;
                }
                this.setChecked(this.mThumbPosition > 0.5f);
                break;
            }
            case 3: {
                this.setChecked(this.mThumbPosition > 0.5f);
            }
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        switch (widthMode) {
            case 0: {
                widthSize = this.getSuggestedMinimumWidth();
                break;
            }
            case -2147483648: {
                widthSize = Math.min(widthSize, this.getSuggestedMinimumWidth());
            }
        }
        switch (heightMode) {
            case 0: {
                heightSize = this.getSuggestedMinimumHeight();
                break;
            }
            case -2147483648: {
                heightSize = Math.min(heightSize, this.getSuggestedMinimumHeight());
            }
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    public int getSuggestedMinimumWidth() {
        return this.mThumbRadius * 4 + Math.max(this.mShadowSize, this.getPaddingLeft()) + Math.max(this.mShadowSize, this.getPaddingRight());
    }

    public int getSuggestedMinimumHeight() {
        return this.mThumbRadius * 2 + Math.max(this.mShadowSize - this.mShadowOffset, this.getPaddingTop()) + Math.max(this.mShadowSize + this.mShadowOffset, this.getPaddingBottom());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mDrawRect.left = Math.max(this.mShadowSize, this.getPaddingLeft());
        this.mDrawRect.right = w - Math.max(this.mShadowSize, this.getPaddingRight());
        int height = this.mThumbRadius * 2;
        int align = this.mGravity & 0x70;
        switch (align) {
            case 48: {
                this.mDrawRect.top = Math.max(this.mShadowSize - this.mShadowOffset, this.getPaddingTop());
                this.mDrawRect.bottom = this.mDrawRect.top + (float)height;
                break;
            }
            case 80: {
                this.mDrawRect.bottom = h - Math.max(this.mShadowSize + this.mShadowOffset, this.getPaddingBottom());
                this.mDrawRect.top = this.mDrawRect.bottom - (float)height;
                break;
            }
            default: {
                this.mDrawRect.top = (float)(h - height) / 2.0f;
                this.mDrawRect.bottom = this.mDrawRect.top + (float)height;
            }
        }
    }

    private int getTrackColor(boolean checked) {
        this.mTempStates[0] = this.isEnabled() ? 16842910 : -16842910;
        this.mTempStates[1] = checked ? 0x10100A0 : -16842912;
        return this.mTrackColors.getColorForState(this.mTempStates, 0);
    }

    private int getThumbColor(boolean checked) {
        this.mTempStates[0] = this.isEnabled() ? 16842910 : -16842910;
        this.mTempStates[1] = checked ? 0x10100A0 : -16842912;
        return this.mThumbColors.getColorForState(this.mTempStates, 0);
    }

    private void buildShadow() {
        if (this.mShadowSize <= 0) {
            return;
        }
        if (this.mShadowPaint == null) {
            this.mShadowPaint = new Paint(5);
            this.mShadowPaint.setStyle(Paint.Style.FILL);
            this.mShadowPaint.setDither(true);
        }
        float startRatio = (float)this.mThumbRadius / (float)(this.mThumbRadius + this.mShadowSize + this.mShadowOffset);
        this.mShadowPaint.setShader((Shader)new RadialGradient(0.0f, 0.0f, (float)(this.mThumbRadius + this.mShadowSize), new int[]{0x4C000000, 0x4C000000, 0}, new float[]{0.0f, startRatio, 1.0f}, Shader.TileMode.CLAMP));
        if (this.mShadowPath == null) {
            this.mShadowPath = new Path();
            this.mShadowPath.setFillType(Path.FillType.EVEN_ODD);
        } else {
            this.mShadowPath.reset();
        }
        float radius = this.mThumbRadius + this.mShadowSize;
        this.mTempRect.set(-radius, -radius, radius, radius);
        this.mShadowPath.addOval(this.mTempRect, Path.Direction.CW);
        radius = this.mThumbRadius - 1;
        this.mTempRect.set(-radius, -radius - (float)this.mShadowOffset, radius, radius - (float)this.mShadowOffset);
        this.mShadowPath.addOval(this.mTempRect, Path.Direction.CW);
    }

    private void getTrackPath(float x, float y, float radius) {
        float halfStroke = (float)this.mTrackSize / 2.0f;
        this.mTrackPath.reset();
        if (this.mTrackCap != Paint.Cap.ROUND) {
            this.mTempRect.set(x - radius + 1.0f, y - radius + 1.0f, x + radius - 1.0f, y + radius - 1.0f);
            float angle = (float)(Math.asin(halfStroke / (radius - 1.0f)) / Math.PI * 180.0);
            if (x - radius > this.mDrawRect.left) {
                this.mTrackPath.moveTo(this.mDrawRect.left, y - halfStroke);
                this.mTrackPath.arcTo(this.mTempRect, 180.0f + angle, -angle * 2.0f);
                this.mTrackPath.lineTo(this.mDrawRect.left, y + halfStroke);
                this.mTrackPath.close();
            }
            if (x + radius < this.mDrawRect.right) {
                this.mTrackPath.moveTo(this.mDrawRect.right, y - halfStroke);
                this.mTrackPath.arcTo(this.mTempRect, -angle, angle * 2.0f);
                this.mTrackPath.lineTo(this.mDrawRect.right, y + halfStroke);
                this.mTrackPath.close();
            }
        } else {
            float angle2;
            float angle = (float)(Math.asin(halfStroke / (radius - 1.0f)) / Math.PI * 180.0);
            if (x - radius > this.mDrawRect.left) {
                angle2 = (float)(Math.acos(Math.max(0.0f, (this.mDrawRect.left + halfStroke - x + radius) / halfStroke)) / Math.PI * 180.0);
                this.mTempRect.set(this.mDrawRect.left, y - halfStroke, this.mDrawRect.left + (float)this.mTrackSize, y + halfStroke);
                this.mTrackPath.arcTo(this.mTempRect, 180.0f - angle2, angle2 * 2.0f);
                this.mTempRect.set(x - radius + 1.0f, y - radius + 1.0f, x + radius - 1.0f, y + radius - 1.0f);
                this.mTrackPath.arcTo(this.mTempRect, 180.0f + angle, -angle * 2.0f);
                this.mTrackPath.close();
            }
            if (x + radius < this.mDrawRect.right) {
                angle2 = (float)Math.acos(Math.max(0.0f, (x + radius - this.mDrawRect.right + halfStroke) / halfStroke));
                this.mTrackPath.moveTo((float)((double)(this.mDrawRect.right - halfStroke) + Math.cos(angle2) * (double)halfStroke), (float)((double)y + Math.sin(angle2) * (double)halfStroke));
                angle2 = (float)((double)angle2 / Math.PI * 180.0);
                this.mTempRect.set(this.mDrawRect.right - (float)this.mTrackSize, y - halfStroke, this.mDrawRect.right, y + halfStroke);
                this.mTrackPath.arcTo(this.mTempRect, angle2, -angle2 * 2.0f);
                this.mTempRect.set(x - radius + 1.0f, y - radius + 1.0f, x + radius - 1.0f, y + radius - 1.0f);
                this.mTrackPath.arcTo(this.mTempRect, -angle, angle * 2.0f);
                this.mTrackPath.close();
            }
        }
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        float x = (this.mDrawRect.width() - (float)(this.mThumbRadius * 2)) * this.mThumbPosition + this.mDrawRect.left + (float)this.mThumbRadius;
        float y = this.mDrawRect.centerY();
        this.getTrackPath(x, y, this.mThumbRadius);
        this.mPaint.setColor(ColorUtil.getMiddleColor(this.getTrackColor(false), this.getTrackColor(true), this.mThumbPosition));
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.mTrackPath, this.mPaint);
        if (this.mShadowSize > 0) {
            int saveCount = canvas.save();
            canvas.translate(x, y + (float)this.mShadowOffset);
            canvas.drawPath(this.mShadowPath, this.mShadowPaint);
            canvas.restoreToCount(saveCount);
        }
        this.mPaint.setColor(ColorUtil.getMiddleColor(this.getThumbColor(false), this.getThumbColor(true), this.mThumbPosition));
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(x, y, (float)this.mThumbRadius, this.mPaint);
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mStartPosition = this.mThumbPosition;
        this.mAnimDuration = (int)((float)this.mMaxAnimDuration * (this.mChecked ? 1.0f - this.mStartPosition : this.mStartPosition));
    }

    private void startAnimation() {
        if (this.getHandler() != null) {
            this.resetAnimation();
            this.mRunning = true;
            this.getHandler().postAtTime(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        } else {
            this.mThumbPosition = this.mChecked ? 1.0f : 0.0f;
        }
        this.invalidate();
    }

    private void stopAnimation() {
        this.mRunning = false;
        this.getHandler().removeCallbacks(this.mUpdater);
        this.invalidate();
    }

    private void update() {
        long curTime = SystemClock.uptimeMillis();
        float progress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mAnimDuration);
        float value = this.mInterpolator.getInterpolation(progress);
        float f = this.mThumbPosition = this.mChecked ? this.mStartPosition * (1.0f - value) + value : this.mStartPosition * (1.0f - value);
        if (progress == 1.0f) {
            this.stopAnimation();
        }
        if (this.mRunning) {
            this.getHandler().postAtTime(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidate();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.checked = this.isChecked();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setChecked(ss.checked);
        this.requestLayout();
    }

    static class SavedState
    extends View.BaseSavedState {
        boolean checked;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.checked = (Boolean)in.readValue(null);
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeValue((Object)this.checked);
        }

        public String toString() {
            return "Switch.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " checked=" + this.checked + "}";
        }
    }
}

