/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v7.internal.widget.TintManager;
import android.support.v7.internal.widget.TintTypedArray;
import android.support.v7.internal.widget.ViewUtils;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.SpinnerAdapter;
import com.rey.material.R;
import com.rey.material.drawable.ArrowDrawable;
import com.rey.material.drawable.DividerDrawable;
import com.rey.material.util.ThemeUtil;
import com.rey.material.widget.ListPopupWindow;
import com.rey.material.widget.ListView;
import com.rey.material.widget.RippleManager;
import com.rey.material.widget.TextView;

public class Spinner
extends FrameLayout {
    private static final int MAX_ITEMS_MEASURED = 15;
    private static final int INVALID_POSITION = -1;
    private boolean mLabelEnable;
    private LabelView mLabelView;
    private SpinnerAdapter mAdapter;
    private OnItemClickListener mOnItemClickListener;
    private OnItemSelectedListener mOnItemSelectedListener;
    private int mMinWidth;
    private int mMinHeight;
    private DropdownPopup mPopup;
    private int mDropDownWidth;
    private ArrowDrawable mArrowDrawable;
    private int mArrowSize;
    private int mArrowPadding;
    private boolean mArrowAnimSwitchMode;
    private DividerDrawable mDividerDrawable;
    private int mDividerHeight;
    private int mDividerPadding;
    private int mGravity;
    private boolean mDisableChildrenWhenDisabled;
    private int mSelectedPosition = -1;
    private RecycleBin mRecycler = new RecycleBin();
    private Rect mTempRect = new Rect();
    private DropDownAdapter mTempAdapter;
    private SpinnerDataSetObserver mDataSetObserver = new SpinnerDataSetObserver();
    private TintManager mTintManager;
    private RippleManager mRippleManager = new RippleManager();

    public Spinner(Context context) {
        super(context);
        this.init(context, null, R.attr.listPopupWindowStyle, 0);
    }

    public Spinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, R.attr.listPopupWindowStyle, 0);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public Spinner(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    public void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int resId;
        this.setWillNotDraw(false);
        this.mRippleManager.onCreate((View)this, context, attrs, defStyleAttr, defStyleRes);
        TintTypedArray a = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.Spinner, (int)defStyleAttr, (int)defStyleRes);
        this.mLabelEnable = a.getBoolean(R.styleable.Spinner_spn_labelEnable, false);
        if (this.mLabelEnable) {
            this.mLabelView = new LabelView(context);
            this.mLabelView.setGravity(0x800003);
            this.mLabelView.setSingleLine(true);
            int labelPadding = a.getDimensionPixelOffset(R.styleable.Spinner_spn_labelPadding, 0);
            int labelTextSize = a.getDimensionPixelSize(R.styleable.Spinner_spn_labelTextSize, 0);
            ColorStateList labelTextColor = a.getColorStateList(R.styleable.Spinner_spn_labelTextColor);
            int labelTextAppearance = a.getResourceId(R.styleable.Spinner_spn_labelTextAppearance, 0);
            int labelEllipsize = a.getInteger(R.styleable.Spinner_spn_labelEllipsize, 0);
            String label = a.getString(R.styleable.Spinner_spn_label);
            this.mLabelView.setText(label);
            this.mLabelView.setPadding(0, 0, 0, labelPadding);
            if (labelTextAppearance > 0) {
                this.mLabelView.setTextAppearance(context, labelTextAppearance);
            }
            if (labelTextSize > 0) {
                this.mLabelView.setTextSize(0, labelTextSize);
            }
            if (labelTextColor != null) {
                this.mLabelView.setTextColor(labelTextColor);
            }
            switch (labelEllipsize) {
                case 1: {
                    this.mLabelView.setEllipsize(TextUtils.TruncateAt.START);
                    break;
                }
                case 2: {
                    this.mLabelView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                    break;
                }
                case 3: {
                    this.mLabelView.setEllipsize(TextUtils.TruncateAt.END);
                    break;
                }
                case 4: {
                    this.mLabelView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
                    break;
                }
                default: {
                    this.mLabelView.setEllipsize(TextUtils.TruncateAt.END);
                }
            }
            this.addView((View)this.mLabelView, 0, new ViewGroup.LayoutParams(-2, -2));
        }
        this.mGravity = a.getInt(R.styleable.Spinner_android_gravity, 17);
        this.setMinimumWidth(a.getDimensionPixelOffset(R.styleable.Spinner_android_minWidth, 0));
        this.setMinimumHeight(a.getDimensionPixelOffset(R.styleable.Spinner_android_minHeight, 0));
        this.mPopup = new DropdownPopup(context, attrs, defStyleAttr, defStyleRes);
        this.mPopup.setModal(true);
        this.mDropDownWidth = a.getLayoutDimension(R.styleable.Spinner_android_dropDownWidth, -2);
        this.mPopup.setBackgroundDrawable(a.getDrawable(R.styleable.Spinner_android_popupBackground));
        this.mPopup.setPromptText(a.getString(R.styleable.Spinner_prompt));
        this.mPopup.setItemAnimation(a.getResourceId(R.styleable.Spinner_spn_popupItemAnimation, 0));
        this.mPopup.setItemAnimationOffset(a.getInteger(R.styleable.Spinner_spn_popupItemAnimOffset, 50));
        this.mDisableChildrenWhenDisabled = a.getBoolean(R.styleable.Spinner_disableChildrenWhenDisabled, false);
        this.mArrowAnimSwitchMode = a.getBoolean(R.styleable.Spinner_spn_arrowSwitchMode, false);
        int arrowAnimDuration = a.getInteger(R.styleable.Spinner_spn_arrowAnimDuration, 0);
        this.mArrowSize = a.getDimensionPixelSize(R.styleable.Spinner_spn_arrowSize, ThemeUtil.dpToPx(this.getContext(), 4));
        this.mArrowPadding = a.getDimensionPixelSize(R.styleable.Spinner_spn_arrowPadding, ThemeUtil.dpToPx(this.getContext(), 4));
        ColorStateList arrowColor = a.getColorStateList(R.styleable.Spinner_spn_arrowColor);
        if (arrowColor == null) {
            arrowColor = ColorStateList.valueOf((int)ThemeUtil.colorControlNormal(context, -16777216));
        }
        Interpolator arrowInterpolator = (resId = a.getResourceId(R.styleable.Spinner_spn_arrowInterpolator, 0)) != 0 ? AnimationUtils.loadInterpolator((Context)context, (int)resId) : null;
        boolean arrowClockwise = a.getBoolean(R.styleable.Spinner_spn_arrowAnimClockwise, true);
        this.mArrowDrawable = new ArrowDrawable(ArrowDrawable.MODE_DOWN, this.mArrowSize, arrowColor, arrowAnimDuration, arrowInterpolator, arrowClockwise);
        this.mArrowDrawable.setCallback((Drawable.Callback)this);
        this.mDividerHeight = a.getDimensionPixelOffset(R.styleable.Spinner_spn_dividerHeight, 0);
        this.mDividerPadding = a.getDimensionPixelOffset(R.styleable.Spinner_spn_dividerPadding, 0);
        int dividerAnimDuration = a.getInteger(R.styleable.Spinner_spn_dividerAnimDuration, 0);
        ColorStateList dividerColor = a.getColorStateList(R.styleable.Spinner_spn_dividerColor);
        if (dividerColor == null) {
            int[][] states = new int[][]{{-16842908}, {16842908, 16842910}};
            int[] colors = new int[]{ThemeUtil.colorControlNormal(context, -16777216), ThemeUtil.colorControlActivated(context, -16777216)};
            dividerColor = new ColorStateList((int[][])states, colors);
        }
        if (this.mDividerHeight > 0) {
            this.mDividerDrawable = new DividerDrawable(this.mDividerHeight, dividerColor, dividerAnimDuration);
            this.mDividerDrawable.setCallback((Drawable.Callback)this);
        }
        this.mTintManager = a.getTintManager();
        a.recycle();
        if (this.mTempAdapter != null) {
            this.mPopup.setAdapter(this.mTempAdapter);
            this.mTempAdapter = null;
        }
        if (this.isInEditMode()) {
            TextView tv = new TextView(context, attrs, defStyleAttr);
            tv.setText("Item 1");
            super.addView((View)tv);
        }
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Spinner.this.showPopup();
            }
        });
    }

    public View getSelectedView() {
        View v = this.getChildAt(this.getChildCount() - 1);
        return v == this.mLabelView ? null : v;
    }

    public void setSelection(int position) {
        if (this.mAdapter != null) {
            position = Math.min(position, this.mAdapter.getCount() - 1);
        }
        if (this.mSelectedPosition != position) {
            this.mSelectedPosition = position;
            if (this.mOnItemSelectedListener != null) {
                this.mOnItemSelectedListener.onItemSelected(this, this.getSelectedView(), position, this.mAdapter == null ? -1L : this.mAdapter.getItemId(position));
            }
            this.onDataInvalidated();
        }
    }

    public int getSelectedItemPosition() {
        return this.mSelectedPosition;
    }

    public SpinnerAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(SpinnerAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
        }
        this.mRecycler.clear();
        this.mAdapter = adapter;
        this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
        this.onDataChanged();
        if (this.mPopup != null) {
            this.mPopup.setAdapter(new DropDownAdapter(adapter));
        } else {
            this.mTempAdapter = new DropDownAdapter(adapter);
        }
    }

    public void setPopupBackgroundDrawable(Drawable background) {
        this.mPopup.setBackgroundDrawable(background);
    }

    public void setPopupBackgroundResource(int resId) {
        this.setPopupBackgroundDrawable(this.mTintManager.getDrawable(resId));
    }

    public Drawable getPopupBackground() {
        return this.mPopup.getBackground();
    }

    public void setDropDownVerticalOffset(int pixels) {
        this.mPopup.setVerticalOffset(pixels);
    }

    public int getDropDownVerticalOffset() {
        return this.mPopup.getVerticalOffset();
    }

    public void setDropDownHorizontalOffset(int pixels) {
        this.mPopup.setHorizontalOffset(pixels);
    }

    public int getDropDownHorizontalOffset() {
        return this.mPopup.getHorizontalOffset();
    }

    public void setDropDownWidth(int pixels) {
        this.mDropDownWidth = pixels;
    }

    public int getDropDownWidth() {
        return this.mDropDownWidth;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mDisableChildrenWhenDisabled) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setEnabled(enabled);
            }
        }
    }

    public void setMinimumHeight(int minHeight) {
        this.mMinHeight = minHeight;
        super.setMinimumHeight(minHeight);
    }

    public void setMinimumWidth(int minWidth) {
        this.mMinWidth = minWidth;
        super.setMinimumWidth(minWidth);
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 0x800003;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    public int getBaseline() {
        View child = this.getSelectedView();
        if (child != null) {
            int childBaseline = child.getBaseline();
            return childBaseline >= 0 ? child.getTop() + childBaseline : -1;
        }
        return -1;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        if (l == this.mRippleManager) {
            super.setOnClickListener(l);
        } else {
            this.mRippleManager.setOnClickListener(l);
            this.setOnClickListener(this.mRippleManager);
        }
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mOnItemClickListener = l;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener l) {
        this.mOnItemSelectedListener = l;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return true;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        return this.mRippleManager.onTouchEvent(event) || result;
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || this.mArrowDrawable == who || this.mDividerDrawable == who;
    }

    private int getArrowDrawableWidth() {
        return this.mArrowSize + this.mArrowPadding * 2;
    }

    private int getDividerDrawableHeight() {
        return this.mDividerHeight > 0 ? this.mDividerHeight + this.mDividerPadding : 0;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int paddingHorizontal = this.getPaddingLeft() + this.getPaddingRight() + this.getArrowDrawableWidth();
        int paddingVertical = this.getPaddingTop() + this.getPaddingBottom() + this.getDividerDrawableHeight();
        int labelWidth = 0;
        int labelHeight = 0;
        if (this.mLabelView != null) {
            this.mLabelView.measure(View.MeasureSpec.makeMeasureSpec((int)(widthSize - paddingHorizontal), (int)widthMode), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            labelWidth = this.mLabelView.getMeasuredWidth();
            labelHeight = this.mLabelView.getMeasuredHeight();
        }
        int width = 0;
        int height = 0;
        View v = this.getSelectedView();
        if (v != null) {
            int hs;
            int ws;
            ViewGroup.LayoutParams params = v.getLayoutParams();
            switch (params.width) {
                case -2: {
                    ws = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                    break;
                }
                case -1: {
                    ws = View.MeasureSpec.makeMeasureSpec((int)(widthSize - paddingHorizontal), (int)widthMode);
                    break;
                }
                default: {
                    ws = View.MeasureSpec.makeMeasureSpec((int)params.width, (int)0x40000000);
                }
            }
            switch (params.height) {
                case -2: {
                    hs = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                    break;
                }
                case -1: {
                    hs = View.MeasureSpec.makeMeasureSpec((int)(heightSize - paddingVertical - labelHeight), (int)heightMode);
                    break;
                }
                default: {
                    hs = View.MeasureSpec.makeMeasureSpec((int)params.height, (int)0x40000000);
                }
            }
            v.measure(ws, hs);
            width = v.getMeasuredWidth();
            height = v.getMeasuredHeight();
        }
        width = Math.max(this.mMinWidth, Math.max(labelWidth, width) + paddingHorizontal);
        height = Math.max(this.mMinHeight, height + labelHeight + paddingVertical);
        switch (widthMode) {
            case -2147483648: {
                width = Math.min(widthSize, width);
                break;
            }
            case 0x40000000: {
                width = widthSize;
            }
        }
        switch (heightMode) {
            case -2147483648: {
                height = Math.min(heightSize, height);
                break;
            }
            case 0x40000000: {
                height = heightSize;
            }
        }
        this.setMeasuredDimension(width, height);
        if (v != null && (v.getMeasuredWidth() != (width -= paddingHorizontal) || v.getMeasuredHeight() != (height -= labelHeight + paddingVertical))) {
            v.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View v;
        int childLeft = this.getPaddingLeft();
        int childRight = r - l - this.getPaddingRight() - this.getArrowDrawableWidth();
        int childTop = this.getPaddingTop();
        int childBottom = b - t - this.getPaddingBottom();
        if (this.mLabelView != null) {
            this.mLabelView.layout(childLeft, childTop, childLeft + this.mLabelView.getMeasuredWidth(), childTop + this.mLabelView.getMeasuredHeight());
            childTop += this.mLabelView.getMeasuredHeight();
        }
        if ((v = this.getSelectedView()) != null) {
            int y;
            int x;
            int horizontalGravity = this.mGravity & 7;
            switch (horizontalGravity) {
                case 3: {
                    x = childLeft;
                    break;
                }
                case 1: {
                    x = (childRight - childLeft - v.getMeasuredWidth()) / 2 + childLeft;
                    break;
                }
                case 5: {
                    x = childRight - v.getMeasuredWidth();
                    break;
                }
                default: {
                    x = (childRight - childLeft - v.getMeasuredWidth()) / 2 + childLeft;
                }
            }
            int verticalGravity = this.mGravity & 0x70;
            switch (verticalGravity) {
                case 48: {
                    y = childTop;
                    break;
                }
                case 16: {
                    y = (childBottom - childTop - v.getMeasuredHeight()) / 2 + childTop;
                    break;
                }
                case 80: {
                    y = childBottom - v.getMeasuredHeight();
                    break;
                }
                default: {
                    y = (childBottom - childTop - v.getMeasuredHeight()) / 2 + childTop;
                }
            }
            v.layout(x, y, x + v.getMeasuredWidth(), y + v.getMeasuredHeight());
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mArrowDrawable.setBounds(w - this.getArrowDrawableWidth() - this.getPaddingRight(), this.getPaddingTop() + (this.mLabelView == null ? 0 : this.mLabelView.getMeasuredHeight()), w - this.getPaddingRight(), h - this.getDividerDrawableHeight() - this.getPaddingBottom());
        if (this.mDividerDrawable != null) {
            this.mDividerDrawable.setBounds(this.getPaddingLeft(), h - this.mDividerHeight - this.getPaddingBottom(), w - this.getPaddingRight(), h - this.getPaddingBottom());
        }
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        this.mArrowDrawable.draw(canvas);
        if (this.mDividerDrawable != null) {
            this.mDividerDrawable.draw(canvas);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mDividerDrawable != null) {
            this.mDividerDrawable.setState(this.getDrawableState());
        }
    }

    public boolean performItemClick(View view, int position, long id) {
        if (this.mOnItemClickListener != null) {
            if (this.mOnItemClickListener.onItemClick(this, view, position, id)) {
                this.setSelection(position);
            }
            return true;
        }
        this.setSelection(position);
        return false;
    }

    private void onDataChanged() {
        if (this.mSelectedPosition == -1) {
            this.setSelection(0);
        } else if (this.mSelectedPosition < this.mAdapter.getCount()) {
            this.onDataInvalidated();
        } else {
            this.setSelection(this.mAdapter.getCount() - 1);
        }
    }

    private void onDataInvalidated() {
        if (this.mAdapter == null) {
            return;
        }
        if (this.mLabelView == null) {
            this.removeAllViews();
        } else {
            for (int i = this.getChildCount() - 1; i > 0; --i) {
                this.removeViewAt(i);
            }
        }
        int type = this.mAdapter.getItemViewType(this.mSelectedPosition);
        View v = this.mAdapter.getView(this.mSelectedPosition, this.mRecycler.get(type), (ViewGroup)this);
        v.setFocusable(false);
        v.setClickable(false);
        super.addView(v);
        this.mRecycler.put(type, v);
    }

    private void showPopup() {
        if (!this.mPopup.isShowing()) {
            this.mPopup.show();
            ListView lv = this.mPopup.getListView();
            if (lv != null) {
                if (Build.VERSION.SDK_INT >= 11) {
                    lv.setChoiceMode(1);
                }
                lv.setSelection(this.getSelectedItemPosition());
            }
            if (this.mArrowAnimSwitchMode) {
                this.mArrowDrawable.setMode(ArrowDrawable.MODE_UP, true);
            }
        }
    }

    private void onPopupDismissed() {
        this.mArrowDrawable.setMode(ArrowDrawable.MODE_DOWN, true);
    }

    private int measureContentWidth(SpinnerAdapter adapter, Drawable background) {
        if (adapter == null) {
            return 0;
        }
        int width = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int start = Math.max(0, this.getSelectedItemPosition());
        int end = Math.min(adapter.getCount(), start + 15);
        int count = end - start;
        for (int i = start = Math.max(0, start - (15 - count)); i < end; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if ((itemView = adapter.getView(i, itemView, null)).getLayoutParams() == null) {
                itemView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            }
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            width = Math.max(width, itemView.getMeasuredWidth());
        }
        if (background != null) {
            background.getPadding(this.mTempRect);
            width += this.mTempRect.left + this.mTempRect.right;
        }
        return width;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.position = this.getSelectedItemPosition();
        ss.showDropdown = this.mPopup != null && this.mPopup.isShowing();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        ViewTreeObserver vto;
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setSelection(ss.position);
        if (ss.showDropdown && (vto = this.getViewTreeObserver()) != null) {
            ViewTreeObserver.OnGlobalLayoutListener listener = new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    Spinner.this.showPopup();
                    ViewTreeObserver vto = Spinner.this.getViewTreeObserver();
                    if (vto != null) {
                        vto.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            };
            vto.addOnGlobalLayoutListener(listener);
        }
    }

    private class DropdownPopup
    extends ListPopupWindow {
        private CharSequence mHintText;
        private DropDownAdapter mAdapter;
        private ViewTreeObserver.OnGlobalLayoutListener layoutListener;

        public DropdownPopup(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
            this.layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    DropdownPopup.this.computeContentWidth();
                    DropdownPopup.super.show();
                }
            };
            this.setAnchorView((View)Spinner.this);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnDismissListener(new PopupWindow.OnDismissListener(){

                @TargetApi(value=16)
                public void onDismiss() {
                    ViewTreeObserver vto = Spinner.this.getViewTreeObserver();
                    if (vto != null) {
                        if (Build.VERSION.SDK_INT >= 16) {
                            vto.removeOnGlobalLayoutListener(DropdownPopup.this.layoutListener);
                        } else {
                            vto.removeGlobalOnLayoutListener(DropdownPopup.this.layoutListener);
                        }
                    }
                    Spinner.this.onPopupDismissed();
                }
            });
        }

        @Override
        public void setAdapter(ListAdapter adapter) {
            super.setAdapter(adapter);
            this.mAdapter = (DropDownAdapter)adapter;
            this.mAdapter.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View v, int position, long id) {
                    Spinner.this.performItemClick(v, position, DropdownPopup.this.mAdapter.getItemId(position));
                    DropdownPopup.this.dismiss();
                }
            });
        }

        public CharSequence getHintText() {
            return this.mHintText;
        }

        public void setPromptText(CharSequence hintText) {
            this.mHintText = hintText;
        }

        void computeContentWidth() {
            Drawable background = this.getBackground();
            int hOffset = 0;
            if (background != null) {
                background.getPadding(Spinner.this.mTempRect);
                hOffset = ViewUtils.isLayoutRtl((View)Spinner.this) ? ((Spinner)Spinner.this).mTempRect.right : -((Spinner)Spinner.this).mTempRect.left;
            } else {
                ((Spinner)Spinner.this).mTempRect.right = 0;
                ((Spinner)Spinner.this).mTempRect.left = 0;
            }
            int spinnerPaddingLeft = Spinner.this.getPaddingLeft();
            int spinnerPaddingRight = Spinner.this.getPaddingRight();
            int spinnerWidth = Spinner.this.getWidth();
            if (Spinner.this.mDropDownWidth == -2) {
                int contentWidthLimit;
                int contentWidth = Spinner.this.measureContentWidth(this.mAdapter, this.getBackground());
                if (contentWidth > (contentWidthLimit = Spinner.this.getContext().getResources().getDisplayMetrics().widthPixels - ((Spinner)Spinner.this).mTempRect.left - ((Spinner)Spinner.this).mTempRect.right)) {
                    contentWidth = contentWidthLimit;
                }
                this.setContentWidth(Math.max(contentWidth, spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight));
            } else if (Spinner.this.mDropDownWidth == -1) {
                this.setContentWidth(spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight);
            } else {
                this.setContentWidth(Spinner.this.mDropDownWidth);
            }
            hOffset = ViewUtils.isLayoutRtl((View)Spinner.this) ? (hOffset += spinnerWidth - spinnerPaddingRight - this.getWidth()) : (hOffset += spinnerPaddingLeft);
            this.setHorizontalOffset(hOffset);
        }

        @Override
        public void show() {
            boolean wasShowing = this.isShowing();
            this.computeContentWidth();
            this.setInputMethodMode(2);
            super.show();
            if (wasShowing) {
                return;
            }
            ViewTreeObserver vto = Spinner.this.getViewTreeObserver();
            if (vto != null) {
                vto.addOnGlobalLayoutListener(this.layoutListener);
            }
        }
    }

    private class LabelView
    extends android.widget.TextView {
        public LabelView(Context context) {
            super(context);
        }

        protected int[] onCreateDrawableState(int extraSpace) {
            return Spinner.this.getDrawableState();
        }
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter,
    View.OnClickListener {
        private SpinnerAdapter mAdapter;
        private ListAdapter mListAdapter;
        private AdapterView.OnItemClickListener mOnItemClickListener;

        public DropDownAdapter(SpinnerAdapter adapter) {
            this.mAdapter = adapter;
            if (adapter instanceof ListAdapter) {
                this.mListAdapter = (ListAdapter)adapter;
            }
        }

        public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
            this.mOnItemClickListener = listener;
        }

        public void onClick(View v) {
            int position = (Integer)v.getTag();
            if (this.mOnItemClickListener != null) {
                this.mOnItemClickListener.onItemClick(null, v, position, 0L);
            }
        }

        public int getCount() {
            return this.mAdapter == null ? 0 : this.mAdapter.getCount();
        }

        public Object getItem(int position) {
            return this.mAdapter == null ? null : this.mAdapter.getItem(position);
        }

        public long getItemId(int position) {
            return this.mAdapter == null ? -1L : this.mAdapter.getItemId(position);
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View v = this.getDropDownView(position, convertView, parent);
            v.setOnClickListener((View.OnClickListener)this);
            v.setTag((Object)position);
            return v;
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            return this.mAdapter == null ? null : this.mAdapter.getDropDownView(position, convertView, parent);
        }

        public boolean hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        public boolean areAllItemsEnabled() {
            ListAdapter adapter = this.mListAdapter;
            return adapter == null || adapter.areAllItemsEnabled();
        }

        public boolean isEnabled(int position) {
            ListAdapter adapter = this.mListAdapter;
            return adapter == null || adapter.isEnabled(position);
        }

        public int getItemViewType(int position) {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.getItemViewType(position);
            }
            return 0;
        }

        public int getViewTypeCount() {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.getViewTypeCount();
            }
            return 1;
        }

        public boolean isEmpty() {
            return this.getCount() == 0;
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(observer);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(observer);
            }
        }
    }

    private class RecycleBin {
        private final SparseArray<View> mScrapHeap = new SparseArray();

        private RecycleBin() {
        }

        public void put(int type, View v) {
            this.mScrapHeap.put(type, (Object)v);
        }

        View get(int type) {
            View result = (View)this.mScrapHeap.get(type);
            if (result != null) {
                this.mScrapHeap.delete(type);
            }
            return result;
        }

        void clear() {
            SparseArray<View> scrapHeap = this.mScrapHeap;
            scrapHeap.clear();
        }
    }

    private class SpinnerDataSetObserver
    extends DataSetObserver {
        private SpinnerDataSetObserver() {
        }

        public void onChanged() {
            Spinner.this.onDataChanged();
        }

        public void onInvalidated() {
            Spinner.this.onDataInvalidated();
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int position;
        boolean showDropdown;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(Parcel in) {
            super(in);
            this.position = in.readInt();
            this.showDropdown = in.readByte() != 0;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.position);
            out.writeByte((byte)(this.showDropdown ? 1 : 0));
        }

        public String toString() {
            return "AbsSpinner.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " position=" + this.position + " showDropdown=" + this.showDropdown + "}";
        }
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(Spinner var1, View var2, int var3, long var4);
    }

    public static interface OnItemClickListener {
        public boolean onItemClick(Spinner var1, View var2, int var3, long var4);
    }
}

