/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.rey.material.R;
import com.rey.material.drawable.RippleDrawable;
import com.rey.material.util.ThemeUtil;
import com.rey.material.widget.Button;
import com.rey.material.widget.TextView;

public class SnackBar
extends FrameLayout {
    private TextView mText;
    private Button mAction;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    private BackgroundDrawable mBackground;
    private int mMarginLeft;
    private int mMarginBottom;
    private int mWidth;
    private int mHeight;
    private int mMaxHeight;
    private int mMinHeight;
    private int mInAnimationId;
    private int mOutAnimationId;
    private long mDuration = -1L;
    private int mActionId;
    private boolean mRemoveOnDismiss;
    private Runnable mDismissRunnable = new Runnable(){

        @Override
        public void run() {
            SnackBar.this.dismiss();
        }
    };
    private int mState = 0;
    public static final int STATE_DISMISSED = 0;
    public static final int STATE_SHOWED = 1;
    public static final int STATE_SHOWING = 2;
    public static final int STATE_DISMISSING = 3;
    private OnActionClickListener mActionClickListener;
    private OnStateChangeListener mStateChangeListener;

    public static SnackBar make(Context context) {
        return new SnackBar(context);
    }

    public SnackBar(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public SnackBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public SnackBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public SnackBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    @TargetApi(value=16)
    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mText = new TextView(context);
        this.mText.setGravity(8388627);
        this.addView((View)this.mText, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.mAction = new Button(context);
        this.mAction.setBackgroundResource(0);
        this.mAction.setGravity(17);
        this.mAction.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SnackBar.this.mActionClickListener != null) {
                    SnackBar.this.mActionClickListener.onActionClick(SnackBar.this, SnackBar.this.mActionId);
                }
                SnackBar.this.dismiss();
            }
        });
        this.addView((View)this.mAction, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.mBackground = new BackgroundDrawable();
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(this.mBackground);
        } else {
            this.setBackgroundDrawable(this.mBackground);
        }
        this.setClickable(true);
        this.applyStyle(attrs, defStyleAttr, defStyleRes);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = 0;
        int height = 0;
        if (this.mAction.getVisibility() == 0) {
            this.mAction.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), heightMeasureSpec);
            this.mText.measure(View.MeasureSpec.makeMeasureSpec((int)(widthSize - (this.mAction.getMeasuredWidth() - this.mText.getPaddingRight())), (int)widthMode), heightMeasureSpec);
            width = this.mText.getMeasuredWidth() + this.mAction.getMeasuredWidth() - this.mText.getPaddingRight();
        } else {
            this.mText.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode), heightMeasureSpec);
            width = this.mText.getMeasuredWidth();
        }
        height = Math.max(this.mText.getMeasuredHeight(), this.mAction.getMeasuredHeight());
        switch (widthMode) {
            case -2147483648: {
                width = Math.min(widthSize, width);
                break;
            }
            case 0x40000000: {
                width = widthSize;
            }
        }
        switch (heightMode) {
            case -2147483648: {
                height = Math.min(heightSize, height);
                break;
            }
            case 0x40000000: {
                height = heightSize;
            }
        }
        if (this.mMaxHeight > 0) {
            height = Math.min(this.mMaxHeight, height);
        }
        if (this.mMinHeight > 0) {
            height = Math.max(this.mMinHeight, height);
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childLeft = this.getPaddingLeft();
        int childRight = r - l - this.getPaddingRight();
        int childTop = this.getPaddingTop();
        int childBottom = b - t - this.getPaddingBottom();
        if (this.mAction.getVisibility() == 0) {
            this.mAction.layout(childRight - this.mAction.getMeasuredWidth(), childTop, childRight, childBottom);
            this.mText.layout(childLeft, childTop, childRight - this.mAction.getMeasuredWidth() + this.mText.getPaddingRight(), childBottom);
        } else {
            this.mText.layout(childLeft, childTop, childRight, childBottom);
        }
    }

    @TargetApi(value=16)
    private void applyStyle(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Context context = this.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SnackBar, defStyleAttr, defStyleRes);
        int backgroundColor = a.getColor(R.styleable.SnackBar_sb_backgroundColor, -13487566);
        int backgroundRadius = a.getDimensionPixelSize(R.styleable.SnackBar_sb_backgroundCornerRadius, 0);
        int horizontalPadding = a.getDimensionPixelSize(R.styleable.SnackBar_sb_horizontalPadding, ThemeUtil.dpToPx(context, 24));
        int verticalPadding = a.getDimensionPixelSize(R.styleable.SnackBar_sb_verticalPadding, 0);
        TypedValue value = a.peekValue(R.styleable.SnackBar_sb_width);
        this.mWidth = value != null && value.type == 16 ? a.getInteger(R.styleable.SnackBar_sb_width, -1) : a.getDimensionPixelSize(R.styleable.SnackBar_sb_width, -1);
        int minWidth = a.getDimensionPixelSize(R.styleable.SnackBar_sb_minWidth, 0);
        int maxWidth = a.getDimensionPixelSize(R.styleable.SnackBar_sb_maxWidth, 0);
        value = a.peekValue(R.styleable.SnackBar_sb_height);
        this.mHeight = value != null && value.type == 16 ? a.getInteger(R.styleable.SnackBar_sb_height, -2) : a.getDimensionPixelSize(R.styleable.SnackBar_sb_height, -2);
        int minHeight = a.getDimensionPixelSize(R.styleable.SnackBar_sb_minHeight, 0);
        int maxHeight = a.getDimensionPixelSize(R.styleable.SnackBar_sb_maxHeight, 0);
        this.mMarginLeft = a.getDimensionPixelSize(R.styleable.SnackBar_sb_marginLeft, 0);
        this.mMarginBottom = a.getDimensionPixelSize(R.styleable.SnackBar_sb_marginBottom, 0);
        int textSize = a.getDimensionPixelSize(R.styleable.SnackBar_sb_textSize, 0);
        boolean hasTextColor = a.hasValue(R.styleable.SnackBar_sb_textColor);
        int textColor = hasTextColor ? a.getColor(R.styleable.SnackBar_sb_textColor, -1) : 0;
        int textAppearance = a.getResourceId(R.styleable.SnackBar_sb_textAppearance, 0);
        boolean singleLine = a.getBoolean(R.styleable.SnackBar_sb_singleLine, true);
        int maxLines = a.getInteger(R.styleable.SnackBar_sb_maxLines, 0);
        int lines = a.getInteger(R.styleable.SnackBar_sb_lines, 0);
        int ellipsize = a.getInteger(R.styleable.SnackBar_sb_ellipsize, 0);
        int actionTextSize = a.getDimensionPixelSize(R.styleable.SnackBar_sb_actionTextSize, 0);
        value = a.peekValue(R.styleable.SnackBar_sb_actionTextColor);
        ColorStateList actionTextColor = value != null && value.type >= 28 && value.type <= 31 ? ColorStateList.valueOf((int)a.getColor(R.styleable.SnackBar_sb_actionTextColor, -16777216)) : a.getColorStateList(R.styleable.SnackBar_sb_actionTextColor);
        int actionTextAppearance = a.getResourceId(R.styleable.SnackBar_sb_actionTextAppearance, 0);
        int actionRipple = a.getResourceId(R.styleable.SnackBar_sb_actionRipple, 0);
        this.mInAnimationId = a.getResourceId(R.styleable.SnackBar_sb_inAnimation, 0);
        this.mOutAnimationId = a.getResourceId(R.styleable.SnackBar_sb_outAnimation, 0);
        this.mRemoveOnDismiss = a.getBoolean(R.styleable.SnackBar_sb_removeOnDismiss, true);
        a.recycle();
        this.backgroundColor(backgroundColor).backgroundRadius(backgroundRadius);
        this.padding(horizontalPadding, verticalPadding);
        this.textAppearance(textAppearance);
        if (textSize > 0) {
            this.textSize(textSize);
        }
        if (hasTextColor) {
            this.textColor(textColor);
        }
        this.singleLine(singleLine);
        if (maxLines > 0) {
            this.maxLines(maxLines);
        }
        if (lines > 0) {
            this.lines(lines);
        }
        if (minWidth > 0) {
            this.minWidth(minWidth);
        }
        if (maxWidth > 0) {
            this.maxWidth(maxWidth);
        }
        if (minHeight > 0) {
            this.minHeight(minHeight);
        }
        if (maxHeight > 0) {
            this.maxHeight(maxHeight);
        }
        switch (ellipsize) {
            case 1: {
                this.ellipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                this.ellipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                this.ellipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 4: {
                this.ellipsize(TextUtils.TruncateAt.MARQUEE);
                break;
            }
            default: {
                this.ellipsize(TextUtils.TruncateAt.END);
            }
        }
        if (textAppearance != 0) {
            this.actionTextAppearance(actionTextAppearance);
        }
        if (actionTextSize > 0) {
            this.actionTextSize(actionTextSize);
        }
        if (actionTextColor != null) {
            this.actionTextColor(actionTextColor);
        }
        if (actionRipple != 0) {
            this.actionRipple(actionRipple);
        }
    }

    public SnackBar applyStyle(int resId) {
        this.applyStyle(null, 0, resId);
        return this;
    }

    public SnackBar text(CharSequence text) {
        this.mText.setText(text);
        return this;
    }

    public SnackBar text(int id) {
        return this.text(this.getContext().getResources().getString(id));
    }

    public SnackBar textColor(int color) {
        this.mText.setTextColor(color);
        return this;
    }

    public SnackBar textSize(int size) {
        this.mText.setTextSize(0, size);
        return this;
    }

    public SnackBar textAppearance(int resId) {
        if (resId != 0) {
            this.mText.setTextAppearance(this.getContext(), resId);
        }
        return this;
    }

    public SnackBar ellipsize(TextUtils.TruncateAt at) {
        this.mText.setEllipsize(at);
        return this;
    }

    public SnackBar singleLine(boolean b) {
        this.mText.setSingleLine(b);
        return this;
    }

    public SnackBar maxLines(int lines) {
        this.mText.setMaxLines(lines);
        return this;
    }

    public SnackBar lines(int lines) {
        this.mText.setLines(lines);
        return this;
    }

    public SnackBar actionId(int id) {
        this.mActionId = id;
        return this;
    }

    public SnackBar actionText(CharSequence text) {
        if (text == null) {
            this.mAction.setVisibility(4);
        } else {
            this.mAction.setVisibility(0);
            this.mAction.setText(text);
        }
        return this;
    }

    public SnackBar actionText(int id) {
        if (id == 0) {
            return this.actionText(null);
        }
        return this.actionText(this.getContext().getResources().getString(id));
    }

    public SnackBar actionTextColor(int color) {
        this.mAction.setTextColor(color);
        return this;
    }

    public SnackBar actionTextColor(ColorStateList colors) {
        this.mAction.setTextColor(colors);
        return this;
    }

    public SnackBar actionTextAppearance(int resId) {
        if (resId != 0) {
            this.mAction.setTextAppearance(this.getContext(), resId);
        }
        return this;
    }

    public SnackBar actionTextSize(int size) {
        this.mAction.setTextSize(0, size);
        return this;
    }

    @TargetApi(value=16)
    public SnackBar actionRipple(int resId) {
        if (resId != 0) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.mAction.setBackground(new RippleDrawable.Builder(this.getContext(), resId).build());
            } else {
                this.mAction.setBackgroundDrawable(new RippleDrawable.Builder(this.getContext(), resId).build());
            }
        }
        return this;
    }

    public SnackBar duration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public SnackBar backgroundColor(int color) {
        this.mBackground.setColor(color);
        return this;
    }

    public SnackBar backgroundRadius(int radius) {
        this.mBackground.setRadius(radius);
        return this;
    }

    public SnackBar horizontalPadding(int padding) {
        this.mText.setPadding(padding, this.mText.getPaddingTop(), padding, this.mText.getPaddingBottom());
        this.mAction.setPadding(padding, this.mAction.getPaddingTop(), padding, this.mAction.getPaddingBottom());
        return this;
    }

    public SnackBar verticalPadding(int padding) {
        this.mText.setPadding(this.mText.getPaddingLeft(), padding, this.mText.getPaddingRight(), padding);
        this.mAction.setPadding(this.mAction.getPaddingLeft(), padding, this.mAction.getPaddingRight(), padding);
        return this;
    }

    public SnackBar padding(int horizontalPadding, int verticalPadding) {
        this.mText.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        this.mAction.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        return this;
    }

    public SnackBar width(int width) {
        this.mWidth = width;
        return this;
    }

    public SnackBar minWidth(int width) {
        this.mText.setMinWidth(width);
        return this;
    }

    public SnackBar maxWidth(int width) {
        this.mText.setMaxWidth(width);
        return this;
    }

    public SnackBar height(int height) {
        this.mHeight = height;
        return this;
    }

    public SnackBar maxHeight(int height) {
        this.mMaxHeight = height;
        return this;
    }

    public SnackBar minHeight(int height) {
        this.mMinHeight = height;
        return this;
    }

    public SnackBar marginLeft(int size) {
        this.mMarginLeft = size;
        return this;
    }

    public SnackBar marginBottom(int size) {
        this.mMarginBottom = size;
        return this;
    }

    public SnackBar actionClickListener(OnActionClickListener listener) {
        this.mActionClickListener = listener;
        return this;
    }

    public SnackBar stateChangeListener(OnStateChangeListener listener) {
        this.mStateChangeListener = listener;
        return this;
    }

    public SnackBar removeOnDismiss(boolean b) {
        this.mRemoveOnDismiss = b;
        return this;
    }

    public void show(Activity activity) {
        this.show((ViewGroup)activity.getWindow().findViewById(0x1020002));
    }

    public void show(ViewGroup parent) {
        if (this.mState == 2 || this.mState == 3) {
            return;
        }
        if (this.getParent() != parent) {
            if (this.getParent() != null) {
                ((ViewGroup)this.getParent()).removeView((View)this);
            }
            parent.addView((View)this);
        }
        this.show();
    }

    public void show() {
        FrameLayout.LayoutParams params;
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent == null || this.mState == 2 || this.mState == 3) {
            return;
        }
        if (parent instanceof FrameLayout) {
            params = (FrameLayout.LayoutParams)this.getLayoutParams();
            params.width = this.mWidth;
            params.height = this.mHeight;
            params.gravity = 80;
            params.leftMargin = this.mMarginLeft;
            params.bottomMargin = this.mMarginBottom;
        } else if (parent instanceof RelativeLayout) {
            params = (RelativeLayout.LayoutParams)this.getLayoutParams();
            params.width = this.mWidth;
            params.height = this.mHeight;
            params.addRule(12);
            params.leftMargin = this.mMarginLeft;
            params.bottomMargin = this.mMarginBottom;
        }
        if (this.mInAnimationId != 0 && this.mState != 1) {
            Animation anim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.mInAnimationId);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    SnackBar.this.setState(2);
                    SnackBar.this.setVisibility(0);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    SnackBar.this.setState(1);
                    SnackBar.this.startTimer();
                }
            });
            this.startAnimation(anim);
        } else {
            this.setVisibility(0);
            this.setState(1);
            this.startTimer();
        }
    }

    private void startTimer() {
        this.removeCallbacks(this.mDismissRunnable);
        if (this.mDuration > 0L) {
            this.postDelayed(this.mDismissRunnable, this.mDuration);
        }
    }

    public void dismiss() {
        if (this.mState != 1) {
            return;
        }
        this.removeCallbacks(this.mDismissRunnable);
        if (this.mOutAnimationId != 0) {
            Animation anim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.mOutAnimationId);
            anim.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    SnackBar.this.setState(3);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (SnackBar.this.mRemoveOnDismiss && SnackBar.this.getParent() != null && SnackBar.this.getParent() instanceof ViewGroup) {
                        ((ViewGroup)SnackBar.this.getParent()).removeView((View)SnackBar.this);
                    }
                    SnackBar.this.setState(0);
                    SnackBar.this.setVisibility(8);
                }
            });
            this.startAnimation(anim);
        } else {
            if (this.mRemoveOnDismiss && this.getParent() != null && this.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.getParent()).removeView((View)this);
            }
            this.setState(0);
            this.setVisibility(8);
        }
    }

    public int getState() {
        return this.mState;
    }

    private void setState(int state) {
        if (this.mState != state) {
            int oldState = this.mState;
            this.mState = state;
            if (this.mStateChangeListener != null) {
                this.mStateChangeListener.onStateChange(this, oldState, this.mState);
            }
        }
    }

    private class BackgroundDrawable
    extends Drawable {
        private int mBackgroundColor;
        private int mBackgroundRadius;
        private Paint mPaint = new Paint();
        private RectF mRect;

        public BackgroundDrawable() {
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mRect = new RectF();
        }

        public void setColor(int color) {
            if (this.mBackgroundColor != color) {
                this.mBackgroundColor = color;
                this.mPaint.setColor(this.mBackgroundColor);
                this.invalidateSelf();
            }
        }

        public void setRadius(int radius) {
            if (this.mBackgroundRadius != radius) {
                this.mBackgroundRadius = radius;
                this.invalidateSelf();
            }
        }

        protected void onBoundsChange(Rect bounds) {
            this.mRect.set(bounds);
        }

        public void draw(Canvas canvas) {
            canvas.drawRoundRect(this.mRect, (float)this.mBackgroundRadius, (float)this.mBackgroundRadius, this.mPaint);
        }

        public void setAlpha(int alpha) {
            this.mPaint.setAlpha(alpha);
        }

        public void setColorFilter(ColorFilter cf) {
            this.mPaint.setColorFilter(cf);
        }

        public int getOpacity() {
            return -3;
        }
    }

    public static interface OnStateChangeListener {
        public void onStateChange(SnackBar var1, int var2, int var3);
    }

    public static interface OnActionClickListener {
        public void onActionClick(SnackBar var1, int var2);
    }
}

