/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.rey.material.widget.RippleManager;

public class CompoundButton
extends android.widget.CompoundButton {
    private RippleManager mRippleManager = new RippleManager();
    protected Drawable mButtonDrawable;

    public CompoundButton(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public CompoundButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public CompoundButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public CompoundButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    @TargetApi(value=17)
    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mRippleManager.onCreate((View)this, context, attrs, defStyleAttr, defStyleRes);
        if (Build.VERSION.SDK_INT < 17) {
            TypedArray a = context.obtainStyledAttributes(attrs, new int[]{16842965, 16842966}, defStyleAttr, defStyleRes);
            if (!a.hasValue(0) && !a.hasValue(1)) {
                this.setPadding(0, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
            }
            a.recycle();
        }
        this.setClickable(true);
    }

    public void setOnClickListener(View.OnClickListener l) {
        if (l == this.mRippleManager) {
            super.setOnClickListener(l);
        } else {
            this.mRippleManager.setOnClickListener(l);
            this.setOnClickListener(this.mRippleManager);
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        return this.mRippleManager.onTouchEvent(event) || result;
    }

    public void setButtonDrawable(Drawable d) {
        this.mButtonDrawable = d;
        super.setButtonDrawable(d);
    }

    public int getCompoundPaddingLeft() {
        int padding = super.getCompoundPaddingLeft();
        if (Build.VERSION.SDK_INT >= 17) {
            return padding;
        }
        if (this.mButtonDrawable != null) {
            padding += this.mButtonDrawable.getIntrinsicWidth();
        }
        return padding;
    }
}

