/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import java.util.HashMap;

public class TypefaceUtil {
    private static final HashMap<String, Typeface> sCachedFonts = new HashMap();
    private static final String PREFIX_ASSET = "asset:";

    private TypefaceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface load(Context context, String familyName, int style2) {
        if (familyName != null && familyName.startsWith(PREFIX_ASSET)) {
            HashMap<String, Typeface> hashMap = sCachedFonts;
            synchronized (hashMap) {
                try {
                    if (!sCachedFonts.containsKey(familyName)) {
                        Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)familyName);
                        sCachedFonts.put(familyName, typeface);
                        return typeface;
                    }
                }
                catch (Exception e) {
                    return Typeface.DEFAULT;
                }
                return sCachedFonts.get(familyName);
            }
        }
        return Typeface.create((String)familyName, (int)style2);
    }
}

