/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.database.sqlite;

import android.content.Context;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import io.requery.android.database.DatabaseErrorHandler;
import io.requery.android.database.sqlite.SQLiteDatabase;
import io.requery.android.database.sqlite.SQLiteDatabaseConfiguration;
import io.requery.android.database.sqlite.SQLiteOpenHelper;
import java.util.Collections;

public final class RequerySQLiteOpenHelperFactory
implements SupportSQLiteOpenHelper.Factory {
    private final Iterable<ConfigurationOptions> configurationOptions;

    public RequerySQLiteOpenHelperFactory(Iterable<ConfigurationOptions> configurationOptions) {
        this.configurationOptions = configurationOptions;
    }

    public RequerySQLiteOpenHelperFactory() {
        this(Collections.emptyList());
    }

    public SupportSQLiteOpenHelper create(SupportSQLiteOpenHelper.Configuration config) {
        return new CallbackSQLiteOpenHelper(config.context, config.name, config.callback, this.configurationOptions);
    }

    private static final class CallbackSQLiteOpenHelper
    extends SQLiteOpenHelper {
        private final SupportSQLiteOpenHelper.Callback callback;
        private final Iterable<ConfigurationOptions> configurationOptions;

        CallbackSQLiteOpenHelper(Context context, String name, SupportSQLiteOpenHelper.Callback cb, Iterable<ConfigurationOptions> ops) {
            super(context, name, null, cb.version, new CallbackDatabaseErrorHandler(cb));
            this.callback = cb;
            this.configurationOptions = ops;
        }

        @Override
        public void onConfigure(SQLiteDatabase db) {
            this.callback.onConfigure((SupportSQLiteDatabase)db);
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            this.callback.onCreate((SupportSQLiteDatabase)db);
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.callback.onUpgrade((SupportSQLiteDatabase)db, oldVersion, newVersion);
        }

        @Override
        public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.callback.onDowngrade((SupportSQLiteDatabase)db, oldVersion, newVersion);
        }

        @Override
        public void onOpen(SQLiteDatabase db) {
            this.callback.onOpen((SupportSQLiteDatabase)db);
        }

        @Override
        protected SQLiteDatabaseConfiguration createConfiguration(String path, int openFlags) {
            SQLiteDatabaseConfiguration config = super.createConfiguration(path, openFlags);
            for (ConfigurationOptions option : this.configurationOptions) {
                config = option.apply(config);
            }
            return config;
        }
    }

    public static interface ConfigurationOptions {
        public SQLiteDatabaseConfiguration apply(SQLiteDatabaseConfiguration var1);
    }

    private static final class CallbackDatabaseErrorHandler
    implements DatabaseErrorHandler {
        private final SupportSQLiteOpenHelper.Callback callback;

        CallbackDatabaseErrorHandler(SupportSQLiteOpenHelper.Callback callback) {
            this.callback = callback;
        }

        @Override
        public void onCorruption(SQLiteDatabase db) {
            this.callback.onCorruption((SupportSQLiteDatabase)db);
        }
    }
}

