/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.database;

import android.database.CharArrayBuffer;
import io.requery.android.database.CursorWindowAllocationException;
import io.requery.android.database.sqlite.SQLiteClosable;

public class CursorWindow
extends SQLiteClosable {
    private static final int WINDOW_SIZE_KB = 1024;
    private static int sCursorWindowSize = -1;
    public long mWindowPtr;
    private int mStartPos = 0;
    private final String mName;

    private static native long nativeCreate(String var0, int var1);

    private static native void nativeDispose(long var0);

    private static native void nativeClear(long var0);

    private static native int nativeGetNumRows(long var0);

    private static native boolean nativeSetNumColumns(long var0, int var2);

    private static native boolean nativeAllocRow(long var0);

    private static native void nativeFreeLastRow(long var0);

    private static native int nativeGetType(long var0, int var2, int var3);

    private static native byte[] nativeGetBlob(long var0, int var2, int var3);

    private static native String nativeGetString(long var0, int var2, int var3);

    private static native long nativeGetLong(long var0, int var2, int var3);

    private static native double nativeGetDouble(long var0, int var2, int var3);

    private static native boolean nativePutBlob(long var0, byte[] var2, int var3, int var4);

    private static native boolean nativePutString(long var0, String var2, int var3, int var4);

    private static native boolean nativePutLong(long var0, long var2, int var4, int var5);

    private static native boolean nativePutDouble(long var0, double var2, int var4, int var5);

    private static native boolean nativePutNull(long var0, int var2, int var3);

    private static native String nativeGetName(long var0);

    public CursorWindow(String name) {
        String string = this.mName = name != null && name.length() != 0 ? name : "<unnamed>";
        if (sCursorWindowSize < 0) {
            sCursorWindowSize = 0x100000;
        }
        this.mWindowPtr = CursorWindow.nativeCreate(this.mName, sCursorWindowSize);
        if (this.mWindowPtr == 0L) {
            throw new CursorWindowAllocationException("Cursor window allocation of " + sCursorWindowSize / 1024 + " kb failed. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void dispose() {
        if (this.mWindowPtr != 0L) {
            CursorWindow.nativeDispose(this.mWindowPtr);
            this.mWindowPtr = 0L;
        }
    }

    public String getName() {
        return this.mName;
    }

    public void clear() {
        this.mStartPos = 0;
        CursorWindow.nativeClear(this.mWindowPtr);
    }

    public int getStartPosition() {
        return this.mStartPos;
    }

    public void setStartPosition(int pos) {
        this.mStartPos = pos;
    }

    public int getNumRows() {
        return CursorWindow.nativeGetNumRows(this.mWindowPtr);
    }

    public boolean setNumColumns(int columnNum) {
        return CursorWindow.nativeSetNumColumns(this.mWindowPtr, columnNum);
    }

    public boolean allocRow() {
        return CursorWindow.nativeAllocRow(this.mWindowPtr);
    }

    public void freeLastRow() {
        CursorWindow.nativeFreeLastRow(this.mWindowPtr);
    }

    public int getType(int row, int column) {
        return CursorWindow.nativeGetType(this.mWindowPtr, row - this.mStartPos, column);
    }

    public byte[] getBlob(int row, int column) {
        return CursorWindow.nativeGetBlob(this.mWindowPtr, row - this.mStartPos, column);
    }

    public String getString(int row, int column) {
        String value = CursorWindow.nativeGetString(this.mWindowPtr, row - this.mStartPos, column);
        if (value == null) {
            return "";
        }
        return value;
    }

    public void copyStringToBuffer(int row, int column, CharArrayBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("CharArrayBuffer should not be null");
        }
        char[] chars = this.getString(row, column).toCharArray();
        buffer.data = chars;
        buffer.sizeCopied = chars.length;
    }

    public long getLong(int row, int column) {
        return CursorWindow.nativeGetLong(this.mWindowPtr, row - this.mStartPos, column);
    }

    public double getDouble(int row, int column) {
        return CursorWindow.nativeGetDouble(this.mWindowPtr, row - this.mStartPos, column);
    }

    public short getShort(int row, int column) {
        return (short)this.getLong(row, column);
    }

    public int getInt(int row, int column) {
        return (int)this.getLong(row, column);
    }

    public float getFloat(int row, int column) {
        return (float)this.getDouble(row, column);
    }

    public boolean putBlob(byte[] value, int row, int column) {
        return CursorWindow.nativePutBlob(this.mWindowPtr, value, row - this.mStartPos, column);
    }

    public boolean putString(String value, int row, int column) {
        return CursorWindow.nativePutString(this.mWindowPtr, value, row - this.mStartPos, column);
    }

    public boolean putLong(long value, int row, int column) {
        return CursorWindow.nativePutLong(this.mWindowPtr, value, row - this.mStartPos, column);
    }

    public boolean putDouble(double value, int row, int column) {
        return CursorWindow.nativePutDouble(this.mWindowPtr, value, row - this.mStartPos, column);
    }

    public boolean putNull(int row, int column) {
        return CursorWindow.nativePutNull(this.mWindowPtr, row - this.mStartPos, column);
    }

    @Override
    protected void onAllReferencesReleased() {
        this.dispose();
    }

    public String toString() {
        return this.getName() + " {" + Long.toHexString(this.mWindowPtr) + "}";
    }
}

