/*
 * Decompiled with CFR 0.152.
 */
package io.requery.android.database.sqlite;

import android.util.Log;
import android.util.SparseIntArray;
import io.requery.android.database.AbstractWindowedCursor;
import io.requery.android.database.CursorWindow;
import io.requery.android.database.sqlite.SQLiteCursorDriver;
import io.requery.android.database.sqlite.SQLiteDatabase;
import io.requery.android.database.sqlite.SQLiteQuery;

public class SQLiteCursor
extends AbstractWindowedCursor {
    static final String TAG = "SQLiteCursor";
    static final int NO_COUNT = -1;
    private final String mEditTable;
    private final String[] mColumns;
    private final SQLiteQuery mQuery;
    private final SQLiteCursorDriver mDriver;
    private int mCount = -1;
    private int mCursorWindowCapacity;
    private SparseIntArray mColumnNameMap;

    public SQLiteCursor(SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query object cannot be null");
        }
        this.mDriver = driver;
        this.mEditTable = editTable;
        this.mColumnNameMap = null;
        this.mQuery = query;
        this.mColumns = query.getColumnNames();
    }

    public SQLiteDatabase getDatabase() {
        return this.mQuery.getDatabase();
    }

    @Override
    public boolean onMove(int oldPosition, int newPosition) {
        if (this.mWindow == null || newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
            this.fillWindow(newPosition);
        }
        return true;
    }

    @Override
    public int getCount() {
        if (this.mCount == -1) {
            this.fillWindow(0);
        }
        return this.mCount;
    }

    public static int cursorPickFillWindowStartPosition(int cursorPosition, int cursorWindowCapacity) {
        return Math.max(cursorPosition - cursorWindowCapacity / 3, 0);
    }

    private void fillWindow(int requiredPos) {
        this.clearOrCreateWindow(this.getDatabase().getPath());
        try {
            if (this.mCount == -1) {
                int startPos = SQLiteCursor.cursorPickFillWindowStartPosition(requiredPos, 0);
                this.mCount = this.mQuery.fillWindow(this.mWindow, startPos, requiredPos, true);
                this.mCursorWindowCapacity = this.mWindow.getNumRows();
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("received count(*) from native_fill_window: " + this.mCount));
                }
            } else {
                int startPos = SQLiteCursor.cursorPickFillWindowStartPosition(requiredPos, this.mCursorWindowCapacity);
                this.mQuery.fillWindow(this.mWindow, startPos, requiredPos, false);
            }
        }
        catch (RuntimeException ex) {
            this.setWindow(null);
            throw ex;
        }
    }

    @Override
    public int getColumnIndex(String columnName) {
        int periodIndex;
        if (this.mColumnNameMap == null) {
            String[] columns = this.mColumns;
            int columnCount = columns.length;
            SparseIntArray map = new SparseIntArray(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                map.put(columns[i].hashCode(), i);
            }
            this.mColumnNameMap = map;
        }
        if ((periodIndex = columnName.lastIndexOf(46)) != -1) {
            Exception e = new Exception();
            Log.e((String)TAG, (String)("requesting column name with table name -- " + columnName), (Throwable)e);
            columnName = columnName.substring(periodIndex + 1);
        }
        return this.mColumnNameMap.get(columnName.hashCode(), -1);
    }

    @Override
    public String[] getColumnNames() {
        return this.mColumns;
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.mDriver.cursorDeactivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            this.mQuery.close();
            this.mDriver.cursorClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requery() {
        if (this.isClosed()) {
            return false;
        }
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            if (!this.mQuery.getDatabase().isOpen()) {
                return false;
            }
            if (this.mWindow != null) {
                this.mWindow.clear();
            }
            this.mPos = -1;
            this.mCount = -1;
            this.mDriver.cursorRequeried(this);
        }
        try {
            return super.requery();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)("requery() failed " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public void setWindow(CursorWindow window) {
        super.setWindow(window);
        this.mCount = -1;
    }

    public void setSelectionArguments(String[] selectionArgs) {
        this.mDriver.setBindArguments(selectionArgs);
    }

    @Override
    protected void finalize() {
        try {
            if (this.mWindow != null) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

