/*
 * Decompiled with CFR 0.152.
 */
package pl.jeremi.antirelog;

import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Note;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.jeremi.antirelog.AntiRelog;

class CombatHandle {
    static boolean enableBar;
    private int combatTimeLeft;
    private int combatTimeOut;
    private int vanishTimeOut;
    private JavaPlugin plugin;
    private String busyChat;
    private String freeChat;
    private BarColor busyColor;
    private BarColor freeColor;
    private BarStyle barStyle;
    private BossBar busyBar;
    private BossBar freeBar;
    private Player player;
    private boolean inCombat;
    private int combatTickTask = -1;

    CombatHandle(Player player, JavaPlugin plugin) {
        this.player = player;
        this.plugin = plugin;
        this.combatTimeOut = AntiRelog.config.getInt("combat-len");
        this.vanishTimeOut = AntiRelog.config.getInt("vanish-timeout");
        this.busyChat = this.formatCombatChatMessage("busy-chat");
        this.freeChat = this.formatCombatChatMessage("free-chat");
        if (enableBar) {
            this.busyColor = BarColor.valueOf((String)AntiRelog.getConfigString("busy-color").toUpperCase());
            this.freeColor = BarColor.valueOf((String)AntiRelog.getConfigString("free-color").toUpperCase());
            this.barStyle = BarStyle.valueOf((String)AntiRelog.getConfigString("bar-style").toUpperCase());
            this.busyBar = Bukkit.createBossBar((String)this.formatCombatChatMessage("busy-message"), (BarColor)this.busyColor, (BarStyle)this.barStyle, (BarFlag[])new BarFlag[0]);
            this.busyBar.addPlayer(player);
            this.busyBar.setVisible(false);
            this.freeBar = Bukkit.createBossBar((String)this.formatCombatChatMessage("free-message"), (BarColor)this.freeColor, (BarStyle)this.barStyle, (BarFlag[])new BarFlag[0]);
            this.freeBar.addPlayer(player);
            this.freeBar.setVisible(false);
        }
        this.inCombat = false;
    }

    private String formatCombatChatMessage(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)AntiRelog.getConfigString(message)).replaceAll("\\{displayname}", this.player.getDisplayName()).replaceAll("\\{username}", this.player.getName()).replaceAll("\\{timeleft}", String.valueOf(this.combatTimeLeft)).replaceAll("\\{timeout}", String.valueOf(this.combatTimeOut));
    }

    boolean shouldBePunished() {
        return this.inCombat;
    }

    void startCombat() {
        if (enableBar) {
            this.busyBar.setTitle(this.formatCombatChatMessage("busy-message"));
            this.busyBar.setVisible(true);
            this.busyBar.setProgress(1.0);
            this.freeBar.setVisible(false);
        }
        if (!this.busyChat.isEmpty() && !this.inCombat) {
            this.player.sendMessage(this.busyChat);
        }
        this.combatTimeLeft = this.combatTimeOut;
        if (this.combatTickTask != -1) {
            this.plugin.getServer().getScheduler().cancelTask(this.combatTickTask);
        }
        this.combatTickTask = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (CombatHandle.this.combatTimeLeft == 0) {
                    CombatHandle.this.endCombat();
                    return;
                }
                CombatHandle.this.player.playNote(CombatHandle.this.player.getLocation(), Instrument.PIANO, Note.sharp((int)1, (Note.Tone)Note.Tone.C));
                if (enableBar) {
                    CombatHandle.this.busyBar.setProgress((double)CombatHandle.this.combatTimeLeft / (double)CombatHandle.this.combatTimeOut);
                    CombatHandle.this.busyBar.setTitle(CombatHandle.this.formatCombatChatMessage("busy-message"));
                }
                CombatHandle.this.combatTimeLeft--;
            }
        }, 0L, 20L);
        this.inCombat = true;
    }

    void endCombat() {
        if (enableBar) {
            this.busyBar.setVisible(false);
            this.freeBar.setVisible(true);
            this.freeBar.setProgress(1.0);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    CombatHandle.this.freeBar.setVisible(false);
                }
            }, (long)(this.vanishTimeOut * 20));
        }
        this.plugin.getServer().getScheduler().cancelTask(this.combatTickTask);
        this.combatTickTask = -1;
        this.player.playNote(this.player.getLocation(), Instrument.PIANO, Note.natural((int)1, (Note.Tone)Note.Tone.G));
        if (!this.freeChat.isEmpty()) {
            this.player.sendMessage(this.freeChat);
        }
        this.inCombat = false;
    }

    void cleanUp() {
        if (enableBar) {
            this.busyBar.removeAll();
            this.freeBar.removeAll();
        }
    }
}

