/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.server.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nanohttpd.protocols.http.IHTTPSession;
import org.nanohttpd.protocols.http.response.IStatus;
import org.nanohttpd.protocols.http.response.Response;
import org.nanohttpd.protocols.http.response.Status;
import org.nanohttpd.router.RouterNanoHTTPD;
import org.readium.r2.shared.MediaOverlays;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.util.mediatype.MediaType;
import org.readium.r2.streamer.server.ServingFetcher;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J \u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\tH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/readium/r2/streamer/server/handler/MediaOverlayHandler;", "Lorg/nanohttpd/router/RouterNanoHTTPD$DefaultHandler;", "()V", "get", "Lorg/nanohttpd/protocols/http/response/Response;", "uriResource", "Lorg/nanohttpd/router/RouterNanoHTTPD$UriResource;", "urlParams", "", "", "session", "Lorg/nanohttpd/protocols/http/IHTTPSession;", "getMediaOverlay", "Lorg/readium/r2/shared/MediaOverlays;", "spines", "", "Lorg/readium/r2/shared/publication/Link;", "searchQueryPath", "getMimeType", "getStatus", "Lorg/nanohttpd/protocols/http/response/IStatus;", "getText", "r2-streamer_release"})
public final class MediaOverlayHandler
extends RouterNanoHTTPD.DefaultHandler {
    @NotNull
    public String getText() {
        return "{\"success\":false}";
    }

    @NotNull
    public String getMimeType() {
        return MediaType.Companion.getREADIUM_WEBPUB_MANIFEST().toString();
    }

    @NotNull
    public IStatus getStatus() {
        return (IStatus)Status.OK;
    }

    @NotNull
    public Response get(@Nullable RouterNanoHTTPD.UriResource uriResource, @Nullable Map<String, String> urlParams, @Nullable IHTTPSession session) {
        RouterNanoHTTPD.UriResource uriResource2 = uriResource;
        Intrinsics.checkNotNull((Object)uriResource2);
        ServingFetcher fetcher = (ServingFetcher)uriResource2.initParameter(ServingFetcher.class);
        IHTTPSession iHTTPSession = session;
        Intrinsics.checkNotNull((Object)iHTTPSession);
        if (iHTTPSession.getParameters().containsKey("resource")) {
            Response response;
            Object v = session.getParameters().get("resource");
            Intrinsics.checkNotNull(v);
            String searchQueryPath = (String)((List)v).get(0);
            List spines = fetcher.getPublication().getResources();
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                Intrinsics.checkNotNullExpressionValue((Object)searchQueryPath, (String)"searchQueryPath");
                String json = objectMapper.writeValueAsString((Object)this.getMediaOverlay(spines, searchQueryPath));
                response = Response.newFixedLengthResponse((IStatus)this.getStatus(), (String)this.getMimeType(), (String)json);
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"{\n                val js\u2026Type, json)\n            }");
            }
            catch (JsonProcessingException e) {
                Response response2 = Response.newFixedLengthResponse((IStatus)this.getStatus(), (String)this.getMimeType(), (String)"{\"success\":false}");
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"{\n                newFix\u2026E_RESPONSE)\n            }");
                response = response2;
            }
            return response;
        }
        Response response = Response.newFixedLengthResponse((IStatus)this.getStatus(), (String)this.getMimeType(), (String)"{\"success\":false}");
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"{\n            newFixedLe\u2026ILURE_RESPONSE)\n        }");
        return response;
    }

    private final MediaOverlays getMediaOverlay(List<Link> spines, String searchQueryPath) {
        return null;
    }
}

