/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.server;

import android.net.Uri;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.extensions.FileKt;
import org.readium.r2.shared.util.mediatype.MediaType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0013\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0003H\u0086\u0002J\u0019\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/readium/r2/streamer/server/Files;", "", "basePath", "", "fallbackMediaType", "Lorg/readium/r2/shared/util/mediatype/MediaType;", "(Ljava/lang/String;Lorg/readium/r2/shared/util/mediatype/MediaType;)V", "files", "", "Ljava/io/File;", "find", "Lorg/readium/r2/streamer/server/Files$ServedFile;", "uri", "Landroid/net/Uri;", "get", "key", "set", "", "href", "file", "ServedFile", "r2-streamer_release"})
public final class Files {
    @NotNull
    private final String basePath;
    @NotNull
    private final MediaType fallbackMediaType;
    @NotNull
    private final Map<String, File> files;

    public Files(@NotNull String basePath, @NotNull MediaType fallbackMediaType) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)fallbackMediaType, (String)"fallbackMediaType");
        this.basePath = basePath;
        this.fallbackMediaType = fallbackMediaType;
        boolean bl = false;
        this.files = new LinkedHashMap();
    }

    public /* synthetic */ Files(String string, MediaType mediaType2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mediaType2 = MediaType.Companion.getBINARY();
        }
        this(string, mediaType2);
    }

    public final void set(@NotNull String href, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)href, (String)"href");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map<String, File> map = this.files;
        File file2 = file.getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.canonicalFile");
        boolean bl = false;
        map.put(href, file2);
    }

    @Nullable
    public final File get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.files.get(key);
    }

    @Nullable
    public final ServedFile find(@NotNull Uri uri) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Object object2 = uri.getPath();
        Object object3 = object = object2 == null ? null : StringsKt.removePrefix((String)object2, (CharSequence)this.basePath);
        if (object == null) {
            return null;
        }
        String path = object;
        object2 = this.files;
        boolean bl = false;
        object = object2.entrySet().iterator();
        while (object.hasNext()) {
            Object object4 = object2 = (Map.Entry)object.next();
            boolean bl2 = false;
            String href = (String)object4.getKey();
            Object object5 = object2;
            boolean bl3 = false;
            File file = (File)object5.getValue();
            if (!StringsKt.startsWith$default((String)path, (String)href, (boolean)false, (int)2, null)) continue;
            File requestedFile = new File(file, StringsKt.removePrefix((String)path, (CharSequence)href)).getCanonicalFile();
            Intrinsics.checkNotNullExpressionValue((Object)requestedFile, (String)"requestedFile");
            if (!FileKt.isParentOf((File)file, (File)requestedFile)) continue;
            return new ServedFile(requestedFile, this.fallbackMediaType);
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/readium/r2/streamer/server/Files$ServedFile;", "", "file", "Ljava/io/File;", "fallbackMediaType", "Lorg/readium/r2/shared/util/mediatype/MediaType;", "(Ljava/io/File;Lorg/readium/r2/shared/util/mediatype/MediaType;)V", "getFile", "()Ljava/io/File;", "mediaType", "getMediaType", "()Lorg/readium/r2/shared/util/mediatype/MediaType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "r2-streamer_release"})
    public static final class ServedFile {
        @NotNull
        private final File file;
        @NotNull
        private final MediaType fallbackMediaType;

        public ServedFile(@NotNull File file, @NotNull MediaType fallbackMediaType) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)fallbackMediaType, (String)"fallbackMediaType");
            this.file = file;
            this.fallbackMediaType = fallbackMediaType;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final MediaType getMediaType() {
            return (MediaType)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MediaType>, Object>(this, null){
                int label;
                final /* synthetic */ ServedFile this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            MediaType mediaType2;
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = MediaType.Companion.ofFile$default((MediaType.Companion)MediaType.Companion, (File)this.this$0.getFile(), null, null, null, (Continuation)((Continuation)this), (int)14, null);
                            if (object3 != object2) return mediaType2 == null ? ServedFile.access$getFallbackMediaType$p(this.this$0) : mediaType2;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            MediaType mediaType2 = (MediaType)object3;
                            return mediaType2 == null ? ServedFile.access$getFallbackMediaType$p(this.this$0) : mediaType2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super MediaType> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        private final MediaType component2() {
            return this.fallbackMediaType;
        }

        @NotNull
        public final ServedFile copy(@NotNull File file, @NotNull MediaType fallbackMediaType) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)fallbackMediaType, (String)"fallbackMediaType");
            return new ServedFile(file, fallbackMediaType);
        }

        public static /* synthetic */ ServedFile copy$default(ServedFile servedFile, File file, MediaType mediaType2, int n, Object object) {
            if ((n & 1) != 0) {
                file = servedFile.file;
            }
            if ((n & 2) != 0) {
                mediaType2 = servedFile.fallbackMediaType;
            }
            return servedFile.copy(file, mediaType2);
        }

        @NotNull
        public String toString() {
            return "ServedFile(file=" + this.file + ", fallbackMediaType=" + this.fallbackMediaType + ')';
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + this.fallbackMediaType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServedFile)) {
                return false;
            }
            ServedFile servedFile = (ServedFile)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)servedFile.file)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fallbackMediaType, (Object)servedFile.fallbackMediaType);
        }

        public static final /* synthetic */ MediaType access$getFallbackMediaType$p(ServedFile $this) {
            return $this.fallbackMediaType;
        }
    }
}

