/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.parser.xml.ElementNode;
import org.readium.r2.streamer.parser.epub.EpubMetadata;
import org.readium.r2.streamer.parser.epub.Item;
import org.readium.r2.streamer.parser.epub.MetadataParser;
import org.readium.r2.streamer.parser.epub.PropertyDataTypeKt;
import org.readium.r2.streamer.parser.epub.Spine;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 '2\u00020\u0001:\u0001'B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\rH\u00c6\u0003JM\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016\u00a8\u0006("}, d2={"Lorg/readium/r2/streamer/parser/epub/PackageDocument;", "", "path", "", "epubVersion", "", "uniqueIdentifierId", "metadata", "Lorg/readium/r2/streamer/parser/epub/EpubMetadata;", "manifest", "", "Lorg/readium/r2/streamer/parser/epub/Item;", "spine", "Lorg/readium/r2/streamer/parser/epub/Spine;", "(Ljava/lang/String;DLjava/lang/String;Lorg/readium/r2/streamer/parser/epub/EpubMetadata;Ljava/util/List;Lorg/readium/r2/streamer/parser/epub/Spine;)V", "getEpubVersion", "()D", "getManifest", "()Ljava/util/List;", "getMetadata", "()Lorg/readium/r2/streamer/parser/epub/EpubMetadata;", "getPath", "()Ljava/lang/String;", "getSpine", "()Lorg/readium/r2/streamer/parser/epub/Spine;", "getUniqueIdentifierId", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "r2-streamer_release"})
public final class PackageDocument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    private final double epubVersion;
    @Nullable
    private final String uniqueIdentifierId;
    @NotNull
    private final EpubMetadata metadata;
    @NotNull
    private final List<Item> manifest;
    @NotNull
    private final Spine spine;

    public PackageDocument(@NotNull String path, double epubVersion, @Nullable String uniqueIdentifierId, @NotNull EpubMetadata metadata2, @NotNull List<Item> manifest, @NotNull Spine spine) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter(manifest, (String)"manifest");
        Intrinsics.checkNotNullParameter((Object)spine, (String)"spine");
        this.path = path;
        this.epubVersion = epubVersion;
        this.uniqueIdentifierId = uniqueIdentifierId;
        this.metadata = metadata2;
        this.manifest = manifest;
        this.spine = spine;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final double getEpubVersion() {
        return this.epubVersion;
    }

    @Nullable
    public final String getUniqueIdentifierId() {
        return this.uniqueIdentifierId;
    }

    @NotNull
    public final EpubMetadata getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final List<Item> getManifest() {
        return this.manifest;
    }

    @NotNull
    public final Spine getSpine() {
        return this.spine;
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    public final double component2() {
        return this.epubVersion;
    }

    @Nullable
    public final String component3() {
        return this.uniqueIdentifierId;
    }

    @NotNull
    public final EpubMetadata component4() {
        return this.metadata;
    }

    @NotNull
    public final List<Item> component5() {
        return this.manifest;
    }

    @NotNull
    public final Spine component6() {
        return this.spine;
    }

    @NotNull
    public final PackageDocument copy(@NotNull String path, double epubVersion, @Nullable String uniqueIdentifierId, @NotNull EpubMetadata metadata2, @NotNull List<Item> manifest, @NotNull Spine spine) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter(manifest, (String)"manifest");
        Intrinsics.checkNotNullParameter((Object)spine, (String)"spine");
        return new PackageDocument(path, epubVersion, uniqueIdentifierId, metadata2, manifest, spine);
    }

    public static /* synthetic */ PackageDocument copy$default(PackageDocument packageDocument, String string, double d, String string2, EpubMetadata epubMetadata, List list, Spine spine, int n, Object object) {
        if ((n & 1) != 0) {
            string = packageDocument.path;
        }
        if ((n & 2) != 0) {
            d = packageDocument.epubVersion;
        }
        if ((n & 4) != 0) {
            string2 = packageDocument.uniqueIdentifierId;
        }
        if ((n & 8) != 0) {
            epubMetadata = packageDocument.metadata;
        }
        if ((n & 0x10) != 0) {
            list = packageDocument.manifest;
        }
        if ((n & 0x20) != 0) {
            spine = packageDocument.spine;
        }
        return packageDocument.copy(string, d, string2, epubMetadata, list, spine);
    }

    @NotNull
    public String toString() {
        return "PackageDocument(path=" + this.path + ", epubVersion=" + this.epubVersion + ", uniqueIdentifierId=" + this.uniqueIdentifierId + ", metadata=" + this.metadata + ", manifest=" + this.manifest + ", spine=" + this.spine + ')';
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = result * 31 + Double.hashCode(this.epubVersion);
        result = result * 31 + (this.uniqueIdentifierId == null ? 0 : this.uniqueIdentifierId.hashCode());
        result = result * 31 + this.metadata.hashCode();
        result = result * 31 + ((Object)this.manifest).hashCode();
        result = result * 31 + this.spine.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PackageDocument)) {
            return false;
        }
        PackageDocument packageDocument = (PackageDocument)other;
        if (!Intrinsics.areEqual((Object)this.path, (Object)packageDocument.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.epubVersion, (Object)packageDocument.epubVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.uniqueIdentifierId, (Object)packageDocument.uniqueIdentifierId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metadata, (Object)packageDocument.metadata)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.manifest, packageDocument.manifest)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.spine, (Object)packageDocument.spine);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/readium/r2/streamer/parser/epub/PackageDocument$Companion;", "", "()V", "parse", "Lorg/readium/r2/streamer/parser/epub/PackageDocument;", "document", "Lorg/readium/r2/shared/parser/xml/ElementNode;", "filePath", "", "r2-streamer_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PackageDocument parse(@NotNull ElementNode document, @NotNull String filePath) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object it;
            Map<String, String> map;
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            String string = document.getAttr("prefix");
            if (string == null) {
                map = null;
            } else {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                it = string2;
                boolean bl3 = false;
                map = PropertyDataTypeKt.parsePrefixes((String)it);
            }
            string = map;
            boolean bl = false;
            Object object = string;
            if (object == null) {
                object = MapsKt.emptyMap();
            }
            String packagePrefixes = object;
            Map prefixMap = MapsKt.plus(PropertyDataTypeKt.getPACKAGE_RESERVED_PREFIXES(), (Map)((Object)packagePrefixes));
            String string3 = document.getAttr("version");
            double epubVersion = string3 == null ? 1.2 : ((it = StringsKt.toDoubleOrNull((String)string3)) == null ? 1.2 : (Double)it);
            it = new MetadataParser(epubVersion, prefixMap).parse(document, filePath);
            if (it == null) {
                return null;
            }
            Object metadata2 = it;
            ElementNode bl3 = document.getFirst("manifest", "http://www.idpf.org/2007/opf");
            if (bl3 == null) {
                return null;
            }
            ElementNode manifestElement = bl3;
            Object object2 = document.getFirst("spine", "http://www.idpf.org/2007/opf");
            if (object2 == null) {
                return null;
            }
            ElementNode spineElement = object2;
            object2 = manifestElement.get("item", "http://www.idpf.org/2007/opf");
            Object object3 = metadata2;
            String string4 = document.getAttr("unique-identifier");
            double d = epubVersion;
            String string5 = filePath;
            boolean $i$f$mapNotNull = false;
            void var12_20 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Item item;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                ElementNode it2 = (ElementNode)element$iv$iv;
                boolean bl5 = false;
                if (Item.Companion.parse(it2, filePath, prefixMap) == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                Item it$iv$iv = item;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            Spine spine = Spine.Companion.parse(spineElement, prefixMap, epubVersion);
            List list2 = list;
            Object object4 = object3;
            String string6 = string4;
            double d2 = d;
            String string7 = string5;
            return new PackageDocument(string7, d2, string6, (EpubMetadata)object4, list2, spine);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

