/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.parser.xml.ElementNode;
import org.readium.r2.shared.util.Href;
import org.readium.r2.streamer.parser.epub.DEFAULT_VOCAB;
import org.readium.r2.streamer.parser.epub.EpubLink;
import org.readium.r2.streamer.parser.epub.EpubMetadata;
import org.readium.r2.streamer.parser.epub.MetadataItem;
import org.readium.r2.streamer.parser.epub.PropertyDataTypeKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f0\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J \u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0006J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\f0\u001b2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/readium/r2/streamer/parser/epub/MetadataParser;", "", "epubVersion", "", "prefixMap", "", "", "(DLjava/util/Map;)V", "computeMetaItem", "Lorg/readium/r2/streamer/parser/epub/MetadataItem;", "expr", "metas", "", "chain", "", "contributorWithLegacyAttr", "element", "Lorg/readium/r2/shared/parser/xml/ElementNode;", "name", "value", "dateWithLegacyAttr", "parse", "Lorg/readium/r2/streamer/parser/epub/EpubMetadata;", "document", "filePath", "parseDcElement", "parseElements", "Lkotlin/Pair;", "Lorg/readium/r2/streamer/parser/epub/EpubLink;", "metadataElement", "parseLinkElement", "parseMetaElement", "resolveMetaHierarchy", "items", "r2-streamer_release"})
public final class MetadataParser {
    private final double epubVersion;
    @NotNull
    private final Map<String, String> prefixMap;

    public MetadataParser(double epubVersion, @NotNull Map<String, String> prefixMap) {
        Intrinsics.checkNotNullParameter(prefixMap, (String)"prefixMap");
        this.epubVersion = epubVersion;
        this.prefixMap = prefixMap;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final EpubMetadata parse(@NotNull ElementNode document, @NotNull String filePath) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupByTo$iv$iv2;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Pair<List<MetadataItem>, List<EpubLink>> pair = document.getFirst("metadata", "http://www.idpf.org/2007/opf");
        if (pair == null) {
            return null;
        }
        Pair<List<MetadataItem>, List<EpubLink>> metadata2 = pair;
        pair = this.parseElements((ElementNode)metadata2, filePath);
        List metas = (List)pair.component1();
        List links = (List)pair.component2();
        Iterable $this$partition$iv = this.resolveMetaHierarchy(metas);
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv2 : $this$partition$iv) {
            MetadataItem it = (MetadataItem)element$iv2;
            boolean bl = false;
            if (it.getRefines() == null) {
                first$iv.add(element$iv2);
                continue;
            }
            second$iv.add(element$iv2);
        }
        Pair pair2 = new Pair(first$iv, second$iv);
        List globalMetas = (List)pair2.component1();
        List refineMetas = (List)pair2.component2();
        Iterable $this$groupBy$iv = globalMetas;
        boolean $i$f$groupBy = false;
        element$iv2 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object;
            MetadataItem p0 = (MetadataItem)element$iv$iv;
            boolean bl = false;
            String key$iv$iv2 = p0.getProperty();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv2 = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv2);
                object = answer$iv$iv$iv2;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map globalCollection = destination$iv$iv;
        Object $this$groupBy$iv2 = refineMetas;
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            MetadataItem p0 = (MetadataItem)element$iv$iv;
            boolean bl = false;
            key$iv$iv = p0.getRefines();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv2 = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$groupByTo$iv$iv3;
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map2 = map;
            boolean bl4 = false;
            Iterable $this$groupBy$iv3 = (Iterable)it.getValue();
            boolean $i$f$groupBy3 = false;
            Iterable iterable = $this$groupBy$iv3;
            Map destination$iv$iv3 = new LinkedHashMap();
            boolean $i$f$groupByTo3 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv3) {
                Object object;
                MetadataItem p0 = (MetadataItem)element$iv$iv;
                boolean bl5 = false;
                String key$iv$iv3 = p0.getProperty();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv3);
                if (value$iv$iv$iv == null) {
                    boolean bl6 = false;
                    List answer$iv$iv$iv3 = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv3, answer$iv$iv$iv3);
                    object = answer$iv$iv$iv3;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map map3 = destination$iv$iv3;
            map2.put(k2, map3);
        }
        Map refineCollections = destination$iv$iv2;
        return new EpubMetadata(globalCollection, refineCollections, links);
    }

    private final Pair<List<MetadataItem>, List<EpubLink>> parseElements(ElementNode metadataElement, String filePath) {
        boolean bl = false;
        List metas = new ArrayList();
        boolean bl2 = false;
        List links = new ArrayList();
        for (ElementNode e : metadataElement.getAll()) {
            Object it;
            boolean bl3;
            boolean bl4;
            Object object;
            Object object2;
            if (Intrinsics.areEqual((Object)e.getNamespace(), (Object)"http://purl.org/dc/elements/1.1/")) {
                object2 = this.parseDcElement(e);
                if (object2 == null) continue;
                object = object2;
                bl4 = false;
                bl3 = false;
                it = object;
                boolean bl5 = false;
                metas.add(it);
                continue;
            }
            if (Intrinsics.areEqual((Object)e.getNamespace(), (Object)"http://www.idpf.org/2007/opf") && Intrinsics.areEqual((Object)e.getName(), (Object)"meta")) {
                object2 = this.parseMetaElement(e);
                if (object2 == null) continue;
                object = object2;
                bl4 = false;
                bl3 = false;
                it = object;
                boolean bl6 = false;
                metas.add(it);
                continue;
            }
            if (!Intrinsics.areEqual((Object)e.getNamespace(), (Object)"http://www.idpf.org/2007/opf") || !Intrinsics.areEqual((Object)e.getName(), (Object)"link") || (object2 = this.parseLinkElement(e, filePath)) == null) continue;
            object = object2;
            bl4 = false;
            bl3 = false;
            it = object;
            boolean bl7 = false;
            links.add(it);
        }
        return new Pair((Object)metas, (Object)links);
    }

    /*
     * WARNING - void declaration
     */
    private final EpubLink parseLinkElement(ElementNode element, String filePath) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv22;
        String string = element.getAttr("href");
        if (string == null) {
            return null;
        }
        String href = string;
        String string2 = element.getAttr("rel");
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String relAttr = string3;
        Iterable $this$mapNotNull$iv = PropertyDataTypeKt.parseProperties(relAttr);
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string4;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (PropertyDataTypeKt.resolveProperty(it, this.prefixMap, DEFAULT_VOCAB.LINK) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            String it$iv$iv = string4;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List rel = (List)destination$iv$iv;
        String $i$f$mapNotNull22 = element.getAttr("properties");
        boolean $this$mapNotNullTo$iv$iv22 = false;
        String string5 = $i$f$mapNotNull22;
        if (string5 == null) {
            string5 = "";
        }
        String propAttr = string5;
        Iterable $this$mapNotNull$iv2 = PropertyDataTypeKt.parseProperties(propAttr);
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$mapNotNullTo22 = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            String string6;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl7 = false;
            String it = (String)element$iv$iv;
            boolean bl8 = false;
            if (PropertyDataTypeKt.resolveProperty(it, this.prefixMap, DEFAULT_VOCAB.LINK) == null) continue;
            boolean bl9 = false;
            boolean bl10 = false;
            String it$iv$iv = string6;
            boolean bl11 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List properties = (List)destination$iv$iv2;
        String mediaType2 = element.getAttr("media-type");
        String string7 = element.getAttr("refines");
        String refines = string7 == null ? null : StringsKt.removePrefix((String)string7, (CharSequence)"#");
        return new EpubLink(new Href(href, filePath).getString(), CollectionsKt.toSet((Iterable)rel), mediaType2, refines, properties);
    }

    private final MetadataItem parseMetaElement(ElementNode element) {
        MetadataItem metadataItem;
        if (element.getAttr("property") == null) {
            String string;
            String string2;
            boolean bl;
            String string3;
            CharSequence charSequence;
            String string4;
            String string5 = element.getAttr("name");
            if (string5 == null) {
                string4 = null;
            } else {
                charSequence = string5;
                boolean bl2 = false;
                string3 = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                if (string3 == null) {
                    string4 = null;
                } else {
                    CharSequence charSequence2;
                    charSequence = string3;
                    bl2 = false;
                    CharSequence charSequence3 = charSequence;
                    boolean bl3 = false;
                    if (charSequence3.length() == 0) {
                        bl = false;
                        charSequence2 = null;
                    } else {
                        charSequence2 = charSequence;
                    }
                    string4 = string2 = (String)charSequence2;
                }
            }
            if (string2 == null) {
                return null;
            }
            String name = string2;
            string3 = element.getAttr("content");
            if (string3 == null) {
                string = null;
            } else {
                CharSequence charSequence4 = string3;
                boolean bl4 = false;
                charSequence = ((Object)StringsKt.trim((CharSequence)charSequence4)).toString();
                if (charSequence == null) {
                    string = null;
                } else {
                    CharSequence charSequence5;
                    charSequence4 = charSequence;
                    bl4 = false;
                    CharSequence charSequence6 = charSequence4;
                    bl = false;
                    if (charSequence6.length() == 0) {
                        boolean bl5 = false;
                        charSequence5 = null;
                    } else {
                        charSequence5 = charSequence4;
                    }
                    string = string5 = (String)charSequence5;
                }
            }
            if (string5 == null) {
                return null;
            }
            String content = string5;
            String resolvedName = PropertyDataTypeKt.resolveProperty$default(name, this.prefixMap, null, 4, null);
            metadataItem = new MetadataItem(resolvedName, content, element.getLang(), null, null, element.getId(), null, 64, null);
        } else {
            String string;
            boolean bl;
            String string6;
            String content;
            String string7;
            CharSequence charSequence;
            String string8;
            String resolvedName = element.getAttr("property");
            if (resolvedName == null) {
                string8 = null;
            } else {
                charSequence = resolvedName;
                boolean bl6 = false;
                string7 = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
                if (string7 == null) {
                    string8 = null;
                } else {
                    CharSequence charSequence7;
                    charSequence = string7;
                    bl6 = false;
                    CharSequence charSequence8 = charSequence;
                    boolean bl7 = false;
                    if (charSequence8.length() == 0) {
                        boolean bl8 = false;
                        charSequence7 = null;
                    } else {
                        charSequence7 = charSequence;
                    }
                    string8 = content = (String)charSequence7;
                }
            }
            if (content == null) {
                return null;
            }
            String propName = content;
            string7 = element.getText();
            if (string7 == null) {
                string6 = null;
            } else {
                CharSequence charSequence9 = string7;
                boolean bl9 = false;
                charSequence = ((Object)StringsKt.trim((CharSequence)charSequence9)).toString();
                if (charSequence == null) {
                    string6 = null;
                } else {
                    CharSequence charSequence10;
                    charSequence9 = charSequence;
                    bl9 = false;
                    CharSequence charSequence11 = charSequence9;
                    bl = false;
                    if (charSequence11.length() == 0) {
                        boolean bl10 = false;
                        charSequence10 = null;
                    } else {
                        charSequence10 = charSequence9;
                    }
                    string6 = resolvedName = (String)charSequence10;
                }
            }
            if (resolvedName == null) {
                return null;
            }
            String propValue = resolvedName;
            String resolvedProp = PropertyDataTypeKt.resolveProperty(propName, this.prefixMap, DEFAULT_VOCAB.META);
            charSequence = element.getAttr("scheme");
            if (charSequence == null) {
                string = null;
            } else {
                CharSequence charSequence12 = charSequence;
                boolean bl11 = false;
                String string9 = ((Object)StringsKt.trim((CharSequence)charSequence12)).toString();
                if (string9 == null) {
                    string = null;
                } else {
                    CharSequence charSequence13;
                    CharSequence charSequence14 = string9;
                    bl = false;
                    CharSequence charSequence15 = charSequence14;
                    boolean bl12 = false;
                    if (charSequence15.length() == 0) {
                        boolean bl13 = false;
                        charSequence13 = null;
                    } else {
                        charSequence13 = charSequence14;
                    }
                    charSequence12 = (String)charSequence13;
                    if (charSequence12 == null) {
                        string = null;
                    } else {
                        charSequence14 = charSequence12;
                        bl = false;
                        boolean bl14 = false;
                        CharSequence it = charSequence14;
                        boolean bl15 = false;
                        string = PropertyDataTypeKt.resolveProperty$default((String)it, this.prefixMap, null, 4, null);
                    }
                }
            }
            String resolvedScheme = string;
            String string10 = element.getAttr("refines");
            String refines = string10 == null ? null : StringsKt.removePrefix((String)string10, (CharSequence)"#");
            metadataItem = new MetadataItem(resolvedProp, propValue, element.getLang(), resolvedScheme, refines, element.getId(), null, 64, null);
        }
        return metadataItem;
    }

    private final MetadataItem parseDcElement(ElementNode element) {
        MetadataItem metadataItem;
        String string;
        String string2;
        String string3 = element.getText();
        if (string3 == null) {
            string2 = null;
        } else {
            CharSequence charSequence = string3;
            boolean bl = false;
            String string4 = ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
            if (string4 == null) {
                string2 = null;
            } else {
                CharSequence charSequence2;
                charSequence = string4;
                bl = false;
                CharSequence charSequence3 = charSequence;
                boolean bl2 = false;
                if (charSequence3.length() == 0) {
                    boolean bl3 = false;
                    charSequence2 = null;
                } else {
                    charSequence2 = charSequence;
                }
                string2 = string = (String)charSequence2;
            }
        }
        if (string == null) {
            return null;
        }
        String propValue = string;
        String propName = Intrinsics.stringPlus((String)"http://purl.org/dc/terms/", (Object)element.getName());
        switch (element.getName()) {
            case "creator": 
            case "contributor": 
            case "publisher": {
                metadataItem = this.contributorWithLegacyAttr(element, propName, propValue);
                break;
            }
            case "date": {
                metadataItem = this.dateWithLegacyAttr(element, propName, propValue);
                break;
            }
            default: {
                metadataItem = new MetadataItem(propName, propValue, element.getLang(), null, null, element.getId(), null, 88, null);
            }
        }
        return metadataItem;
    }

    /*
     * WARNING - void declaration
     */
    private final MetadataItem contributorWithLegacyAttr(ElementNode element, String name, String value) {
        void $this$groupByTo$iv$iv;
        MetadataItem metadataItem;
        Object it2;
        boolean bl;
        String string;
        MetadataItem metadataItem2;
        String string2 = element.getAttrNs("file-as", "http://www.idpf.org/2007/opf");
        if (string2 == null) {
            metadataItem2 = null;
        } else {
            string = string2;
            boolean bl2 = false;
            bl = false;
            it2 = string;
            boolean bl3 = false;
            metadataItem2 = new MetadataItem("http://idpf.org/epub/vocab/package/meta/#file-as", (String)it2, element.getLang(), null, null, element.getId(), null, 88, null);
        }
        MetadataItem fileAs = metadataItem2;
        string = element.getAttrNs("role", "http://www.idpf.org/2007/opf");
        if (string == null) {
            metadataItem = null;
        } else {
            String string3 = string;
            bl = false;
            boolean it2 = false;
            String it3 = string3;
            boolean bl4 = false;
            metadataItem = new MetadataItem("http://idpf.org/epub/vocab/package/meta/#role", it3, element.getLang(), null, null, element.getId(), null, 88, null);
        }
        MetadataItem role = metadataItem;
        Object[] objectArray = new MetadataItem[]{fileAs, role};
        Iterable $this$groupBy$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
        boolean $i$f$groupBy = false;
        it2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            MetadataItem p0 = (MetadataItem)element$iv$iv;
            boolean bl5 = false;
            String key$iv$iv = p0.getProperty();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map children = destination$iv$iv;
        return new MetadataItem(name, value, element.getLang(), null, null, element.getId(), children, 24, null);
    }

    private final MetadataItem dateWithLegacyAttr(ElementNode element, String name, String value) {
        String eventAttr = element.getAttrNs("event", "http://www.idpf.org/2007/opf");
        String propName = Intrinsics.areEqual((Object)eventAttr, (Object)"modification") ? "http://purl.org/dc/terms/modified" : name;
        return new MetadataItem(propName, value, element.getLang(), null, null, element.getId(), null, 88, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MetadataItem> resolveMetaHierarchy(List<MetadataItem> items) {
        void $this$mapTo$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = items;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<String> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MetadataItem it = (MetadataItem)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List metadataIds = (List)destination$iv$iv;
        Iterable $this$filter$iv = items;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MetadataItem it = (MetadataItem)element$iv$iv;
            boolean bl = false;
            if (!(it.getRefines() == null || !metadataIds.contains(it.getRefines()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List rootExpr = (List)destination$iv$iv2;
        Iterable $this$groupBy$iv = items;
        boolean $i$f$groupBy = false;
        destination$iv$iv2 = $this$groupBy$iv;
        Object destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            MetadataItem p0 = (MetadataItem)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = p0.getRefines();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map exprByRefines = destination$iv$iv3;
        Iterable $this$map$iv = rootExpr;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MetadataItem list$iv$iv = (MetadataItem)item$iv$iv;
            Object object = destination$iv$iv3;
            boolean bl = false;
            MetadataItem metadataItem = this.computeMetaItem((MetadataItem)it, exprByRefines, SetsKt.emptySet());
            object.add(metadataItem);
        }
        return (List)destination$iv$iv3;
    }

    /*
     * WARNING - void declaration
     */
    private final MetadataItem computeMetaItem(MetadataItem expr, Map<String, ? extends List<MetadataItem>> metas, Set<String> chain) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        MetadataItem metadataItem;
        Object object;
        void $this$mapTo$iv$iv;
        MetadataItem element$iv$iv;
        List list;
        Set updatedChain = expr.getId() == null ? chain : SetsKt.plus(chain, (Object)expr.getId());
        String string = expr.getId();
        if (string == null) {
            list = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            List<MetadataItem> list2 = metas.get(it);
            if (list2 == null) {
                list = null;
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    MetadataItem it2 = element$iv$iv = iterator.next();
                    boolean bl4 = false;
                    if (!(!CollectionsKt.contains((Iterable)chain, (Object)it2.getId()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
        }
        string = list;
        boolean bl = false;
        Object object2 = string;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        String refinedBy = object2;
        Iterable $this$map$iv = (Iterable)((Object)refinedBy);
        boolean $i$f$map = false;
        Iterable $i$f$filter = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv = (MetadataItem)item$iv$iv;
            object = destination$iv$iv;
            boolean bl5 = false;
            metadataItem = this.computeMetaItem((MetadataItem)it, metas, updatedChain);
            object.add(metadataItem);
        }
        List newChildren = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.plus((Collection)CollectionsKt.flatten((Iterable)expr.getChildren().values()), (Iterable)newChildren);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        metadataItem = null;
        object = expr;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object3;
            MetadataItem p0 = (MetadataItem)element$iv$iv2;
            boolean bl6 = false;
            String key$iv$iv = p0.getProperty();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl7 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv2);
        }
        Object object4 = destination$iv$iv;
        return MetadataItem.copy$default((MetadataItem)object, (String)((Object)metadataItem), string7, string6, string5, string4, string3, (Map)object4, 63, null);
    }
}

