/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.publication.ReadingProgression;
import org.readium.r2.streamer.parser.epub.ReadiumCssLayout$Companion$WhenMappings;
import org.readium.r2.streamer.parser.epub.ReadiumCssLayout$WhenMappings;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0080\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lorg/readium/r2/streamer/parser/epub/ReadiumCssLayout;", "", "cssId", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCssId", "()Ljava/lang/String;", "readiumCSSPath", "getReadiumCSSPath", "RTL", "LTR", "CJK_VERTICAL", "CJK_HORIZONTAL", "Companion", "r2-streamer_release"})
public final class ReadiumCssLayout
extends Enum<ReadiumCssLayout> {
    public static final /* enum */ ReadiumCssLayout RTL;
    public static final /* enum */ ReadiumCssLayout LTR;
    public static final /* enum */ ReadiumCssLayout CJK_VERTICAL;
    public static final /* enum */ ReadiumCssLayout CJK_HORIZONTAL;
    private static final /* synthetic */ ReadiumCssLayout[] $VALUES;
    @NotNull
    private final String cssId;
    public static final Companion Companion;

    static {
        ReadiumCssLayout[] readiumCssLayoutArray = new ReadiumCssLayout[4];
        ReadiumCssLayout[] readiumCssLayoutArray2 = readiumCssLayoutArray;
        readiumCssLayoutArray[0] = RTL = new ReadiumCssLayout("rtl");
        readiumCssLayoutArray[1] = LTR = new ReadiumCssLayout("ltr");
        readiumCssLayoutArray[2] = CJK_VERTICAL = new ReadiumCssLayout("cjk-vertical");
        readiumCssLayoutArray[3] = CJK_HORIZONTAL = new ReadiumCssLayout("cjk-horizontal");
        $VALUES = readiumCssLayoutArray;
        Companion = new Companion(null);
    }

    @NotNull
    public final String getReadiumCSSPath() {
        String string;
        switch (ReadiumCssLayout$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                string = "";
                break;
            }
            case 2: {
                string = "rtl/";
                break;
            }
            case 3: {
                string = "cjk-vertical/";
                break;
            }
            case 4: {
                string = "cjk-horizontal/";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final String getCssId() {
        return this.cssId;
    }

    private ReadiumCssLayout(String cssId) {
        this.cssId = cssId;
    }

    public static ReadiumCssLayout[] values() {
        return (ReadiumCssLayout[])$VALUES.clone();
    }

    public static ReadiumCssLayout valueOf(String string) {
        return Enum.valueOf(ReadiumCssLayout.class, string);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002\u00a8\u0006\f"}, d2={"Lorg/readium/r2/streamer/parser/epub/ReadiumCssLayout$Companion;", "", "()V", "invoke", "Lorg/readium/r2/streamer/parser/epub/ReadiumCssLayout;", "languages", "", "", "readingProgression", "Lorg/readium/r2/shared/publication/ReadingProgression;", "metadata", "Lorg/readium/r2/shared/publication/Metadata;", "r2-streamer_release"})
    public static final class Companion {
        @NotNull
        public final ReadiumCssLayout invoke(@NotNull org.readium.r2.shared.publication.Metadata metadata2) {
            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
            return this.invoke(metadata2.getLanguages(), metadata2.getEffectiveReadingProgression());
        }

        @NotNull
        public final ReadiumCssLayout invoke(@NotNull List<String> languages, @NotNull ReadingProgression readingProgression) {
            ReadiumCssLayout readiumCssLayout;
            boolean bl;
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            Intrinsics.checkNotNullParameter((Object)readingProgression, (String)"readingProgression");
            if (languages.size() == 1) {
                String language = (String)StringsKt.split$default((CharSequence)languages.get(0), (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null).get(0);
                bl = CollectionsKt.listOf((Object[])new String[]{"zh", "ja", "ko"}).contains(language);
            } else {
                bl = false;
            }
            boolean isCjk = bl;
            switch (ReadiumCssLayout$Companion$WhenMappings.$EnumSwitchMapping$0[readingProgression.ordinal()]) {
                case 1: 
                case 2: {
                    if (isCjk) {
                        readiumCssLayout = CJK_VERTICAL;
                        break;
                    }
                    readiumCssLayout = RTL;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (isCjk) {
                        readiumCssLayout = CJK_HORIZONTAL;
                        break;
                    }
                    readiumCssLayout = LTR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return readiumCssLayout;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

