/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.server;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Scanner;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nanohttpd.router.RouterNanoHTTPD;
import org.readium.r2.shared.Injectable;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.server.Assets;
import org.readium.r2.streamer.server.Files;
import org.readium.r2.streamer.server.Resources;
import org.readium.r2.streamer.server.ServingFetcher;
import org.readium.r2.streamer.server.handler.AssetHandler;
import org.readium.r2.streamer.server.handler.FileHandler;
import org.readium.r2.streamer.server.handler.ManifestHandler;
import org.readium.r2.streamer.server.handler.MediaOverlayHandler;
import org.readium.r2.streamer.server.handler.PublicationResourceHandler;
import org.readium.r2.streamer.server.handler.ResourceHandler;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\bJ*\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\bJ \u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J.\u0010%\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\b\b\u0002\u0010'\u001a\u00020\u00132\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u001e\u0010*\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\bJ\u001e\u0010+\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010(\u001a\u00020)J\u0018\u0010,\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020-H\u0007J\u0010\u0010/\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020-H\u0007J5\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\b2\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020605\"\u000206H\u0002\u00a2\u0006\u0002\u00107J\u0014\u00108\u001a\u00020\u001a*\u00020$2\u0006\u00109\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/readium/r2/streamer/server/AbstractServer;", "Lorg/nanohttpd/router/RouterNanoHTTPD;", "port", "", "context", "Landroid/content/Context;", "(ILandroid/content/Context;)V", "ASSETS_HANDLE", "", "CSS_HANDLE", "FONT_HANDLE", "JSON_MANIFEST_HANDLE", "JS_HANDLE", "MANIFEST_HANDLE", "MANIFEST_ITEM_HANDLE", "MEDIA_OVERLAY_HANDLE", "assets", "Lorg/readium/r2/streamer/server/Assets;", "containsMediaOverlay", "", "customResources", "Lorg/readium/r2/streamer/server/Resources;", "fonts", "Lorg/readium/r2/streamer/server/Files;", "resources", "addEpub", "", "publication", "Lorg/readium/r2/shared/publication/Publication;", "fileName", "userPropertiesPath", "container", "Lorg/readium/r2/streamer/container/Container;", "addFont", "name", "inputStream", "Ljava/io/InputStream;", "addResource", "body", "custom", "injectable", "Lorg/readium/r2/shared/Injectable;", "loadCustomFont", "loadCustomResource", "loadR2FontResources", "Landroid/content/res/AssetManager;", "loadR2ScriptResources", "loadReadiumCSSResources", "setRoute", "url", "handler", "Ljava/lang/Class;", "initParameter", "", "", "(Ljava/lang/String;Ljava/lang/Class;[Ljava/lang/Object;)V", "toFile", "path", "r2-streamer_release"})
public abstract class AbstractServer
extends RouterNanoHTTPD {
    private final String MANIFEST_HANDLE = "/manifest";
    private final String JSON_MANIFEST_HANDLE = "/manifest.json";
    private final String MANIFEST_ITEM_HANDLE = "/(.*)";
    private final String MEDIA_OVERLAY_HANDLE = "/media-overlay";
    private final String CSS_HANDLE;
    private final String JS_HANDLE;
    private final String FONT_HANDLE;
    private final String ASSETS_HANDLE = "/assets/(.*)";
    private boolean containsMediaOverlay;
    private final Resources resources;
    private final Resources customResources;
    private final Assets assets;
    private final Files fonts;
    private int port;
    private final Context context;

    private final void addResource(String name, String body, boolean custom, Injectable injectable) {
        if (custom) {
            this.customResources.add(name, body, injectable);
        }
        Resources.add$default(this.resources, name, body, null, 4, null);
    }

    static /* synthetic */ void addResource$default(AbstractServer abstractServer, String string, String string2, boolean bl, Injectable injectable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addResource");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            injectable = null;
        }
        abstractServer.addResource(string, string2, bl, injectable);
    }

    private final void addFont(String name, InputStream inputStream, Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        File file = context.getFilesDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.filesDir");
        File dir = new File(stringBuilder.append(file.getPath()).append("/").append(Injectable.Font.getRawValue()).append("/").toString());
        dir.mkdirs();
        StringBuilder stringBuilder2 = new StringBuilder();
        File file2 = context.getFilesDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"context.filesDir");
        this.toFile(inputStream, stringBuilder2.append(file2.getPath()).append("/").append(Injectable.Font.getRawValue()).append("/").append(name).toString());
        StringBuilder stringBuilder3 = new StringBuilder();
        File file3 = context.getFilesDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"context.filesDir");
        File file4 = new File(stringBuilder3.append(file3.getPath()).append("/").append(Injectable.Font.getRawValue()).append("/").append(name).toString());
        this.fonts.set(name, file4);
    }

    public final void loadCustomResource(@NotNull InputStream inputStream, @NotNull String fileName, @NotNull Injectable injectable) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)injectable, (String)"injectable");
        try {
            String string = new Scanner(inputStream, "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(inputStream, \"ut\u2026seDelimiter(\"\\\\A\").next()");
            this.addResource(fileName, string, true, injectable);
        }
        catch (IOException e) {
        }
    }

    public final void loadCustomFont(@NotNull InputStream inputStream, @NotNull Context context, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        try {
            this.addFont(fileName, inputStream, context);
        }
        catch (IOException e) {
        }
    }

    public final void addEpub(@NotNull Publication publication, @NotNull String fileName, @Nullable String userPropertiesPath) {
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        this.addEpub(publication, null, fileName, userPropertiesPath);
    }

    public final void addEpub(@NotNull Publication publication, @Nullable Container container, @NotNull String fileName, @Nullable String userPropertiesPath) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Object object = container;
        if (object != null && (object = object.getRootFile()) != null && (object = object.getRootFilePath()) != null) {
            CharSequence charSequence = (CharSequence)object;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return;
            }
        }
        URL baseUrl = new URL(Publication.Companion.localBaseUrlOf(fileName, this.port));
        ServingFetcher fetcher = new ServingFetcher(publication, userPropertiesPath, this.customResources);
        try {
            string = URLDecoder.decode(baseUrl.getPath(), "UTF-8");
        }
        catch (Exception e) {
            string = baseUrl.getPath();
        }
        String basePath = string;
        if (this.containsMediaOverlay) {
            this.setRoute(basePath + this.MEDIA_OVERLAY_HANDLE, MediaOverlayHandler.class, fetcher);
        }
        this.setRoute(basePath + this.JSON_MANIFEST_HANDLE, ManifestHandler.class, fetcher);
        this.setRoute(basePath + this.MANIFEST_HANDLE, ManifestHandler.class, fetcher);
        this.setRoute(basePath + this.MANIFEST_ITEM_HANDLE, PublicationResourceHandler.class, fetcher);
        this.setRoute(this.ASSETS_HANDLE, AssetHandler.class, this.assets);
        this.setRoute(this.JS_HANDLE, ResourceHandler.class, this.resources);
        this.setRoute(this.CSS_HANDLE, ResourceHandler.class, this.resources);
        this.setRoute(this.FONT_HANDLE, FileHandler.class, this.fonts);
    }

    private final void setRoute(String url, Class<?> handler, Object ... initParameter) {
        try {
            this.removeRoute(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addRoute(url, handler, Arrays.copyOf(initParameter, initParameter.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void toFile(@NotNull InputStream $this$toFile, String path) {
        Closeable closeable = $this$toFile;
        boolean bl = false;
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl2 = false;
            Object object = new File(path);
            boolean bl3 = false;
            object = new FileOutputStream((File)object);
            bl3 = false;
            Throwable throwable2 = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl4 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Deprecated(message="This is not needed anymore")
    public final void loadReadiumCSSResources(@NotNull AssetManager assets) {
        Intrinsics.checkParameterIsNotNull((Object)assets, (String)"assets");
    }

    @Deprecated(message="This is not needed anymore")
    public final void loadR2ScriptResources(@NotNull AssetManager assets) {
        Intrinsics.checkParameterIsNotNull((Object)assets, (String)"assets");
    }

    @Deprecated(message="This is not needed anymore")
    public final void loadR2FontResources(@NotNull AssetManager assets, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)assets, (String)"assets");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
    }

    public AbstractServer(int port, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super("127.0.0.1", port);
        this.port = port;
        this.context = context;
        this.MANIFEST_HANDLE = "/manifest";
        this.JSON_MANIFEST_HANDLE = "/manifest.json";
        this.MANIFEST_ITEM_HANDLE = "/(.*)";
        this.MEDIA_OVERLAY_HANDLE = "/media-overlay";
        this.CSS_HANDLE = "/" + Injectable.Style.getRawValue() + "/(.*)";
        this.JS_HANDLE = "/" + Injectable.Script.getRawValue() + "/(.*)";
        this.FONT_HANDLE = "/" + Injectable.Font.getRawValue() + "/(.*)";
        this.ASSETS_HANDLE = "/assets/(.*)";
        this.resources = new Resources();
        this.customResources = new Resources();
        AssetManager assetManager = this.context.getAssets();
        Intrinsics.checkExpressionValueIsNotNull((Object)assetManager, (String)"context.assets");
        this.assets = new Assets(assetManager, "/assets/", null, 4, null);
        this.fonts = new Files("" + '/' + Injectable.Style + '/', null, 2, null);
        this.assets.add("readium-css", "readium/readium-css");
        this.assets.add("scripts", "readium/scripts");
        this.assets.add("fonts", "readium/fonts");
    }
}

