/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.pdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.fetcher.Resource;
import org.readium.r2.shared.format.MediaType;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Locator;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.shared.publication.services.PositionsService;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u001d\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010R'\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lorg/readium/r2/streamer/parser/pdf/PdfPositionsService;", "Lorg/readium/r2/shared/publication/services/PositionsService;", "link", "Lorg/readium/r2/shared/publication/Link;", "pageCount", "", "tableOfContents", "", "(Lorg/readium/r2/shared/publication/Link;ILjava/util/List;)V", "_positions", "Lorg/readium/r2/shared/publication/Locator;", "get_positions", "()Ljava/util/List;", "_positions$delegate", "Lkotlin/Lazy;", "positionsByReadingOrder", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "r2-streamer_release"})
public final class PdfPositionsService
implements PositionsService {
    private final Lazy _positions$delegate;
    private final Link link;
    private final int pageCount;
    private final List<Link> tableOfContents;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Object positionsByReadingOrder(@NotNull Continuation<? super List<? extends List<Locator>>> $completion) {
        return this.get_positions();
    }

    private final List<List<Locator>> get_positions() {
        Lazy lazy = this._positions$delegate;
        PdfPositionsService pdfPositionsService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public PdfPositionsService(@NotNull Link link, int pageCount, @NotNull List<Link> tableOfContents) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        Intrinsics.checkParameterIsNotNull(tableOfContents, (String)"tableOfContents");
        this.link = link;
        this.pageCount = pageCount;
        this.tableOfContents = tableOfContents;
        this._positions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends List<? extends Locator>>>(this){
            final /* synthetic */ PdfPositionsService this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<List<Locator>> invoke() {
                void $this$mapTo$iv$iv;
                if (PdfPositionsService.access$getPageCount$p(this.this$0) <= 0) {
                    Timber.e((String)("Invalid page count for a PDF document: " + PdfPositionsService.access$getPageCount$p(this.this$0)), (Object[])new Object[0]);
                    return CollectionsKt.listOf((Object)CollectionsKt.emptyList());
                }
                int n = 1;
                Iterable $this$map$iv = (Iterable)new IntRange(n, PdfPositionsService.access$getPageCount$p(this.this$0));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void position;
                    int item$iv$iv;
                    int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    double progression = (double)(position - true) / (double)PdfPositionsService.access$getPageCount$p(this.this$0);
                    String string = PdfPositionsService.access$getLink$p(this.this$0).getHref();
                    String string2 = PdfPositionsService.access$getLink$p(this.this$0).getType();
                    if (string2 == null) {
                        string2 = MediaType.Companion.getPDF().toString();
                    }
                    Map map = null;
                    Integer n3 = (int)position;
                    Double d = progression;
                    Locator locator = new Locator(string, string2, null, new Locator.Locations(CollectionsKt.listOf((Object)("page=" + (int)position)), Double.valueOf(progression), n3, d, map, 16, null), null, 20, null);
                    collection.add(locator);
                }
                return CollectionsKt.listOf((Object)((List)destination$iv$iv));
            }
            {
                this.this$0 = pdfPositionsService;
                super(0);
            }
        }));
    }

    @NotNull
    public List<Link> getLinks() {
        return PositionsService.DefaultImpls.getLinks((PositionsService)this);
    }

    public void close() {
        PositionsService.DefaultImpls.close((PositionsService)this);
    }

    @Nullable
    public Resource get(@NotNull Link link) {
        Intrinsics.checkParameterIsNotNull((Object)link, (String)"link");
        return PositionsService.DefaultImpls.get((PositionsService)this, (Link)link);
    }

    @Nullable
    public Object positions(@NotNull Continuation<? super List<Locator>> continuation) {
        return PositionsService.DefaultImpls.positions((PositionsService)this, continuation);
    }

    public static final /* synthetic */ int access$getPageCount$p(PdfPositionsService $this) {
        return $this.pageCount;
    }

    public static final /* synthetic */ Link access$getLink$p(PdfPositionsService $this) {
        return $this.link;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/readium/r2/streamer/parser/pdf/PdfPositionsService$Companion;", "", "()V", "create", "Lorg/readium/r2/streamer/parser/pdf/PdfPositionsService;", "context", "Lorg/readium/r2/shared/publication/Publication$Service$Context;", "r2-streamer_release"})
    public static final class Companion {
        @Nullable
        public final PdfPositionsService create(@NotNull Publication.Service.Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Link link = (Link)CollectionsKt.firstOrNull((List)context.getManifest().getReadingOrder());
            if (link == null) {
                return null;
            }
            Link link2 = link;
            Integer n = context.getManifest().getMetadata().getNumberOfPages();
            return new PdfPositionsService(link2, n != null ? n : 0, context.getManifest().getTableOfContents());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

