/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.drm.DRM;
import org.readium.r2.shared.parser.xml.ElementNode;
import org.readium.r2.shared.publication.encryption.Encryption;
import org.readium.r2.shared.util.Href;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0005\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\bH\u0002J\u001e\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u001e\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0005\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/readium/r2/streamer/parser/epub/EncryptionParser;", "", "()V", "parse", "", "", "Lorg/readium/r2/shared/publication/encryption/Encryption;", "document", "Lorg/readium/r2/shared/parser/xml/ElementNode;", "parseCompressionElement", "Lkotlin/Pair;", "", "compressionElement", "parseEncryptedData", "node", "parseEncryptionProperties", "encryptionProperties", "r2-streamer_release"})
public final class EncryptionParser {
    public static final EncryptionParser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Encryption> parse(@NotNull ElementNode document) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Iterable $this$mapNotNull$iv = document.get("EncryptedData", "http://www.w3.org/2001/04/xmlenc#");
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair<String, Encryption> pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ElementNode it = (ElementNode)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.parseEncryptedData(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair<String, Encryption> it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final Pair<String, Encryption> parseEncryptedData(ElementNode node) {
        Pair<Long, String> compression;
        Pair<Long, String> pair;
        Object object = node.getFirst("CipherData", "http://www.w3.org/2001/04/xmlenc#");
        if (object == null || (object = object.getFirst("CipherReference", "http://www.w3.org/2001/04/xmlenc#")) == null || (object = object.getAttr("URI")) == null) {
            return null;
        }
        Object resourceURI = object;
        ElementNode elementNode = node.getFirst("KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        String retrievalMethod = elementNode != null && (elementNode = elementNode.getFirst("RetrievalMethod", "http://www.w3.org/2000/09/xmldsig#")) != null ? elementNode.getAttr("URI") : null;
        String scheme = Intrinsics.areEqual(retrievalMethod, (Object)"license.lcpl#/encryption/content_key") ? DRM.Scheme.lcp.getRawValue() : null;
        Object object2 = node.getFirst("EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        if (object2 == null || (object2 = object2.getAttr("Algorithm")) == null) {
            return null;
        }
        Object algorithm = object2;
        ElementNode elementNode2 = node.getFirst("EncryptionProperties", "http://www.w3.org/2001/04/xmlenc#");
        if (elementNode2 != null) {
            ElementNode elementNode3 = elementNode2;
            boolean bl = false;
            boolean bl2 = false;
            ElementNode it = elementNode3;
            boolean bl3 = false;
            pair = INSTANCE.parseEncryptionProperties(it);
        } else {
            pair = null;
        }
        Pair<Long, String> pair2 = compression = pair;
        Long originalLength = pair2 != null ? (Long)pair2.getFirst() : null;
        Pair<Long, String> pair3 = compression;
        String compressionMethod = pair3 != null ? (String)pair3.getSecond() : null;
        Long l = originalLength;
        String string = null;
        String string2 = compressionMethod;
        Object object3 = algorithm;
        String string3 = scheme;
        Encryption enc = new Encryption((String)object3, string2, l, string, string3, 8, null);
        return new Pair((Object)new Href((String)resourceURI, null, 2, null).getString(), (Object)enc);
    }

    private final Pair<Long, String> parseEncryptionProperties(ElementNode encryptionProperties) {
        for (ElementNode encryptionProperty : encryptionProperties.get("EncryptionProperty", "http://www.w3.org/2001/04/xmlenc#")) {
            ElementNode compressionElement = encryptionProperty.getFirst("Compression", "http://www.idpf.org/2016/encryption#compression");
            if (compressionElement == null) continue;
            Pair<Long, String> pair = this.parseCompressionElement(compressionElement);
            if (pair == null) continue;
            Pair<Long, String> pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair<Long, String> it = pair2;
            boolean bl3 = false;
            return it;
        }
        return null;
    }

    private final Pair<Long, String> parseCompressionElement(ElementNode compressionElement) {
        Object object = compressionElement.getAttr("OriginalLength");
        if (object == null || (object = StringsKt.toLongOrNull((String)object)) == null) {
            return null;
        }
        long originalLength = (Long)object;
        String string = compressionElement.getAttr("Method");
        if (string == null) {
            return null;
        }
        String method = string;
        String compression = Intrinsics.areEqual((Object)method, (Object)"8") ? "deflate" : "none";
        return new Pair((Object)originalLength, (Object)compression);
    }

    private EncryptionParser() {
    }

    static {
        EncryptionParser encryptionParser;
        INSTANCE = encryptionParser = new EncryptionParser();
    }
}

