/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.server;

import android.content.res.AssetManager;
import android.net.Uri;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.extensions.FileKt;
import org.readium.r2.shared.format.Format;
import org.readium.r2.shared.format.MediaType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/readium/r2/streamer/server/Assets;", "", "assetManager", "Landroid/content/res/AssetManager;", "basePath", "", "fallbackMediaType", "Lorg/readium/r2/shared/format/MediaType;", "(Landroid/content/res/AssetManager;Ljava/lang/String;Lorg/readium/r2/shared/format/MediaType;)V", "assets", "", "Lkotlin/Pair;", "Ljava/io/File;", "add", "", "href", "path", "find", "Lorg/readium/r2/streamer/server/Assets$ServedAsset;", "uri", "Landroid/net/Uri;", "ServedAsset", "r2-streamer_release"})
public final class Assets {
    private final List<Pair<String, File>> assets;
    private final AssetManager assetManager;
    private final String basePath;
    private final MediaType fallbackMediaType;

    public final void add(@NotNull String href, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)href, (String)"href");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.assets.add(0, (Pair<String, File>)new Pair((Object)href, (Object)new File('/' + path).getCanonicalFile()));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ServedAsset find(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        String string = uri.getPath();
        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)this.basePath)) == null) {
            return null;
        }
        String path = string;
        for (Pair<String, File> pair : this.assets) {
            void href;
            String string2 = (String)pair.component1();
            File file = (File)pair.component2();
            if (!StringsKt.startsWith$default((String)path, (String)href, (boolean)false, (int)2, null)) continue;
            File requestedFile = new File(file, StringsKt.removePrefix((String)path, (CharSequence)((CharSequence)href))).getCanonicalFile();
            if (!Intrinsics.areEqual((Object)file, (Object)requestedFile)) {
                File file2 = requestedFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"requestedFile");
                if (!FileKt.isParentOf((File)file, (File)file2)) continue;
            }
            File file3 = requestedFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"requestedFile");
            Format format2 = Format.Companion.of$default((Format.Companion)Format.Companion, null, (String)FilesKt.getExtension((File)file3), null, (int)5, null);
            if (format2 == null || (format2 = format2.getMediaType()) == null) {
                format2 = this.fallbackMediaType;
            }
            Format mediaType2 = format2;
            String string3 = requestedFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"requestedFile.path");
            InputStream inputStream = this.assetManager.open(StringsKt.removePrefix((String)string3, (CharSequence)"/"));
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"assetManager.open(reques\u2026e.path.removePrefix(\"/\"))");
            return new ServedAsset(inputStream, (MediaType)mediaType2);
        }
        return null;
    }

    public Assets(@NotNull AssetManager assetManager, @NotNull String basePath, @NotNull MediaType fallbackMediaType) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)assetManager, (String)"assetManager");
        Intrinsics.checkParameterIsNotNull((Object)basePath, (String)"basePath");
        Intrinsics.checkParameterIsNotNull((Object)fallbackMediaType, (String)"fallbackMediaType");
        this.assetManager = assetManager;
        this.basePath = basePath;
        this.fallbackMediaType = fallbackMediaType;
        Assets assets = this;
        boolean bl = false;
        assets.assets = list = (List)new ArrayList();
    }

    public /* synthetic */ Assets(AssetManager assetManager, String string, MediaType mediaType2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            mediaType2 = MediaType.Companion.getBINARY();
        }
        this(assetManager, string, mediaType2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/readium/r2/streamer/server/Assets$ServedAsset;", "", "stream", "Ljava/io/InputStream;", "mediaType", "Lorg/readium/r2/shared/format/MediaType;", "(Ljava/io/InputStream;Lorg/readium/r2/shared/format/MediaType;)V", "getMediaType", "()Lorg/readium/r2/shared/format/MediaType;", "getStream", "()Ljava/io/InputStream;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "r2-streamer_release"})
    public static final class ServedAsset {
        @NotNull
        private final InputStream stream;
        @NotNull
        private final MediaType mediaType;

        @NotNull
        public final InputStream getStream() {
            return this.stream;
        }

        @NotNull
        public final MediaType getMediaType() {
            return this.mediaType;
        }

        public ServedAsset(@NotNull InputStream stream, @NotNull MediaType mediaType2) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Intrinsics.checkParameterIsNotNull((Object)mediaType2, (String)"mediaType");
            this.stream = stream;
            this.mediaType = mediaType2;
        }

        @NotNull
        public final InputStream component1() {
            return this.stream;
        }

        @NotNull
        public final MediaType component2() {
            return this.mediaType;
        }

        @NotNull
        public final ServedAsset copy(@NotNull InputStream stream, @NotNull MediaType mediaType2) {
            Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
            Intrinsics.checkParameterIsNotNull((Object)mediaType2, (String)"mediaType");
            return new ServedAsset(stream, mediaType2);
        }

        public static /* synthetic */ ServedAsset copy$default(ServedAsset servedAsset, InputStream inputStream, MediaType mediaType2, int n, Object object) {
            if ((n & 1) != 0) {
                inputStream = servedAsset.stream;
            }
            if ((n & 2) != 0) {
                mediaType2 = servedAsset.mediaType;
            }
            return servedAsset.copy(inputStream, mediaType2);
        }

        @NotNull
        public String toString() {
            return "ServedAsset(stream=" + this.stream + ", mediaType=" + this.mediaType + ")";
        }

        public int hashCode() {
            InputStream inputStream = this.stream;
            MediaType mediaType2 = this.mediaType;
            return (inputStream != null ? inputStream.hashCode() : 0) * 31 + (mediaType2 != null ? mediaType2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ServedAsset)) break block3;
                    ServedAsset servedAsset = (ServedAsset)object;
                    if (!Intrinsics.areEqual((Object)this.stream, (Object)servedAsset.stream) || !Intrinsics.areEqual((Object)this.mediaType, (Object)servedAsset.mediaType)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

