/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.readium;

import android.content.Context;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.readium.r2.shared.drm.DRM;
import org.readium.r2.shared.format.Format;
import org.readium.r2.shared.format.MediaType;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.streamer.container.ArchiveContainer;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.container.EmptyContainer;
import org.readium.r2.streamer.parser.PubBox;
import org.readium.r2.streamer.parser.PublicationParser;
import org.readium.r2.streamer.parser.readium.LcpdfPositionListFactory;
import org.readium.r2.streamer.parser.readium.ReadiumWebPubParser;
import org.readium.r2.streamer.parser.readium.ReadiumWebPubParserKt;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/readium/r2/streamer/parser/readium/ReadiumWebPubParser;", "Lorg/readium/r2/streamer/parser/PublicationParser;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "parse", "Lorg/readium/r2/streamer/parser/PubBox;", "fileAtPath", "", "fallbackTitle", "parseManifest", "file", "Ljava/io/File;", "format", "Lorg/readium/r2/shared/format/Format;", "parsePackage", "parsePublication", "Lorg/readium/r2/shared/publication/Publication;", "manifestJson", "container", "Lorg/readium/r2/streamer/container/Container;", "isPackage", "", "r2-streamer_release"})
public final class ReadiumWebPubParser
implements PublicationParser {
    private final Context context;

    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath, @NotNull String fallbackTitle) {
        PubBox pubBox;
        block9: {
            block10: {
                boolean bl;
                block8: {
                    Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
                    Intrinsics.checkParameterIsNotNull((Object)fallbackTitle, (String)"fallbackTitle");
                    File file = new File(fileAtPath);
                    Format format2 = (Format)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Format>, Object>(file, null){
                        private CoroutineScope p$;
                        Object L$0;
                        int label;
                        final /* synthetic */ File $file;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    CoroutineScope $this$runBlocking = this.p$;
                                    this.L$0 = $this$runBlocking;
                                    this.label = 1;
                                    Object object2 = Format.Companion.ofFile$default((Format.Companion)Format.Companion, (File)this.$file, null, null, null, (Continuation)this, (int)14, null);
                                    if (object2 != object) return object2;
                                    return object;
                                }
                                case 1: {
                                    CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return object2;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                        {
                            this.$file = file;
                            super(2, continuation);
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                            Function2<CoroutineScope, Continuation<? super Format>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                            return function2;
                        }

                        public final Object invoke(Object object, Object object2) {
                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                    if (format2 == null) {
                        return null;
                    }
                    Format format3 = format2;
                    PubBox pubBox2 = pubBox = format3.getMediaType().isRwpm() ? this.parseManifest(file, format3) : this.parsePackage(file, format3);
                    if (pubBox == null) break block9;
                    List readingOrder = pubBox.getPublication().getReadingOrder();
                    if (!Intrinsics.areEqual((Object)format3, (Object)Format.Companion.getLCP_PROTECTED_PDF())) break block9;
                    if (readingOrder.isEmpty()) break block10;
                    Iterable $this$all$iv = readingOrder;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            Link it = (Link)element$iv;
                            boolean bl2 = false;
                            MediaType mediaType2 = it.getMediaType();
                            if (mediaType2 != null && mediaType2.matches(MediaType.Companion.getPDF())) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) break block9;
            }
            Timber.e((String)"Invalid LCP Protected PDF", (Object[])new Object[0]);
            return null;
        }
        return pubBox;
    }

    private final PubBox parseManifest(File file, Format format2) {
        PubBox pubBox;
        try {
            PubBox pubBox2;
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            EmptyContainer container = new EmptyContainer(string, format2.getMediaType().toString());
            String manifestJson = FilesKt.readText$default((File)file, null, (int)1, null);
            Publication publication2 = this.parsePublication(manifestJson, container, format2, false);
            if (publication2 != null) {
                Publication publication3 = publication2;
                boolean bl = false;
                boolean bl2 = false;
                Publication it = publication3;
                boolean bl3 = false;
                pubBox2 = new PubBox(it, container);
            } else {
                pubBox2 = null;
            }
            pubBox = pubBox2;
        }
        catch (Exception e) {
            Timber.e((Throwable)e, (String)"Failed to parse RWPM", (Object[])new Object[0]);
            pubBox = null;
        }
        return pubBox;
    }

    private final PubBox parsePackage(File file, Format format2) {
        PubBox pubBox;
        try {
            PubBox pubBox2;
            String manifestPath = "manifest.json";
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            ArchiveContainer archiveContainer = new ArchiveContainer(string, format2.getMediaType().toString());
            boolean bl = false;
            boolean bl2 = false;
            ArchiveContainer $this$apply = archiveContainer;
            boolean bl3 = false;
            $this$apply.getRootFile().setRootFilePath(manifestPath);
            ArchiveContainer container = archiveContainer;
            Object object = container.data(manifestPath);
            bl2 = false;
            String manifestJson = new String((byte[])object, Charsets.UTF_8);
            Publication publication2 = this.parsePublication(manifestJson, container, format2, true);
            if (publication2 != null) {
                object = publication2;
                bl2 = false;
                boolean bl4 = false;
                Object it = object;
                boolean bl5 = false;
                pubBox2 = new PubBox((Publication)it, container);
            } else {
                pubBox2 = null;
            }
            pubBox = pubBox2;
        }
        catch (Exception e) {
            Timber.e((Throwable)e, (String)"Failed to parse Readium WebPub package", (Object[])new Object[0]);
            pubBox = null;
        }
        return pubBox;
    }

    private final Publication parsePublication(String manifestJson, Container container, Format format2, boolean isPackage) {
        Publication publication2;
        try {
            Publication publication3;
            Publication publication4;
            boolean lcpProtected;
            boolean bl = lcpProtected = isPackage && ReadiumWebPubParserKt.access$isProtectedWithLcp$p(container);
            if (lcpProtected) {
                container.setDrm(new DRM(DRM.Brand.lcp));
            }
            Publication publication5 = Publication.Companion.fromJSON(new JSONObject(manifestJson), (Function1)parsePublication.publication.1.INSTANCE);
            if (publication5 != null) {
                Publication publication6 = publication5;
                boolean bl2 = false;
                boolean bl3 = false;
                Publication $this$apply = publication6;
                boolean bl4 = false;
                $this$apply.setType(ReadiumWebPubParserKt.access$toPublicationType(format2));
                publication4 = publication6;
            } else {
                publication4 = publication3 = null;
            }
            if (Intrinsics.areEqual((Object)format2, (Object)Format.Companion.getLCP_PROTECTED_PDF())) {
                Publication publication7 = publication3;
                publication3 = publication7 != null ? publication7.copyWithPositionsFactory((Function1)new Function1<Publication, LcpdfPositionListFactory>(this, container){
                    final /* synthetic */ ReadiumWebPubParser this$0;
                    final /* synthetic */ Container $container;

                    @NotNull
                    public final LcpdfPositionListFactory invoke(@NotNull Publication $this$copyWithPositionsFactory) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$copyWithPositionsFactory, (String)"$receiver");
                        Context context = ReadiumWebPubParser.access$getContext$p(this.this$0).getApplicationContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"this@ReadiumWebPubParser\u2026ontext.applicationContext");
                        return new LcpdfPositionListFactory(context, this.$container, $this$copyWithPositionsFactory.getReadingOrder());
                    }
                    {
                        this.this$0 = readiumWebPubParser;
                        this.$container = container;
                        super(1);
                    }
                }) : null;
            }
            publication2 = publication3;
        }
        catch (Exception e) {
            Timber.e((Throwable)e, (String)"Failed to parse RWPM", (Object[])new Object[0]);
            publication2 = null;
        }
        return publication2;
    }

    public ReadiumWebPubParser(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    public static final /* synthetic */ Context access$getContext$p(ReadiumWebPubParser $this) {
        return $this.context;
    }
}

