/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.readium;

import android.content.Context;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.format.MediaType;
import org.readium.r2.shared.pdf.PdfDocument;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Locator;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.fetcher.DrmDecoder;
import org.readium.r2.streamer.parser.pdf.PdfiumDocument;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0016J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/readium/r2/streamer/parser/readium/LcpdfPositionListFactory;", "Lorg/readium/r2/shared/publication/Publication$PositionListFactory;", "context", "Landroid/content/Context;", "container", "Lorg/readium/r2/streamer/container/Container;", "readingOrder", "", "Lorg/readium/r2/shared/publication/Link;", "(Landroid/content/Context;Lorg/readium/r2/streamer/container/Container;Ljava/util/List;)V", "decoder", "Lorg/readium/r2/streamer/fetcher/DrmDecoder;", "create", "Lorg/readium/r2/shared/publication/Locator;", "createPositionsOf", "link", "pageCount", "", "totalPageCount", "startPosition", "openPdfAt", "Lorg/readium/r2/shared/pdf/PdfDocument;", "r2-streamer_release"})
public final class LcpdfPositionListFactory
implements Publication.PositionListFactory {
    private final DrmDecoder decoder;
    private final Context context;
    private final Container container;
    private final List<Link> readingOrder;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Locator> create() {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.readingOrder;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void link;
            Link link2 = (Link)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PdfDocument pdfDocument = this.openPdfAt((Link)link);
            int pageCount = pdfDocument != null ? pdfDocument.getPageCount() : 0;
            Pair pair = new Pair((Object)pageCount, (Object)link);
            collection.add(pair);
        }
        List resources = (List)destination$iv$iv;
        Iterable $this$sumBy$iv = resources;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            Object item$iv$iv;
            item$iv$iv = (Pair)element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = ((Number)it.getFirst()).intValue();
            sum$iv = n + n2;
        }
        int totalPageCount = sum$iv;
        if (totalPageCount <= 0) {
            return CollectionsKt.emptyList();
        }
        int lastPositionOfPreviousResource = 0;
        Iterable $this$flatMap$iv = resources;
        boolean $i$f$flatMap = false;
        Iterable $i$f$mapTo22 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void pageCount;
            Pair $dstr$pageCount$link = (Pair)element$iv$iv;
            boolean bl = false;
            int n = ((Number)$dstr$pageCount$link.component1()).intValue();
            Link link = (Link)$dstr$pageCount$link.component2();
            List<Locator> positions = this.createPositionsOf(link, (int)pageCount, totalPageCount, lastPositionOfPreviousResource);
            lastPositionOfPreviousResource += pageCount;
            Iterable list$iv$iv = positions;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Locator> createPositionsOf(Link link, int pageCount, int totalPageCount, int startPosition) {
        void $this$mapTo$iv$iv;
        if (pageCount <= 0 || totalPageCount <= 0) {
            return CollectionsKt.emptyList();
        }
        int n = 1;
        Iterable $this$map$iv = (Iterable)new IntRange(n, pageCount);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void position;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double progression = (double)(position - true) / (double)pageCount;
            double totalProgression = (double)(startPosition + position - 1) / (double)totalPageCount;
            String string = link.getHref();
            String string2 = link.getType();
            if (string2 == null) {
                string2 = MediaType.Companion.getPDF().toString();
            }
            Map map = null;
            Integer n3 = startPosition + position;
            Double d = totalProgression;
            Locator locator = new Locator(string, string2, null, new Locator.Locations(CollectionsKt.listOf((Object)("page=" + (int)position)), Double.valueOf(progression), n3, d, map, 16, null), null, 20, null);
            collection.add(locator);
        }
        return (List)destination$iv$iv;
    }

    private final PdfDocument openPdfAt(Link link) {
        Object object;
        try {
            object = this.container.dataInputStream(link.getHref());
            boolean bl = false;
            boolean bl2 = false;
            InputStream it = object;
            boolean bl3 = false;
            object = this.decoder.decoding(it, link, this.container.getDrm());
            bl = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            object = PdfiumDocument.Companion.fromBytes(ByteStreamsKt.readBytes((InputStream)it), this.context);
        }
        catch (Exception e) {
            Timber.e((Throwable)e);
            object = null;
        }
        return (PdfDocument)object;
    }

    public LcpdfPositionListFactory(@NotNull Context context, @NotNull Container container, @NotNull List<Link> readingOrder) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull(readingOrder, (String)"readingOrder");
        this.context = context;
        this.container = container;
        this.readingOrder = readingOrder;
        this.decoder = new DrmDecoder();
    }
}

