/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.pdf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.format.MediaType;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Locator;
import org.readium.r2.shared.publication.Publication;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/readium/r2/streamer/parser/pdf/PdfPositionListFactory;", "Lorg/readium/r2/shared/publication/Publication$PositionListFactory;", "documentHref", "", "pageCount", "", "tableOfContents", "", "Lorg/readium/r2/shared/publication/Link;", "(Ljava/lang/String;ILjava/util/List;)V", "create", "Lorg/readium/r2/shared/publication/Locator;", "r2-streamer_release"})
public final class PdfPositionListFactory
implements Publication.PositionListFactory {
    private final String documentHref;
    private final int pageCount;
    private final List<Link> tableOfContents;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Locator> create() {
        void $this$mapTo$iv$iv;
        if (this.pageCount <= 0) {
            Timber.e((String)("Invalid page count for a PDF document: " + this.pageCount), (Object[])new Object[0]);
            return CollectionsKt.emptyList();
        }
        int n = 1;
        Iterable $this$map$iv = (Iterable)new IntRange(n, this.pageCount);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void position;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double progression = (double)(position - true) / (double)this.pageCount;
            Map map = null;
            Integer n3 = (int)position;
            Double d = progression;
            Locator locator = new Locator(this.documentHref, MediaType.Companion.getPDF().toString(), null, new Locator.Locations(CollectionsKt.listOf((Object)("page=" + (int)position)), Double.valueOf(progression), n3, d, map, 16, null), null, 20, null);
            collection.add(locator);
        }
        return (List)destination$iv$iv;
    }

    public PdfPositionListFactory(@NotNull String documentHref, int pageCount, @NotNull List<Link> tableOfContents) {
        Intrinsics.checkParameterIsNotNull((Object)documentHref, (String)"documentHref");
        Intrinsics.checkParameterIsNotNull(tableOfContents, (String)"tableOfContents");
        this.documentHref = documentHref;
        this.pageCount = pageCount;
        this.tableOfContents = tableOfContents;
    }
}

