/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.pdf;

import android.content.Context;
import android.graphics.Bitmap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.PdfSupport;
import org.readium.r2.shared.format.MediaType;
import org.readium.r2.shared.pdf.PdfDocumentKt;
import org.readium.r2.shared.publication.Contributor;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.LocalizedString;
import org.readium.r2.shared.publication.Properties;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.shared.publication.ReadingProgression;
import org.readium.r2.streamer.container.FileContainer;
import org.readium.r2.streamer.parser.PubBox;
import org.readium.r2.streamer.parser.PublicationParser;
import org.readium.r2.streamer.parser.pdf.PdfPositionListFactory;
import org.readium.r2.streamer.parser.pdf.PdfiumDocument;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\f\u0010\n\u001a\u00020\b*\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/readium/r2/streamer/parser/pdf/PdfParser;", "Lorg/readium/r2/streamer/parser/PublicationParser;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "parse", "Lorg/readium/r2/streamer/parser/PubBox;", "fileAtPath", "", "fallbackTitle", "toTitle", "Ljava/io/File;", "r2-streamer_release"})
@PdfSupport
public final class PdfParser
implements PublicationParser {
    private final Context context;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath, @NotNull String fallbackTitle) {
        PubBox pubBox;
        Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
        Intrinsics.checkParameterIsNotNull((Object)fallbackTitle, (String)"fallbackTitle");
        try {
            Collection<Contributor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            CharSequence charSequence;
            List list;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            List list2;
            List tableOfContents;
            Object object;
            Object object2;
            List list3;
            List list4;
            String string6;
            Publication.PositionListFactory positionListFactory;
            Iterator iterator;
            List links;
            PdfiumDocument document;
            FileContainer container;
            String rootHref;
            block13: {
                File file;
                block12: {
                    CharSequence charSequence2;
                    Unit unit;
                    file = new File(fileAtPath);
                    rootHref = "/publication.pdf";
                    container = new FileContainer(fileAtPath, MediaType.Companion.getPDF().toString());
                    container.getRootFile().setRootFilePath(rootHref);
                    container.getFiles().put(rootHref, new FileContainer.File.Path(fileAtPath));
                    document = PdfiumDocument.Companion.fromBytes(FilesKt.readBytes((File)new File(fileAtPath)), this.context);
                    boolean bl = false;
                    links = new ArrayList();
                    Bitmap bitmap = document.getCover();
                    if (bitmap != null) {
                        Bitmap bitmap2 = bitmap;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Bitmap cover2 = bitmap2;
                        boolean bl4 = false;
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        if (cover2.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream)) {
                            String coverHref = "/cover.png";
                            Map<String, FileContainer.File> map = container.getFiles();
                            byte[] byArray = stream.toByteArray();
                            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"stream.toByteArray()");
                            map.put(coverHref, new FileContainer.File.Bytes(byArray));
                            iterator = null;
                            positionListFactory = null;
                            string6 = null;
                            list4 = null;
                            list3 = null;
                            object2 = cover2.getHeight();
                            object = cover2.getWidth();
                            Properties properties = null;
                            String string7 = MediaType.Companion.getPNG().toString();
                            String string8 = null;
                            boolean bl5 = false;
                            Set set = SetsKt.setOf((Object)"cover");
                            links.add(new Link(coverHref, string7, bl5, string8, set, properties, (Integer)object2, (Integer)object, list3, list4, string6, positionListFactory, iterator, 7980, null));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    tableOfContents = PdfDocumentKt.toLinks(document.getOutline(), (String)rootHref);
                    list2 = null;
                    string5 = document.getIdentifier();
                    if (string5 == null) {
                        string5 = file.getName();
                    }
                    string4 = null;
                    string3 = document.getTitle();
                    if (string3 == null) break block12;
                    CharSequence charSequence3 = string3;
                    string2 = string4;
                    string = string5;
                    list = list2;
                    boolean cover2 = false;
                    CharSequence bl4 = charSequence3;
                    boolean stream = false;
                    if (bl4.length() == 0) {
                        boolean bl6 = false;
                        charSequence2 = null;
                    } else {
                        charSequence2 = charSequence3;
                    }
                    charSequence = charSequence2;
                    list2 = list;
                    string5 = string;
                    string4 = string2;
                    string3 = (String)charSequence;
                    if (string3 != null) break block13;
                }
                string3 = this.toTitle(file);
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            String string9 = null;
            String string10 = string3;
            Iterable iterable = CollectionsKt.listOfNotNull((Object)document.getAuthor());
            List list5 = null;
            List list6 = null;
            Date date = null;
            Date date2 = null;
            charSequence = null;
            LocalizedString localizedString = null;
            LocalizedString localizedString2 = new LocalizedString(string10, string9, n, defaultConstructorMarker);
            string2 = string4;
            string = string5;
            list = list2;
            boolean $i$f$map = false;
            void bl4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                string6 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Contributor contributor = new Contributor((String)it);
                collection.add(contributor);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker2 = null;
            int n2 = 503315962;
            Map map = null;
            List list7 = null;
            List list8 = null;
            Integer n3 = document.getPageCount();
            Double d = null;
            String string11 = null;
            ReadingProgression readingProgression = null;
            List list9 = null;
            List list10 = null;
            List list11 = null;
            List list12 = null;
            List list13 = null;
            List list14 = null;
            List list15 = null;
            List list16 = null;
            List list17 = null;
            List list18 = null;
            List list19 = null;
            List list20 = null;
            Collection<Contributor> collection2 = collection;
            List list21 = list5;
            List list22 = list6;
            Date date3 = date;
            Date date4 = date2;
            CharSequence charSequence4 = charSequence;
            LocalizedString localizedString3 = localizedString;
            LocalizedString localizedString4 = localizedString2;
            String string12 = string2;
            String string13 = string;
            iterable = null;
            String string14 = null;
            Map map2 = null;
            double d2 = 0.0;
            iterator = null;
            positionListFactory = new PdfPositionListFactory(rootHref, document.getPageCount(), tableOfContents);
            string6 = null;
            list4 = tableOfContents;
            list3 = null;
            object2 = links;
            object = CollectionsKt.listOf((Object)new Link(rootHref, MediaType.Companion.getPDF().toString(), false, null, null, null, null, null, null, null, null, null, null, 8188, null));
            DefaultConstructorMarker defaultConstructorMarker3 = null;
            int n4 = 8017;
            Iterable iterable2 = iterable;
            String string15 = string14;
            Map map3 = map2;
            double d3 = d2;
            Iterator iterator2 = iterator;
            Publication.PositionListFactory positionListFactory2 = positionListFactory;
            String string16 = string6;
            List list23 = list4;
            List list24 = list3;
            Object object3 = object;
            Object object4 = object2;
            org.readium.r2.shared.publication.Metadata metadata2 = new org.readium.r2.shared.publication.Metadata(string13, string12, localizedString4, localizedString3, (LocalizedString)charSequence4, date4, date3, list22, list21, collection2, list20, list19, list18, list17, list16, list15, list14, list13, list12, list11, list10, list9, readingProgression, string11, d, n3, list8, list7, map, n2, defaultConstructorMarker2);
            List list25 = list;
            Publication publication2 = new Publication(list25, metadata2, (List)object4, (List)object3, list24, list23, (List)((Object)string16), positionListFactory2, iterator2, d3, map3, string15, (Map)((Object)iterable2), n4, defaultConstructorMarker3);
            pubBox = new PubBox(publication2, container);
        }
        catch (Exception e) {
            Timber.e((Throwable)e);
            pubBox = null;
        }
        return pubBox;
    }

    private final String toTitle(@NotNull File $this$toTitle) {
        return StringsKt.replace$default((String)FilesKt.getNameWithoutExtension((File)$this$toTitle), (String)"_", (String)" ", (boolean)false, (int)4, null);
    }

    public PdfParser(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

