/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Locator;
import org.readium.r2.shared.publication.Properties;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.shared.publication.encryption.PropertiesKt;
import org.readium.r2.shared.publication.epub.EpubLayout;
import org.readium.r2.shared.publication.epub.PresentationKt;
import org.readium.r2.shared.publication.presentation.Presentation;
import org.readium.r2.streamer.container.Container;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005H\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/readium/r2/streamer/parser/epub/EpubPositionListFactory;", "Lorg/readium/r2/shared/publication/Publication$PositionListFactory;", "container", "Lorg/readium/r2/streamer/container/Container;", "readingOrder", "", "Lorg/readium/r2/shared/publication/Link;", "presentation", "Lorg/readium/r2/shared/publication/presentation/Presentation;", "reflowablePositionLength", "", "(Lorg/readium/r2/streamer/container/Container;Ljava/util/List;Lorg/readium/r2/shared/publication/presentation/Presentation;J)V", "create", "Lorg/readium/r2/shared/publication/Locator;", "createFixed", "link", "startPosition", "", "createLocator", "progression", "", "position", "createReflowable", "r2-streamer_release"})
public final class EpubPositionListFactory
implements Publication.PositionListFactory {
    private final Container container;
    private final List<Link> readingOrder;
    private final Presentation presentation;
    private final long reflowablePositionLength;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Locator> create() {
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        int lastPositionOfPreviousResource = 0;
        Iterable $this$flatMap$iv = this.readingOrder;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Link link = (Link)element$iv$iv;
            boolean bl = false;
            List<Locator> positions = PresentationKt.layoutOf((Presentation)this.presentation, (Link)link) == EpubLayout.FIXED ? this.createFixed(link, lastPositionOfPreviousResource) : this.createReflowable(link, lastPositionOfPreviousResource, this.container);
            Object object = (Locator)CollectionsKt.lastOrNull(positions);
            if (object != null && (object = object.getLocations()) != null && (object = object.getPosition()) != null) {
                Object object2 = object;
                boolean bl2 = false;
                boolean bl3 = false;
                int it = ((Number)object2).intValue();
                boolean bl4 = false;
                lastPositionOfPreviousResource = it;
            }
            Iterable list$iv$iv = positions;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List positions = (List)destination$iv$iv;
        int totalPageCount = positions.size();
        Iterable $this$map$iv = positions;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void locator;
            Locator bl = (Locator)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl5 = false;
            Integer position = locator.getLocations().getPosition();
            void var19_26 = position == null ? locator : Locator.copyWithLocations$default((Locator)locator, null, null, null, (Double)((double)(position - 1) / (double)totalPageCount), null, (int)23, null);
            collection.add(var19_26);
        }
        positions = (List)destination$iv$iv2;
        return positions;
    }

    private final List<Locator> createFixed(Link link, int startPosition) {
        return CollectionsKt.listOf((Object)this.createLocator(link, 0.0, startPosition + 1));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Locator> createReflowable(Link link, int startPosition, Container container) {
        void $this$mapTo$iv$iv;
        Object object = PropertiesKt.getEncryption((Properties)link.getProperties());
        long length = object != null && (object = object.getOriginalLength()) != null ? ((Long)object).longValue() : container.dataLength(link.getHref());
        double d = (double)length / (double)this.reflowablePositionLength;
        boolean bl = false;
        int pageCount = RangesKt.coerceAtLeast((int)((int)Math.ceil(d)), (int)1);
        int n = 1;
        Iterable $this$map$iv = (Iterable)new IntRange(n, pageCount);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void position;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Locator locator = this.createLocator(link, (double)(position - true) / (double)pageCount, startPosition + position);
            collection.add(locator);
        }
        return (List)destination$iv$iv;
    }

    private final Locator createLocator(Link link, double progression, int position) {
        String string = link.getHref();
        String string2 = link.getType();
        if (string2 == null) {
            string2 = "text/html";
        }
        return new Locator(string, string2, link.getTitle(), new Locator.Locations(null, Double.valueOf(progression), Integer.valueOf(position), null, null, 25, null), null, 16, null);
    }

    public EpubPositionListFactory(@NotNull Container container, @NotNull List<Link> readingOrder, @NotNull Presentation presentation, long reflowablePositionLength) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull(readingOrder, (String)"readingOrder");
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        this.container = container;
        this.readingOrder = readingOrder;
        this.presentation = presentation;
        this.reflowablePositionLength = reflowablePositionLength;
    }
}

