/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.ReadiumCSSName;
import org.readium.r2.shared.RootFile;
import org.readium.r2.shared.URLHelperKt;
import org.readium.r2.shared.drm.DRM;
import org.readium.r2.shared.format.MediaType;
import org.readium.r2.shared.parser.xml.ElementNode;
import org.readium.r2.shared.parser.xml.XmlParser;
import org.readium.r2.shared.publication.Link;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.shared.publication.encryption.Encryption;
import org.readium.r2.shared.publication.presentation.MetadataKt;
import org.readium.r2.streamer.container.ArchiveContainer;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.container.ContainerError;
import org.readium.r2.streamer.container.DirectoryContainer;
import org.readium.r2.streamer.parser.PubBox;
import org.readium.r2.streamer.parser.PublicationParser;
import org.readium.r2.streamer.parser.epub.EPUBConstant;
import org.readium.r2.streamer.parser.epub.EncryptionParser;
import org.readium.r2.streamer.parser.epub.EpubPositionListFactory;
import org.readium.r2.streamer.parser.epub.Item;
import org.readium.r2.streamer.parser.epub.NavigationDocumentParser;
import org.readium.r2.streamer.parser.epub.NcxParser;
import org.readium.r2.streamer.parser.epub.PackageDocument;
import org.readium.r2.streamer.parser.epub.PublicationFactory;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J*\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u0006H\u0002\u00a8\u0006!"}, d2={"Lorg/readium/r2/streamer/parser/epub/EpubParser;", "Lorg/readium/r2/streamer/parser/PublicationParser;", "()V", "fillEncryption", "Lkotlin/Pair;", "Lorg/readium/r2/streamer/container/Container;", "Lorg/readium/r2/shared/publication/Publication;", "container", "publication", "drm", "Lorg/readium/r2/shared/drm/DRM;", "generateContainerFrom", "path", "", "getRootFilePath", "document", "Lorg/readium/r2/shared/parser/xml/ElementNode;", "parse", "Lorg/readium/r2/streamer/parser/PubBox;", "fileAtPath", "fallbackTitle", "parseDisplayOptions", "", "parseEncryptionData", "Lorg/readium/r2/shared/publication/encryption/Encryption;", "parseNavigationData", "", "Lorg/readium/r2/shared/publication/Link;", "packageDocument", "Lorg/readium/r2/streamer/parser/epub/PackageDocument;", "parseXmlDocument", "setLayoutStyle", "", "r2-streamer_release"})
public final class EpubParser
implements PublicationParser {
    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath, @NotNull String fallbackTitle) {
        Container container;
        Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
        Intrinsics.checkParameterIsNotNull((Object)fallbackTitle, (String)"fallbackTitle");
        try {
            container = this.generateContainerFrom(fileAtPath);
        }
        catch (Exception e) {
            Timber.e((Throwable)e, (String)"Could not generate container", (Object[])new Object[0]);
            return null;
        }
        Container container2 = container;
        ElementNode elementNode = this.parseXmlDocument("META-INF/container.xml", container2);
        if (elementNode == null) {
            return null;
        }
        ElementNode containerXml = elementNode;
        String opfPath = this.getRootFilePath(containerXml);
        ElementNode elementNode2 = this.parseXmlDocument(opfPath, container2);
        if (elementNode2 == null) {
            return null;
        }
        ElementNode packageXml = elementNode2;
        PackageDocument packageDocument = PackageDocument.Companion.parse(packageXml, opfPath);
        if (packageDocument == null) {
            return null;
        }
        PackageDocument packageDocument2 = packageDocument;
        RootFile rootFile = container2.getRootFile();
        boolean bl = false;
        boolean bl2 = false;
        RootFile $this$apply = rootFile;
        boolean bl3 = false;
        $this$apply.setMimetype(MediaType.Companion.getEPUB().toString());
        $this$apply.setRootFilePath(opfPath);
        Publication publication2 = new PublicationFactory(fallbackTitle, packageDocument2, this.parseNavigationData(packageDocument2, container2), this.parseEncryptionData(container2), this.parseDisplayOptions(container2)).create().copyWithPositionsFactory((Function1)new Function1<Publication, EpubPositionListFactory>(container2){
            final /* synthetic */ Container $container;

            @NotNull
            public final EpubPositionListFactory invoke(@NotNull Publication $this$copyWithPositionsFactory) {
                Intrinsics.checkParameterIsNotNull((Object)$this$copyWithPositionsFactory, (String)"$receiver");
                return new EpubPositionListFactory(this.$container, $this$copyWithPositionsFactory.getReadingOrder(), MetadataKt.getPresentation((org.readium.r2.shared.publication.Metadata)$this$copyWithPositionsFactory.getMetadata()), 1024L);
            }
            {
                this.$container = container;
                super(1);
            }
        });
        bl2 = false;
        boolean bl4 = false;
        Publication $this$apply2 = publication2;
        boolean bl5 = false;
        $this$apply2.getInternalData().put("type", "epub");
        $this$apply2.getInternalData().put("rootfile", opfPath);
        this.setLayoutStyle($this$apply2);
        Publication publication3 = publication2;
        return new PubBox(publication3, container2);
    }

    private final Container generateContainerFrom(String path) {
        if (!new File(path).exists()) {
            throw (Throwable)new ContainerError.missingFile(path);
        }
        Container container = new File(path).isDirectory() ? (Container)new DirectoryContainer(path, MediaType.Companion.getEPUB().toString()) : (Container)new ArchiveContainer(path, MediaType.Companion.getEPUB().toString());
        container.setDrm(container.dataLength("META-INF/license.lcpl") > 0L ? new DRM(DRM.Brand.lcp) : null);
        return container;
    }

    private final String getRootFilePath(ElementNode document) {
        Object object = document.getFirst("rootfiles", "urn:oasis:names:tc:opendocument:xmlns:container");
        if (object == null || (object = object.getFirst("rootfile", "urn:oasis:names:tc:opendocument:xmlns:container")) == null || (object = object.getAttr("full-path")) == null) {
            object = "content.opf";
        }
        return object;
    }

    private final void setLayoutStyle(@NotNull Publication $this$setLayoutStyle) {
        block2: {
            $this$setLayoutStyle.setCssStyle($this$setLayoutStyle.getContentLayout().getCssId());
            Map<ReadiumCSSName, Boolean> map = EPUBConstant.INSTANCE.getUserSettingsUIPreset().get($this$setLayoutStyle.getContentLayout());
            if (map == null) break block2;
            Map<ReadiumCSSName, Boolean> map2 = map;
            boolean bl = false;
            boolean bl2 = false;
            Map<ReadiumCSSName, Boolean> it = map2;
            boolean bl3 = false;
            if ($this$setLayoutStyle.getType() == Publication.TYPE.WEBPUB) {
                $this$setLayoutStyle.setUserSettingsUIPreset(EPUBConstant.INSTANCE.getForceScrollPreset());
            } else {
                $this$setLayoutStyle.setUserSettingsUIPreset(it);
            }
        }
    }

    private final ElementNode parseXmlDocument(String path, Container container) {
        Object object;
        try {
            object = container.data(path);
        }
        catch (Exception e) {
            Timber.e((Throwable)e, (String)("Missing File : " + path), (Object[])new Object[0]);
            return null;
        }
        byte[] data = object;
        try {
            object = data;
            XmlParser xmlParser = new XmlParser(false, false, 3, null);
            boolean e = false;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            object = xmlParser.parse((InputStream)byteArrayInputStream);
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    private final Map<String, Encryption> parseEncryptionData(Container container) {
        Map map;
        if (container.dataLength("META-INF/encryption.xml") > 0L) {
            Map<String, Encryption> map2;
            boolean bl;
            ElementNode elementNode;
            ElementNode elementNode2 = this.parseXmlDocument("META-INF/encryption.xml", container);
            if (elementNode2 != null) {
                elementNode = elementNode2;
                bl = false;
                boolean bl2 = false;
                ElementNode it = elementNode;
                boolean bl3 = false;
                map2 = EncryptionParser.INSTANCE.parse(it, container.getDrm());
            } else {
                map2 = null;
            }
            elementNode = map2;
            bl = false;
            map = elementNode;
            if (map == null) {
                map = MapsKt.emptyMap();
            }
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    private final Map<String, List<Link>> parseNavigationData(PackageDocument packageDocument, Container container) {
        Map<String, List<Link>> map;
        ElementNode it;
        boolean bl;
        boolean bl2;
        ElementNode elementNode;
        Object it2;
        Object element$iv;
        boolean $i$f$firstOrNull;
        Object $this$firstOrNull$iv;
        if (packageDocument.getEpubVersion() < 3.0) {
            Item ncxItem;
            Object v0;
            block13: {
                $this$firstOrNull$iv = packageDocument.getManifest();
                $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    Item it3 = (Item)element$iv;
                    boolean bl3 = false;
                    if (!MediaType.Companion.getNCX().contains(it3.getMediaType())) continue;
                    v0 = element$iv;
                    break block13;
                }
                v0 = null;
            }
            Item item = ncxItem = (Item)v0;
            if (item != null) {
                $this$firstOrNull$iv = item;
                $i$f$firstOrNull = false;
                boolean bl4 = false;
                it2 = $this$firstOrNull$iv;
                boolean bl5 = false;
                String ncxPath = URLHelperKt.normalize((String)packageDocument.getPath(), (String)ncxItem.getHref());
                ElementNode elementNode2 = this.parseXmlDocument(ncxPath, container);
                if (elementNode2 != null) {
                    elementNode = elementNode2;
                    bl2 = false;
                    bl = false;
                    it = elementNode;
                    boolean bl6 = false;
                    map = NcxParser.INSTANCE.parse(it, ncxPath);
                } else {
                    map = null;
                }
            } else {
                map = null;
            }
        } else {
            Item navItem;
            Object v4;
            block14: {
                $this$firstOrNull$iv = packageDocument.getManifest();
                $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    Item it4 = (Item)element$iv;
                    boolean bl7 = false;
                    if (!it4.getProperties().contains("http://idpf.org/epub/vocab/package/item/#nav")) continue;
                    v4 = element$iv;
                    break block14;
                }
                v4 = null;
            }
            Item item = navItem = (Item)v4;
            if (item != null) {
                Item item2 = item;
                boolean bl8 = false;
                boolean bl9 = false;
                it2 = item2;
                boolean bl10 = false;
                String navPath = URLHelperKt.normalize((String)packageDocument.getPath(), (String)navItem.getHref());
                ElementNode elementNode3 = this.parseXmlDocument(navPath, container);
                if (elementNode3 != null) {
                    elementNode = elementNode3;
                    bl2 = false;
                    bl = false;
                    it = elementNode;
                    boolean bl11 = false;
                    map = NavigationDocumentParser.INSTANCE.parse(it, navPath);
                } else {
                    map = null;
                }
            } else {
                map = null;
            }
        }
        Map<String, List<Link>> map2 = map;
        boolean bl12 = false;
        Map<String, List<Link>> map3 = map2;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        return map3;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseDisplayOptions(Container container) {
        Map map;
        ElementNode displayOptionsXml;
        Object object;
        ElementNode elementNode = this.parseXmlDocument("META-INF/com.kobobooks.display-options.xml", container);
        if (elementNode == null) {
            elementNode = this.parseXmlDocument("META-INF/com.kobobooks.display-options.xml", container);
        }
        if ((object = (displayOptionsXml = elementNode)) != null && (object = object.getFirst("platform", "")) != null && (object = object.get("option", "")) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ElementNode element = (ElementNode)element$iv$iv;
                boolean bl2 = false;
                String optName = element.getAttr("name");
                String optVal = element.getText();
                if ((optName != null && optVal != null ? new Pair((Object)optName, (Object)optVal) : null) == null) continue;
                pair = pair;
                boolean bl3 = false;
                boolean bl4 = false;
                Pair it$iv$iv = pair;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else {
            map = null;
        }
        Map map2 = map;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        return map3;
    }

    @Deprecated(message="This is done automatically in [parse], you can remove the call to [fillEncryption]", replaceWith=@ReplaceWith(imports={}, expression=""))
    @NotNull
    public final Pair<Container, Publication> fillEncryption(@NotNull Container container, @NotNull Publication publication2, @Nullable DRM drm) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)publication2, (String)"publication");
        return new Pair((Object)container, (Object)publication2);
    }
}

