/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.fetcher;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.format.MediaType;
import org.readium.r2.shared.publication.Publication;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.fetcher.ContentFilters;
import org.readium.r2.streamer.fetcher.ContentFiltersCbz;
import org.readium.r2.streamer.fetcher.ContentFiltersEpub;
import org.readium.r2.streamer.fetcher.ContentFiltersLcp;
import org.readium.r2.streamer.server.Resources;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0007J \u0010\u001d\u001a\u0004\u0018\u00010\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/readium/r2/streamer/fetcher/Fetcher;", "", "publication", "Lorg/readium/r2/shared/publication/Publication;", "container", "Lorg/readium/r2/streamer/container/Container;", "userPropertiesPath", "", "customResources", "Lorg/readium/r2/streamer/server/Resources;", "(Lorg/readium/r2/shared/publication/Publication;Lorg/readium/r2/streamer/container/Container;Ljava/lang/String;Lorg/readium/r2/streamer/server/Resources;)V", "getContainer", "()Lorg/readium/r2/streamer/container/Container;", "setContainer", "(Lorg/readium/r2/streamer/container/Container;)V", "contentFilters", "Lorg/readium/r2/streamer/fetcher/ContentFilters;", "getPublication", "()Lorg/readium/r2/shared/publication/Publication;", "setPublication", "(Lorg/readium/r2/shared/publication/Publication;)V", "rootFileDirectory", "data", "", "path", "dataLength", "", "dataStream", "Ljava/io/InputStream;", "getContentFilters", "mimeType", "r2-streamer_release"})
public final class Fetcher {
    private String rootFileDirectory;
    private ContentFilters contentFilters;
    @NotNull
    private Publication publication;
    @NotNull
    private Container container;
    private final String userPropertiesPath;

    @Nullable
    public final byte[] data(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        byte[] data = this.container.data(path);
        if (data != null) {
            ContentFilters contentFilters = this.contentFilters;
            data = contentFilters != null ? contentFilters.apply(data, this.publication, this.container, path) : null;
        }
        return data;
    }

    @NotNull
    public final InputStream dataStream(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Object inputStream = this.container.dataInputStream(path);
        Object object = this.contentFilters;
        if (object == null || (object = object.apply((InputStream)inputStream, this.publication, this.container, path)) == null) {
            object = inputStream;
        }
        inputStream = object;
        return inputStream;
    }

    public final long dataLength(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String relativePath = this.rootFileDirectory + path;
        if (this.publication.resourceWithHref(path) == null) {
            throw (Throwable)new Exception("Missing file");
        }
        return this.container.dataLength(relativePath);
    }

    private final ContentFilters getContentFilters(String mimeType, Resources customResources) {
        MediaType mediaType2;
        String string;
        String string2 = mimeType;
        if (string2 != null) {
            string = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            mediaType2 = MediaType.Companion.parse(it);
        } else {
            mediaType2 = null;
        }
        MediaType mediaType3 = mediaType2;
        string = mediaType3;
        return Intrinsics.areEqual((Object)string, (Object)MediaType.Companion.getEPUB()) ? (ContentFilters)new ContentFiltersEpub(this.userPropertiesPath, customResources) : (Intrinsics.areEqual((Object)string, (Object)MediaType.Companion.getCBZ()) ? (ContentFilters)new ContentFiltersCbz() : (Intrinsics.areEqual((Object)string, (Object)MediaType.Companion.getLCP_PROTECTED_AUDIOBOOK()) || Intrinsics.areEqual((Object)string, (Object)MediaType.Companion.getLCP_PROTECTED_PDF()) ? (ContentFilters)new ContentFiltersLcp() : null));
    }

    static /* synthetic */ ContentFilters getContentFilters$default(Fetcher fetcher, String string, Resources resources, int n, Object object) {
        if ((n & 2) != 0) {
            resources = null;
        }
        return fetcher.getContentFilters(string, resources);
    }

    @NotNull
    public final Publication getPublication() {
        return this.publication;
    }

    public final void setPublication(@NotNull Publication publication2) {
        Intrinsics.checkParameterIsNotNull((Object)publication2, (String)"<set-?>");
        this.publication = publication2;
    }

    @NotNull
    public final Container getContainer() {
        return this.container;
    }

    public final void setContainer(@NotNull Container container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"<set-?>");
        this.container = container;
    }

    public Fetcher(@NotNull Publication publication2, @NotNull Container container, @Nullable String userPropertiesPath, @Nullable Resources customResources) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)publication2, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.publication = publication2;
        this.container = container;
        this.userPropertiesPath = userPropertiesPath;
        CharSequence charSequence2 = this.container.getRootFile().getRootFilePath();
        boolean bl = false;
        CharSequence charSequence3 = charSequence2;
        boolean bl2 = false;
        if (charSequence3.length() == 0) {
            boolean bl3 = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        String string = (String)charSequence;
        if (string == null) {
            throw (Throwable)new Exception("Missing root file");
        }
        String rootFilePath = string;
        charSequence2 = rootFilePath;
        bl = false;
        if (charSequence2.length() > 0 && StringsKt.contains$default((CharSequence)rootFilePath, (char)'/', (boolean)false, (int)2, null)) {
            this.rootFileDirectory = StringsKt.replaceAfterLast((String)rootFilePath, (String)"/", (String)"", (String)rootFilePath);
            this.rootFileDirectory = StringsKt.dropLast((String)this.rootFileDirectory, (int)1);
        } else {
            this.rootFileDirectory = "";
        }
        this.contentFilters = this.getContentFilters(this.container.getRootFile().getMimetype(), customResources);
    }

    public /* synthetic */ Fetcher(Publication publication2, Container container, String string, Resources resources, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            resources = null;
        }
        this(publication2, container, string, resources);
    }
}

