/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.container;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.RootFile;
import org.readium.r2.shared.drm.DRM;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.container.ContainerError;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001!B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lorg/readium/r2/streamer/container/FileContainer;", "Lorg/readium/r2/streamer/container/Container;", "path", "", "mimetype", "(Ljava/lang/String;Ljava/lang/String;)V", "drm", "Lorg/readium/r2/shared/drm/DRM;", "getDrm", "()Lorg/readium/r2/shared/drm/DRM;", "setDrm", "(Lorg/readium/r2/shared/drm/DRM;)V", "files", "", "Lorg/readium/r2/streamer/container/FileContainer$File;", "getFiles", "()Ljava/util/Map;", "setFiles", "(Ljava/util/Map;)V", "rootFile", "Lorg/readium/r2/shared/RootFile;", "getRootFile", "()Lorg/readium/r2/shared/RootFile;", "setRootFile", "(Lorg/readium/r2/shared/RootFile;)V", "data", "", "relativePath", "dataInputStream", "Ljava/io/InputStream;", "dataLength", "", "fileAt", "File", "r2-streamer_release"})
public final class FileContainer
implements Container {
    @NotNull
    private Map<String, File> files;
    @NotNull
    private RootFile rootFile;
    @Nullable
    private DRM drm;

    @NotNull
    public final Map<String, File> getFiles() {
        return this.files;
    }

    public final void setFiles(@NotNull Map<String, File> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.files = map;
    }

    @Override
    @NotNull
    public RootFile getRootFile() {
        return this.rootFile;
    }

    @Override
    public void setRootFile(@NotNull RootFile rootFile) {
        Intrinsics.checkParameterIsNotNull((Object)rootFile, (String)"<set-?>");
        this.rootFile = rootFile;
    }

    @Override
    @Nullable
    public DRM getDrm() {
        return this.drm;
    }

    @Override
    public void setDrm(@Nullable DRM dRM) {
        this.drm = dRM;
    }

    @Override
    @NotNull
    public byte[] data(@NotNull String relativePath) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                object = this.fileAt(relativePath);
                if (object == null) break block2;
                byte[] byArray = ((File)object).getBytes();
                object = byArray;
                if (byArray != null) break block3;
            }
            throw (Throwable)ContainerError.fileNotFound.INSTANCE;
        }
        return object;
    }

    @Override
    public long dataLength(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Object object = this.fileAt(relativePath);
        if (object == null || (object = ((File)object).getLength()) == null) {
            throw (Throwable)ContainerError.fileNotFound.INSTANCE;
        }
        return (Long)object;
    }

    @Override
    @NotNull
    public InputStream dataInputStream(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Object object = this.fileAt(relativePath);
        if (object == null || (object = ((File)object).stream()) == null) {
            throw (Throwable)ContainerError.fileNotFound.INSTANCE;
        }
        return object;
    }

    private final File fileAt(String path) {
        File file = this.files.get(path);
        if (file == null) {
            file = this.files.get('/' + path);
        }
        return file;
    }

    public FileContainer(@NotNull String path, @NotNull String mimetype) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)mimetype, (String)"mimetype");
        FileContainer fileContainer = this;
        boolean bl = false;
        fileContainer.files = map = (Map)new LinkedHashMap();
        this.rootFile = new RootFile(path, null, mimetype, null, 10, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH&R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/readium/r2/streamer/container/FileContainer$File;", "", "()V", "bytes", "", "getBytes", "()[B", "length", "", "getLength", "()Ljava/lang/Long;", "stream", "Ljava/io/InputStream;", "Bytes", "Path", "Lorg/readium/r2/streamer/container/FileContainer$File$Path;", "Lorg/readium/r2/streamer/container/FileContainer$File$Bytes;", "r2-streamer_release"})
    public static abstract class File {
        @Nullable
        public abstract byte[] getBytes();

        @Nullable
        public abstract Long getLength();

        @Nullable
        public abstract InputStream stream();

        private File() {
        }

        public /* synthetic */ File(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/readium/r2/streamer/container/FileContainer$File$Path;", "Lorg/readium/r2/streamer/container/FileContainer$File;", "path", "", "(Ljava/lang/String;)V", "bytes", "", "getBytes", "()[B", "length", "", "getLength", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "stream", "Ljava/io/InputStream;", "toString", "r2-streamer_release"})
        public static final class Path
        extends File {
            @Nullable
            private final Long length;
            @NotNull
            private final String path;

            @Override
            @Nullable
            public byte[] getBytes() {
                byte[] byArray;
                boolean $i$f$tryOrNull = false;
                byte[] default$iv$iv = null;
                boolean $i$f$tryOr = false;
                try {
                    boolean bl = false;
                    byArray = TextStreamsKt.readBytes((URL)new URL(this.path));
                }
                catch (Exception e$iv$iv) {
                    byArray = default$iv$iv;
                }
                return byArray;
            }

            @Override
            @Nullable
            public Long getLength() {
                return this.length;
            }

            @Override
            @Nullable
            public InputStream stream() {
                BufferedInputStream bufferedInputStream;
                boolean $i$f$tryOrNull = false;
                BufferedInputStream default$iv$iv = null;
                boolean $i$f$tryOr = false;
                try {
                    boolean bl = false;
                    InputStream inputStream = new FileInputStream(this.path);
                    int n = 8192;
                    boolean bl2 = false;
                    bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
                }
                catch (Exception e$iv$iv) {
                    bufferedInputStream = default$iv$iv;
                }
                return bufferedInputStream;
            }

            @NotNull
            public final String getPath() {
                return this.path;
            }

            public Path(@NotNull String path) {
                Long l;
                Long l2;
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                super(null);
                this.path = path;
                Path path2 = this;
                boolean $i$f$tryOrNull = false;
                Long default$iv$iv = null;
                boolean $i$f$tryOr = false;
                try {
                    boolean bl = false;
                    l2 = new java.io.File(this.path).length();
                }
                catch (Exception e$iv$iv) {
                    l2 = default$iv$iv;
                }
                path2.length = l = l2;
            }

            @NotNull
            public final String component1() {
                return this.path;
            }

            @NotNull
            public final Path copy(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                return new Path(path);
            }

            public static /* synthetic */ Path copy$default(Path path, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = path.path;
                }
                return path.copy(string);
            }

            @NotNull
            public String toString() {
                return "Path(path=" + this.path + ")";
            }

            public int hashCode() {
                String string = this.path;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Path)) break block3;
                        Path path = (Path)object;
                        if (!Intrinsics.areEqual((Object)this.path, (Object)path.path)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/readium/r2/streamer/container/FileContainer$File$Bytes;", "Lorg/readium/r2/streamer/container/FileContainer$File;", "bytes", "", "([B)V", "getBytes", "()[B", "length", "", "getLength", "()Ljava/lang/Long;", "Ljava/lang/Long;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "stream", "Ljava/io/InputStream;", "toString", "", "r2-streamer_release"})
        public static final class Bytes
        extends File {
            @Nullable
            private final Long length;
            @NotNull
            private final byte[] bytes;

            @Override
            @Nullable
            public Long getLength() {
                return this.length;
            }

            @Override
            @Nullable
            public InputStream stream() {
                return new ByteArrayInputStream(this.getBytes());
            }

            @Override
            @NotNull
            public byte[] getBytes() {
                return this.bytes;
            }

            public Bytes(@NotNull byte[] bytes) {
                Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
                super(null);
                this.bytes = bytes;
                this.length = this.getBytes().length;
            }

            @NotNull
            public final byte[] component1() {
                return this.getBytes();
            }

            @NotNull
            public final Bytes copy(@NotNull byte[] bytes) {
                Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
                return new Bytes(bytes);
            }

            public static /* synthetic */ Bytes copy$default(Bytes bytes, byte[] byArray, int n, Object object) {
                if ((n & 1) != 0) {
                    byArray = bytes.getBytes();
                }
                return bytes.copy(byArray);
            }

            @NotNull
            public String toString() {
                return "Bytes(bytes=" + Arrays.toString(this.getBytes()) + ")";
            }

            public int hashCode() {
                byte[] byArray = this.getBytes();
                return byArray != null ? Arrays.hashCode(byArray) : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Bytes)) break block3;
                        Bytes bytes = (Bytes)object;
                        if (!Intrinsics.areEqual((Object)this.getBytes(), (Object)bytes.getBytes())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

