/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.container;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.RootFile;
import org.readium.r2.shared.drm.DRM;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.container.ContainerError;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lorg/readium/r2/streamer/container/ArchiveContainer;", "Lorg/readium/r2/streamer/container/Container;", "path", "", "mimetype", "(Ljava/lang/String;Ljava/lang/String;)V", "archive", "Ljava/util/zip/ZipFile;", "getArchive", "()Ljava/util/zip/ZipFile;", "drm", "Lorg/readium/r2/shared/drm/DRM;", "getDrm", "()Lorg/readium/r2/shared/drm/DRM;", "setDrm", "(Lorg/readium/r2/shared/drm/DRM;)V", "rootFile", "Lorg/readium/r2/shared/RootFile;", "getRootFile", "()Lorg/readium/r2/shared/RootFile;", "setRootFile", "(Lorg/readium/r2/shared/RootFile;)V", "data", "", "relativePath", "dataInputStream", "Ljava/io/InputStream;", "dataLength", "", "getEntry", "Ljava/util/zip/ZipEntry;", "r2-streamer_release"})
public class ArchiveContainer
implements Container {
    @NotNull
    private RootFile rootFile;
    @Nullable
    private DRM drm;
    @NotNull
    private final ZipFile archive;

    @Override
    @NotNull
    public RootFile getRootFile() {
        return this.rootFile;
    }

    @Override
    public void setRootFile(@NotNull RootFile rootFile) {
        Intrinsics.checkParameterIsNotNull((Object)rootFile, (String)"<set-?>");
        this.rootFile = rootFile;
    }

    @Override
    @Nullable
    public DRM getDrm() {
        return this.drm;
    }

    @Override
    public void setDrm(@Nullable DRM dRM) {
        this.drm = dRM;
    }

    @NotNull
    public final ZipFile getArchive() {
        return this.archive;
    }

    @Override
    @NotNull
    public byte[] data(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        ZipEntry zipEntry = this.getEntry(relativePath);
        InputStream inputStream = this.archive.getInputStream(zipEntry);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Ref.IntRef readLength = new Ref.IntRef();
        byte[] buffer = new byte[16384];
        while (true) {
            int n = inputStream.read(buffer);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            readLength.element = it;
            if (!(it != -1)) break;
            outputStream.write(buffer, 0, readLength.element);
        }
        inputStream.close();
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"outputStream.toByteArray()");
        return byArray;
    }

    @Override
    public long dataLength(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        try {
            return this.getEntry(relativePath).getSize();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    @NotNull
    public InputStream dataInputStream(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        InputStream inputStream = this.archive.getInputStream(this.getEntry(relativePath));
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"archive.getInputStream(getEntry(relativePath))");
        return inputStream;
    }

    private final ZipEntry getEntry(String relativePath) {
        String string;
        try {
            String string2 = new URI(relativePath).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URI(relativePath).path");
            string = string2;
        }
        catch (Exception e) {
            string = relativePath;
        }
        String path = string;
        path = StringsKt.removePrefix((String)path, (CharSequence)"/");
        ZipEntry zipEntry = this.archive.getEntry(path);
        if (zipEntry != null) {
            return zipEntry;
        }
        Enumeration<? extends ZipEntry> zipEntries = this.archive.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry2 = zipEntry = zipEntries.nextElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry2, (String)"zipEntry");
            if (!StringsKt.equals((String)path, (String)zipEntry2.getName(), (boolean)true)) continue;
            return zipEntry;
        }
        throw (Throwable)ContainerError.fileNotFound.INSTANCE;
    }

    public ArchiveContainer(@NotNull String path, @NotNull String mimetype) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)mimetype, (String)"mimetype");
        this.rootFile = new RootFile(path, null, mimetype, null, 10, null);
        this.archive = new ZipFile(path);
    }
}

