/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.server;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nanohttpd.router.RouterNanoHTTPD;
import org.readium.r2.shared.Injectable;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.fetcher.Fetcher;
import org.readium.r2.streamer.server.Fonts;
import org.readium.r2.streamer.server.Resources;
import org.readium.r2.streamer.server.handler.CSSHandler;
import org.readium.r2.streamer.server.handler.FontHandler;
import org.readium.r2.streamer.server.handler.JSHandler;
import org.readium.r2.streamer.server.handler.ManifestHandler;
import org.readium.r2.streamer.server.handler.MediaOverlayHandler;
import org.readium.r2.streamer.server.handler.ResourceHandler;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\u0006J \u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0006H\u0002J.\u0010$\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\b\b\u0002\u0010&\u001a\u00020\u000e2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u001e\u0010)\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0006J\u001e\u0010*\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(J\u0016\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-2\u0006\u0010 \u001a\u00020!J\u000e\u0010.\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-J\u000e\u0010/\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-J\u0014\u00100\u001a\u00020\u0015*\u00020\u001f2\u0006\u00101\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/readium/r2/streamer/server/AbstractServer;", "Lorg/nanohttpd/router/RouterNanoHTTPD;", "port", "", "(I)V", "CSS_HANDLE", "", "FONT_HANDLE", "JSON_MANIFEST_HANDLE", "JS_HANDLE", "MANIFEST_HANDLE", "MANIFEST_ITEM_HANDLE", "MEDIA_OVERLAY_HANDLE", "containsMediaOverlay", "", "customResources", "Lorg/readium/r2/streamer/server/Resources;", "fonts", "Lorg/readium/r2/streamer/server/Fonts;", "resources", "addEpub", "", "publication", "Lorg/readium/r2/shared/Publication;", "container", "Lorg/readium/r2/streamer/container/Container;", "fileName", "userPropertiesPath", "addFont", "name", "inputStream", "Ljava/io/InputStream;", "context", "Landroid/content/Context;", "addLinks", "filePath", "addResource", "body", "custom", "injectable", "Lorg/readium/r2/shared/Injectable;", "loadCustomFont", "loadCustomResource", "loadR2FontResources", "assets", "Landroid/content/res/AssetManager;", "loadR2ScriptResources", "loadReadiumCSSResources", "toFile", "path", "r2-streamer_release"})
public abstract class AbstractServer
extends RouterNanoHTTPD {
    private final String MANIFEST_HANDLE = "/manifest";
    private final String JSON_MANIFEST_HANDLE = "/manifest.json";
    private final String MANIFEST_ITEM_HANDLE = "/(.*)";
    private final String MEDIA_OVERLAY_HANDLE = "/media-overlay";
    private final String CSS_HANDLE;
    private final String JS_HANDLE;
    private final String FONT_HANDLE;
    private boolean containsMediaOverlay;
    private final Resources resources;
    private final Resources customResources;
    private final Fonts fonts;
    private int port;

    private final void addResource(String name, String body, boolean custom, Injectable injectable) {
        if (custom) {
            this.customResources.add(name, body, injectable);
        }
        Resources.add$default(this.resources, name, body, null, 4, null);
    }

    static /* synthetic */ void addResource$default(AbstractServer abstractServer, String string, String string2, boolean bl, Injectable injectable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addResource");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            injectable = null;
        }
        abstractServer.addResource(string, string2, bl, injectable);
    }

    private final void addFont(String name, InputStream inputStream, Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        File file = context.getFilesDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.filesDir");
        File dir = new File(stringBuilder.append(file.getPath()).append("/").append(Injectable.Font.getRawValue()).append("/").toString());
        dir.mkdirs();
        StringBuilder stringBuilder2 = new StringBuilder();
        File file2 = context.getFilesDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"context.filesDir");
        this.toFile(inputStream, stringBuilder2.append(file2.getPath()).append("/").append(Injectable.Font.getRawValue()).append("/").append(name).toString());
        StringBuilder stringBuilder3 = new StringBuilder();
        File file3 = context.getFilesDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"context.filesDir");
        File file4 = new File(stringBuilder3.append(file3.getPath()).append("/").append(Injectable.Font.getRawValue()).append("/").append(name).toString());
        this.fonts.add(name, file4);
    }

    public final void loadReadiumCSSResources(@NotNull AssetManager assets) {
        Intrinsics.checkParameterIsNotNull((Object)assets, (String)"assets");
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/ltr/ReadiumCSS-after.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "ltr-after.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/ltr/ReadiumCSS-before.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "ltr-before.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/ltr/ReadiumCSS-default.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "ltr-default.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/rtl/ReadiumCSS-after.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "rtl-after.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/rtl/ReadiumCSS-before.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "rtl-before.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/rtl/ReadiumCSS-default.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "rtl-default.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/cjk-vertical/ReadiumCSS-after.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "cjkv-after.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/cjk-vertical/ReadiumCSS-before.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "cjkv-before.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/cjk-vertical/ReadiumCSS-default.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "cjkv-default.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/cjk-horizontal/ReadiumCSS-after.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "cjkh-after.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/cjk-horizontal/ReadiumCSS-before.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "cjkh-before.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open("static/" + Injectable.Style.getRawValue() + "/cjk-horizontal/ReadiumCSS-default.css"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"sta\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "cjkh-default.css", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
    }

    public final void loadR2ScriptResources(@NotNull AssetManager assets) {
        Intrinsics.checkParameterIsNotNull((Object)assets, (String)"assets");
        try {
            String string = new Scanner(assets.open(Injectable.Script.getRawValue() + "/touchHandling.js"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(Inje\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "touchHandling.js", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
        try {
            String string = new Scanner(assets.open(Injectable.Script.getRawValue() + "/utils.js"), "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(Inje\u2026seDelimiter(\"\\\\A\").next()");
            AbstractServer.addResource$default(this, "utils.js", string, false, null, 12, null);
        }
        catch (IOException e) {
        }
    }

    public final void loadR2FontResources(@NotNull AssetManager assets, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)assets, (String)"assets");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            InputStream inputStream = assets.open("static/" + Injectable.Font.getRawValue() + "/OpenDyslexic-Regular.otf");
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"assets.open(\"static/\"+ I\u2026penDyslexic-Regular.otf\")");
            this.addFont("OpenDyslexic-Regular.otf", inputStream, context);
        }
        catch (IOException e) {
        }
    }

    public final void loadCustomResource(@NotNull InputStream inputStream, @NotNull String fileName, @NotNull Injectable injectable) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)injectable, (String)"injectable");
        try {
            String string = new Scanner(inputStream, "utf-8").useDelimiter("\\A").next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(inputStream, \"ut\u2026seDelimiter(\"\\\\A\").next()");
            this.addResource(fileName, string, true, injectable);
        }
        catch (IOException e) {
        }
    }

    public final void loadCustomFont(@NotNull InputStream inputStream, @NotNull Context context, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        try {
            this.addFont(fileName, inputStream, context);
        }
        catch (IOException e) {
        }
    }

    public final void addEpub(@NotNull Publication publication, @NotNull Container container, @NotNull String fileName, @Nullable String userPropertiesPath) {
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Fetcher fetcher = new Fetcher(publication, container, userPropertiesPath, this.customResources);
        this.addLinks(publication, fileName);
        publication.addSelfLink(fileName, new URL("http://127.0.0.1:" + this.port));
        if (this.containsMediaOverlay) {
            this.addRoute(fileName + this.MEDIA_OVERLAY_HANDLE, MediaOverlayHandler.class, new Object[]{fetcher});
        }
        this.addRoute(fileName + this.JSON_MANIFEST_HANDLE, ManifestHandler.class, new Object[]{fetcher});
        this.addRoute(fileName + this.MANIFEST_HANDLE, ManifestHandler.class, new Object[]{fetcher});
        this.addRoute(fileName + this.MANIFEST_ITEM_HANDLE, ResourceHandler.class, new Object[]{fetcher});
        this.addRoute(this.JS_HANDLE, JSHandler.class, new Object[]{this.resources});
        this.addRoute(this.CSS_HANDLE, CSSHandler.class, new Object[]{this.resources});
        this.addRoute(this.FONT_HANDLE, FontHandler.class, new Object[]{this.fonts});
    }

    private final void addLinks(Publication publication, String filePath) {
        this.containsMediaOverlay = false;
        for (Link link : publication.getOtherLinks()) {
            if (!link.getRel().contains("media-overlay")) continue;
            this.containsMediaOverlay = true;
            String string = link.getHref();
            link.setHref(string != null ? StringsKt.replace$default((String)string, (String)"port", (String)("127.0.0.1:" + this.getListeningPort() + filePath), (boolean)false, (int)4, null) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void toFile(@NotNull InputStream $this$toFile, String path) {
        Closeable closeable = $this$toFile;
        boolean bl = false;
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl2 = false;
            Object object = new File(path);
            boolean bl3 = false;
            object = new FileOutputStream((File)object);
            bl3 = false;
            Throwable throwable2 = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl4 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public AbstractServer(int port) {
        super("127.0.0.1", port);
        this.port = port;
        this.MANIFEST_HANDLE = "/manifest";
        this.JSON_MANIFEST_HANDLE = "/manifest.json";
        this.MANIFEST_ITEM_HANDLE = "/(.*)";
        this.MEDIA_OVERLAY_HANDLE = "/media-overlay";
        this.CSS_HANDLE = "/" + Injectable.Style.getRawValue() + "/(.*)";
        this.JS_HANDLE = "/" + Injectable.Script.getRawValue() + "/(.*)";
        this.FONT_HANDLE = "/" + Injectable.Font.getRawValue() + "/(.*)";
        this.resources = new Resources();
        this.customResources = new Resources();
        this.fonts = new Fonts();
    }
}

