/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.ContentLayoutStyle;
import org.readium.r2.shared.Encryption;
import org.readium.r2.shared.LangType;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.drm.DRM;
import org.readium.r2.shared.drm.DRMLicense;
import org.readium.r2.shared.parser.xml.Node;
import org.readium.r2.shared.parser.xml.XmlParser;
import org.readium.r2.streamer.container.ArchiveContainer;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.container.ContainerError;
import org.readium.r2.streamer.container.DirectoryContainer;
import org.readium.r2.streamer.parser.PubBox;
import org.readium.r2.streamer.parser.PublicationParser;
import org.readium.r2.streamer.parser.epub.EPUBConstant;
import org.readium.r2.streamer.parser.epub.EncryptionParser;
import org.readium.r2.streamer.parser.epub.NCXParser;
import org.readium.r2.streamer.parser.epub.NavigationDocumentParser;
import org.readium.r2.streamer.parser.epub.OPFParser;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001a\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u001a\u0010$\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u001a\u0010'\u001a\u00020(2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u000f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/readium/r2/streamer/parser/epub/EpubParser;", "Lorg/readium/r2/streamer/parser/PublicationParser;", "()V", "encp", "Lorg/readium/r2/streamer/parser/epub/EncryptionParser;", "ncxp", "Lorg/readium/r2/streamer/parser/epub/NCXParser;", "ndp", "Lorg/readium/r2/streamer/parser/epub/NavigationDocumentParser;", "opfParser", "Lorg/readium/r2/streamer/parser/epub/OPFParser;", "fillEncryption", "Lkotlin/Pair;", "Lorg/readium/r2/streamer/container/Container;", "Lorg/readium/r2/shared/Publication;", "container", "publication", "drm", "Lorg/readium/r2/shared/drm/DRM;", "fillEncryptionProfile", "generateContainerFrom", "path", "", "getRootFilePath", "data", "", "parse", "Lorg/readium/r2/streamer/parser/PubBox;", "fileAtPath", "title", "parseEncryption", "", "parseNavigationDocument", "parseNcxDocument", "scanForDRM", "setLayoutStyle", "xmlAsByteArray", "link", "Lorg/readium/r2/shared/Link;", "xmlDocumentForResource", "Lorg/readium/r2/shared/parser/xml/XmlParser;", "r2-streamer_release"})
public final class EpubParser
implements PublicationParser {
    private final OPFParser opfParser = new OPFParser();
    private final NavigationDocumentParser ndp = new NavigationDocumentParser();
    private final NCXParser ncxp = new NCXParser();
    private final EncryptionParser encp = new EncryptionParser();

    private final Container generateContainerFrom(String path) {
        if (!new File(path).exists()) {
            throw (Throwable)new ContainerError.missingFile(path);
        }
        boolean isDirectory = new File(path).isDirectory();
        return (Container)((Function0)new Function0<Container>(isDirectory, path){
            final /* synthetic */ boolean $isDirectory;
            final /* synthetic */ String $path;

            @NotNull
            public final Container invoke() {
                return this.$isDirectory ? (Container)new DirectoryContainer(this.$path, "application/epub+zip") : (Container)new ArchiveContainer(this.$path, "application/epub+zip");
            }
            {
                this.$isDirectory = bl;
                this.$path = string;
                super(0);
            }
        }).invoke();
    }

    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath, @NotNull String title) {
        byte[] documentData;
        byte[] byArray;
        byte[] e2;
        Container container;
        Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        try {
            container = this.generateContainerFrom(fileAtPath);
        }
        catch (Exception e2) {
            return null;
        }
        Container container2 = container;
        try {
            e2 = container2.data("META-INF/container.xml");
        }
        catch (Exception e3) {
            return null;
        }
        byte[] data = e2;
        container2.getRootFile().setMimetype("application/epub+zip");
        container2.getRootFile().setRootFilePath(this.getRootFilePath(data));
        XmlParser xmlParser = new XmlParser();
        try {
            byArray = container2.data(container2.getRootFile().getRootFilePath());
        }
        catch (Exception e4) {
            return null;
        }
        byArray = documentData = byArray;
        XmlParser xmlParser2 = xmlParser;
        boolean bl = false;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        XmlParser.parseXml$default((XmlParser)xmlParser2, (InputStream)byteArrayInputStream, (boolean)false, (int)2, null);
        Object v = xmlParser.root().getAttributes().get("version");
        if (v == null) {
            Intrinsics.throwNpe();
        }
        String string = (String)v;
        boolean bl2 = false;
        double epubVersion = Double.parseDouble(string);
        Publication publication = this.opfParser.parseOpf(xmlParser, container2.getRootFile().getRootFilePath(), epubVersion);
        if (publication == null) {
            return null;
        }
        Publication publication2 = publication;
        DRM drm = this.scanForDRM(container2);
        this.parseEncryption(container2, publication2, drm);
        this.parseNavigationDocument(container2, publication2);
        this.parseNcxDocument(container2, publication2);
        this.setLayoutStyle(publication2);
        container2.setDrm(drm);
        return new PubBox(publication2, container2);
    }

    private final DRM scanForDRM(Container container) {
        byte[] byArray;
        try {
            byArray = container.data("META-INF/license.lcpl");
        }
        catch (Throwable e) {
            byArray = null;
        }
        if (byArray != null) {
            return new DRM(DRM.Brand.lcp);
        }
        return null;
    }

    private final String getRootFilePath(byte[] data) {
        XmlParser xmlParser = new XmlParser();
        byte[] byArray = data;
        XmlParser xmlParser2 = xmlParser;
        boolean bl = false;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        XmlParser.parseXml$default((XmlParser)xmlParser2, (InputStream)byteArrayInputStream, (boolean)false, (int)2, null);
        Object object = xmlParser.getFirst("container");
        if (object == null || (object = object.getFirst("rootfiles")) == null || (object = object.getFirst("rootfile")) == null || (object = object.getAttributes()) == null || (object = (String)object.get("full-path")) == null) {
            object = "content.opf";
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private final void setLayoutStyle(Publication publication) {
        block12: {
            langType = LangType.other;
            block8: for (String lang : publication.getMetadata().getLanguages()) {
                var5_5 = lang;
                switch (var5_5.hashCode()) {
                    case 3121: {
                        if (!var5_5.equals("ar")) ** break;
                        break;
                    }
                    case 3428: {
                        if (!var5_5.equals("ko")) ** break;
                        ** GOTO lbl22
                    }
                    case 3383: {
                        if (!var5_5.equals("ja")) ** break;
                        ** GOTO lbl22
                    }
                    case 3259: {
                        if (!var5_5.equals("fa")) ** break;
                        break;
                    }
                    case 3325: {
                        if (!var5_5.equals("he")) ** break;
                        break;
                    }
                    case 3886: {
                        if (!var5_5.equals("zh")) ** break;
lbl22:
                        // 3 sources

                        langType = LangType.cjk;
                        break block8;
                    }
                }
                langType = LangType.afh;
                break;
            }
            pageDirection = publication.getMetadata().getDirection();
            contentLayoutStyle = publication.getMetadata().contentLayoutStyle(langType, pageDirection);
            publication.setCssStyle(contentLayoutStyle.name());
            v0 = publication.getCssStyle();
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            v1 = EPUBConstant.Companion.getUserSettingsUIPreset().get(ContentLayoutStyle.Companion.layout(v0));
            if (v1 == null) break block12;
            var5_5 = v1;
            var6_6 = false;
            var7_7 = false;
            it = var5_5;
            $i$a$-let-EpubParser$setLayoutStyle$1 = false;
            if (publication.getType() == Publication.TYPE.WEBPUB) {
                publication.setUserSettingsUIPreset(EPUBConstant.Companion.getForceScrollPreset());
            } else {
                publication.setUserSettingsUIPreset((Map)it);
            }
        }
    }

    @NotNull
    public final Pair<Container, Publication> fillEncryption(@NotNull Container container, @NotNull Publication publication, @Nullable DRM drm) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        container.setDrm(drm);
        this.fillEncryptionProfile(publication, drm);
        return new Pair((Object)container, (Object)publication);
    }

    private final Publication fillEncryptionProfile(Publication publication, DRM drm) {
        DRM dRM = drm;
        if (dRM != null) {
            DRM dRM2 = dRM;
            boolean bl = false;
            boolean bl2 = false;
            DRM it = dRM2;
            boolean bl3 = false;
            for (Link link : publication.getResources()) {
                Encryption encryption = link.getProperties().getEncryption();
                if ((encryption != null ? encryption.getScheme() : null) != it.getScheme()) continue;
                Encryption encryption2 = link.getProperties().getEncryption();
                if (encryption2 == null) continue;
                DRMLicense dRMLicense = it.getLicense();
                encryption2.setProfile(dRMLicense != null ? dRMLicense.getEncryptionProfile() : null);
            }
            for (Link link : publication.getReadingOrder()) {
                Encryption encryption = link.getProperties().getEncryption();
                if ((encryption != null ? encryption.getScheme() : null) != it.getScheme()) continue;
                Encryption encryption3 = link.getProperties().getEncryption();
                if (encryption3 == null) continue;
                DRMLicense dRMLicense = it.getLicense();
                encryption3.setProfile(dRMLicense != null ? dRMLicense.getEncryptionProfile() : null);
            }
        }
        return publication;
    }

    private final void parseEncryption(Container container, Publication publication, DRM drm) {
        byte[] byArray;
        try {
            byArray = container.data("META-INF/encryption.xml");
        }
        catch (Exception e) {
            return;
        }
        byte[] documentData = byArray;
        XmlParser document = new XmlParser();
        byte[] e = documentData;
        XmlParser xmlParser = document;
        boolean bl = false;
        Object object = new ByteArrayInputStream(e);
        xmlParser.parseXml((InputStream)object, true);
        Object object2 = document.getFirst("encryption");
        if (object2 == null || (object2 = object2.get("EncryptedData")) == null) {
            return;
        }
        Object encryptedDataElements = object2;
        Iterator iterator = encryptedDataElements.iterator();
        while (iterator.hasNext()) {
            Object object3;
            String keyInfoUri;
            String string;
            Node it;
            boolean bl2;
            boolean bl3;
            Node node;
            Node encryptedDataElement = (Node)iterator.next();
            Encryption encryption = new Encryption();
            Node node2 = encryptedDataElement.getFirst("KeyInfo");
            if (node2 != null && (node2 = node2.getFirst("RetrievalMethod")) != null) {
                node = node2;
                bl3 = false;
                bl2 = false;
                it = node;
                boolean bl4 = false;
                string = (String)it.getAttributes().get("URI");
            } else {
                string = keyInfoUri = null;
            }
            if (Intrinsics.areEqual(keyInfoUri, (Object)"license.lcpl#/encryption/content_key")) {
                DRM dRM = drm;
                if ((dRM != null ? dRM.getBrand() : null) == DRM.Brand.lcp) {
                    encryption.setScheme(DRM.Scheme.lcp);
                }
            }
            Encryption encryption2 = encryption;
            if (encryptedDataElement.getFirst("EncryptionMethod") != null) {
                xmlParser = encryption2;
                bl3 = false;
                bl2 = false;
                it = node;
                boolean bl5 = false;
                object = (String)it.getAttributes().get("Algorithm");
                encryption2 = xmlParser;
                object3 = object;
            } else {
                object3 = null;
            }
            encryption2.setAlgorithm(object3);
            this.encp.parseEncryptionProperties(encryptedDataElement, encryption);
            this.encp.add(encryption, publication, encryptedDataElement);
        }
    }

    private final void parseNavigationDocument(Container container, Publication publication) {
        Object object;
        XmlParser xmlParser;
        Link link = publication.linkWithRel("contents");
        if (link == null) {
            return;
        }
        Link navLink = link;
        try {
            xmlParser = this.xmlDocumentForResource(navLink, container);
        }
        catch (Exception e) {
            return;
        }
        XmlParser navDocument = xmlParser;
        try {
            object = this.xmlAsByteArray(navLink, container);
        }
        catch (Exception e) {
            return;
        }
        byte[] navByteArray = object;
        String string = navLink.getHref();
        if (string == null) {
            return;
        }
        this.ndp.setNavigationDocumentPath(string);
        object = publication.getTableOfContents();
        Iterable iterable = this.ndp.tableOfContent(navByteArray);
        boolean bl = false;
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getLandmarks();
        iterable = this.ndp.landmarks(navDocument);
        bl = false;
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfAudioFiles();
        iterable = this.ndp.listOfAudiofiles(navDocument);
        bl = false;
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfIllustrations();
        iterable = this.ndp.listOfIllustrations(navDocument);
        bl = false;
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfTables();
        iterable = this.ndp.listOfTables(navDocument);
        bl = false;
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfVideos();
        iterable = this.ndp.listOfVideos(navDocument);
        bl = false;
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getPageList();
        iterable = this.ndp.pageList(navDocument);
        bl = false;
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
    }

    private final void parseNcxDocument(Container container, Publication publication) {
        Object object;
        Object object2;
        Object v0;
        block7: {
            Iterable $this$firstOrNull$iv = publication.getResources();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Link it = (Link)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTypeLink(), (Object)"application/x-dtbncx+xml")) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        Link link = v0;
        if (link == null) {
            return;
        }
        Link ncxLink = link;
        try {
            object2 = this.xmlDocumentForResource(ncxLink, container);
        }
        catch (Exception e) {
            return;
        }
        XmlParser ncxDocument = object2;
        String string = ncxLink.getHref();
        if (string == null) {
            return;
        }
        this.ncxp.setNcxDocumentPath(string);
        if (publication.getTableOfContents().isEmpty()) {
            object2 = publication.getTableOfContents();
            object = this.ncxp.tableOfContents(ncxDocument);
            boolean bl = false;
            CollectionsKt.addAll((Collection)object2, (Iterable)object);
        }
        if (publication.getPageList().isEmpty()) {
            object2 = publication.getPageList();
            object = this.ncxp.pageList(ncxDocument);
            boolean bl = false;
            CollectionsKt.addAll((Collection)object2, (Iterable)object);
        }
    }

    private final byte[] xmlAsByteArray(Link link, Container container) {
        Object object = link;
        if (object == null || (object = object.getHref()) == null) {
            Link link2 = link;
            throw (Throwable)new ContainerError.missingLink(link2 != null ? link2.getTitle() : null);
        }
        Object pathFile = object;
        if (StringsKt.first((CharSequence)((CharSequence)pathFile)) == '/') {
            Object object2 = pathFile;
            int n = 1;
            boolean bl = false;
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object3).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            pathFile = string;
        }
        return container.data((String)pathFile);
    }

    private final XmlParser xmlDocumentForResource(Link link, Container container) {
        Object object = link;
        if (object == null || (object = object.getHref()) == null) {
            Link link2 = link;
            throw (Throwable)new ContainerError.missingLink(link2 != null ? link2.getTitle() : null);
        }
        Object pathFile = object;
        if (StringsKt.first((CharSequence)((CharSequence)pathFile)) == '/') {
            Object object2 = pathFile;
            int n = 1;
            boolean bl = false;
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object3).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            pathFile = string;
        }
        byte[] containerData = container.data((String)pathFile);
        XmlParser document = new XmlParser();
        byte[] byArray = containerData;
        XmlParser xmlParser = document;
        boolean bl = false;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        XmlParser.parseXml$default((XmlParser)xmlParser, (InputStream)byteArrayInputStream, (boolean)false, (int)2, null);
        return document;
    }
}

