/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.cbz;

import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.streamer.container.ContainerError;
import org.readium.r2.streamer.parser.PubBox;
import org.readium.r2.streamer.parser.PublicationParser;
import org.readium.r2.streamer.parser.cbz.CBZArchiveContainer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/readium/r2/streamer/parser/cbz/CBZParser;", "Lorg/readium/r2/streamer/parser/PublicationParser;", "()V", "convertHashToString", "", "md5Bytes", "", "fileToMD5", "filePath", "generateContainerFrom", "Lorg/readium/r2/streamer/parser/cbz/CBZArchiveContainer;", "path", "getMimeType", "file", "parse", "Lorg/readium/r2/streamer/parser/PubBox;", "fileAtPath", "title", "r2-streamer_release"})
public final class CBZParser
implements PublicationParser {
    private final CBZArchiveContainer generateContainerFrom(String path) {
        CBZArchiveContainer container = null;
        if (!new File(path).exists()) {
            throw (Throwable)new ContainerError.missingFile(path);
        }
        container = new CBZArchiveContainer(path);
        return container;
    }

    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath, @NotNull String title) {
        List<String> e2;
        CBZArchiveContainer cBZArchiveContainer;
        Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        try {
            cBZArchiveContainer = this.generateContainerFrom(fileAtPath);
        }
        catch (Exception e2) {
            return null;
        }
        CBZArchiveContainer container = cBZArchiveContainer;
        try {
            e2 = container.getFiles();
        }
        catch (Exception e3) {
            return null;
        }
        List<String> listFiles = e2;
        Publication publication = new Publication();
        Iterable $this$forEach$iv = listFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Link link = new Link();
            link.setTypeLink(this.getMimeType(it));
            link.setHref(it);
            if (StringsKt.startsWith$default((String)it, (String)"_", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)".", (boolean)false, (int)2, null)) continue;
            if (Intrinsics.areEqual((Object)link.getTypeLink(), (Object)"image/jpeg") || Intrinsics.areEqual((Object)link.getTypeLink(), (Object)"image/png")) {
                publication.getImages().add(link);
                continue;
            }
            publication.getResources().add(link);
        }
        String hash = this.fileToMD5(fileAtPath);
        ((Link)CollectionsKt.first((List)publication.getImages())).getRel().add("cover");
        for (Link link : publication.getImages()) {
            if (link.getTitle() != null) {
                String string = link.getTitle();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                CharSequence charSequence = string;
                boolean bl = false;
                if (!(charSequence.length() == 0)) continue;
            }
            link.setTitle(link.getHref());
        }
        Iterable iterable = publication.getImages();
        Publication publication2 = publication;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Link it = (Link)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getHref());
                it = (Link)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getHref();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        publication2.setImages(CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator)));
        org.readium.r2.shared.Metadata metadata = publication.getMetadata();
        String string = hash;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        metadata.setIdentifier(string);
        publication.setType(Publication.TYPE.CBZ);
        return new PubBox(publication, container);
    }

    private final String getMimeType(String file) {
        String string;
        try {
            String string2;
            if (Build.VERSION.SDK_INT >= 26) {
                Path path;
                Path path2 = path = Paths.get(file, new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
                string2 = ((Object)path2.getFileName()).toString();
            } else {
                Uri uri;
                Uri uri2 = uri = Uri.parse((String)file);
                Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
                string2 = uri2.getLastPathSegment();
            }
            String lastSegment = string2;
            String type = null;
            String string3 = lastSegment;
            String name = string3 != null && (string3 = StringsKt.replace$default((String)string3, (String)" ", (String)"", (boolean)false, (int)4, null)) != null && (string3 = StringsKt.replace$default((String)string3, (String)"'", (String)"", (boolean)false, (int)4, null)) != null ? StringsKt.replace$default((String)string3, (String)",", (String)"", (boolean)false, (int)4, null) : null;
            String extension = MimeTypeMap.getFileExtensionFromUrl(name);
            if (!TextUtils.isEmpty((CharSequence)extension)) {
                String string4 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                type = string4;
            } else {
                String string5 = name;
                String reCheckExtension = MimeTypeMap.getFileExtensionFromUrl(string5 != null ? StringsKt.replace$default(string5, (String)"\\s+", (String)"", (boolean)false, (int)4, null) : null);
                if (!TextUtils.isEmpty((CharSequence)reCheckExtension)) {
                    String string6 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(reCheckExtension);
                    if (string6 == null) {
                        Intrinsics.throwNpe();
                    }
                    type = string6;
                }
            }
            string = type;
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final String fileToMD5(String filePath) {
        inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            buffer = new byte[1024];
            digest = MessageDigest.getInstance("MD5");
            numRead = 0;
            while (numRead != -1) {
                numRead = inputStream.read(buffer);
                if (numRead <= 0) continue;
                digest.update(buffer, 0, numRead);
            }
            md5Bytes = digest.digest();
            Intrinsics.checkExpressionValueIsNotNull((Object)md5Bytes, (String)"md5Bytes");
            var7_12 = this.convertHashToString(md5Bytes);
            ** try [egrp 1[TRYBLOCK] [0 : 87->95)] { 
        }
        catch (Exception e) {
            var4_7 = null;
            return var4_7;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception var5_10) {}
            }
        }
lbl-1000:
        // 1 sources

        {
            inputStream.close();
        }
lbl20:
        // 1 sources

        catch (Exception var8_13) {
            // empty catch block
        }
        return var7_12;
    }

    /*
     * WARNING - void declaration
     */
    private final String convertHashToString(byte[] md5Bytes) {
        String returnVal = "";
        int n = 0;
        int n2 = md5Bytes.length;
        while (n < n2) {
            String string;
            void i;
            int n3 = md5Bytes[i];
            int n4 = 255;
            StringBuilder stringBuilder = new StringBuilder().append(returnVal);
            boolean bl = false;
            byte by = (byte)(n3 & n4);
            n3 = by + 256;
            n4 = 16;
            bl = false;
            String string2 = Integer.toString(n3, CharsKt.checkRadix((int)n4));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            String string3 = string = string2;
            n4 = 1;
            bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n4);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            string = string5;
            returnVal = stringBuilder.append(string).toString();
            ++i;
        }
        return returnVal;
    }
}

