/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.audio;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.PublicationKt;
import org.readium.r2.streamer.container.ContainerError;
import org.readium.r2.streamer.parser.PubBox;
import org.readium.r2.streamer.parser.PublicationParser;
import org.readium.r2.streamer.parser.audio.AudioBookDirectoryContainer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/readium/r2/streamer/parser/audio/AudioBookParser;", "Lorg/readium/r2/streamer/parser/PublicationParser;", "()V", "generateContainerFrom", "Lorg/readium/r2/streamer/parser/audio/AudioBookDirectoryContainer;", "path", "", "parse", "Lorg/readium/r2/streamer/parser/PubBox;", "fileAtPath", "title", "r2-streamer_release"})
public final class AudioBookParser
implements PublicationParser {
    private final AudioBookDirectoryContainer generateContainerFrom(String path) {
        AudioBookDirectoryContainer container = null;
        if (!new File(path).exists()) {
            throw (Throwable)new ContainerError.missingFile(path);
        }
        container = new AudioBookDirectoryContainer(path);
        return container;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath, @NotNull String title) {
        byte[] data;
        byte[] e2;
        AudioBookDirectoryContainer audioBookDirectoryContainer;
        Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        try {
            audioBookDirectoryContainer = this.generateContainerFrom(fileAtPath);
        }
        catch (Exception e2) {
            return null;
        }
        AudioBookDirectoryContainer container = audioBookDirectoryContainer;
        try {
            e2 = container.data("manifest.json");
        }
        catch (Exception e3) {
            return null;
        }
        byte[] e3 = data = e2;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.defaultCharset()");
        Charset charset2 = charset;
        boolean bl = false;
        boolean bl2 = false;
        String stringManifest = new String(e3, charset2);
        JSONObject json = new JSONObject(stringManifest);
        Publication publication = PublicationKt.parsePublication((JSONObject)json);
        bl = false;
        for (Link link : (Iterable)publication.getReadingOrder()) {
            void index;
            String string;
            if (new URI(link.getHref()).isAbsolute()) {
                string = link.getHref();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                string = fileAtPath + "/" + link.getHref();
            }
            String uri = string;
            ((Link)publication.getReadingOrder().get((int)index)).setHref(uri);
            ++index;
        }
        publication.setType(Publication.TYPE.AUDIO);
        return new PubBox(publication, container);
    }
}

