/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.container;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.RootFile;
import org.readium.r2.shared.drm.DRM;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.container.ContainerError;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/readium/r2/streamer/container/DirectoryContainer;", "Lorg/readium/r2/streamer/container/Container;", "path", "", "mimetype", "(Ljava/lang/String;Ljava/lang/String;)V", "drm", "Lorg/readium/r2/shared/drm/DRM;", "getDrm", "()Lorg/readium/r2/shared/drm/DRM;", "setDrm", "(Lorg/readium/r2/shared/drm/DRM;)V", "rootFile", "Lorg/readium/r2/shared/RootFile;", "getRootFile", "()Lorg/readium/r2/shared/RootFile;", "setRootFile", "(Lorg/readium/r2/shared/RootFile;)V", "data", "", "relativePath", "dataInputStream", "Ljava/io/FileInputStream;", "dataLength", "", "getDecodedRelativePath", "r2-streamer_release"})
public class DirectoryContainer
implements Container {
    @NotNull
    private RootFile rootFile;
    @Nullable
    private DRM drm;

    @Override
    @NotNull
    public RootFile getRootFile() {
        return this.rootFile;
    }

    @Override
    public void setRootFile(@NotNull RootFile rootFile) {
        Intrinsics.checkParameterIsNotNull((Object)rootFile, (String)"<set-?>");
        this.rootFile = rootFile;
    }

    @Override
    @Nullable
    public DRM getDrm() {
        return this.drm;
    }

    @Override
    public void setDrm(@Nullable DRM dRM) {
        this.drm = dRM;
    }

    @Override
    @NotNull
    public byte[] data(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        String decodedFilePath = this.getRootFile().getRootPath() + "/" + this.getDecodedRelativePath(relativePath);
        File file = new File(decodedFilePath);
        if (!file.exists()) {
            throw (Throwable)ContainerError.fileNotFound.INSTANCE;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int readLength = 0;
        byte[] buffer = new byte[16384];
        FileInputStream inputStream = new FileInputStream(file);
        while (true) {
            int n = inputStream.read(buffer);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            readLength = it;
            if (!(it != -1)) break;
            outputStream.write(buffer, 0, readLength);
        }
        inputStream.close();
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"outputStream.toByteArray()");
        return byArray;
    }

    @Override
    public long dataLength(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return new File(this.getRootFile().toString() + "/" + this.getDecodedRelativePath(relativePath)).length();
    }

    @Override
    @NotNull
    public FileInputStream dataInputStream(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return new FileInputStream(new File(this.getRootFile().toString() + "/" + this.getDecodedRelativePath(relativePath)));
    }

    private final String getDecodedRelativePath(String relativePath) {
        String replacedPath = StringsKt.replace$default((String)relativePath, (String)" ", (String)"%20", (boolean)false, (int)4, null);
        String string = new URI(replacedPath).getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URI(replacedPath).path");
        return string;
    }

    public DirectoryContainer(@NotNull String path, @NotNull String mimetype) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)mimetype, (String)"mimetype");
        this.rootFile = new RootFile(path, null, mimetype, null, 10, null);
    }
}

