/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.PublicationKt;
import org.readium.r2.streamer.container.ContainerDiViNa;
import org.readium.r2.streamer.parser.PubBox;
import org.readium.r2.streamer.parser.PublicationParser;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/readium/r2/streamer/parser/DiViNaParser;", "Lorg/readium/r2/streamer/parser/PublicationParser;", "()V", "generateContainerFrom", "Lorg/readium/r2/streamer/container/ContainerDiViNa;", "path", "", "parse", "Lorg/readium/r2/streamer/parser/PubBox;", "fileAtPath", "title", "toFile", "", "Ljava/io/InputStream;", "Companion", "r2-streamer_release"})
public final class DiViNaParser
implements PublicationParser {
    @NotNull
    public static final String mimetypeDiViNa = "application/divina+json";
    @NotNull
    public static final String manifestPath = "manifest.json";
    @NotNull
    public static final String publicationPath = "publication.json";
    public static final Companion Companion = new Companion(null);

    private final ContainerDiViNa generateContainerFrom(String path) {
        ContainerDiViNa container = null;
        if (!new File(path).exists()) {
            throw (Throwable)new Exception("Missing File");
        }
        container = new ContainerDiViNa(path);
        if (!container.getSuccessCreated()) {
            throw (Throwable)new Exception("Missing File");
        }
        return container;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath, @NotNull String title) {
        byte[] data;
        Object publication;
        byte[] e2;
        ContainerDiViNa containerDiViNa;
        Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        try {
            containerDiViNa = this.generateContainerFrom(fileAtPath);
        }
        catch (Exception e2) {
            Timber.e((Throwable)e2, (String)"Could not generate container", (Object[])new Object[0]);
            return null;
        }
        ContainerDiViNa container = containerDiViNa;
        try {
            e2 = container.data(manifestPath);
        }
        catch (Exception e3) {
            Timber.e((Throwable)e3, (String)"Missing File : manifest.json", (Object[])new Object[0]);
            try {
                publication = container.data(publicationPath);
                container.getRootFile();
                ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])publication);
                this.toFile(inputStream, container.getRootFile().getRootPath() + "/manifest.json");
            }
            catch (FileNotFoundException e4) {
                Timber.e((Throwable)e4, (String)"Missing File : publication.json", (Object[])new Object[0]);
                return null;
            }
            catch (Exception e5) {
                Timber.e((Throwable)e5, (String)(container.getRootFile().getRootPath() + "/manifest.json"), (Object[])new Object[0]);
                return null;
            }
            e2 = publication;
        }
        byte[] e3 = data = e2;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.defaultCharset()");
        publication = charset;
        boolean e5 = false;
        boolean bl = false;
        String stringManifest = new String(e3, (Charset)publication);
        JSONObject json = new JSONObject(stringManifest);
        publication = PublicationKt.parsePublication((JSONObject)json);
        publication.setType(Publication.TYPE.DiViNa);
        e5 = false;
        for (Link link : (Iterable)publication.getReadingOrder()) {
            void index;
            block13: {
                block12: {
                    if (link.getTitle() == null) break block12;
                    String string = link.getTitle();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    CharSequence charSequence = string;
                    boolean bl2 = false;
                    if (!(charSequence.length() == 0)) break block13;
                }
                link.setTitle(link.getHref());
            }
            ++index;
        }
        return new PubBox((Publication)publication, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void toFile(@NotNull InputStream $this$toFile, String path) {
        Closeable closeable = $this$toFile;
        boolean bl = false;
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl2 = false;
            Object object = new File(path);
            boolean bl3 = false;
            object = new FileOutputStream((File)object);
            bl3 = false;
            Throwable throwable2 = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                boolean bl4 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/readium/r2/streamer/parser/DiViNaParser$Companion;", "", "()V", "manifestPath", "", "mimetypeDiViNa", "publicationPath", "r2-streamer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

