/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.fetcher;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.readium.r2.shared.Injectable;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.PageProgressionDirection;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.PublicationKt;
import org.readium.r2.shared.ReadiumCSSName;
import org.readium.r2.shared.RenditionLayout;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.fetcher.ContentFilters;
import org.readium.r2.streamer.fetcher.ContentFiltersEpub$WhenMappings;
import org.readium.r2.streamer.fetcher.DrmDecoder;
import org.readium.r2.streamer.fetcher.FontDecoder;
import org.readium.r2.streamer.server.Resources;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J(\u0010\u0017\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\"\u001a\u00020#2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0006\u0012\u0004\u0018\u00010'0%H\u0002J\u001c\u0010(\u001a\u00020\u00032\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030*H\u0002J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0002J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0002J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0002J*\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010*2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0*H\u0002J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u0018H\u0002J\u0018\u00102\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/readium/r2/streamer/fetcher/ContentFiltersEpub;", "Lorg/readium/r2/streamer/fetcher/ContentFilters;", "userPropertiesPath", "", "customResources", "Lorg/readium/r2/streamer/server/Resources;", "(Ljava/lang/String;Lorg/readium/r2/streamer/server/Resources;)V", "getCustomResources", "()Lorg/readium/r2/streamer/server/Resources;", "setCustomResources", "(Lorg/readium/r2/streamer/server/Resources;)V", "drmDecoder", "Lorg/readium/r2/streamer/fetcher/DrmDecoder;", "getDrmDecoder", "()Lorg/readium/r2/streamer/fetcher/DrmDecoder;", "setDrmDecoder", "(Lorg/readium/r2/streamer/fetcher/DrmDecoder;)V", "fontDecoder", "Lorg/readium/r2/streamer/fetcher/FontDecoder;", "getFontDecoder", "()Lorg/readium/r2/streamer/fetcher/FontDecoder;", "setFontDecoder", "(Lorg/readium/r2/streamer/fetcher/FontDecoder;)V", "apply", "Ljava/io/InputStream;", "input", "publication", "Lorg/readium/r2/shared/Publication;", "container", "Lorg/readium/r2/streamer/container/Container;", "path", "", "applyDirectionAttribute", "resourceHtml", "applyPreset", "Lorg/json/JSONObject;", "preset", "Lkotlin/Pair;", "Lorg/readium/r2/shared/ReadiumCSSName;", "", "buildStringProperties", "list", "", "getHtmlFont", "resourceName", "getHtmlLink", "getHtmlScript", "getProperties", "injectFixedLayoutHtml", "stream", "injectReflowableHtml", "r2-streamer_release"})
public final class ContentFiltersEpub
implements ContentFilters {
    @NotNull
    private FontDecoder fontDecoder;
    @NotNull
    private DrmDecoder drmDecoder;
    private final String userPropertiesPath;
    @Nullable
    private Resources customResources;

    @Override
    @NotNull
    public FontDecoder getFontDecoder() {
        return this.fontDecoder;
    }

    @Override
    public void setFontDecoder(@NotNull FontDecoder fontDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)fontDecoder, (String)"<set-?>");
        this.fontDecoder = fontDecoder;
    }

    @Override
    @NotNull
    public DrmDecoder getDrmDecoder() {
        return this.drmDecoder;
    }

    @Override
    public void setDrmDecoder(@NotNull DrmDecoder drmDecoder) {
        Intrinsics.checkParameterIsNotNull((Object)drmDecoder, (String)"<set-?>");
        this.drmDecoder = drmDecoder;
    }

    @Override
    @NotNull
    public InputStream apply(@NotNull InputStream input, @NotNull Publication publication, @NotNull Container container, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Link link = publication.linkWithHref(path);
        if (link != null) {
            Link link2 = link;
            boolean bl = false;
            boolean bl2 = false;
            Link resourceLink = link2;
            boolean bl3 = false;
            InputStream decodedInputStream = this.getDrmDecoder().decoding(input, resourceLink, container.getDrm());
            decodedInputStream = this.getFontDecoder().decoding(decodedInputStream, publication, path);
            if (Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"application/xhtml+xml") || Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"text/html")) {
                decodedInputStream = publication.getMetadata().getRendition().getLayout() == RenditionLayout.Reflowable && resourceLink.getProperties().getLayout() == null || Intrinsics.areEqual((Object)resourceLink.getProperties().getLayout(), (Object)"reflowable") ? this.injectReflowableHtml(decodedInputStream, publication) : this.injectFixedLayoutHtml(decodedInputStream);
            }
            return decodedInputStream;
        }
        ContentFiltersEpub contentFiltersEpub = this;
        boolean bl = false;
        boolean bl4 = false;
        ContentFiltersEpub $this$run = contentFiltersEpub;
        boolean bl5 = false;
        return input;
    }

    @Override
    @NotNull
    public byte[] apply(@NotNull byte[] input, @NotNull Publication publication, @NotNull Container container, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Link link = publication.linkWithHref(path);
        if (link != null) {
            URL baseUrl;
            Link link2 = link;
            boolean bl = false;
            boolean bl2 = false;
            Link resourceLink = link2;
            boolean bl3 = false;
            byte[] byArray = input;
            boolean bl4 = false;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byArray);
            InputStream decodedInputStream = this.getDrmDecoder().decoding(inputStream, resourceLink, container.getDrm());
            decodedInputStream = this.getFontDecoder().decoding(decodedInputStream, publication, path);
            URL uRL = publication.baseUrl();
            URL uRL2 = baseUrl = uRL != null ? PublicationKt.removeLastComponent((URL)uRL) : null;
            if ((Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"application/xhtml+xml") || Intrinsics.areEqual((Object)resourceLink.getTypeLink(), (Object)"text/html")) && baseUrl != null) {
                decodedInputStream = publication.getMetadata().getRendition().getLayout() == RenditionLayout.Reflowable && (resourceLink.getProperties().getLayout() == null || Intrinsics.areEqual((Object)resourceLink.getProperties().getLayout(), (Object)"reflowable")) ? this.injectReflowableHtml(decodedInputStream, publication) : this.injectFixedLayoutHtml(decodedInputStream);
            }
            return ByteStreamsKt.readBytes((InputStream)decodedInputStream);
        }
        ContentFiltersEpub contentFiltersEpub = this;
        boolean bl = false;
        boolean bl5 = false;
        ContentFiltersEpub $this$run = contentFiltersEpub;
        boolean bl6 = false;
        return input;
    }

    private final InputStream injectReflowableHtml(InputStream stream, Publication publication) {
        boolean bl;
        String string;
        byte[] data = ByteStreamsKt.readBytes((InputStream)stream);
        boolean bl2 = false;
        String string2 = string = new String(data, Charsets.UTF_8);
        boolean bl3 = false;
        String resourceHtml = string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        int beginHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"<head>", (int)0, (boolean)false) + 6;
        int endHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"</head>", (int)0, (boolean)false);
        if (endHeadIndex == -1) {
            return stream;
        }
        String cssStyle = publication.getCssStyle();
        boolean bl4 = false;
        List endIncludes = new ArrayList();
        boolean bl5 = false;
        List beginIncludes = new ArrayList();
        beginIncludes.add("<meta name=\"viewport\" content=\"width=device-width, height=device-height, initial-scale=1.0, maximum-scale=1.0, user-scalable=0\" />");
        beginIncludes.add(this.getHtmlLink("/" + Injectable.Style.getRawValue() + '/' + cssStyle + "-before.css"));
        beginIncludes.add(this.getHtmlLink("/" + Injectable.Style.getRawValue() + '/' + cssStyle + "-default.css"));
        endIncludes.add(this.getHtmlLink("/" + Injectable.Style.getRawValue() + '/' + cssStyle + "-after.css"));
        endIncludes.add(this.getHtmlScript("/" + Injectable.Script.getRawValue() + "/touchHandling.js"));
        endIncludes.add(this.getHtmlScript("/" + Injectable.Script.getRawValue() + "/utils.js"));
        Resources resources = this.customResources;
        if (resources != null) {
            Resources resources2 = resources;
            boolean bl6 = false;
            bl = false;
            Resources it = resources2;
            boolean bl7 = false;
            Map<String, Object> map = it.getResources();
            boolean bl8 = false;
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry;
                Map.Entry<String, Object> entry2 = entry = iterator.next();
                boolean bl9 = false;
                String key = entry2.getKey();
                entry2 = entry;
                bl9 = false;
                Object value = entry2.getValue();
                if (!(value instanceof Pair)) continue;
                Pair res = (Pair)value;
                if (Injectable.Companion.invoke((String)res.getSecond()) == Injectable.Script) {
                    endIncludes.add(this.getHtmlScript('/' + Injectable.Script.getRawValue() + '/' + key));
                    continue;
                }
                if (Injectable.Companion.invoke((String)res.getSecond()) != Injectable.Style) continue;
                endIncludes.add(this.getHtmlLink('/' + Injectable.Style.getRawValue() + '/' + key));
            }
        }
        for (String element : beginIncludes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(beginHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
            beginHeadIndex += element.length();
            endHeadIndex += element.length();
        }
        for (String element : endIncludes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(endHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
            endHeadIndex += element.length();
        }
        String string3 = new StringBuilder(resourceHtml).insert(endHeadIndex, this.getHtmlFont("/fonts/OpenDyslexic-Regular.otf")).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder(resourceHt\u2026Regular.otf\")).toString()");
        resourceHtml = string3;
        String string4 = new StringBuilder(resourceHtml).insert(endHeadIndex, "<style>@import url('https://fonts.googleapis.com/css?family=PT+Serif|Roboto|Source+Sans+Pro|Vollkorn');</style>\n").toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder(resourceHt\u2026);</style>\\n\").toString()");
        resourceHtml = string4;
        Map<String, String> map = this.getProperties(publication.getUserSettingsUIPreset());
        if (map != null) {
            MatchResult html;
            Map<String, String> map2 = map;
            boolean bl10 = false;
            bl = false;
            Map<String, String> propertyPair = map2;
            boolean bl11 = false;
            MatchResult matchResult = html = new Regex("<html.*>").find((CharSequence)resourceHtml, 0);
            if (matchResult != null) {
                MatchResult matchResult2 = matchResult;
                boolean bl12 = false;
                boolean bl13 = false;
                MatchResult it = matchResult2;
                boolean bl14 = false;
                MatchResult match = new Regex("(style=(\"([^\"]*)\"[ >]))|(style='([^']*)'[ >])").find((CharSequence)html.getValue(), 0);
                if (match != null) {
                    String string5;
                    int beginStyle = match.getRange().getStart() + 7;
                    String newHtml = html.getValue();
                    String string6 = new StringBuilder(newHtml).insert(beginStyle, this.buildStringProperties(propertyPair) + ' ').toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"StringBuilder(newHtml).i\u2026pertyPair)} \").toString()");
                    newHtml = string6;
                    CharSequence charSequence = new StringBuilder(resourceHtml);
                    Regex regex = new Regex("<html.*>");
                    boolean bl15 = false;
                    resourceHtml = string5 = regex.replace(charSequence, newHtml);
                } else {
                    int beginHtmlIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"<html", (int)0, (boolean)false) + 5;
                    String string7 = new StringBuilder(resourceHtml).insert(beginHtmlIndex, " style=\"" + this.buildStringProperties(propertyPair) + '\"').toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"StringBuilder(resourceHt\u2026ertyPair)}\\\"\").toString()");
                    resourceHtml = string7;
                }
            } else {
                ContentFiltersEpub contentFiltersEpub = this;
                boolean bl16 = false;
                boolean bl17 = false;
                ContentFiltersEpub $this$run = contentFiltersEpub;
                boolean bl18 = false;
                int beginHtmlIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"<html", (int)0, (boolean)false) + 5;
                String string8 = new StringBuilder(resourceHtml).insert(beginHtmlIndex, " style=\"" + $this$run.buildStringProperties(propertyPair) + '\"').toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"StringBuilder(resourceHt\u2026ertyPair)}\\\"\").toString()");
                resourceHtml = string8;
            }
        }
        resourceHtml = this.applyDirectionAttribute(resourceHtml, publication);
        Object object = resourceHtml;
        Charset charset = Charsets.UTF_8;
        bl = false;
        String string9 = object;
        if (string9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string9.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        boolean bl19 = false;
        return new ByteArrayInputStream((byte[])object);
    }

    private final String applyDirectionAttribute(String resourceHtml, Publication publication) {
        String resourceHtml1 = resourceHtml;
        Function2<String, String, String> $fun$addRTLDir$1 = new Function2<String, String, String>(this){
            final /* synthetic */ ContentFiltersEpub this$0;

            @NotNull
            public final String invoke(@NotNull String tagName, @NotNull String html) {
                Object object;
                block6: {
                    boolean bl;
                    boolean bl2;
                    Object object2;
                    block5: {
                        String string;
                        Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
                        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
                        object = new Regex('<' + tagName + ".*>").find((CharSequence)html, 0);
                        if (object == null) break block5;
                        object2 = object;
                        bl2 = false;
                        bl = false;
                        Object result = object2;
                        boolean bl3 = false;
                        MatchResult matchResult = new Regex("dir=").find((CharSequence)result.getValue(), 0);
                        if (matchResult != null) {
                            MatchResult matchResult2 = matchResult;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            MatchResult it = matchResult2;
                            boolean bl6 = false;
                            string = html;
                        } else {
                            ContentFiltersEpub contentFiltersEpub = this.this$0;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            ContentFiltersEpub $this$run = contentFiltersEpub;
                            boolean bl9 = false;
                            int beginHtmlIndex = StringsKt.indexOf((CharSequence)html, (String)('<' + tagName), (int)0, (boolean)false) + 5;
                            String string2 = new StringBuilder(html).insert(beginHtmlIndex, " dir=\"rtl\"").toString();
                            string = string2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"run {\n                  \u2026tring()\n                }");
                        }
                        object = string;
                        if (string != null) break block6;
                    }
                    object2 = this.this$0;
                    bl2 = false;
                    bl = false;
                    Object $this$run = object2;
                    boolean bl10 = false;
                    object = html;
                }
                return object;
            }
            {
                this.this$0 = contentFiltersEpub;
                super(2);
            }
        };
        if (Intrinsics.areEqual((Object)publication.getCssStyle(), (Object)PageProgressionDirection.rtl.name())) {
            resourceHtml1 = $fun$addRTLDir$1.invoke("html", resourceHtml1);
            resourceHtml1 = $fun$addRTLDir$1.invoke("body", resourceHtml1);
        }
        return resourceHtml1;
    }

    private final InputStream injectFixedLayoutHtml(InputStream stream) {
        byte[] data = ByteStreamsKt.readBytes((InputStream)stream);
        boolean bl = false;
        String resourceHtml = new String(data, Charsets.UTF_8);
        int endHeadIndex = StringsKt.indexOf((CharSequence)resourceHtml, (String)"</head>", (int)0, (boolean)false);
        if (endHeadIndex == -1) {
            return stream;
        }
        boolean bl2 = false;
        List includes = new ArrayList();
        includes.add(this.getHtmlScript("/" + Injectable.Script.getRawValue() + "/touchHandling.js"));
        includes.add(this.getHtmlScript("/" + Injectable.Script.getRawValue() + "/utils.js"));
        for (String element : includes) {
            Intrinsics.checkExpressionValueIsNotNull((Object)new StringBuilder(resourceHtml).insert(endHeadIndex, element).toString(), (String)"StringBuilder(resourceHt\u2026ndex, element).toString()");
        }
        Object object = resourceHtml;
        Charset charset = Charsets.UTF_8;
        boolean bl3 = false;
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        boolean bl4 = false;
        return new ByteArrayInputStream((byte[])object);
    }

    private final String getHtmlFont(String resourceName) {
        String prefix = "<style type=\"text/css\"> @font-face{font-family: \"OpenDyslexic\"; src:url(\"";
        String suffix = "\") format('truetype');}</style>\n";
        return prefix + resourceName + suffix;
    }

    private final String getHtmlLink(String resourceName) {
        String prefix = "<link rel=\"stylesheet\" type=\"text/css\" href=\"";
        String suffix = "\"/>\n";
        return prefix + resourceName + suffix;
    }

    private final String getHtmlScript(String resourceName) {
        String prefix = "<script type=\"text/javascript\" src=\"";
        String suffix = "\"></script>\n";
        return prefix + resourceName + suffix;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getProperties(Map<ReadiumCSSName, Boolean> preset) {
        Map map;
        String it;
        boolean bl;
        boolean bl2;
        String string;
        String userPropertiesString = null;
        String string2 = this.userPropertiesPath;
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl3 = false;
            userPropertiesString = new String();
            File file = new File(it);
            if (file.isFile() && file.canRead()) {
                for (String i : FilesKt.readLines$default((File)file, null, (int)1, null)) {
                    userPropertiesString = Intrinsics.stringPlus((String)userPropertiesString, (Object)i);
                }
            }
        }
        String string3 = userPropertiesString;
        if (string3 != null) {
            Map map2;
            string = string3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            try {
                JSONArray propertiesArray = new JSONArray(userPropertiesString);
                int n = 0;
                Map properties = new LinkedHashMap();
                n = 0;
                int n2 = propertiesArray.length();
                while (n < n2) {
                    void i;
                    JSONObject value = new JSONObject(propertiesArray.getString((int)i));
                    boolean isInPreset = false;
                    Map<ReadiumCSSName, Boolean> map3 = preset;
                    boolean bl5 = false;
                    for (Map.Entry<ReadiumCSSName, Boolean> property : map3.entrySet()) {
                        if (!Intrinsics.areEqual((Object)property.getKey().getRef(), (Object)value.getString("name"))) continue;
                        isInPreset = true;
                        Pair presetPair = new Pair((Object)property.getKey(), (Object)preset.get(property.getKey()));
                        JSONObject presetValue = this.applyPreset((Pair<? extends ReadiumCSSName, Boolean>)presetPair);
                        String string4 = presetValue.getString("name");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"presetValue.getString(\"name\")");
                        String string5 = presetValue.getString("value");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"presetValue.getString(\"value\")");
                        properties.put(string4, string5);
                    }
                    if (!isInPreset) {
                        String string6 = value.getString("name");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"value.getString(\"name\")");
                        String string7 = value.getString("value");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"value.getString(\"value\")");
                        properties.put(string6, string7);
                    }
                    ++i;
                }
                map2 = properties;
            }
            catch (Exception e) {
                map2 = null;
            }
            map = map2;
        } else {
            map = null;
        }
        return map;
    }

    private final JSONObject applyPreset(Pair<? extends ReadiumCSSName, Boolean> preset) {
        JSONObject readiumCSSProperty = new JSONObject();
        readiumCSSProperty.put("name", (Object)((ReadiumCSSName)preset.getFirst()).getRef());
        switch (ContentFiltersEpub$WhenMappings.$EnumSwitchMapping$0[((ReadiumCSSName)preset.getFirst()).ordinal()]) {
            case 1: {
                readiumCSSProperty.put("value", (Object)"");
                break;
            }
            case 2: {
                readiumCSSProperty.put("value", (Object)"readium-font-off");
                break;
            }
            case 3: {
                readiumCSSProperty.put("value", (Object)"readium-default-on");
                break;
            }
            case 4: {
                readiumCSSProperty.put("value", (Object)"");
                break;
            }
            case 5: {
                readiumCSSProperty.put("value", (Object)"auto");
                break;
            }
            case 6: {
                readiumCSSProperty.put("value", (Object)"0.5");
                break;
            }
            case 7: {
                readiumCSSProperty.put("value", (Object)"1.0");
                break;
            }
            case 8: {
                readiumCSSProperty.put("value", (Object)"");
                break;
            }
            case 9: {
                readiumCSSProperty.put("value", (Object)"Original");
                break;
            }
            case 10: {
                readiumCSSProperty.put("value", (Object)"100%");
                break;
            }
            case 11: {
                readiumCSSProperty.put("value", (Object)"0.0rem");
                break;
            }
            case 12: {
                readiumCSSProperty.put("value", (Object)"0.0em");
                break;
            }
            case 13: {
                readiumCSSProperty.put("value", (Object)"justify");
                break;
            }
            case 14: {
                readiumCSSProperty.put("value", (Object)"");
                break;
            }
            case 15: {
                Object object = preset.getSecond();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                if (((Boolean)object).booleanValue()) {
                    readiumCSSProperty.put("value", (Object)"readium-scroll-on");
                    break;
                }
                readiumCSSProperty.put("value", (Object)"readium-scroll-off");
            }
        }
        return readiumCSSProperty;
    }

    private final String buildStringProperties(Map<String, String> list) {
        String string = "";
        Map<String, String> map = list;
        boolean bl = false;
        for (Map.Entry<String, String> property : map.entrySet()) {
            string = string + " " + property.getKey() + ": " + property.getValue() + ";";
        }
        return string;
    }

    @Nullable
    public final Resources getCustomResources() {
        return this.customResources;
    }

    public final void setCustomResources(@Nullable Resources resources) {
        this.customResources = resources;
    }

    public ContentFiltersEpub(@Nullable String userPropertiesPath, @Nullable Resources customResources) {
        this.userPropertiesPath = userPropertiesPath;
        this.customResources = customResources;
        this.fontDecoder = new FontDecoder();
        this.drmDecoder = new DrmDecoder();
    }
}

