/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser.epub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Properties;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.Subject;
import org.readium.r2.shared.parser.xml.Node;
import org.readium.r2.shared.parser.xml.XmlParser;
import org.readium.r2.streamer.parser.PublicationParserKt;
import org.readium.r2.streamer.parser.epub.MetadataParser;
import org.readium.r2.streamer.parser.epub.OPFParser;
import org.readium.r2.streamer.parser.epub.SMILParser;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"Lorg/readium/r2/streamer/parser/epub/OPFParser;", "", "()V", "rootFilePath", "", "smilp", "Lorg/readium/r2/streamer/parser/epub/SMILParser;", "getSmilp", "()Lorg/readium/r2/streamer/parser/epub/SMILParser;", "coverLinkFromMeta", "", "metadata", "Lorg/readium/r2/shared/parser/xml/Node;", "publication", "Lorg/readium/r2/shared/Publication;", "linkFromManifest", "Lorg/readium/r2/shared/Link;", "item", "parse", "Lorg/readium/r2/shared/Properties;", "propertiesArray", "", "parseMetadata", "", "document", "Lorg/readium/r2/shared/parser/xml/XmlParser;", "parseOpf", "filePath", "epubVersion", "", "parseResources", "manifest", "parseSpine", "spine", "r2-streamer_release"})
public final class OPFParser {
    @NotNull
    private final SMILParser smilp = new SMILParser();
    private String rootFilePath;

    @NotNull
    public final SMILParser getSmilp() {
        return this.smilp;
    }

    @Nullable
    public final Publication parseOpf(@NotNull XmlParser document, @NotNull String filePath, double epubVersion) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Publication publication = new Publication();
        this.rootFilePath = filePath;
        publication.setVersion(epubVersion);
        publication.getInternalData().put("type", "epub");
        Map map = publication.getInternalData();
        String string = this.rootFilePath;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        map.put("rootfile", string);
        if (!this.parseMetadata(document, publication)) {
            return null;
        }
        Node node = document.getFirst("package");
        if (node == null) {
            Intrinsics.throwNpe();
        }
        Node node2 = node.getFirst("manifest");
        if (node2 == null) {
            Intrinsics.throwNpe();
        }
        this.parseResources(node2, publication);
        Node node3 = document.root().getFirst("metadata");
        if (node3 == null && (node3 = document.root().getFirst("opf:metadata")) == null) {
            Intrinsics.throwNpe();
        }
        this.coverLinkFromMeta(node3, publication);
        Node node4 = document.getFirst("package");
        if (node4 == null) {
            Intrinsics.throwNpe();
        }
        Node node5 = node4.getFirst("spine");
        if (node5 == null) {
            Intrinsics.throwNpe();
        }
        this.parseSpine(node5, publication);
        return publication;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parseMetadata(XmlParser document, Publication publication) {
        List rightsMap;
        List list;
        Object object;
        Iterable destination$iv$iv;
        List list2;
        org.readium.r2.shared.Metadata metadata;
        Object object2;
        Node metadataElement;
        MetadataParser metadataParser;
        org.readium.r2.shared.Metadata metadata2;
        block19: {
            block18: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object3;
                org.readium.r2.shared.Metadata metadata3;
                metadata2 = new org.readium.r2.shared.Metadata();
                metadataParser = new MetadataParser();
                Node node = document.root().getFirst("metadata");
                if (node == null) {
                    node = document.root().getFirst("opf:metadata");
                }
                Node node2 = metadataElement = node;
                if (node2 == null) {
                    Intrinsics.throwNpe();
                }
                metadata2.setMultilanguageTitle(metadataParser.mainTitle(node2));
                Node node3 = document.getFirst("package");
                if (node3 == null) {
                    Intrinsics.throwNpe();
                }
                String string = metadataParser.uniqueIdentifier(metadataElement, node3.getAttributes());
                if (string == null) {
                    return false;
                }
                metadata2.setIdentifier(string);
                Node node4 = metadataElement.getFirst("dc:description");
                metadata2.setDescription(node4 != null ? node4.getText() : null);
                Node node5 = metadataElement.getFirst("dc:date");
                metadata2.setPublicationDate(node5 != null ? node5.getText() : null);
                object2 = metadata2;
                try {
                    metadata3 = object2;
                    object3 = new DateTime((Object)metadataParser.modifiedDate(metadataElement)).toDate();
                }
                catch (Exception exception) {
                    metadata3 = object2;
                    object3 = null;
                }
                metadata3.setModified(object3);
                Node node6 = metadataElement.getFirst("dc:sources");
                metadata2.setSource(node6 != null ? node6.getText() : null);
                Subject subject = metadataParser.subject(metadataElement);
                if (subject != null) {
                    object3 = subject;
                    boolean e = false;
                    boolean bl = false;
                    Date it = object3;
                    boolean bl2 = false;
                    metadata2.getSubjects().add(it);
                }
                metadata = metadata2;
                list2 = metadataElement.get("dc:language");
                if (list2 == null) break block18;
                object3 = list2;
                object2 = metadata;
                boolean $i$f$map = false;
                void var8_15 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string2;
                    void it;
                    Node node7 = (Node)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    if (it.getText() == null) {
                        Intrinsics.throwNpe();
                    }
                    object.add(string2);
                }
                object = (List)destination$iv$iv;
                metadata = object2;
                list2 = CollectionsKt.toMutableList((Collection)((Collection)object));
                if (list2 != null) break block19;
            }
            throw (Throwable)new Exception("No language");
        }
        metadata.setLanguages(list2);
        List list3 = metadataElement.get("dc:rights");
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Node bl = (Node)item$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl3 = false;
                object = it.getText();
                object2.add(object);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = rightsMap = null;
        }
        if (rightsMap != null) {
            Collection collection = rightsMap;
            boolean bl = false;
            if (!collection.isEmpty()) {
                metadata2.setRights(CollectionsKt.joinToString$default((Iterable)rightsMap, null, null, null, (int)0, null, (Function1)parseMetadata.3.INSTANCE, (int)31, null));
            }
        }
        metadataParser.parseContributors(metadataElement, metadata2, publication.getVersion());
        Object object4 = document.root().getFirst("spine");
        if (object4 != null && (object4 = object4.getAttributes()) != null && (object4 = (String)object4.get("page-progression-direction")) != null) {
            Object object5 = object4;
            boolean bl = false;
            boolean bl4 = false;
            Object it = object5;
            boolean bl5 = false;
            metadata2.setDirection((String)it);
        }
        metadataParser.parseRenditionProperties(metadataElement, metadata2);
        metadata2.setOtherMetadata(metadataParser.parseMediaDurations(metadataElement, metadata2.getOtherMetadata()));
        publication.setMetadata(metadata2);
        return true;
    }

    private final void parseResources(Node manifest, Publication publication) {
        List manifestItems;
        List list = manifest.get("item");
        if (list == null) {
            Intrinsics.throwNpe();
        }
        if ((manifestItems = list).isEmpty()) {
            return;
        }
        for (Node item : manifestItems) {
            if ((String)item.getAttributes().get("id") == null) {
                continue;
            }
            Link link = this.linkFromManifest(item);
            publication.getResources().add(link);
        }
    }

    private final void coverLinkFromMeta(Node metadata, Publication publication) {
        block5: {
            Link coverLink;
            Object object;
            Object v3;
            block4: {
                Node coverMeta;
                Object object2;
                Object v1;
                block3: {
                    List list = metadata.get("meta");
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Node it = (Node)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)((String)it.getAttributes().get("name")), (Object)"cover")) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                String coverId = (object2 = (coverMeta = (Node)v1)) != null && (object2 = object2.getAttributes()) != null ? (String)object2.get("content") : null;
                Iterable $this$firstOrNull$iv = publication.getResources();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Link it = (Link)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTitle(), (Object)coverId)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            if ((object = (coverLink = (Link)v3)) == null || (object = object.getRel()) == null) break block5;
            object.add("cover");
        }
    }

    private final void parseSpine(Node spine, Publication publication) {
        List spineItems;
        List list = spine.get("itemref");
        if (list == null) {
            Intrinsics.throwNpe();
        }
        if ((spineItems = list).isEmpty()) {
            Timber.tag((String)"Warning").d("Spine has no children elements", new Object[0]);
            return;
        }
        for (Node item : spineItems) {
            String string;
            String string2;
            boolean bl;
            int index;
            int n;
            block9: {
                String idref = (String)item.getAttributes().get("idref");
                List $this$indexOfFirst$iv = publication.getResources();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    Link it = (Link)item$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getTitle(), (Object)idref)) {
                        n = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            if ((index = n) == -1) continue;
            if ((String)item.getAttributes().get("properties") != null) {
                bl = false;
                boolean bl3 = false;
                String it = string2;
                boolean bl4 = false;
                List properties = StringsKt.split$default((CharSequence)it, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
                ((Link)publication.getResources().get(index)).setProperties(this.parse(properties));
            }
            if ((String)item.getAttributes().get("linear") != null) {
                bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            } else {
                string = null;
            }
            if (Intrinsics.areEqual(string, (Object)"no")) continue;
            publication.getReadingOrder().add(publication.getResources().get(index));
            publication.getResources().remove(index);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Properties parse(List<String> propertiesArray) {
        properties = new Properties();
        var4_3 = propertiesArray.iterator();
        while (var4_3.hasNext()) {
            block64: {
                block63: {
                    block62: {
                        block61: {
                            block60: {
                                block58: {
                                    block59: {
                                        var5_5 = property = var4_3.next();
                                        switch (var5_5.hashCode()) {
                                            case 718455363: {
                                                if (!var5_5.equals("xmp-record")) ** break;
                                                break block58;
                                            }
                                            case 114276: {
                                                if (!var5_5.equals("svg")) ** break;
                                                break block59;
                                            }
                                            case -1081249113: {
                                                if (!var5_5.equals("mathml")) ** break;
                                                break;
                                            }
                                            case 842234206: {
                                                if (!var5_5.equals("remote-resources")) ** break;
                                                break block60;
                                            }
                                            case -407578966: {
                                                if (!var5_5.equals("scripted")) ** break;
                                                v0 = "js";
                                                break block61;
                                            }
                                        }
                                        v0 = "onix-record";
                                        break block61;
                                    }
                                    v0 = "svg";
                                    break block61;
                                }
                                v0 = "xmp";
                                break block61;
                            }
                            v0 = "remote-resources";
                            break block61;
                            v0 = null;
                        }
                        if (v0 != null) {
                            var5_5 = v0;
                            var6_6 = false;
                            var7_7 = false;
                            it = var5_5;
                            $i$a$-let-OPFParser$parse$1 = false;
                            properties.getContains().add(it);
                        }
                        var5_5 = property;
                        tmp = -1;
                        switch (var5_5.hashCode()) {
                            case 1742863153: {
                                if (!var5_5.equals("page-spread-center")) break;
                                tmp = 1;
                                break;
                            }
                            case -1915234845: {
                                if (!var5_5.equals("page-spread-left")) break;
                                tmp = 2;
                                break;
                            }
                            case 762922944: {
                                if (!var5_5.equals("page-spread-right")) break;
                                tmp = 3;
                                break;
                            }
                        }
                        switch (tmp) {
                            case 2: {
                                v1 = "left";
                                break;
                            }
                            case 3: {
                                v1 = "right";
                                break;
                            }
                            case 1: {
                                v1 = "center";
                                break;
                            }
                            default: {
                                v1 = null;
                            }
                        }
                        if (v1 != null) {
                            var5_5 = v1;
                            var6_6 = false;
                            var7_7 = false;
                            it = var5_5;
                            $i$a$-let-OPFParser$parse$2 = false;
                            properties.setPage(it);
                        }
                        var5_5 = property;
                        tmp = -1;
                        switch (var5_5.hashCode()) {
                            case -1203435481: {
                                if (!var5_5.equals("rendition:spread-landscape")) break;
                                tmp = 1;
                                break;
                            }
                            case -1295365969: {
                                if (!var5_5.equals("rendition:spread-portrait")) break;
                                tmp = 2;
                                break;
                            }
                            case -178264810: {
                                if (!var5_5.equals("rendition:spread-node")) break;
                                tmp = 3;
                                break;
                            }
                            case -178645821: {
                                if (!var5_5.equals("rendition:spread-auto")) break;
                                tmp = 4;
                                break;
                            }
                            case -178621803: {
                                if (!var5_5.equals("rendition:spread-both")) break;
                                tmp = 5;
                                break;
                            }
                        }
                        switch (tmp) {
                            case 3: {
                                v2 = "none";
                                break;
                            }
                            case 4: {
                                v2 = "auto";
                                break;
                            }
                            case 1: {
                                v2 = "landscape";
                                break;
                            }
                            case 2: {
                                v2 = "both";
                                break;
                            }
                            case 5: {
                                v2 = "both";
                                break;
                            }
                            default: {
                                v2 = null;
                            }
                        }
                        if (v2 != null) {
                            var5_5 = v2;
                            var6_6 = false;
                            var7_7 = false;
                            it = var5_5;
                            $i$a$-let-OPFParser$parse$3 = false;
                            properties.setSpread(it);
                        }
                        var5_5 = property;
                        switch (var5_5.hashCode()) {
                            case 210818310: {
                                if (!var5_5.equals("rendition:layout-pre-paginated")) ** break;
                                break;
                            }
                            case -1234919240: {
                                if (!var5_5.equals("rendition:layout-reflowable")) ** break;
                                v3 = "reflowable";
                                break block62;
                            }
                        }
                        v3 = "fixed";
                        break block62;
                        v3 = null;
                    }
                    if (v3 != null) {
                        var5_5 = v3;
                        var6_6 = false;
                        var7_7 = false;
                        it = var5_5;
                        $i$a$-let-OPFParser$parse$4 = false;
                        properties.setLayout(it);
                    }
                    var5_5 = property;
                    switch (var5_5.hashCode()) {
                        case -916787848: {
                            if (!var5_5.equals("rendition:orientation-landscape")) ** break;
                            break;
                        }
                        case -39193282: {
                            if (!var5_5.equals("rendition:orientation-portrait")) ** break;
                            break block63;
                        }
                        case 1768710354: {
                            if (!var5_5.equals("rendition:orientation-auto")) ** break;
                            v4 = "auto";
                            break block64;
                        }
                    }
                    v4 = "landscape";
                    break block64;
                }
                v4 = "portrait";
                break block64;
                v4 = null;
            }
            if (v4 != null) {
                var5_5 = v4;
                var6_6 = false;
                var7_7 = false;
                it = var5_5;
                $i$a$-let-OPFParser$parse$5 = false;
                properties.setOrientation(it);
            }
            var5_5 = property;
            tmp = -1;
            switch (var5_5.hashCode()) {
                case 1029707880: {
                    if (!var5_5.equals("rendition:flow-auto")) break;
                    tmp = 1;
                    break;
                }
                case -1558199372: {
                    if (!var5_5.equals("rendition:flow-paginated")) break;
                    tmp = 2;
                    break;
                }
                case -2089031216: {
                    if (!var5_5.equals("rendition:flow-scrolled-doc")) break;
                    tmp = 3;
                    break;
                }
                case 957911927: {
                    if (!var5_5.equals("rendition:flow-scrolled-continuous")) break;
                    tmp = 4;
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    v5 = "auto";
                    break;
                }
                case 2: {
                    v5 = "paginated";
                    break;
                }
                case 4: {
                    v5 = "scrolled-continuous";
                    break;
                }
                case 3: {
                    v5 = "scrolled";
                    break;
                }
                default: {
                    v5 = null;
                }
            }
            if (v5 == null) continue;
            var5_5 = v5;
            var6_6 = false;
            var7_7 = false;
            it = var5_5;
            $i$a$-let-OPFParser$parse$6 = false;
            properties.setOverflow(it);
        }
        return properties;
    }

    private final Link linkFromManifest(Node item) {
        Link link;
        block3: {
            link = new Link();
            link.setTitle((String)item.getAttributes().get("id"));
            String string = this.rootFilePath;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            link.setHref(PublicationParserKt.normalize(string, (String)item.getAttributes().get("href")));
            link.setTypeLink((String)item.getAttributes().get("media-type"));
            String string2 = (String)item.getAttributes().get("properties");
            if (string2 == null) break block3;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            List properties = StringsKt.split$default((CharSequence)it, (String[])new String[]{"\\s+"}, (boolean)false, (int)0, (int)6, null);
            boolean bl4 = false;
            boolean bl5 = false;
            List $this$with = properties;
            boolean bl6 = false;
            if ($this$with.contains("nav")) {
                link.getRel().add("contents");
            }
            if ($this$with.contains("cover-image")) {
                link.getRel().add("cover");
            }
        }
        return link;
    }
}

