/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser;

import android.webkit.MimeTypeMap;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.streamer.container.ContainerCbz;
import org.readium.r2.streamer.parser.PubBox;
import org.readium.r2.streamer.parser.PublicationParser;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/readium/r2/streamer/parser/CbzParser;", "Lorg/readium/r2/streamer/parser/PublicationParser;", "()V", "generateContainerFrom", "Lorg/readium/r2/streamer/container/ContainerCbz;", "path", "", "getMimeType", "fileName", "parse", "Lorg/readium/r2/streamer/parser/PubBox;", "fileAtPath", "title", "Companion", "r2-streamer_release"})
public final class CbzParser
implements PublicationParser {
    @NotNull
    public static final String mimetypeCBZ = "application/vnd.comicbook+zip";
    @NotNull
    public static final String mimetypeCBR = "application/x-cbr";
    @NotNull
    public static final String mimetypeJPEG = "image/jpeg";
    @NotNull
    public static final String mimetypePNG = "image/png";
    public static final Companion Companion = new Companion(null);

    private final ContainerCbz generateContainerFrom(String path) {
        ContainerCbz container = null;
        if (!new File(path).exists()) {
            throw (Throwable)new Exception("Missing File");
        }
        container = new ContainerCbz(path);
        if (!container.getSuccessCreated()) {
            throw (Throwable)new Exception("Missing File");
        }
        return container;
    }

    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath, @NotNull String title) {
        List<String> e2;
        ContainerCbz containerCbz;
        Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        try {
            containerCbz = this.generateContainerFrom(fileAtPath);
        }
        catch (Exception e2) {
            Timber.e((Throwable)e2, (String)"Could not generate container", (Object[])new Object[0]);
            return null;
        }
        ContainerCbz container = containerCbz;
        try {
            e2 = container.getFilesList();
        }
        catch (Exception e3) {
            Timber.e((Throwable)e3, (String)"Missing File : META-INF/container.xml", (Object[])new Object[0]);
            return null;
        }
        List<String> listFiles = e2;
        Publication publication = new Publication();
        Iterable $this$forEach$iv = listFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Link link = new Link();
            link.setTypeLink(this.getMimeType(it));
            link.setHref(it);
            if (Intrinsics.areEqual((Object)this.getMimeType(it), (Object)mimetypeJPEG) || Intrinsics.areEqual((Object)this.getMimeType(it), (Object)mimetypePNG)) {
                publication.getPageList().add(link);
                continue;
            }
            publication.getResources().add(link);
        }
        ((Link)CollectionsKt.first((List)publication.getPageList())).getRel().add("cover");
        publication.getMetadata().setIdentifier(fileAtPath);
        publication.setType(Publication.TYPE.CBZ);
        return new PubBox(publication, container);
    }

    private final String getMimeType(String fileName) {
        String string;
        try {
            String name = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)fileName, (String)" ", (String)"", (boolean)false, (int)4, null), (String)"'", (String)"", (boolean)false, (int)4, null), (String)",", (String)"", (boolean)false, (int)4, null);
            String extension = MimeTypeMap.getFileExtensionFromUrl((String)name);
            string = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        catch (Exception e) {
            Timber.e((Throwable)e);
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/readium/r2/streamer/parser/CbzParser$Companion;", "", "()V", "mimetypeCBR", "", "mimetypeCBZ", "mimetypeJPEG", "mimetypePNG", "r2-streamer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

