/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.fetcher;

import com.mcxiaoke.koi.HASH;
import com.mcxiaoke.koi.ext.StringKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.Encryption;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/readium/r2/streamer/fetcher/FontDecoder;", "", "()V", "adobe", "", "decodableAlgorithms", "", "", "decoders", "idpf", "decoding", "Ljava/io/InputStream;", "input", "publication", "Lorg/readium/r2/shared/Publication;", "path", "decodingFont", "Ljava/io/ByteArrayInputStream;", "pubId", "length", "deobfuscate", "", "publicationKey", "obfuscationLength", "getHashKeyAdobe", "r2-streamer_intTestappDebug"})
public final class FontDecoder {
    private final int adobe = 1024;
    private final int idpf = 1040;
    private Map<String, String> decodableAlgorithms = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"fontIdpf", (Object)"http://www.idpf.org/2008/embedding"), TuplesKt.to((Object)"fontAdobe", (Object)"http://ns.adobe.com/pdf/enc#RC")});
    private Map<String, Integer> decoders = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"http://www.idpf.org/2008/embedding", (Object)this.idpf), TuplesKt.to((Object)"http://ns.adobe.com/pdf/enc#RC", (Object)this.adobe)});

    @NotNull
    public final InputStream decoding(@NotNull InputStream input, @NotNull Publication publication, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String publicationIdentifier = publication.getMetadata().getIdentifier();
        Link link = publication.linkWithHref(path);
        if (link == null) {
            return input;
        }
        Link link2 = link;
        Encryption encryption = link2.getProperties().getEncryption();
        if (encryption == null) {
            return input;
        }
        Encryption encryption2 = encryption;
        String string = encryption2.getAlgorithm();
        if (string == null) {
            return input;
        }
        String algorithm = string;
        Map<String, Integer> map = this.decoders;
        Encryption encryption3 = link2.getProperties().getEncryption();
        String string2 = encryption3 != null ? encryption3.getAlgorithm() : null;
        boolean bl = false;
        Integer n = map.get(string2);
        if (n == null) {
            return input;
        }
        int type = n;
        if (!this.decodableAlgorithms.values().contains(algorithm)) {
            Timber.e((String)("Error " + path + " is encrypted, but can't handle it"), (Object[])new Object[0]);
            return input;
        }
        return this.decodingFont(input, publicationIdentifier, type);
    }

    private final ByteArrayInputStream decodingFont(InputStream input, String pubId, int length) {
        int n = length;
        byte[] publicationKey = n == this.adobe ? this.getHashKeyAdobe(pubId) : StringKt.toHexBytes((String)HASH.INSTANCE.sha1(pubId));
        return new ByteArrayInputStream(this.deobfuscate(input, publicationKey, length));
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] deobfuscate(InputStream input, byte[] publicationKey, int obfuscationLength) {
        byte[] buffer = ByteStreamsKt.readBytes((InputStream)input);
        int count = buffer.length > obfuscationLength ? obfuscationLength : buffer.length;
        int n = 0;
        int n2 = count;
        while (n < n2) {
            byte by;
            void i;
            byte by2 = buffer[i];
            byte by3 = publicationKey[i % publicationKey.length];
            void var12_12 = i++;
            byte[] byArray = buffer;
            boolean bl = false;
            byArray[var12_12] = by = (byte)(by2 ^ by3);
        }
        return buffer;
    }

    private final byte[] getHashKeyAdobe(String pubId) {
        return StringKt.toHexBytes((String)StringsKt.replace$default((String)StringsKt.replace$default((String)pubId, (String)"urn:uuid:", (String)"", (boolean)false, (int)4, null), (String)"-", (String)"", (boolean)false, (int)4, null));
    }
}

