/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.container;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.streamer.container.Container;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/readium/r2/streamer/container/DirectoryContainer;", "Lorg/readium/r2/streamer/container/Container;", "data", "", "relativePath", "", "dataInputStream", "Ljava/io/FileInputStream;", "dataLength", "", "getDecodedRelativePath", "r2-streamer_intTestappDebug"})
public interface DirectoryContainer
extends Container {
    @Override
    @NotNull
    public byte[] data(@NotNull String var1);

    @Override
    public long dataLength(@NotNull String var1);

    @Override
    @NotNull
    public FileInputStream dataInputStream(@NotNull String var1);

    @NotNull
    public String getDecodedRelativePath(@NotNull String var1);

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static byte[] data(DirectoryContainer $this, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            String decodedFilePath = $this.getRootFile().getRootPath() + "/" + $this.getDecodedRelativePath(relativePath);
            File file = new File(decodedFilePath);
            if (!file.exists()) {
                throw (Throwable)new Exception("Missing File");
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int readLength = 0;
            byte[] buffer = new byte[16384];
            FileInputStream inputStream = new FileInputStream(file);
            while (true) {
                int n;
                int it;
                readLength = it = (n = inputStream.read(buffer));
                if (!(it != -1)) break;
                outputStream.write(buffer, 0, readLength);
            }
            inputStream.close();
            byte[] byArray = outputStream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"outputStream.toByteArray()");
            return byArray;
        }

        public static long dataLength(DirectoryContainer $this, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            return new File($this.getRootFile().toString() + "/" + $this.getDecodedRelativePath(relativePath)).length();
        }

        @NotNull
        public static FileInputStream dataInputStream(DirectoryContainer $this, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            return new FileInputStream(new File($this.getRootFile().toString() + "/" + $this.getDecodedRelativePath(relativePath)));
        }

        @NotNull
        public static String getDecodedRelativePath(DirectoryContainer $this, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            String string = new URI(relativePath).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URI(relativePath).path");
            return string;
        }
    }
}

