/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.container;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.RootFile;
import org.readium.r2.shared.drm.Drm;
import org.readium.r2.shared.parser.xml.XmlParser;
import org.readium.r2.streamer.container.DirectoryContainer;
import org.readium.r2.streamer.container.EpubContainer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u0012\u0010 \u001a\u00020\u001e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lorg/readium/r2/streamer/container/ContainerEpubDirectory;", "Lorg/readium/r2/streamer/container/EpubContainer;", "Lorg/readium/r2/streamer/container/DirectoryContainer;", "path", "", "(Ljava/lang/String;)V", "drm", "Lorg/readium/r2/shared/drm/Drm;", "getDrm", "()Lorg/readium/r2/shared/drm/Drm;", "setDrm", "(Lorg/readium/r2/shared/drm/Drm;)V", "rootFile", "Lorg/readium/r2/shared/RootFile;", "getRootFile", "()Lorg/readium/r2/shared/RootFile;", "setRootFile", "(Lorg/readium/r2/shared/RootFile;)V", "successCreated", "", "getSuccessCreated", "()Z", "setSuccessCreated", "(Z)V", "scanForDrm", "xmlAsByteArray", "", "link", "Lorg/readium/r2/shared/Link;", "xmlDocumentForFile", "Lorg/readium/r2/shared/parser/xml/XmlParser;", "relativePath", "xmlDocumentForResource", "r2-streamer_intTestappDebug"})
public final class ContainerEpubDirectory
implements EpubContainer,
DirectoryContainer {
    private boolean successCreated;
    @NotNull
    private RootFile rootFile;
    @Nullable
    private Drm drm;

    @Override
    public boolean getSuccessCreated() {
        return this.successCreated;
    }

    @Override
    public void setSuccessCreated(boolean bl) {
        this.successCreated = bl;
    }

    @Override
    @NotNull
    public RootFile getRootFile() {
        return this.rootFile;
    }

    @Override
    public void setRootFile(@NotNull RootFile rootFile) {
        Intrinsics.checkParameterIsNotNull((Object)rootFile, (String)"<set-?>");
        this.rootFile = rootFile;
    }

    @Override
    @Nullable
    public Drm getDrm() {
        return this.drm;
    }

    @Override
    public void setDrm(@Nullable Drm drm) {
        this.drm = drm;
    }

    @Override
    @NotNull
    public XmlParser xmlDocumentForFile(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        byte[] containerData = this.data(relativePath);
        XmlParser document = new XmlParser();
        byte[] byArray = containerData;
        XmlParser xmlParser = document;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        xmlParser.parseXml((InputStream)byteArrayInputStream);
        return document;
    }

    @Override
    @NotNull
    public byte[] xmlAsByteArray(@Nullable Link link) {
        Object object = link;
        if (object == null || (object = object.getHref()) == null) {
            Link link2 = link;
            throw (Throwable)new Exception("Missing Link : " + (link2 != null ? link2.getTitle() : null));
        }
        Object pathFile = object;
        if (StringsKt.first((CharSequence)((CharSequence)pathFile)) == '/') {
            Object object2 = pathFile;
            int n = 1;
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object3).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            pathFile = string;
        }
        return this.data((String)pathFile);
    }

    @Override
    @NotNull
    public XmlParser xmlDocumentForResource(@Nullable Link link) {
        Object object = link;
        if (object == null || (object = object.getHref()) == null) {
            Link link2 = link;
            throw (Throwable)new Exception("missing Link : " + (link2 != null ? link2.getTitle() : null));
        }
        Object pathFile = object;
        if (StringsKt.first((CharSequence)((CharSequence)pathFile)) == '/') {
            Object object2 = pathFile;
            int n = 1;
            Object object3 = object2;
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object3).substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            pathFile = string;
        }
        return this.xmlDocumentForFile((String)pathFile);
    }

    @Override
    @Nullable
    public Drm scanForDrm() {
        if (new File(this.getRootFile().getRootPath() + "/" + "META-INF/license.lcpl").exists()) {
            return new Drm(Drm.Brand.Lcp);
        }
        return null;
    }

    public ContainerEpubDirectory(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (new File(path).exists()) {
            this.setSuccessCreated(true);
        }
        this.setRootFile(new RootFile(path, null, null, null, 6, null));
    }

    @Override
    @NotNull
    public byte[] data(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return DirectoryContainer.DefaultImpls.data(this, relativePath);
    }

    @Override
    public long dataLength(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return DirectoryContainer.DefaultImpls.dataLength(this, relativePath);
    }

    @Override
    @NotNull
    public FileInputStream dataInputStream(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return DirectoryContainer.DefaultImpls.dataInputStream(this, relativePath);
    }

    @Override
    @NotNull
    public String getDecodedRelativePath(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return DirectoryContainer.DefaultImpls.getDecodedRelativePath(this, relativePath);
    }
}

