/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.server;

import android.content.Context;
import android.content.res.AssetManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nanohttpd.router.RouterNanoHTTPD;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.fetcher.Fetcher;
import org.readium.r2.streamer.server.Fonts;
import org.readium.r2.streamer.server.Ressources;
import org.readium.r2.streamer.server.handler.CSSHandler;
import org.readium.r2.streamer.server.handler.FontHandler;
import org.readium.r2.streamer.server.handler.JSHandler;
import org.readium.r2.streamer.server.handler.ManifestHandler;
import org.readium.r2.streamer.server.handler.MediaOverlayHandler;
import org.readium.r2.streamer.server.handler.ResourceHandler;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006J \u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0016\u0010%\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0014\u0010&\u001a\u00020\u0014*\u00020'2\u0006\u0010(\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/readium/r2/streamer/server/AbstractServer;", "Lorg/nanohttpd/router/RouterNanoHTTPD;", "port", "", "(I)V", "CSS_HANDLE", "", "FONT_HANDLE", "JSON_MANIFEST_HANDLE", "JS_HANDLE", "MANIFEST_HANDLE", "MANIFEST_ITEM_HANDLE", "MEDIA_OVERLAY_HANDLE", "containsMediaOverlay", "", "fonts", "Lorg/readium/r2/streamer/server/Fonts;", "resources", "Lorg/readium/r2/streamer/server/Ressources;", "addEpub", "", "publication", "Lorg/readium/r2/shared/Publication;", "container", "Lorg/readium/r2/streamer/container/Container;", "fileName", "userPropertiesPath", "addFont", "name", "assets", "Landroid/content/res/AssetManager;", "context", "Landroid/content/Context;", "addLinks", "filePath", "addResource", "body", "loadResources", "toFile", "Ljava/io/InputStream;", "path", "r2-streamer_intTestappDebug"})
public abstract class AbstractServer
extends RouterNanoHTTPD {
    private final String MANIFEST_HANDLE = "/manifest";
    private final String JSON_MANIFEST_HANDLE = "/manifest.json";
    private final String MANIFEST_ITEM_HANDLE = "/(.*)";
    private final String MEDIA_OVERLAY_HANDLE = "/media-overlay";
    private final String CSS_HANDLE = "/styles/(.*)";
    private final String JS_HANDLE = "/scripts/(.*)";
    private final String FONT_HANDLE = "/fonts/(.*)";
    private boolean containsMediaOverlay;
    private final Ressources resources;
    private final Fonts fonts;
    private int port;

    private final void addResource(String name, String body) {
        this.resources.add(name, body);
    }

    private final void addFont(String name, AssetManager assets, Context context) {
        InputStream inputStream = assets.open("fonts/" + name);
        StringBuilder stringBuilder = new StringBuilder();
        File file = context.getExternalFilesDir(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.getExternalFilesDir(null)");
        File dir = new File(stringBuilder.append(file.getPath()).append("/fonts/").toString());
        dir.mkdirs();
        InputStream inputStream2 = inputStream;
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"inputStream");
        StringBuilder stringBuilder2 = new StringBuilder();
        File file2 = context.getExternalFilesDir(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"context.getExternalFilesDir(null)");
        this.toFile(inputStream2, stringBuilder2.append(file2.getPath()).append("/fonts/").append(name).toString());
        StringBuilder stringBuilder3 = new StringBuilder();
        File file3 = context.getExternalFilesDir(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"context.getExternalFilesDir(null)");
        File file4 = new File(stringBuilder3.append(file3.getPath()).append("/fonts/").append(name).toString());
        this.fonts.add(name, file4);
    }

    public final void loadResources(@NotNull AssetManager assets, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)assets, (String)"assets");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = new Scanner(assets.open("ReadiumCSS/ltr/ReadiumCSS-after.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("ltr-after.css", string);
        String string2 = new Scanner(assets.open("ReadiumCSS/ltr/ReadiumCSS-before.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("ltr-before.css", string2);
        String string3 = new Scanner(assets.open("ReadiumCSS/ltr/ReadiumCSS-default.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("ltr-default.css", string3);
        String string4 = new Scanner(assets.open("ReadiumCSS/rtl/ReadiumCSS-after.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("rtl-after.css", string4);
        String string5 = new Scanner(assets.open("ReadiumCSS/rtl/ReadiumCSS-before.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("rtl-before.css", string5);
        String string6 = new Scanner(assets.open("ReadiumCSS/rtl/ReadiumCSS-default.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("rtl-default.css", string6);
        String string7 = new Scanner(assets.open("ReadiumCSS/cjk-vertical/ReadiumCSS-after.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("cjkv-after.css", string7);
        String string8 = new Scanner(assets.open("ReadiumCSS/cjk-vertical/ReadiumCSS-before.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("cjkv-before.css", string8);
        String string9 = new Scanner(assets.open("ReadiumCSS/cjk-vertical/ReadiumCSS-default.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("cjkv-default.css", string9);
        String string10 = new Scanner(assets.open("ReadiumCSS/cjk-horizontal/ReadiumCSS-after.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("cjkh-after.css", string10);
        String string11 = new Scanner(assets.open("ReadiumCSS/cjk-horizontal/ReadiumCSS-before.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("cjkh-before.css", string11);
        String string12 = new Scanner(assets.open("ReadiumCSS/cjk-horizontal/ReadiumCSS-default.css"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("cjkh-default.css", string12);
        String string13 = new Scanner(assets.open("ReadiumCSS/touchHandling.js"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("touchHandling.js", string13);
        String string14 = new Scanner(assets.open("ReadiumCSS/utils.js"), "utf-8").useDelimiter("\\A").next();
        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"Scanner(assets.open(\"Rea\u2026seDelimiter(\"\\\\A\").next()");
        this.addResource("utils.js", string14);
        this.addFont("OpenDyslexic-Regular.otf", assets, context);
    }

    public final void addEpub(@NotNull Publication publication, @NotNull Container container, @NotNull String fileName, @Nullable String userPropertiesPath) {
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Fetcher fetcher = new Fetcher(publication, container, userPropertiesPath);
        this.addLinks(publication, fileName);
        publication.addSelfLink(fileName, new URL("http://localhost:" + this.port));
        if (this.containsMediaOverlay) {
            this.addRoute(fileName + this.MEDIA_OVERLAY_HANDLE, MediaOverlayHandler.class, new Object[]{fetcher});
        }
        this.addRoute(fileName + this.JSON_MANIFEST_HANDLE, ManifestHandler.class, new Object[]{fetcher});
        this.addRoute(fileName + this.MANIFEST_HANDLE, ManifestHandler.class, new Object[]{fetcher});
        this.addRoute(fileName + this.MANIFEST_ITEM_HANDLE, ResourceHandler.class, new Object[]{fetcher});
        this.addRoute(this.JS_HANDLE, JSHandler.class, new Object[]{this.resources});
        this.addRoute(this.CSS_HANDLE, CSSHandler.class, new Object[]{this.resources});
        this.addRoute(this.FONT_HANDLE, FontHandler.class, new Object[]{this.fonts});
    }

    private final void addLinks(Publication publication, String filePath) {
        this.containsMediaOverlay = false;
        for (Link link : publication.getOtherLinks()) {
            if (!link.getRel().contains("media-overlay")) continue;
            this.containsMediaOverlay = true;
            String string = link.getHref();
            link.setHref(string != null ? StringsKt.replace$default((String)string, (String)"port", (String)("localhost:" + this.getListeningPort() + filePath), (boolean)false, (int)4, null) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void toFile(@NotNull InputStream $receiver, String path) {
        Closeable closeable = $receiver;
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            Object object = new File(path);
            object = new FileOutputStream((File)object);
            Throwable throwable2 = null;
            try {
                FileOutputStream it = (FileOutputStream)object;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public AbstractServer(int port) {
        super(port);
        this.port = port;
        this.MANIFEST_HANDLE = "/manifest";
        this.JSON_MANIFEST_HANDLE = "/manifest.json";
        this.MANIFEST_ITEM_HANDLE = "/(.*)";
        this.MEDIA_OVERLAY_HANDLE = "/media-overlay";
        this.CSS_HANDLE = "/styles/(.*)";
        this.JS_HANDLE = "/scripts/(.*)";
        this.FONT_HANDLE = "/fonts/(.*)";
        this.resources = new Ressources();
        this.fonts = new Fonts();
    }
}

