/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.parser;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.ContentLayoutStyle;
import org.readium.r2.shared.Encryption;
import org.readium.r2.shared.LangType;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.shared.drm.Drm;
import org.readium.r2.shared.parser.xml.Node;
import org.readium.r2.shared.parser.xml.XmlParser;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.container.ContainerEpub;
import org.readium.r2.streamer.container.ContainerEpubDirectory;
import org.readium.r2.streamer.container.EpubContainer;
import org.readium.r2.streamer.fetcher.ContentFilterKt;
import org.readium.r2.streamer.parser.PubBox;
import org.readium.r2.streamer.parser.PublicationParser;
import org.readium.r2.streamer.parser.epub.EncryptionParser;
import org.readium.r2.streamer.parser.epub.NCXParser;
import org.readium.r2.streamer.parser.epub.NavigationDocumentParser;
import org.readium.r2.streamer.parser.epub.OPFParser;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J,\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\"\u0010\u001b\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010!\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/readium/r2/streamer/parser/EpubParser;", "Lorg/readium/r2/streamer/parser/PublicationParser;", "()V", "encp", "Lorg/readium/r2/streamer/parser/epub/EncryptionParser;", "ncxp", "Lorg/readium/r2/streamer/parser/epub/NCXParser;", "ndp", "Lorg/readium/r2/streamer/parser/epub/NavigationDocumentParser;", "opfParser", "Lorg/readium/r2/streamer/parser/epub/OPFParser;", "fillEncryptionProfile", "Lorg/readium/r2/shared/Publication;", "publication", "drm", "Lorg/readium/r2/shared/drm/Drm;", "generateContainerFrom", "Lorg/readium/r2/streamer/container/EpubContainer;", "path", "", "getRootFilePath", "data", "", "parse", "Lorg/readium/r2/streamer/parser/PubBox;", "fileAtPath", "title", "parseEncryption", "Lkotlin/Pair;", "Lorg/readium/r2/streamer/container/Container;", "container", "", "parseNavigationDocument", "parseNcxDocument", "setLayoutStyle", "r2-streamer_intTestappDebug"})
public final class EpubParser
implements PublicationParser {
    private final OPFParser opfParser = new OPFParser();
    private final NavigationDocumentParser ndp = new NavigationDocumentParser();
    private final NCXParser ncxp = new NCXParser();
    private final EncryptionParser encp = new EncryptionParser();

    private final EpubContainer generateContainerFrom(String path) {
        EpubContainer epubContainer;
        boolean isDirectory = new File(path).isDirectory();
        if (!new File(path).exists()) {
            throw (Throwable)new Exception("Missing File");
        }
        boolean bl = isDirectory;
        if (bl) {
            epubContainer = new ContainerEpubDirectory(path);
        } else if (!bl) {
            epubContainer = new ContainerEpub(path);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        EpubContainer container = epubContainer;
        if (!container.getSuccessCreated()) {
            throw (Throwable)new Exception("Missing File");
        }
        return container;
    }

    @NotNull
    public final Pair<Container, Publication> parseEncryption(@NotNull Container container, @NotNull Publication publication, @Nullable Drm drm) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        container.setDrm(drm);
        this.fillEncryptionProfile(publication, drm);
        return new Pair((Object)container, (Object)publication);
    }

    @Override
    @Nullable
    public PubBox parse(@NotNull String fileAtPath, @NotNull String title) {
        byte[] documentData;
        byte[] byArray;
        byte[] e2;
        EpubContainer epubContainer;
        Intrinsics.checkParameterIsNotNull((Object)fileAtPath, (String)"fileAtPath");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        try {
            epubContainer = this.generateContainerFrom(fileAtPath);
        }
        catch (Exception e2) {
            Log.e((String)"Error", (String)"Could not generate container", (Throwable)e2);
            return null;
        }
        EpubContainer container = epubContainer;
        try {
            e2 = container.data("META-INF/container.xml");
        }
        catch (Exception e3) {
            Log.e((String)"Error", (String)"Missing File : META-INF/container.xml", (Throwable)e3);
            return null;
        }
        byte[] data = e2;
        container.getRootFile().setMimetype("application/epub+zip");
        container.getRootFile().setRootFilePath(this.getRootFilePath(data));
        XmlParser xmlParser = new XmlParser();
        try {
            byArray = container.data(container.getRootFile().getRootFilePath());
        }
        catch (Exception e4) {
            Log.e((String)"Error", (String)("Missing File : " + container.getRootFile().getRootFilePath()), (Throwable)e4);
            return null;
        }
        byArray = documentData = byArray;
        XmlParser xmlParser2 = xmlParser;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        xmlParser2.parseXml((InputStream)byteArrayInputStream);
        Object v = xmlParser.root().getAttributes().get("version");
        if (v == null) {
            Intrinsics.throwNpe();
        }
        String string = (String)v;
        double epubVersion = Double.parseDouble(string);
        Publication publication = this.opfParser.parseOpf(xmlParser, container.getRootFile().getRootFilePath(), epubVersion);
        if (publication == null) {
            return null;
        }
        Publication publication2 = publication;
        Drm drm = container.scanForDrm();
        this.parseEncryption(container, publication2, drm);
        this.parseNavigationDocument(container, publication2);
        this.parseNcxDocument(container, publication2);
        this.setLayoutStyle(publication2);
        container.setDrm(drm);
        return new PubBox(publication2, container);
    }

    private final String getRootFilePath(byte[] data) {
        XmlParser xmlParser = new XmlParser();
        byte[] byArray = data;
        XmlParser xmlParser2 = xmlParser;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        xmlParser2.parseXml((InputStream)byteArrayInputStream);
        Object object = xmlParser.getFirst("container");
        if (object == null || (object = object.getFirst("rootfiles")) == null || (object = object.getFirst("rootfile")) == null || (object = object.getAttributes()) == null || (object = (String)object.get("full-path")) == null) {
            object = "content.opf";
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private final void setLayoutStyle(Publication publication) {
        block12: {
            langType = LangType.other;
            block8: for (String lang : publication.getMetadata().getLanguages()) {
                var5_5 = lang;
                switch (var5_5.hashCode()) {
                    case 3121: {
                        if (!var5_5.equals("ar")) ** break;
                        break;
                    }
                    case 3428: {
                        if (!var5_5.equals("ko")) ** break;
                        ** GOTO lbl22
                    }
                    case 3383: {
                        if (!var5_5.equals("ja")) ** break;
                        ** GOTO lbl22
                    }
                    case 3259: {
                        if (!var5_5.equals("fa")) ** break;
                        break;
                    }
                    case 3325: {
                        if (!var5_5.equals("he")) ** break;
                        break;
                    }
                    case 3886: {
                        if (!var5_5.equals("zh")) ** break;
lbl22:
                        // 3 sources

                        langType = LangType.cjk;
                        break block8;
                    }
                }
                langType = LangType.afh;
                break;
            }
            pageDirection = publication.getMetadata().getDirection();
            contentLayoutStyle = publication.getMetadata().contentLayoutStyle(langType, pageDirection);
            publication.setCssStyle(contentLayoutStyle.name());
            v0 = publication.getCssStyle();
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            v1 = ContentFilterKt.getUserSettingsUIPreset().get(ContentLayoutStyle.Companion.layout(v0));
            if (v1 == null) break block12;
            it = var5_5 = v1;
            if (publication.getType() == Publication.TYPE.WEBPUB) {
                publication.setUserSettingsUIPreset(ContentFilterKt.getForceScrollPreset());
            } else {
                publication.setUserSettingsUIPreset((Map)it);
            }
        }
    }

    private final Publication fillEncryptionProfile(Publication publication, Drm drm) {
        Drm drm2 = drm;
        if (drm2 != null) {
            Drm drm3;
            Drm it = drm3 = drm2;
            for (Link link : publication.getResources()) {
                Encryption encryption = link.getProperties().getEncryption();
                if ((encryption != null ? encryption.getScheme() : null) != it.getScheme()) continue;
                Encryption encryption2 = link.getProperties().getEncryption();
                if (encryption2 == null) continue;
                encryption2.setProfile(it.getProfile());
            }
            for (Link link : publication.getSpine()) {
                Encryption encryption = link.getProperties().getEncryption();
                if ((encryption != null ? encryption.getScheme() : null) != it.getScheme()) continue;
                Encryption encryption3 = link.getProperties().getEncryption();
                if (encryption3 == null) continue;
                encryption3.setProfile(it.getProfile());
            }
        }
        return publication;
    }

    private final void parseEncryption(EpubContainer container, Publication publication, Drm drm) {
        byte[] byArray;
        try {
            byArray = container.data("META-INF/encryption.xml");
        }
        catch (Exception e) {
            return;
        }
        byte[] documentData = byArray;
        XmlParser document = new XmlParser();
        byte[] e = documentData;
        XmlParser xmlParser = document;
        Object object = new ByteArrayInputStream(e);
        xmlParser.parseXml((InputStream)object);
        Object object2 = document.getFirst("encryption");
        if (object2 == null || (object2 = object2.get("EncryptedData")) == null) {
            return;
        }
        Object encryptedDataElements = object2;
        Iterator iterator = encryptedDataElements.iterator();
        while (iterator.hasNext()) {
            Object object3;
            String keyInfoUri;
            String string;
            Node it;
            Node node;
            Node encryptedDataElement = (Node)iterator.next();
            Encryption encryption = new Encryption();
            Node node2 = encryptedDataElement.getFirst("KeyInfo");
            if (node2 != null && (node2 = node2.getFirst("RetrievalMethod")) != null) {
                it = node = node2;
                string = (String)it.getAttributes().get("URI");
            } else {
                string = keyInfoUri = null;
            }
            if (Intrinsics.areEqual(keyInfoUri, (Object)"license.lcpl#/encryption/content_key")) {
                Drm drm2 = drm;
                if ((drm2 != null ? drm2.getBrand() : null) == Drm.Brand.Lcp) {
                    encryption.setScheme(Drm.Scheme.Lcp);
                }
            }
            Encryption encryption2 = encryption;
            if (encryptedDataElement.getFirst("EncryptionMethod") != null) {
                xmlParser = encryption2;
                it = node;
                object = (String)it.getAttributes().get("Algorithm");
                encryption2 = xmlParser;
                object3 = object;
            } else {
                object3 = null;
            }
            encryption2.setAlgorithm(object3);
            this.encp.parseEncryptionProperties(encryptedDataElement, encryption);
            this.encp.add(encryption, publication, encryptedDataElement);
        }
    }

    private final void parseNavigationDocument(EpubContainer container, Publication publication) {
        Object object;
        XmlParser xmlParser;
        Link link = publication.linkWithRel("contents");
        if (link == null) {
            return;
        }
        Link navLink = link;
        try {
            xmlParser = container.xmlDocumentForResource(navLink);
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)"Navigation parsing", (Throwable)e);
            return;
        }
        XmlParser navDocument = xmlParser;
        try {
            object = container.xmlAsByteArray(navLink);
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)"Navigation parsing", (Throwable)e);
            return;
        }
        byte[] navByteArray = object;
        String string = navLink.getHref();
        if (string == null) {
            return;
        }
        this.ndp.setNavigationDocumentPath(string);
        object = publication.getTableOfContents();
        Iterable iterable = this.ndp.tableOfContent(navByteArray);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getLandmarks();
        iterable = this.ndp.landmarks(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfAudioFiles();
        iterable = this.ndp.listOfAudiofiles(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfIllustrations();
        iterable = this.ndp.listOfIllustrations(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfTables();
        iterable = this.ndp.listOfTables(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getListOfVideos();
        iterable = this.ndp.listOfVideos(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        object = publication.getPageList();
        iterable = this.ndp.pageList(navDocument);
        CollectionsKt.addAll((Collection)object, (Iterable)iterable);
    }

    private final void parseNcxDocument(EpubContainer container, Publication publication) {
        Iterable iterable;
        Object object;
        Object v0;
        block7: {
            Iterable $receiver$iv = publication.getResources();
            for (Object element$iv : $receiver$iv) {
                Link it = (Link)element$iv;
                if (!Intrinsics.areEqual((Object)it.getTypeLink(), (Object)"application/x-dtbncx+xml")) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        Link link = v0;
        if (link == null) {
            return;
        }
        Link ncxLink = link;
        try {
            object = container.xmlDocumentForResource(ncxLink);
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)"Ncx parsing", (Throwable)e);
            return;
        }
        XmlParser ncxDocument = object;
        String string = ncxLink.getHref();
        if (string == null) {
            return;
        }
        this.ncxp.setNcxDocumentPath(string);
        if (publication.getTableOfContents().isEmpty()) {
            object = publication.getTableOfContents();
            iterable = this.ncxp.tableOfContents(ncxDocument);
            CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        }
        if (publication.getPageList().isEmpty()) {
            object = publication.getPageList();
            iterable = this.ncxp.pageList(ncxDocument);
            CollectionsKt.addAll((Collection)object, (Iterable)iterable);
        }
    }
}

