/*
 * Decompiled with CFR 0.152.
 */
package org.readium.r2.streamer.fetcher;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Publication;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.fetcher.ContentFilters;
import org.readium.r2.streamer.fetcher.ContentFiltersCbz;
import org.readium.r2.streamer.fetcher.ContentFiltersEpub;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0007J\u0012\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/readium/r2/streamer/fetcher/Fetcher;", "", "publication", "Lorg/readium/r2/shared/Publication;", "container", "Lorg/readium/r2/streamer/container/Container;", "userPropertiesPath", "", "(Lorg/readium/r2/shared/Publication;Lorg/readium/r2/streamer/container/Container;Ljava/lang/String;)V", "getContainer", "()Lorg/readium/r2/streamer/container/Container;", "setContainer", "(Lorg/readium/r2/streamer/container/Container;)V", "contentFilters", "Lorg/readium/r2/streamer/fetcher/ContentFilters;", "getPublication", "()Lorg/readium/r2/shared/Publication;", "setPublication", "(Lorg/readium/r2/shared/Publication;)V", "rootFileDirectory", "data", "", "path", "dataLength", "", "dataStream", "Ljava/io/InputStream;", "getContentFilters", "mimeType", "r2-streamer_intTestappDebug"})
public final class Fetcher {
    private String rootFileDirectory;
    private ContentFilters contentFilters;
    @NotNull
    private Publication publication;
    @NotNull
    private Container container;
    private final String userPropertiesPath;

    @Nullable
    public final byte[] data(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (this.publication.resource(path) == null) {
            throw (Throwable)new Exception("Missing file");
        }
        byte[] data = this.container.data(path);
        if (data != null) {
            ContentFilters contentFilters = this.contentFilters;
            data = contentFilters != null ? contentFilters.apply(data, this.publication, this.container, path) : null;
        }
        return data;
    }

    @NotNull
    public final InputStream dataStream(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        if (this.publication.resource(path) == null) {
            throw (Throwable)new Exception("Missing file");
        }
        Object inputStream = this.container.dataInputStream(path);
        Object object = this.contentFilters;
        if (object == null || (object = object.apply((InputStream)inputStream, this.publication, this.container, path)) == null) {
            object = inputStream;
        }
        inputStream = object;
        return inputStream;
    }

    public final long dataLength(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String relativePath = this.rootFileDirectory + path;
        if (this.publication.resource(path) == null) {
            throw (Throwable)new Exception("Missing file");
        }
        return this.container.dataLength(relativePath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ContentFilters getContentFilters(String mimeType) {
        String string = mimeType;
        if (string == null) throw (Throwable)new Exception("Missing container or MIMEtype");
        switch (string) {
            case "application/epub+zip": 
            case "application/oebps-package+xml": {
                ContentFilters contentFilters = new ContentFiltersEpub(this.userPropertiesPath);
                return contentFilters;
            }
            case "application/vnd.comicbook+zip": 
            case "application/x-cbr": {
                ContentFilters contentFilters = new ContentFiltersCbz();
                return contentFilters;
            }
            default: {
                throw (Throwable)new Exception("Missing container or MIMEtype");
            }
        }
    }

    @NotNull
    public final Publication getPublication() {
        return this.publication;
    }

    public final void setPublication(@NotNull Publication publication) {
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"<set-?>");
        this.publication = publication;
    }

    @NotNull
    public final Container getContainer() {
        return this.container;
    }

    public final void setContainer(@NotNull Container container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"<set-?>");
        this.container = container;
    }

    public Fetcher(@NotNull Publication publication, @NotNull Container container, @Nullable String userPropertiesPath) {
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.publication = publication;
        this.container = container;
        this.userPropertiesPath = userPropertiesPath;
        String string = (String)this.publication.getInternalData().get("rootfile");
        if (string == null) {
            throw (Throwable)new Exception("Missing root file");
        }
        String rootFilePath = string;
        CharSequence charSequence = rootFilePath;
        if (charSequence.length() > 0 && StringsKt.contains$default((CharSequence)rootFilePath, (char)'/', (boolean)false, (int)2, null)) {
            this.rootFileDirectory = StringsKt.replaceAfterLast((String)rootFilePath, (String)"/", (String)"", (String)rootFilePath);
            this.rootFileDirectory = StringsKt.dropLast((String)this.rootFileDirectory, (int)1);
        } else {
            this.rootFileDirectory = "";
        }
        this.contentFilters = this.getContentFilters(this.container.getRootFile().getMimetype());
    }
}

